/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

public class SnapshotTestFuture
extends SnapshotOperationFuture<Object> {
    public static final String DELEGATE_FACTORY_CLASS = "DELEGATE_FACTORY";
    public static final String CANCELABLE = "CANCELABLE";
    public static final String SNAPSHOT_ID = "SNAPSHOT_ID";
    public static final String PAUSE_AFTER_FIRST_STAGE_ON_CRD = "PAUSE_AFTER_FIRST_STAGE_ON_CRD";
    public static final String HANG_ON_FIRST_STAGE = "HANG_ON_FIRST_STAGE";
    private volatile SnapshotOperationFuture<Object> delegate;
    private final boolean initiator;
    private final GridFutureAdapter<Void> clientInitFut;
    private final SnapshotConfiguration snapConf;
    private final SnapshotMetricsMXBeanImpl snapshotMetrics;

    protected SnapshotTestFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        this.clientInitFut = clientInitFut;
        this.initiator = initiator;
        this.snapConf = snapConf;
        this.snapshotMetrics = snapshotMetrics;
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
        this.delegate = this.createDelegate(snapshotInfo);
        if (this.delegate != null) {
            this.delegate.init(snapshotInfo);
            this.initFut.onDone(this.delegate.initFut.error());
            return;
        }
        super.init(snapshotInfo);
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        if (this.delegate != null) {
            return this.delegate.topologyVersion();
        }
        return super.topologyVersion();
    }

    @Override
    public void topologyVersion(AffinityTopologyVersion topVer) {
        if (this.delegate != null) {
            this.delegate.topologyVersion(topVer);
            return;
        }
        super.topologyVersion(topVer);
    }

    @Override
    public synchronized void map(AffinityTopologyVersion topVer) {
        if (this.delegate != null) {
            this.delegate.map(topVer);
            return;
        }
        super.map(topVer);
    }

    @Override
    public boolean initialized() {
        if (this.delegate != null) {
            return this.delegate.initialized();
        }
        return super.initialized();
    }

    @Override
    public boolean isCurrentStageFinished() {
        if (this.delegate != null) {
            return this.delegate.isCurrentStageFinished();
        }
        return super.isCurrentStageFinished();
    }

    @Override
    public SnapshotStatus snapshotStatus() {
        if (this.delegate != null) {
            return this.delegate.snapshotStatus();
        }
        return super.snapshotStatus();
    }

    @Override
    public AffinityTopologyVersion lastKnownVersion() {
        if (this.delegate != null) {
            return this.delegate.lastKnownVersion();
        }
        return super.lastKnownVersion();
    }

    @Override
    public SnapshotOperationType type() {
        if (this.delegate != null) {
            return this.delegate.type();
        }
        return SnapshotOperationType.TEST;
    }

    @Override
    public boolean started() {
        if (this.delegate != null) {
            return this.delegate.started();
        }
        return super.started();
    }

    @Override
    public SnapshotOperationInfoImpl snapshotInfo() {
        if (this.delegate != null) {
            return this.delegate.snapshotInfo();
        }
        return super.snapshotInfo();
    }

    @Override
    public void onMessage(UUID senderNodeId, Object msg) {
        this.initFut.listen((IgniteInClosure & Serializable)lsnr -> {
            if (this.delegate != null) {
                this.delegate.onMessage(senderNodeId, msg);
                return;
            }
            super.onMessage(senderNodeId, msg);
        });
    }

    @Override
    protected synchronized void onMessage(ClusterNode senderNode, SnapshotOperationStageFinishedMessage msg) {
        this.initFut.listen((IgniteInClosure & Serializable)lsnr -> {
            if (this.delegate != null) {
                this.delegate.onMessage(senderNode, msg);
                return;
            }
            super.onMessage(senderNode, msg);
        });
    }

    @Override
    protected synchronized void onMessage(ClusterNode node, ClusterWideSnapshotOperationStageFinishedMessage msg) {
        if (this.delegate != null) {
            this.delegate.onMessage(node, msg);
            return;
        }
        super.onMessage(node, msg);
    }

    @Override
    public synchronized void start(AffinityTopologyVersion topVer) {
        if (this.delegate != null) {
            this.delegate.start(topVer);
            return;
        }
        super.start(topVer);
    }

    @Override
    protected boolean doFirstStage() throws Exception {
        if (this.delegate != null) {
            return this.delegate.doFirstStage();
        }
        Map o = (Map)this.snapshotInfo.snapshotOperation().extraParameter();
        if (o.get(HANG_ON_FIRST_STAGE) != null) {
            while (!this.isCancelled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    this.log.warning("Exception at doFirstStage()", (Throwable)e);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.delegate != null) {
            return this.delegate.doSecondStage(msg);
        }
        return super.doSecondStage(msg);
    }

    @Override
    protected boolean doThirdStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.delegate != null) {
            return this.delegate.doThirdStage(msg);
        }
        return super.doThirdStage(msg);
    }

    @Override
    protected boolean doFourthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.delegate != null) {
            return this.delegate.doFourthStage(msg);
        }
        return super.doFourthStage(msg);
    }

    @Override
    protected boolean doFifthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.delegate != null) {
            return this.delegate.doFifthStage(msg);
        }
        return super.doFifthStage(msg);
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.delegate != null) {
            this.delegate.doFinalStage(msg);
            return;
        }
        super.doFinalStage(msg);
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (this.delegate != null) {
            return this.delegate.nextStage(stage, success);
        }
        return super.nextStage(stage, success);
    }

    @Override
    protected boolean onFirstStageDoneCrdHook() throws IgniteCheckedException {
        if (this.delegate != null) {
            return this.delegate.onFirstStageDoneCrdHook();
        }
        return super.onFirstStageDoneCrdHook();
    }

    @Override
    protected boolean onSecondStageDoneCrdHook() throws IgniteCheckedException {
        if (this.delegate != null) {
            return this.delegate.onSecondStageDoneCrdHook();
        }
        return super.onSecondStageDoneCrdHook();
    }

    @Override
    protected boolean onThirdStageDoneCrdHook() throws IgniteCheckedException {
        if (this.delegate != null) {
            return this.delegate.onThirdStageDoneCrdHook();
        }
        return super.onThirdStageDoneCrdHook();
    }

    @Override
    protected boolean onFourthStageDoneCrdHook() throws IgniteCheckedException {
        if (this.delegate != null) {
            return this.delegate.onFourthStageDoneCrdHook();
        }
        return super.onFourthStageDoneCrdHook();
    }

    @Override
    protected boolean onFifthStageDoneCrdHook() throws IgniteCheckedException {
        if (this.delegate != null) {
            return this.delegate.onFifthStageDoneCrdHook();
        }
        return super.onFifthStageDoneCrdHook();
    }

    @Override
    protected void onLastStageDoneCrdHook(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (this.delegate != null) {
            this.delegate.onLastStageDoneCrdHook(stage);
            return;
        }
        super.onLastStageDoneCrdHook(stage);
    }

    @Override
    protected boolean needExchangeOnFinish() {
        if (this.delegate != null) {
            return this.delegate.needExchangeOnFinish();
        }
        return super.needExchangeOnFinish();
    }

    @Override
    protected void onFinish(Object res, Throwable err) {
        if (this.delegate != null) {
            this.delegate.onFinish(res, err);
            return;
        }
        super.onFinish(res, err);
    }

    @Override
    public synchronized void onNodeLeft(ClusterNode node, DiscoCache discoCache) {
        if (this.delegate != null) {
            this.delegate.onNodeLeft(node, discoCache);
            return;
        }
        super.onNodeLeft(node, discoCache);
    }

    @Override
    protected boolean cancelable() {
        Map o = (Map)this.snapshotInfo.snapshotOperation().extraParameter();
        Object param = o.get(CANCELABLE);
        return param == null || param instanceof Boolean && (Boolean)param != false;
    }

    @Override
    protected void checkSecurityLevel(UUID initiatorId, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
        if (this.delegate != null) {
            this.delegate.checkSecurityLevel(initiatorId, snapshotOperation);
        }
    }

    public SnapshotOperationFuture<Object> delegate() {
        return this.delegate;
    }

    @Nullable
    protected SnapshotOperationFuture<Object> createDelegate(SnapshotOperationInfoImpl snapshotInfo) {
        Class factoryCls;
        Map o = (Map)snapshotInfo.snapshotOperation().extraParameter();
        Object prop = o.get(DELEGATE_FACTORY_CLASS);
        if (prop == null || null == (factoryCls = U.classForName((String)prop.toString(), null))) {
            return null;
        }
        try {
            DelegateFactory factory = (DelegateFactory)U.newInstance((Class)factoryCls);
            return factory.createDelegate(this.protoVer, this.id, this.initiator, this.initiatorNodeId(), this.clientInitFut, this.doneFut, this.snapMgr, this.cctx, this.snapConf, this.snapshotMetrics);
        }
        catch (IgniteCheckedException e) {
            throw new AssertionError("Cannot create factory class.", e);
        }
    }

    @Override
    public void onPartitionStatesRestored(GridDhtPartitionsExchangeFuture fut) {
        if (this.delegate != null) {
            this.delegate.onPartitionStatesRestored(fut);
            return;
        }
        super.onPartitionStatesRestored(fut);
    }

    @Override
    public void onWalStateChanged(int grpId, Map<String, IgniteUuid> caches, boolean enabled) {
        if (this.delegate != null) {
            this.delegate.onWalStateChanged(grpId, caches, enabled);
            return;
        }
        super.onWalStateChanged(grpId, caches, enabled);
    }

    public static interface DelegateFactory {
        public SnapshotOperationFuture<Object> createDelegate(int var1, IgniteUuid var2, boolean var3, UUID var4, @Nullable GridFutureAdapter var5, @Nullable GridFutureAdapter var6, GridCacheSnapshotManager var7, GridCacheSharedContext var8, SnapshotConfiguration var9, SnapshotMetricsMXBeanImpl var10);
    }
}

