/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateLastAllocatedIndex;
import org.apache.ignite.internal.pagemem.wal.record.delta.TrackingPageRepairDeltaRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.MarkerPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.IterationReason;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStartStateMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DigestSnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PagesWrittenTracker;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateTransferParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2DigestWriter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotWriteThrottle;
import org.gridgain.grid.internal.processors.cache.database.snapshot.VerifiableSnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotCreateFuture
extends SnapshotOperationFuture<Void> {
    public static final int DEFAULT_MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT = 3;
    public static final int MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT = Integer.getInteger("GG_MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT", 3);
    public static volatile long FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS = 0L;
    private int snapshotCreateParallelism;
    private volatile boolean createInitialized;
    private final TrackingPageIO trackingPageIO = (TrackingPageIO)TrackingPageIO.VERSIONS.latest();
    private final ThreadLocal<ByteBuffer> tmpWriteBuf = new ThreadLocal();
    @Nullable
    private final FilePageStoreManager storeMgr;
    @Nullable
    private final IgniteCacheDatabaseSharedManager dbSharedMgr;
    private volatile PageIdIterable pagesToWrite;
    private volatile PagesWrittenTracker pagesWritten;
    private volatile PagesWrittenTracker pagesFullyWritten;
    private volatile SnapshotSession snapSes;
    private volatile PartitionAllocationMap partAllocationMap;
    private volatile WALPointer walPnt;
    private final AtomicBoolean walReleased = new AtomicBoolean();
    private volatile SnapshotMetadataV2 metadataStorage;
    private volatile boolean snapshotInProgress;
    private final SnapshotMetricsMXBeanImpl snapshotMetrics;
    private final boolean delayed;
    private volatile FutureTaskQueue<GroupPartitionId> completedPartitionsFutTaskQueue;
    private volatile boolean isFullyWrittenTrackingRequired;
    @Nullable
    private final TransactionalDrProcessorImpl txdrProc;
    private volatile SnapshotDigestRegistry registry;
    private volatile SnapshotWriteThrottle writeThrottle;
    private volatile boolean exchangelessSnapshot;
    private final int walRecordsSerializerVer = IgniteSystemProperties.getInteger((String)"IGNITE_WAL_SERIALIZER_VERSION", (int)2);
    private volatile WalRecordsStore walRecStore;
    private final Set<Integer> walStateChangedGrps = new GridConcurrentHashSet();
    private final GridFutureAdapter<Boolean> prepareFut = new GridFutureAdapter();
    private final Set<GroupPartitionId> createdPartitions = new GridConcurrentHashSet();
    private volatile IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage> locStageCompletedLsnr;
    private volatile SnapshotOperationContext snapshotOperationCtx;
    private volatile boolean forcedFullSnapshot;
    private volatile boolean ignore;

    private static long getSuperPageId(PageMemoryEx pageMem, int grpId, int partId) throws IgniteCheckedException {
        return partId == 65535 ? PageMemory.META_PAGE_ID : pageMem.partitionMetaPageId(grpId, partId);
    }

    SnapshotCreateFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics, boolean delayed) {
        super(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        this.snapshotMetrics = snapshotMetrics;
        this.delayed = delayed;
        if (this.nodeShouldSkipActiveActions()) {
            this.storeMgr = null;
            this.dbSharedMgr = null;
        } else {
            this.storeMgr = SnapshotCreateFuture.getStoreMgr(cctx);
            this.dbSharedMgr = cctx.cache().context().database();
        }
        TransactionalDrProcessor txDr = cctx.kernalContext().txDr();
        this.txdrProc = txDr instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)txDr : null;
    }

    private ByteBuffer createTmpBuffer() {
        ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(this.snapMgr.pageSize());
        tmpWriteBuf.order(ByteOrder.nativeOrder());
        return tmpWriteBuf;
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.CREATE;
    }

    public void cancelSnapshotCreation(String msg, Throwable error) {
        this.error0(msg, error);
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        this.exchangelessSnapshot = GridSnapshotOperationAttrs.exchangelessSnapshot((SnapshotOperation)snapshotInfo.snapshotOperation());
        if (this.exchangelessSnapshot) {
            this.locStageCompletedLsnr = new LocalStageCompletedListener();
            this.snapMgr.registerLocalStageCompletedListener(this.locStageCompletedLsnr);
        }
        super.init(snapshotInfo);
    }

    public IgniteFuture<Boolean> prepareFuture() {
        return new IgniteFutureImpl(this.prepareFut);
    }

    public boolean isFullSnapshot() {
        return this.forcedFullSnapshot || GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCreate(PageIdIterable pageIds, GridSnapshotOperationEx snpOperation, PartitionAllocationMap map, WALPointer pnt, CheckpointRecord cpRec) {
        try {
            if (this.isDone() || this.stage() == SnapshotOperationStage.CANCELLED || this.isNotInBaseline()) {
                return;
            }
            assert (this.pagesToWrite == null && this.pagesWritten == null && this.partAllocationMap == null && this.snapSes == null) : "pageToWrite=" + this.pagesToWrite + ", pagesWritten=" + this.pagesWritten + ", partitionAllocationMap=" + this.partAllocationMap + ", snapSes=" + this.snapSes;
            this.snapshotCreateParallelism = GridSnapshotOperationAttrs.getSnapshotOperationParallelism((GridSnapshotOperationEx)snpOperation);
            this.executorSrvc = Executors.newFixedThreadPool(this.snapshotCreateParallelism, (ThreadFactory)new IgniteThreadFactory(this.cctx.igniteInstanceName(), "db-snapshot-create-threads"));
            int writeThrottlingThreshold = GridSnapshotOperationAttrs.getWriteThrottlingThreshold((GridSnapshotOperationEx)snpOperation);
            if (writeThrottlingThreshold > 0) {
                this.writeThrottle = new SnapshotWriteThrottle(writeThrottlingThreshold, this.snapMgr.pageSize(), this.snapshotMetrics);
            }
            this.completedPartitionsFutTaskQueue = new FutureTaskQueue(Executors.newFixedThreadPool(this.snapshotCreateParallelism, (ThreadFactory)new IgniteThreadFactory(this.cctx.igniteInstanceName(), "db-snapshot-after-create-tasks-threads")), this.log);
            this.pagesToWrite = pageIds;
            this.pagesWritten = new PagesWrittenTracker(pageIds, this.log, null, this.snapshotCreateParallelism);
            this.pagesFullyWritten = new PagesWrittenTracker(pageIds, this.log, this.completedPartitionsFutTaskQueue, this.snapshotCreateParallelism);
            this.partAllocationMap = map;
            this.walPnt = pnt;
            SnapshotSecurityLevel securityLevel = GridSnapshotOperationAttrs.getSecurityLevel((GridSnapshotOperationEx)snpOperation);
            this.isFullyWrittenTrackingRequired = securityLevel != SnapshotSecurityLevel.DISABLED || GridSnapshotOperationAttrs.getCompressionOptionParameter((GridSnapshotOperationEx)snpOperation).isCompressed() || this.exchangelessSnapshot;
            MessageDigestFactory msgDigestFactory = null;
            if (securityLevel != SnapshotSecurityLevel.DISABLED) {
                String constId = U.maskForFileName((CharSequence)this.cctx.discovery().localNode().consistentId().toString());
                msgDigestFactory = SnapshotUtils.messageDigestFactoryWithId(this.snapMgr.config().getMessageDigestFactory(), this.snapshotInfo.snapshotId());
                this.registry = new SnapshotDigestRegistry(this.snapshotInfo.snapshotId(), msgDigestFactory.createDigest().getDigestLength(), msgDigestFactory.getAlgorithmCode(), constId);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Created executor with [size=" + this.snapshotCreateParallelism + ", isFullyWrittenTrackingRequired=" + this.isFullyWrittenTrackingRequired + "]");
            }
            try {
                this.snapSes = this.dbSnapshotSpi.sessionForSnapshotCreation(this.snapshotInfo().snapshotOperation().snapshotId(), this.isFullSnapshot(), GridSnapshotOperationAttrs.getCreatePathParameter((GridSnapshotOperationEx)snpOperation), GridSnapshotOperationAttrs.getCompressionOptionParameter((GridSnapshotOperationEx)snpOperation), GridSnapshotOperationAttrs.getCompressionLevel((GridSnapshotOperationEx)snpOperation), this.completedPartitionsFutTaskQueue, this.context(null), msgDigestFactory, GridSnapshotOperationAttrs.prepareEncryptionOptions((GridSnapshotOperationEx)snpOperation, (EncryptionSpi)this.cctx.kernalContext().config().getEncryptionSpi()));
                this.completedPartitionsFutTaskQueue.setTaskProcessor(groupPartitionId -> {
                    try {
                        if (this.exchangelessSnapshot) {
                            this.walRecStore.writeToSnapshot(this.snapSes, (GroupPartitionId)groupPartitionId);
                        }
                        if (securityLevel != SnapshotSecurityLevel.DISABLED) {
                            SnapshotOutputStream stream = this.snapSes.getOrOpenForFile(groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
                            assert (stream instanceof DigestSnapshotOutputStream);
                            byte[] hash = ((DigestSnapshotOutputStream)stream).digest();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Store digest [constId='" + this.registry.consistentId() + "', ids='" + groupPartitionId + "', hash='" + U.byteArray2HexString((byte[])hash) + "']");
                            }
                            this.registry.partitionDataDigest((GroupPartitionId)groupPartitionId, hash);
                        }
                        return this.snapSes.onPartitionFinished(groupPartitionId);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                });
                if (this.exchangelessSnapshot) {
                    if (this.walPnt == null) {
                        throw new IgniteCheckedException("Exchangeless snapshot does not support WAL mode " + WALMode.NONE + ". Please consider enabling WAL. The following WAL modes can be used: " + WALMode.FSYNC + ", " + WALMode.LOG_ONLY + ", " + WALMode.BACKGROUND + '.');
                    }
                    if (!this.cctx.wal().reserve(this.walPnt)) {
                        throw new IgniteCheckedException("Cannot reserve WAL starting from snapshot record [ptr=" + this.walPnt + ']');
                    }
                    for (Integer grpId : this.snapshotInfo().snapshotOperation().cacheGroupIds()) {
                        CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpId.intValue());
                        if (grpCtx == null || grpCtx.globalWalEnabled()) continue;
                        throw new IgniteCheckedException("WAL is disabled for the group [grpId=" + grpId + ", name=" + grpCtx.cacheOrGroupName() + ']');
                    }
                    this.walRecStore = new WalRecordsStore(cpRec.cacheGroupStates());
                    this.snapMgr.registerConsistentCutStoreListener(this.walRecStore);
                }
                this.createInitialized = true;
            }
            catch (Throwable e) {
                this.cancelSnapshotCreation("Error during getting session for snapshot creation", e);
                this.prepareFut.onDone(e);
                this.prepareFut.onDone((Object)this.createInitialized);
                return;
            }
            this.pagesWritten.reportWrittenSnapshotPages(0, pageIds.getTotalPageCnt(), 0);
        }
        finally {
            this.prepareFut.onDone((Object)this.createInitialized);
        }
    }

    public void beforeCheckpointPageWritten() {
        if (this.cpComplete.get() && this.firstStageInProgress()) {
            this.snapshotInProgress = true;
        }
    }

    @Override
    public synchronized boolean checkStartMessage(StartSnapshotOperationDiscoveryMessage msg, boolean mutableMsg) {
        boolean res = super.checkStartMessage(msg, mutableMsg);
        if (!res) {
            return false;
        }
        if (GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)msg.snapshotOperation()).booleanValue()) {
            return true;
        }
        boolean supportsSmartIncremental = IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY);
        if (!supportsSmartIncremental) {
            return this.checkStartMessagePreMismatchHandlingPolicy(msg, mutableMsg);
        }
        if (!this.cctx.kernalContext().clientNode()) {
            msg.skipAck(true);
            DiscoCache discoCache = this.cctx.discovery().discoCache();
            List srvs = discoCache.serverNodes();
            ClusterNode clusterNode = this.startCrd = srvs.isEmpty() ? null : (ClusterNode)srvs.get(0);
            if (this.startCrd != null) {
                HashMap<Integer, Long> snaps = new HashMap<Integer, Long>();
                HashMap<Integer, Long> fullSnaps = new HashMap<Integer, Long>();
                for (Integer grpId : msg.snapshotOperation().cacheGroupIds()) {
                    if (!this.cctx.discovery().cacheGroupAffinityNode(this.cctx.localNode(), grpId.intValue())) continue;
                    long lastSnapshotId = this.snapMgr.getLastSuccessfulSnapshotIdForCacheGroup(grpId);
                    long lastFullSnapshotId = this.snapMgr.getLastSuccessfulFullSnapshotIdForCacheGroup(grpId);
                    snaps.put(grpId, lastSnapshotId);
                    fullSnaps.put(grpId, lastFullSnapshotId);
                }
                this.startStateMsg = new SnapshotOperationStartStateMessage(msg, null, snaps, fullSnaps);
                if (this.startCrd.isLocal()) {
                    this.initStartStateFuture(discoCache);
                } else {
                    this.cctx.kernalContext().pools().getSystemExecutorService().execute(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotCreateFuture.this.sendStartStateMessage(SnapshotCreateFuture.this.startCrd, SnapshotCreateFuture.this.startStateMsg);
                        }
                    });
                }
            }
        }
        return true;
    }

    private boolean checkStartMessagePreMismatchHandlingPolicy(StartSnapshotOperationDiscoveryMessage msg, boolean mutableMsg) {
        boolean ok = true;
        if (GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)msg.snapshotOperation()).booleanValue()) {
            return true;
        }
        if (mutableMsg) {
            for (Integer grpId : msg.snapshotOperation().cacheGroupIds()) {
                String errorMsg;
                if (!this.cctx.discovery().cacheGroupAffinityNode(this.cctx.localNode(), grpId.intValue())) continue;
                CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpId.intValue());
                String cacheOrGrpName = grpCtx == null ? "<not found>" : grpCtx.cacheOrGroupName();
                long lastSnapshotId = this.snapMgr.getLastSuccessfulSnapshotIdForCacheGroup(grpId);
                Long msgLastSnapshotId = msg.lastSnapshotId(grpId);
                if (msgLastSnapshotId == null) {
                    msg.lastSnapshotId(grpId, lastSnapshotId);
                    if (lastSnapshotId != 0L) continue;
                    errorMsg = "Can't create incremental snapshot: last full snapshot was not found for cache group = " + cacheOrGrpName + " on node = " + this.cctx.localNode();
                    U.error((IgniteLogger)this.log, (Object)errorMsg);
                    msg.error((Exception)((Object)new IgniteCheckedException(errorMsg)));
                    ok = false;
                    continue;
                }
                if (lastSnapshotId != msgLastSnapshotId) {
                    errorMsg = "Last snapshots are different on nodes for cache group = " + cacheOrGrpName + "(id=" + grpId + "), on current node lastSnapshotId = " + lastSnapshotId + ", msgLastSnapshotId = " + msgLastSnapshotId + " on node = " + this.cctx.localNode() + ", creation of incremental snapshot is not possible for this cache group, try creating new full snapshot.";
                    U.error((IgniteLogger)this.log, (Object)errorMsg);
                    msg.error((Exception)((Object)new IgniteCheckedException(errorMsg)));
                    ok = false;
                    continue;
                }
                if (grpCtx != null) continue;
                errorMsg = "Cache group context not found for group " + grpId + " on node = " + this.cctx.localNode();
                U.error((IgniteLogger)this.log, (Object)errorMsg);
                msg.error((Exception)((Object)new IgniteCheckedException(errorMsg)));
                ok = false;
            }
        } else if (!this.cctx.kernalContext().clientNode()) {
            DiscoCache discoCache = this.cctx.discovery().discoCache();
            List srvs = discoCache.serverNodes();
            ClusterNode clusterNode = this.startCrd = srvs.isEmpty() ? null : (ClusterNode)srvs.get(0);
            if (this.startCrd != null) {
                this.startStateMsg = new SnapshotOperationStartStateMessage(msg, null, msg.lastSnapshotIds(), null);
                if (this.startCrd.isLocal()) {
                    this.initStartStateFuture(discoCache);
                } else {
                    this.cctx.kernalContext().pools().getSystemExecutorService().execute(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotCreateFuture.this.sendStartStateMessage(SnapshotCreateFuture.this.startCrd, SnapshotCreateFuture.this.startStateMsg);
                        }
                    });
                }
            }
        }
        return ok;
    }

    @Override
    public synchronized boolean checkStartAckMessage(StartSnapshotOperationAckDiscoveryMessage msg, boolean mutableMsg) {
        boolean res = super.checkStartAckMessage(msg, mutableMsg);
        if (!res) {
            return false;
        }
        if (GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)msg.snapshotOperation()).booleanValue()) {
            return true;
        }
        if (this.cctx.kernalContext().clientNode()) {
            return true;
        }
        boolean supportsSmartIncremental = IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY);
        if (!supportsSmartIncremental) {
            return true;
        }
        Map<String, StartSnapshotOperationAckDiscoveryMessage.Resolution> resolutions = msg.resolutions();
        String consId = U.maskForFileName((CharSequence)this.cctx.discovery().localNode().consistentId().toString());
        StartSnapshotOperationAckDiscoveryMessage.Resolution resolution = resolutions.get(consId);
        switch (resolution) {
            case FORCE_FULL: {
                this.forcedFullSnapshot = true;
                break;
            }
            case INCREMENTAL: {
                break;
            }
            case IGNORE: {
                this.ignore = true;
            }
        }
        return res;
    }

    public void safelyCopyPage(FullPageId fullId) {
        block3: {
            if (this.snapshotInProgress && this.firstStageInProgress()) {
                try {
                    this.copyPage(fullId, false, null);
                }
                catch (IgniteCheckedException e) {
                    String msg = "Failed to copy page: " + fullId;
                    U.error((IgniteLogger)this.log, (Object)msg, (Throwable)e);
                    if (this.isCancelled()) break block3;
                    this.error0(msg, e);
                }
            }
        }
    }

    @Override
    protected boolean nodeShouldSkipActiveActions() {
        return super.nodeShouldSkipActiveActions() || this.ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean firstStageInProgress() {
        Object object = this.stageFieldsLock;
        synchronized (object) {
            return this.stageInProgress == SnapshotOperationStage.FIRST;
        }
    }

    @Override
    protected void onNodeLeft0(ClusterNode node, boolean crdChanged) throws IgniteCheckedException {
        if (crdChanged && this.crdIsLocal() && this.exchangelessSnapshot && !this.walRecStore.cutReadyFut.isDone()) {
            SnapshotOperationFuture cutfut = this.snapMgr.operationFutureReference(SnapshotOperationType.CONSISTENT_CUT).get();
            this.crdChangeFut.listen((IgniteInClosure & Serializable)clo -> this.cctx.kernalContext().closure().runLocalSafe(() -> {
                try {
                    if (cutfut != null) {
                        cutfut.get();
                    }
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("The consistent cut failed due to snapshot coordinator was changed. Will retry create a new consistent cut [err" + e + ']');
                    }
                }
                finally {
                    if (!this.walRecStore.consistentCutReadyFuture().isDone()) {
                        try {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Retrying to create a new consistent cut.");
                            }
                            this.createConsistentCutIfNeeded();
                        }
                        catch (Exception e) {
                            this.cancelSnapshotCreation(e.getMessage(), e);
                        }
                    }
                }
            }));
        }
    }

    private void createConsistentCutIfNeeded() {
        if (this.exchangelessSnapshot) {
            long startWaiting = System.currentTimeMillis();
            if (this.crdIsLocal()) {
                int retryCnt = 0;
                HashMap<String, Serializable> optParams = new HashMap<String, Serializable>();
                optParams.put("EXCHANGELESS_SNAPSHOT", Boolean.TRUE);
                optParams.put("IMPLICIT_SNAPSHOT_OPERATION", Boolean.TRUE);
                while (!this.isCancelled()) {
                    try {
                        SnapshotFuture<Void> cutFut = this.snapMgr.startGlobalConsistentCut(optParams);
                        while (!this.isCancelled()) {
                            try {
                                cutFut.get(100L, TimeUnit.MILLISECONDS);
                                break;
                            }
                            catch (IgniteFutureTimeoutException igniteFutureTimeoutException) {
                            }
                        }
                        if (!this.isCancelled()) break;
                        IgniteInternalFuture<Boolean> cancelCutFut = this.snapMgr.cancelSnapshotOperation(cutFut.operationId(), false, "cancel-exchangeless-consistent-cut");
                        cancelCutFut.get();
                        break;
                    }
                    catch (Exception e) {
                        if (!this.cctx.kernalContext().state().publicApiActiveState(false)) {
                            throw new IgniteException("Snapshot operation has been cancelled. Cluster is inactive [err=" + e.getMessage() + ']', (Throwable)e);
                        }
                        ++retryCnt;
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Failed to create the implicit consistent cut. The attempt will be retried. [attempt=" + retryCnt + ", maxAttempts=" + MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT + ", err=" + e.getMessage() + ']');
                        }
                        if (retryCnt != MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT) continue;
                        throw new IgniteException("Failed to create implicit consistent cut (consider increasing 'GG_MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT' environment variable, current value is " + MAX_ATTEMPTS_CREATING_IMPLICIT_CONSISTENT_CUT + ')', (Throwable)e);
                    }
                }
            }
            while (true) {
                try {
                    this.walRecStore.consistentCutReadyFuture().get(100L, TimeUnit.MILLISECONDS);
                    this.log.info("Time of waiting for the completion of consistent cut: " + (System.currentTimeMillis() - startWaiting) + " ms");
                }
                catch (IgniteFutureTimeoutException e) {
                    if (!this.isCancelled()) continue;
                    this.snapSes.cancel();
                }
                break;
            }
        }
    }

    @Override
    protected boolean doFirstStage() {
        try {
            this.createConsistentCutIfNeeded();
            TwoPhaseCalculator calc = new TwoPhaseCalculator(this.pagesWritten.total(), SnapshotCreateFuture.compressionEnabled(this.snapshotInfo));
            this.snapshotOperationCtx = this.context(calc);
            List<PageIdIterable.CountingIterator<FullPageId>> iterators = this.pagesToWrite.iterators(this.snapshotCreateParallelism);
            CountDownLatch latch = new CountDownLatch(this.snapshotCreateParallelism);
            ConcurrentHashMap.KeySetView exceptions = ConcurrentHashMap.newKeySet();
            int i = 0;
            while (i < this.snapshotCreateParallelism) {
                int stripe = i++;
                this.executorSrvc.submit(() -> {
                    try {
                        PageIdIterable.CountingIterator iter = (PageIdIterable.CountingIterator)iterators.get(stripe);
                        while (iter.hasNext()) {
                            if (this.isCancelled()) {
                                this.snapSes.cancel();
                                break;
                            }
                            FullPageId fullId = (FullPageId)iter.next();
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Next page to snapshot - " + fullId);
                            }
                            if (this.writeThrottle != null) {
                                this.writeThrottle.applyThrottlingIfNeeded();
                            }
                            this.copyPage(fullId, true, this.snapshotOperationCtx);
                            this.pagesWritten.reportWrittenSnapshotPages(iter.currentInternalCount(), iter.totalInternalCount(), stripe);
                        }
                        latch.countDown();
                    }
                    catch (Throwable t) {
                        this.snapSes.cancel();
                        exceptions.add(t);
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new IgniteCheckedException("", (Throwable)e);
            }
            if (!exceptions.isEmpty()) {
                IgniteCheckedException igniteException = new IgniteCheckedException("Failed to create snapshot.");
                for (Throwable t : exceptions) {
                    igniteException.addSuppressed(t);
                }
                throw igniteException;
            }
            if (this.exchangelessSnapshot) {
                this.walRecStore.postProcessRemainingPartitions();
            }
            assert (this.isCancelled() || this.pagesWritten.isComplete()) : "Self-check failed after snapshot creation main phase completed: cancelled=" + this.isCancelled() + ", isCompleted=" + this.pagesWritten.isComplete() + (this.pagesWritten.isComplete() ? "" : ", " + this.pagesWritten.writeState()) + ", pageToWrite=" + this.pagesToWrite;
            calc.second(this.createdPartitions.size());
        }
        catch (IgniteCheckedException e) {
            this.snapSes.cancel();
            U.error((IgniteLogger)this.log, (Object)"Failed to create snapshot.", (Throwable)e);
            throw new IgniteException("Failed to create snapshot.", (Throwable)e);
        }
        if (FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS > 0L && this.isFullSnapshot()) {
            try {
                U.sleep((long)FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS);
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                // empty catch block
            }
        }
        return true;
    }

    private SnapshotMetadataV2 createSnapshotMetadata() throws IgniteCheckedException {
        Map<Byte, Map<Integer, String>> marshallerMappingsMap = this.retrieveMarshallerMappings();
        String consId = U.maskForFileName((CharSequence)this.cctx.discovery().localNode().consistentId().toString());
        Map<Integer, BinaryMetadata> binaryMetadataMap = this.retrieveBinaryMetadata();
        GridSnapshotOperationEx snapshotOperation = this.snapshotInfo.snapshotOperation();
        HashMap cacheGrpMetaMap = U.newHashMap((int)snapshotOperation.cacheGroupIds().size());
        boolean isFullSnapshot = this.forcedFullSnapshot || GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapshotOperation) != false;
        for (Integer grpId : snapshotOperation.cacheGroupIds()) {
            CacheGroupContext cacheGrp = this.cctx.cache().cacheGroup(grpId.intValue());
            if (cacheGrp == null) {
                CacheGroupDescriptor desc = this.cctx.cache().cacheGroupDescriptor(grpId.intValue());
                if (desc == null) {
                    assert (this.isCancelled()) : "Snapshot operation should be cancelled before group destroy: " + grpId;
                    throw new IgniteCheckedException("Snapshot operation has been cancelled");
                }
                ArrayList<StoredCacheData> cfgs = new ArrayList<StoredCacheData>();
                for (String cacheName : desc.caches().keySet()) {
                    DynamicCacheDescriptor dynamicDesc = this.cctx.cache().cacheDescriptor(cacheName);
                    if (dynamicDesc != null) {
                        cfgs.add(dynamicDesc.toStoredData(this.cctx.cache().splitter()));
                        continue;
                    }
                    cfgs.add(new StoredCacheData(this.cctx.cache().cacheConfiguration(cacheName)));
                }
                cacheGrpMetaMap.put(grpId, new CacheSnapshotMetadata(cfgs, grpId.intValue(), desc.cacheOrGroupName(), consId, isFullSnapshot ? Long.valueOf(0L) : null, new HashMap(), new HashMap()));
                continue;
            }
            int partCnt = cacheGrp.affinityFunction().partitions();
            GridDhtPartitionMap locPartMap = cacheGrp.topology().localPartitionMap();
            HashMap partSizes = U.newHashMap((int)partCnt);
            HashMap<Integer, Long> partCntrs = new HashMap<Integer, Long>();
            for (int p = 0; p < partCnt; ++p) {
                Map<Integer, List<WALRecord>> grpWalRecords;
                int pagesCnt;
                if (locPartMap.get(Integer.valueOf(p)) != GridDhtPartitionState.OWNING) continue;
                PagesAllocationRange cntrs = this.partAllocationMap.get(new GroupPartitionId(grpId.intValue(), p));
                HashMap<String, Integer> consIdToCntr = new HashMap<String, Integer>();
                int n = pagesCnt = cntrs != null ? cntrs.getCurrAllocatedPageCnt() : 0;
                if (this.exchangelessSnapshot && (grpWalRecords = this.walRecStore.walRecords().get(cacheGrp.groupId())) != null && !GridFunc.isEmpty((Collection)grpWalRecords.get(p))) {
                    ++pagesCnt;
                }
                consIdToCntr.put(consId, pagesCnt);
                partSizes.put(p, consIdToCntr);
                partCntrs.put(p, cacheGrp.topology().localPartition(p).updateCounter());
            }
            ArrayList<StoredCacheData> cacheGrpCfgs = new ArrayList<StoredCacheData>();
            for (GridCacheContext cacheContext : cacheGrp.caches()) {
                DynamicCacheDescriptor cacheDesc = this.cctx.cache().cacheDescriptor(cacheContext.name());
                if (cacheDesc != null) {
                    cacheGrpCfgs.add(cacheDesc.toStoredData(this.cctx.cache().splitter()));
                    continue;
                }
                cacheGrpCfgs.add(new StoredCacheData(this.cctx.cacheContext(cacheContext.cacheId()).config()));
            }
            cacheGrpMetaMap.put(grpId, new CacheSnapshotMetadata(cacheGrpCfgs, grpId.intValue(), cacheGrp.cacheOrGroupName(), consId, isFullSnapshot ? Long.valueOf(0L) : (cacheGrp.affinityNode() ? Long.valueOf(this.snapMgr.getLastSuccessfulSnapshotIdForCacheGroup(grpId)) : null), (Map)partSizes, partCntrs));
        }
        HashMap pntMap = new HashMap();
        WALPointer walPnt = this.walPnt;
        BaselineTopology blt = this.cctx.kernalContext().state().clusterState().baselineTopology();
        if (walPnt != null && blt != null) {
            Object localNodeConstId = this.cctx.discovery().localNode().consistentId();
            pntMap.put(blt.consistentIdMapping().get(localNodeConstId), walPnt);
        }
        return new SnapshotMetadataV2(snapshotOperation.snapshotId(), this.snapshotInfo.initiatorNodeId(), this.snapMgr.pageSize(), marshallerMappingsMap, binaryMetadataMap, isFullSnapshot, this.forcedFullSnapshot, this.snapshotInfo.topologyVersion(), this.snapshotInfo.clusterNodes(), (Map)cacheGrpMetaMap, Collections.singletonMap(consId, this.pagesWritten.getCntOfWrittenPages() - this.pagesWritten.getCntOfWrittenIndexPages()), Collections.singletonMap(consId, this.pagesWritten.getCntOfWrittenPages()), this.snapMgr.pointInTimeRecoveryEnabled(), pntMap, blt, snapshotOperation.message(), GridSnapshotOperationAttrs.getCompressionOptionParameter((GridSnapshotOperationEx)snapshotOperation), GridSnapshotOperationAttrs.getCompressionLevel((GridSnapshotOperationEx)snapshotOperation), false, this.exchangelessSnapshot, this.snapSes.snapshotEncryptionOptions(), this.createConsistentCutMeta());
    }

    @Nullable
    private Map<Short, ConsistentCutMeta> createConsistentCutMeta() throws IgniteCheckedException {
        HashMap cutMetas = null;
        if (this.exchangelessSnapshot && this.snapMgr.pointInTimeRecoveryEnabled()) {
            assert (this.walRecStore != null) : "WAL record store is not initialized [snapFut=" + this + ']';
            BaselineTopology blt = this.cctx.kernalContext().state().clusterState().baselineTopology();
            if (blt != null) {
                Object localNodeConstId = this.cctx.discovery().localNode().consistentId();
                assert (this.walRecStore.cutReadyFut.isDone()) : "WAL record store cut is not ready [snapFut=" + this + ", cutReadyFut=" + WalRecordsStore.access$200(this.walRecStore) + ']';
                ConsistentCut cut = this.snapMgr.consistentCutStore().restore(this.walRecStore.cutId);
                assert (cut != null) : "Actual cut is null [snapFut=" + this + ", cutId=" + WalRecordsStore.access$500(this.walRecStore) + ']';
                ConsistentCutMeta cutMeta = new ConsistentCutMeta(cut.id(), cut.fuzzyBorderStartPtr(), cut.cutPtr(), cut.cutPtrTimestamp(), cut.skipTxs());
                cutMetas = new HashMap();
                cutMetas.put(blt.consistentIdMapping().get(localNodeConstId), cutMeta);
            }
        }
        return cutMetas;
    }

    private void closeSession() {
        try {
            this.snapSes.close();
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to close snapshot session.", (Throwable)e);
        }
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.nodeShouldSkipActiveActions()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting completing snapshot CREATE");
        }
        try {
            if (!this.success() || this.isCancelled()) {
                return;
            }
            this.completedPartitionsFutTaskQueue.awaitCompletionWithShutdown(this.snapshotOperationCtx, SnapshotCreateFuture.compressionEnabled(this.snapshotInfo));
            this.metadataStorage = this.createSnapshotMetadata();
            this.writeRegistry(this.snapSes, this.metadataStorage);
        }
        finally {
            this.closeSession();
        }
        this.completeSnapshotCreation(this.success(), this.snapshotInfo.snapshotOperation());
    }

    @Override
    protected void cancelComplete(boolean force) throws IgniteCheckedException {
        if (!this.nodeShouldSkipActiveActions()) {
            if (!force) {
                this.cleanup();
            }
            if (GridSnapshotOperationAttrs.getReplicationBootstrapMasterFlag((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation())) {
                Throwable err = this.error();
                this.txdrProc.localCompleteStateChange(ClusterRole.MASTER, ReplicationState.STOP_NOW, this.snapshotInfo.snapshotId(), null, this.topVer, true, err == null ? null : err.getMessage());
            }
        }
    }

    @Override
    protected void onFinish(Void res, Throwable err) {
        if (this.type() == SnapshotOperationType.CREATE && this.crdIsLocal() && GridSnapshotOperationAttrs.getReplicationBootstrapMasterFlag((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()) && err == null) {
            boolean snapshotCopyingFailed;
            SnapshotCreateTransferParameters transferParameters = GridSnapshotOperationAttrs.getCreateTransferParameters((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
            boolean bl = snapshotCopyingFailed = transferParameters == null;
            if (snapshotCopyingFailed) {
                U.warn((IgniteLogger)this.log, (Object)("Snapshot transfer parameters not provided [snapshotId=" + this.snapshotInfo.snapshotId() + "], master replication will stop now"));
            } else {
                try {
                    SnapshotFuture<Void> snapshotFut = this.snapMgr.startGlobalSnapshotCopying(this.snapshotInfo.snapshotId(), org.gridgain.grid.persistentstore.SnapshotPath.file().path(transferParameters.destinationPath()).build(), true, transferParameters.transferParameters(), null);
                    assert (this.txdrProc != null);
                    this.txdrProc.updateStateChangeOperationInfo(snapshotFut.snapshotOperation());
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to start of global snapshot copying [snapshotId=" + this.snapshotInfo.snapshotId() + "]"), (Throwable)e);
                    snapshotCopyingFailed = true;
                }
            }
            if (snapshotCopyingFailed) {
                try {
                    this.txdrProc.localCompleteStateChange(ClusterRole.MASTER, ReplicationState.STOP_NOW, this.snapshotInfo.snapshotId(), null, this.topVer, true, null);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to stop master replication [snapshotId=" + this.snapshotInfo.snapshotId() + "]"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void checkSecurityLevel(UUID initiatorId, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
        try {
            SnapshotUtils.checkSecurityLevel(this.cctx, initiatorId, snapshotOperation, this.snapMgr.resolveSecurityLevel());
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    @Override
    public void onWalStateChanged(int grpId, Map<String, IgniteUuid> caches, boolean enabled) {
        if (!enabled) {
            this.walStateChangedGrps.add(grpId);
        }
    }

    private void cleanup() {
        if (this.createInitialized) {
            this.closeSession();
        }
        long snapId = this.snapshotInfo().snapshotId();
        FsSnapshotPath snapDir = this.dbSnapshotSpi.generateCurNodeSnapshotFolderPath(snapId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cleaning up of snapshot " + snapId);
        }
        if (snapDir.exists()) {
            snapDir.delete();
        }
        SnapshotPath parent = snapDir.getParent();
        try {
            parent.deleteIfEmpty();
        }
        catch (IOException e) {
            U.warn((IgniteLogger)this.log, (Object)("Couldn't delete snapshot dir " + parent + ", error=" + e));
        }
        if (this.exchangelessSnapshot) {
            this.closeWalRecStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeSavingAllocatedIndex(PageMemoryEx pageMem, IgniteWriteAheadLogManager wal, int grpId, int partId) throws IgniteCheckedException {
        int candidateAllocatedCnt;
        long pageId = SnapshotCreateFuture.getSuperPageId(pageMem, grpId, partId);
        long page = pageMem.acquirePage(grpId, pageId);
        boolean wasChanged = false;
        try {
            long pageAddr = pageMem.readLock(grpId, pageId, page);
            try {
                if (PageIO.getType((long)pageAddr) == 0) {
                    return;
                }
            }
            finally {
                pageMem.readUnlock(grpId, pageId, page);
            }
            pageAddr = pageMem.writeLock(grpId, pageId, page);
            try {
                assert (PageIO.getPageId((long)pageAddr) != 0L);
                PageMetaIO pageMetaIO = (PageMetaIO)PageMetaIO.getPageIO((long)pageAddr);
                int lastAllocatedPageCnt = pageMetaIO.getLastAllocatedPageCount(pageAddr);
                if (lastAllocatedPageCnt != (candidateAllocatedCnt = pageMetaIO.getCandidatePageCount(pageAddr))) {
                    pageMetaIO.setLastAllocatedPageCount(pageAddr, candidateAllocatedCnt);
                    wasChanged = true;
                }
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, wasChanged);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
        if (wasChanged && !wal.disabled(grpId)) {
            wal.log((WALRecord)new MetaPageUpdateLastAllocatedIndex(grpId, pageId, candidateAllocatedCnt));
        }
    }

    @Override
    public boolean delayed() {
        return this.delayed;
    }

    private boolean needToWrite(FullPageId fullId) {
        if (!this.createInitialized) {
            return false;
        }
        boolean started = this.started.get();
        boolean cpComplete = this.cpComplete.get();
        if (!cpComplete && !started || !this.firstStageInProgress() || !this.pagesToWrite.contains(fullId) || this.pagesWritten.contains(fullId)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Page was skipped from writing to snapshot, fullPageId=" + fullId + ", started=" + started + ", cpComplete=" + cpComplete + ", firstStageInProgress=" + this.firstStageInProgress() + ", pagesToWrite.contains(fullId)=" + this.pagesToWrite.contains(fullId) + ", pagesWritten.contains(fullId)=" + this.pagesWritten.contains(fullId));
            }
            return false;
        }
        assert (this.partAllocationMap.get(fullId) != null && this.partAllocationMap.get(fullId).getCurrAllocatedPageCnt() > 0) : "partAlloc=" + this.partAllocationMap + ", fullId=" + fullId;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeSnapshotCreation(boolean success, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
        if (!success || this.isCancelled()) {
            return;
        }
        assert (snapshotOperation.type() == SnapshotOperationType.CREATE);
        SnapshotMetadataV2 metadata = this.metadataStorage;
        File storePath = GridSnapshotOperationAttrs.getCreatePathParameter((GridSnapshotOperationEx)snapshotOperation);
        CompressionOption compression = GridSnapshotOperationAttrs.getCompressionOptionParameter((GridSnapshotOperationEx)snapshotOperation);
        int compressionLevel = GridSnapshotOperationAttrs.getCompressionLevel((GridSnapshotOperationEx)snapshotOperation);
        try (SnapshotSession ses = this.dbSnapshotSpi.sessionForSnapshotCreation(metadata.id(), metadata.fullSnapshot(), storePath, compression, compressionLevel, this.completedPartitionsFutTaskQueue, this.snapshotOperationCtx, null, null);){
            metadata.prepareMarshal();
            ses.writeMetadata(ByteBuffer.wrap(new JdkMarshaller().marshal((Object)metadata)));
        }
        catch (IgniteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Exception during closing SnasphotSession", (Throwable)e);
        }
        this.snapMgr.setLastSuccessfulFullSnapshotIdForAllCaches(metadata.id(), metadata.fullSnapshot() && !metadata.forceFullSnapshot(), GridSnapshotOperationAttrs.isForAllCaches((GridSnapshotOperationEx)snapshotOperation));
        for (Integer grpId : this.availableCacheGroups(metadata.cacheGroupIds())) {
            this.dbSharedMgr.checkpointReadLock();
            try {
                CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId.intValue());
                if (grp == null) {
                    assert (this.isCancelled()) : "Snapshot operation should be cancelled before group destroy: " + grpId;
                    throw new IgniteCheckedException("Snapshot operation has been cancelled");
                }
                PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
                this.snapMgr.setLastSuccessfulSnapshotIdForCacheGroup(grpId, metadata.id(), metadata.fullSnapshot(), this.snapMgr.getNextSnapshotTagForCacheGroup(grpId) - 1L);
                CacheSnapshotMetadata cacheSnapshotMetadata = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId);
                Map map = cacheSnapshotMetadata.partitionSizesPerNode();
                for (int i = -1; i < grp.affinity().partitions(); ++i) {
                    int part = i == -1 ? 65535 : i;
                    try {
                        int pageSize;
                        if (part == 65535) {
                            PagesAllocationRange idxCntrs = this.partAllocationMap.get(new GroupPartitionId(grpId.intValue(), 65535));
                            if (idxCntrs == null) continue;
                            pageSize = idxCntrs.getCurrAllocatedPageCnt();
                        } else {
                            Map cIds2PageCnt = (Map)map.get(part);
                            if (cIds2PageCnt == null) continue;
                            pageSize = (Integer)cIds2PageCnt.get(U.maskForFileName((CharSequence)this.cctx.localNode().consistentId().toString()));
                        }
                        if (pageSize < 0) continue;
                        this.completeSavingAllocatedIndex(pageMem, this.cctx.wal(), grpId, part);
                        continue;
                    }
                    catch (IgniteCheckedException e) {
                        U.error((IgniteLogger)this.log, (Object)("Failed to save last allocated page index [cache=" + grp.cacheOrGroupName() + ", partId=" + part + ']'), (Throwable)e);
                    }
                }
            }
            finally {
                this.dbSharedMgr.checkpointReadUnlock();
            }
        }
        this.repairCorruptedTrackingPages();
        this.cctx.wal().flush(null, false);
        if (this.log.isInfoEnabled()) {
            int pageSize = this.cctx.kernalContext().config().getDataStorageConfiguration().getPageSize();
            this.log.info("Snapshot finished in " + (System.currentTimeMillis() - this.startTime) / 1000L + " seconds, " + this.pagesWritten.getCntOfWrittenPages() * (long)pageSize / 1024L + " Kb written (scanned). Total size of caches which were requested to snapshot is " + this.lastTotal * (long)pageSize / 1024L + " Kb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairCorruptedTrackingPages() throws IgniteCheckedException {
        for (FullPageId corruptedTrackingPage : this.pagesToWrite.corruptedTrackingPages()) {
            int grpId = corruptedTrackingPage.groupId();
            long pageId = corruptedTrackingPage.pageId();
            U.warn((IgniteLogger)this.log, (Object)("Repairing tracking page. grpId=" + grpId + ", partition=" + PageIdUtils.partId((long)pageId) + ", trackingPageId=" + U.hexLong((long)pageId)));
            this.dbSharedMgr.checkpointReadLock();
            try {
                CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
                assert (grp != null);
                PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
                long page = pageMem.acquirePage(grpId, pageId);
                try {
                    long pageAddr = pageMem.writeLock(grpId, pageId, page);
                    try {
                        assert (PageIO.getPageId((long)pageAddr) != 0L);
                        this.trackingPageIO.resetCorruptFlag(pageAddr);
                        if (!PageHandler.isWalDeltaRecordNeeded((PageSupport)pageMem, (int)grpId, (long)pageId, (long)page, (IgniteWriteAheadLogManager)this.cctx.wal(), null)) continue;
                        this.cctx.wal().log((WALRecord)new TrackingPageRepairDeltaRecord(grpId, pageId));
                    }
                    finally {
                        pageMem.writeUnlock(grpId, pageId, page, null, true);
                    }
                }
                finally {
                    pageMem.releasePage(grpId, pageId, page);
                }
            }
            finally {
                this.dbSharedMgr.checkpointReadUnlock();
            }
        }
    }

    private Set<Integer> availableCacheGroups(Collection<Integer> reqGrps) {
        if (reqGrps == null) {
            return null;
        }
        HashSet<Integer> filtered = new HashSet<Integer>(reqGrps.size());
        for (Integer grpId : reqGrps) {
            if (!this.cctx.kernalContext().discovery().cacheGroupAffinityNode(this.cctx.localNode(), grpId.intValue())) continue;
            filtered.add(grpId);
        }
        return filtered;
    }

    private Map<Integer, BinaryMetadata> retrieveBinaryMetadata() {
        HashMap<Integer, BinaryMetadata> binaryMetadataMap = new HashMap<Integer, BinaryMetadata>();
        for (BinaryType bType : ((CacheObjectBinaryProcessorImpl)this.cctx.kernalContext().cacheObjects()).metadata()) {
            binaryMetadataMap.put(bType.typeId(), ((BinaryTypeImpl)bType).metadata());
        }
        return binaryMetadataMap;
    }

    private Map<Byte, Map<Integer, String>> retrieveMarshallerMappings() {
        HashMap<Byte, Map<Integer, String>> marshallerMappingsMap = new HashMap<Byte, Map<Integer, String>>();
        Iterator it = this.cctx.kernalContext().mapping().currentMappings();
        while (it.hasNext()) {
            Map.Entry platformEntry = (Map.Entry)it.next();
            marshallerMappingsMap.put((Byte)platformEntry.getKey(), (Map<Integer, String>)platformEntry.getValue());
        }
        return marshallerMappingsMap;
    }

    private void copyPage(FullPageId fullId, boolean snapshotOp, SnapshotOperationContext context) throws IgniteCheckedException {
        int partId;
        if (this.isCancelled() || this.isDone()) {
            return;
        }
        if (!this.needToWrite(fullId)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Copying of page was skipped (already written or don't need to write) - " + fullId);
            }
            return;
        }
        if (!this.pagesWritten.add(fullId)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Copying of page was skipped (already written) - " + fullId);
            }
            return;
        }
        ByteBuffer initializedBuf = this.readPageContent(fullId);
        try {
            partId = this.rewriteMetaPageAndGetPartId(fullId, initializedBuf);
        }
        catch (IgniteCheckedException e) {
            this.printDebugInfo(fullId, null, initializedBuf, e);
            throw e;
        }
        if (this.isCancelled()) {
            throw new IgniteCheckedException("Snapshot operation has been cancelled");
        }
        SnapshotOutputStream stream = this.snapSes.getOrOpenForFile(fullId.groupId(), partId);
        if (stream != null) {
            if (initializedBuf.remaining() != this.snapMgr.pageSize()) {
                throw new IgniteCheckedException(S.toString((String)"Snapshot page has unexpected size", (String)"partId", (Object)partId, (boolean)false, (String)"fullId", (Object)fullId, (boolean)false, (String)"pageSize", (Object)this.snapMgr.pageSize(), (boolean)false, (String)"bufSize", (Object)initializedBuf.remaining(), (boolean)false, (String)"snapOperation", (Object)snapshotOp, (boolean)false));
            }
            stream.write(initializedBuf);
            if (this.writeThrottle != null) {
                this.writeThrottle.incrementWrittenPages();
            }
            if (this.isFullyWrittenTrackingRequired) {
                this.pagesFullyWritten.add(fullId);
            }
            this.createdPartitions.add(new GroupPartitionId(fullId.groupId(), partId));
            if (this.snapshotMetrics != null) {
                this.snapshotMetrics.incrementBytesWritten(initializedBuf.position());
                this.snapshotMetrics.updateProcessedPartitions(fullId.groupId(), partId);
            }
        } else {
            this.log.warning("Stream for writing page to snapshot is null! grpId = " + fullId.groupId() + ", partId = " + partId);
            return;
        }
        initializedBuf.rewind();
        if (context != null) {
            context.reportWork(this.pagesWritten.processed());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Page was successfully copied: " + fullId);
        }
    }

    @NotNull
    private ByteBuffer readPageContent(FullPageId fullId) throws IgniteCheckedException {
        ByteBuffer buf = this.getWriteBuffer();
        try {
            this.storeMgr.read(fullId.groupId(), fullId.pageId(), buf, true);
            assert (PageIO.getVersion((ByteBuffer)buf) > 0) : "version=" + PageIO.getVersion((ByteBuffer)buf) + ", fullId=" + fullId;
            assert (PageIO.getPageId((ByteBuffer)buf) != 0L) : "pageId=" + PageIO.getPageId((ByteBuffer)buf) + ", fullId=" + fullId;
            assert (PageIO.getType((ByteBuffer)buf) > 0) : "type=" + PageIO.getType((ByteBuffer)buf) + ", fullId=" + fullId;
        }
        catch (AssertionError e) {
            U.error((IgniteLogger)this.log, (Object)("partitionAllocationMap=" + this.partAllocationMap + ", tmpWriteBuf=" + U.toHexString((ByteBuffer)buf) + ", fullId=" + fullId), (Throwable)((Object)e));
            throw new IgniteException((Throwable)((Object)e));
        }
        buf.rewind();
        return buf;
    }

    private void printDebugInfo(FullPageId fullId, @Nullable ByteBuffer buf, ByteBuffer initializedBuf, IgniteCheckedException e) {
        SB sb = new SB();
        sb.a("Exception while updating meta during snapshot: fullId=").a((Object)fullId).a(", fromDisk=").a(buf == null);
        CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(fullId.groupId());
        if (grpCtx == null) {
            sb.a(", there is no such cacheGroup with id=").a(fullId.groupId());
        } else {
            IgniteCacheOffheapManager offheap = grpCtx.offheap();
            if (offheap == null) {
                sb.a(", offheap manager is null!");
            } else {
                IgniteCacheOffheapManager.CacheDataStore store = ((IgniteCacheOffheapManagerImpl)offheap).dataStore(PageIdUtils.partId((long)fullId.pageId()), true);
                if (store == null) {
                    sb.a(", store is null!");
                } else {
                    sb.a(", storeSize=").a(store.fullSize());
                }
            }
        }
        sb.a(", buffer=[").a(U.toHexString((ByteBuffer)initializedBuf)).a("]");
        U.error((IgniteLogger)this.log, (Object)sb.toString(), (Throwable)e);
    }

    private int rewriteMetaPageAndGetPartId(FullPageId fullId, @Nullable ByteBuffer buf) throws IgniteCheckedException {
        long writeAddr = GridUnsafe.bufferAddress((ByteBuffer)buf);
        int partId = PageIdUtils.partId((long)fullId.pageId());
        if (PageIdUtils.pageIndex((long)fullId.pageId()) != 0) {
            return partId;
        }
        PageMetaIO metaIO = (PageMetaIO)PageIO.getPageIO((long)writeAddr);
        CacheGroupContext cacheGrpCtx = this.cctx.cache().cacheGroup(fullId.groupId());
        if (cacheGrpCtx == null) {
            assert (this.isCancelled()) : "Snapshot should be cancelled before group destroy: " + fullId;
            throw new IgniteCheckedException("Snapshot operation has been cancelled");
        }
        metaIO.setLastAllocatedPageCount(writeAddr, metaIO.getCandidatePageCount(writeAddr));
        PageIO.setCrc((long)writeAddr, (int)0);
        buf.rewind();
        PageIO.setCrc((long)writeAddr, (int)FastCrc.calcCrc((ByteBuffer)buf, (int)this.snapMgr.pageSize()));
        buf.rewind();
        return partId;
    }

    private void writeRegistry(SnapshotSession ses, SnapshotMetadataV2 meta) throws IgniteCheckedException {
        if (GridSnapshotOperationAttrs.getSecurityLevel((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()) == SnapshotSecurityLevel.DISABLED) {
            return;
        }
        assert (this.registry != null);
        try {
            byte[] metaHash = SnapshotUtils.computeMetadataDigest(SnapshotMetadataV2DigestWriter.INSTANCE, this.snapMgr.config().getMessageDigestFactory(), meta);
            this.registry.metadataDigest(metaHash);
            SnapshotRegistryTransformer transformer = this.snapMgr.config().getRegistryTransformer();
            VerifiableSnapshotDigestRegistry authReg = new VerifiableSnapshotDigestRegistry();
            authReg.prepareMarshal(transformer, this.registry);
            ses.writeRegistry(ByteBuffer.wrap(new JdkMarshaller().marshal((Object)authReg)));
        }
        catch (IOException | SnapshotDigestException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private void closeWalRecStore() {
        if (this.walPnt != null && this.walReleased.compareAndSet(false, true) && this.cctx.wal().reserved(this.walPnt)) {
            this.cctx.wal().release(this.walPnt);
        }
        if (this.walRecStore != null) {
            this.snapMgr.unregisterConsistentCutStoreListener(this.walRecStore);
        }
    }

    private RecordSerializer recordSerializer() throws IgniteCheckedException {
        return new RecordSerializerFactoryImpl(this.cctx, SnapshotUtils.snapshotWalRecordFilter(), SnapshotUtils.snapshotEncryptionProvider((C1<Integer, Serializable>)(C1 & Serializable)grpId -> {
            EncryptionSpi spi = this.cctx.kernalContext().config().getEncryptionSpi();
            assert (!(spi instanceof NoopEncryptionSpi));
            return this.snapSes.snapshotEncryptionOptions().getGroupKey(grpId).key();
        })).createSerializer(this.walRecordsSerializerVer);
    }

    @Override
    protected void clientInitFutDone(Throwable err, boolean doneAfterStart) {
        if (doneAfterStart && this.exchangelessSnapshot && (this.walRecStore == null || this.walRecStore != null && !this.walRecStore.consistentCutReadyFuture().isDone())) {
            return;
        }
        super.clientInitFutDone(err, doneAfterStart);
        if (this.locStageCompletedLsnr != null) {
            this.snapMgr.unregisterLocalStageCompletedListener(this.locStageCompletedLsnr);
        }
    }

    @Override
    protected double adjustProgress(SnapshotOperationStage stage, double progress) {
        double compressionMultiplier = this.snapshotInfo == null || !SnapshotCreateFuture.compressionEnabled(this.snapshotInfo) ? 1.0 : 0.3;
        double firstStagePart = (this.exchangelessSnapshot ? 0.9 : 0.99) * compressionMultiplier;
        switch (stage) {
            case FIRST: {
                return progress * firstStagePart;
            }
            case FINISH: {
                return progress * (1.0 - firstStagePart) + firstStagePart;
            }
        }
        return progress;
    }

    public ExchangelessSnapshotContext exchangelessSnapshotContext() {
        return this.walRecStore;
    }

    @Override
    protected Integer snapshotEventType(SnapshotOperationFuture.SnapshotOperationLifecycleStage lifecycleStage) {
        switch (lifecycleStage) {
            case OP_STARTED: {
                return 1031;
            }
            case OP_FINISHED: {
                return 1032;
            }
        }
        return null;
    }

    private ByteBuffer getWriteBuffer() {
        ByteBuffer buf = this.tmpWriteBuf.get();
        if (buf == null) {
            buf = this.createTmpBuffer();
            this.tmpWriteBuf.set(buf);
        }
        return buf;
    }

    private class LocalStageCompletedListener
    implements IgniteBiInClosure<SnapshotOperationFuture<Void>, SnapshotOperationStage> {
        private static final long serialVersionUID = 0L;

        private LocalStageCompletedListener() {
        }

        public void apply(SnapshotOperationFuture<Void> fut, SnapshotOperationStage stage) {
            if (fut.type() == SnapshotOperationType.CONSISTENT_CUT && GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)fut.snapshotInfo.snapshotOperation()) && stage == SnapshotOperationStage.FINISH) {
                SnapshotCreateFuture.this.clientInitFutDone(null, false);
            }
        }
    }

    private static class AtomicCacheState {
        private int[] parts;
        private long[] initCntrs;
        private long[] lastCntrs;
        private long[] remainingUpdates;
        private int remainingParts;
        @GridToStringExclude
        private int idx;
        private final Map<Integer, Set<Long>> missedUpdates = new HashMap<Integer, Set<Long>>();

        AtomicCacheState(int partsCnt) {
            this.parts = new int[partsCnt];
            this.initCntrs = new long[partsCnt];
            this.lastCntrs = new long[partsCnt];
            this.remainingUpdates = new long[partsCnt];
        }

        public void addInitialPartitionState(int partId, long cntr) {
            if (this.idx == this.parts.length) {
                throw new IllegalStateException("Failed to add new partition to the partitions state (not enough space reserved) [partId=" + partId + ", reserved=" + this.parts.length + ']');
            }
            if (this.idx > 0 && this.parts[this.idx - 1] >= partId) {
                throw new IllegalStateException("Adding partition in a wrong order [prev=" + this.parts[this.idx - 1] + ", cur=" + partId + ']');
            }
            this.parts[this.idx] = partId;
            this.initCntrs[this.idx] = cntr;
            this.missedUpdates.put(partId, new HashSet());
            ++this.idx;
        }

        public void addFinalPartitionState(int partId, long cntr) {
            int idx = this.indexByPartition(partId);
            this.lastCntrs[idx] = cntr;
            this.remainingUpdates[idx] = Math.max(this.lastCntrs[idx] - this.initCntrs[idx], 0L);
            int n = this.remainingParts = this.remainingUpdates[idx] > 0L ? this.remainingParts + 1 : this.remainingParts;
            if (this.remainingUpdates[idx] > 0L) {
                Set<Long> s = this.missedUpdates.get(partId);
                for (long i = this.initCntrs[idx] + 1L; i <= cntr; ++i) {
                    s.add(i);
                }
            }
        }

        public long initialCounterByPartition(int partId) {
            int idx = this.indexByPartition(partId);
            return idx >= 0 ? this.initCntrs[idx] : -1L;
        }

        public long finalCounterByPartition(int partId) {
            int idx = this.indexByPartition(partId);
            return idx >= 0 ? this.lastCntrs[idx] : -1L;
        }

        public boolean updateRemainingUpdates(int partId, long cntr) {
            boolean hasRemainingsUpdates;
            int idx = this.indexByPartition(partId);
            if (cntr < this.initCntrs[idx] || cntr > this.lastCntrs[idx]) {
                return this.remainingUpdates[idx] == 0L;
            }
            int n = idx;
            long l = this.remainingUpdates[n] - 1L;
            this.remainingUpdates[n] = l;
            boolean bl = hasRemainingsUpdates = l != 0L;
            if (!hasRemainingsUpdates) {
                --this.remainingParts;
            }
            this.missedUpdates.get(partId).remove(cntr);
            return hasRemainingsUpdates;
        }

        public boolean hasRemaningPartitions() {
            return this.remainingParts > 0;
        }

        public int partitionByIndex(int idx) {
            return this.parts[idx];
        }

        public int size() {
            return this.idx;
        }

        private int indexByPartition(int partId) {
            return Arrays.binarySearch(this.parts, 0, this.idx, partId);
        }

        public String toString() {
            return S.toString(AtomicCacheState.class, (Object)this, (String)"parts", (Object)IntStream.range(0, this.idx).filter(i -> this.remainingUpdates[i] != 0L).map(i -> this.parts[i]).toArray(), (String)"initCntrs", (Object)IntStream.range(0, this.idx).filter(i -> this.remainingUpdates[i] != 0L).mapToLong(i -> this.initCntrs[i]).toArray(), (String)"lastCntrs", (Object)IntStream.range(0, this.idx).filter(i -> this.remainingUpdates[i] != 0L).mapToLong(i -> this.lastCntrs[i]).toArray(), (String)"missedUpdates", this.missedUpdates.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    private static class AtomicGroupStates {
        private final Map<Integer, AtomicCacheState> partStates;
        private long remainingParts;

        AtomicGroupStates(Set<Integer> grpIds, Map<Integer, CacheState> initStates, GridCacheProcessor ctx) {
            this.partStates = U.newHashMap((int)initStates.size());
            for (Integer grpId : initStates.keySet()) {
                CacheState recState = initStates.get(grpId);
                CacheGroupContext grpCtx = ctx.cacheGroup(grpId.intValue());
                if (grpCtx == null || !grpCtx.hasAtomicCaches() || !grpIds.contains(grpId)) continue;
                AtomicCacheState state = new AtomicCacheState(recState.size());
                for (int i = 0; i < recState.size(); ++i) {
                    byte partState = recState.stateByIndex(i);
                    if (GridDhtPartitionState.fromOrdinal((int)partState) != GridDhtPartitionState.OWNING) continue;
                    state.addInitialPartitionState(recState.partitionByIndex(i), recState.partitionCounterByIndex(i));
                }
                this.partStates.put(grpId, state);
            }
        }

        public void updatePartitionStates(Map<Integer, Map<Integer, Long>> updCntrs) {
            for (Map.Entry<Integer, AtomicCacheState> e : this.partStates.entrySet()) {
                Integer grpId = e.getKey();
                Map<Integer, Long> partCntrs = updCntrs.get(grpId);
                if (partCntrs == null) continue;
                AtomicCacheState partsState = e.getValue();
                for (int i = 0; i < partsState.size(); ++i) {
                    int partId = partsState.partitionByIndex(i);
                    partsState.addFinalPartitionState(partId, partCntrs.getOrDefault(partId, 0L));
                }
                this.remainingParts += (long)partsState.remainingParts;
            }
        }

        public boolean isTrackedGroup(int grpId) {
            return this.partStates.containsKey(grpId);
        }

        public long initialCounterByPartition(int grpId, int partId) {
            return this.partStates.get(grpId).initialCounterByPartition(partId);
        }

        public long finalCounterByPartition(int grpId, int partId) {
            return this.partStates.get(grpId).finalCounterByPartition(partId);
        }

        public void updateRemainingUpdates(int grpId, int partId, long cntr) {
            boolean hasRemainingUpdates = this.partStates.get(grpId).updateRemainingUpdates(partId, cntr);
            if (!hasRemainingUpdates) {
                --this.remainingParts;
            }
        }

        public boolean hasRemaningPartitions() {
            return this.remainingParts != 0L;
        }

        public String toString() {
            Map<Integer, AtomicCacheState> s = this.partStates.entrySet().stream().filter(e -> ((AtomicCacheState)e.getValue()).hasRemaningPartitions()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return S.toString(AtomicGroupStates.class, (Object)this, (String)"partStates", s);
        }
    }

    private static class TransactionalGroupStates {
        private final Set<Integer> txGroups;

        TransactionalGroupStates(Set<Integer> grpIds, Map<Integer, CacheState> initStates, GridCacheProcessor ctx) {
            this.txGroups = U.newHashSet((int)initStates.size());
            for (Integer grpId : initStates.keySet()) {
                CacheGroupContext grpCtx = ctx.cacheGroup(grpId.intValue());
                if (grpCtx == null || grpCtx.hasAtomicCaches() || !grpIds.contains(grpId)) continue;
                this.txGroups.add(grpId);
            }
        }

        public boolean isTrackedGroup(int grpId) {
            return this.txGroups.contains(grpId);
        }
    }

    private class WalRecordsStore
    implements IgniteInClosure<ConsistentCut>,
    ExchangelessSnapshotContext {
        private static final long serialVersionUID = 0L;
        private final AtomicGroupStates atomicPartsStates;
        private final TransactionalGroupStates txStates;
        private final Map<Integer, Map<Integer, List<WALRecord>>> walRecords = new HashMap<Integer, Map<Integer, List<WALRecord>>>();
        private final GridFutureAdapter<Void> cutReadyFut = new GridFutureAdapter();
        private long cutId;
        private final RecordSerializer recordSerializer;

        private WalRecordsStore(Map<Integer, CacheState> initStates) throws IgniteCheckedException {
            this.atomicPartsStates = new AtomicGroupStates(SnapshotCreateFuture.this.snapshotInfo().snapshotOperation().cacheGroupIds(), initStates, SnapshotCreateFuture.this.cctx.cache());
            this.txStates = new TransactionalGroupStates(SnapshotCreateFuture.this.snapshotInfo().snapshotOperation().cacheGroupIds(), initStates, SnapshotCreateFuture.this.cctx.cache());
            this.recordSerializer = SnapshotCreateFuture.this.recordSerializer();
        }

        @Override
        public WALPointer snapshotRecordPointer() {
            return SnapshotCreateFuture.this.walPnt;
        }

        @Override
        public boolean isTracked(int grpId, int partId) {
            Set grpIds = SnapshotCreateFuture.this.snapshotInfo().snapshotOperation().cacheGroupIds();
            return grpIds.contains(grpId) && this.atomicPartsStates.isTrackedGroup(grpId) && this.atomicPartsStates.initialCounterByPartition(grpId, partId) >= 0L;
        }

        @Override
        public long initialUpdateCounter(int grpId, int partId) {
            return this.atomicPartsStates.initialCounterByPartition(grpId, partId);
        }

        public void apply(ConsistentCut cut) {
            this.handleConsistentCut(cut);
        }

        public IgniteFuture<Void> consistentCutReadyFuture() {
            return new IgniteFutureImpl(this.cutReadyFut);
        }

        public synchronized Map<Integer, Map<Integer, List<WALRecord>>> walRecords() {
            assert (this.consistentCutReadyFuture().isDone()) : "WAL records are not available yet.";
            return this.walRecords;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void handleConsistentCut(ConsistentCut cut) {
            assert (!SnapshotCreateFuture.this.isDone()) : "Snapshot create future must not be completed [fut=" + SnapshotCreateFuture.this + ']';
            assert (SnapshotCreateFuture.this.walPnt != null) : "Exchangeless snapshot does not support WAL mode NONE.";
            assert (SnapshotCreateFuture.this.walPnt instanceof FileWALPointer);
            assert (cut.fuzzyBorderStartPtr() instanceof FileWALPointer);
            assert (cut.cutPtr() instanceof FileWALPointer);
            assert (((FileWALPointer)cut.fuzzyBorderStartPtr()).compareTo((FileWALPointer)SnapshotCreateFuture.this.walPnt) > 0) : "The pointer to the fuzzy border of consistent cut must follow the pointer to snapshot record [cutId=" + cut.id() + ", fuzzyBorderPtr=" + cut.fuzzyBorderStartPtr() + ", snapshotRecordPtr=" + SnapshotCreateFuture.access$700(SnapshotCreateFuture.this) + "]";
            try {
                if (SnapshotCreateFuture.this.log.isInfoEnabled()) {
                    SnapshotCreateFuture.this.log.info("Consistent cut for exchangeless snapshot is ready [cut=" + cut.toStringVerbose() + ']');
                }
                for (Integer grpId : SnapshotCreateFuture.this.walStateChangedGrps) {
                    if (!this.txStates.isTrackedGroup(grpId) && !this.atomicPartsStates.isTrackedGroup(grpId)) continue;
                    CacheGroupContext grpCtx = SnapshotCreateFuture.this.cctx.cache().cacheGroup(grpId.intValue());
                    throw new IgniteCheckedException("WAL is disabled for the group [grpId=" + grpId + ", name=" + grpCtx.cacheOrGroupName() + ']');
                }
                this.atomicPartsStates.updatePartitionStates(cut.atomicUpdateCounters());
                Set grpIds = SnapshotCreateFuture.this.snapshotInfo().snapshotOperation().cacheGroupIds();
                FileWALPointer fuzzyBorderPtr = (FileWALPointer)cut.fuzzyBorderStartPtr();
                FileWALPointer cutPtr = (FileWALPointer)cut.cutPtr();
                WALPointer snapshotRecordPtr = SnapshotCreateFuture.this.walPnt;
                assert (snapshotRecordPtr != null) : "Snapshot record is not initialized. Consistent cut will be ignored.. [fut=" + SnapshotCreateFuture.this + ", cutId=" + cut.id() + ']';
                if (!SnapshotCreateFuture.this.cctx.wal().reserve(snapshotRecordPtr)) {
                    throw new IgniteCheckedException("Cannot reserve WAL starting from snapshot record [ptr=" + snapshotRecordPtr + ']');
                }
                try (WALIterator it = SnapshotCreateFuture.this.cctx.wal().replay(snapshotRecordPtr, IterationReason.HANDLE_CONSISTENT_CUT);){
                    IgniteBiTuple rec;
                    FileWALPointer recPtr = null;
                    block21: while (!SnapshotCreateFuture.this.isCancelled() && it.hasNext() && ((recPtr = (FileWALPointer)((WALRecord)(rec = (IgniteBiTuple)it.next()).get2()).position()).compareTo(cutPtr) < 0 || this.atomicPartsStates.hasRemaningPartitions()) && recPtr.index() <= cutPtr.index() + 2L) {
                        switch (((WALRecord)rec.get2()).type()) {
                            case DATA_RECORD: 
                            case DATA_RECORD_V2: 
                            case MVCC_DATA_RECORD: 
                            case OUT_OF_ORDER_UPDATE: {
                                boolean mvcc = ((WALRecord)rec.get2()).type() == WALRecord.RecordType.MVCC_DATA_RECORD;
                                DataRecord dataRecord = (DataRecord)rec.get2();
                                for (DataEntry e : dataRecord.writeEntries()) {
                                    GridCacheContext cacheCtx = SnapshotCreateFuture.this.cctx.cacheContext(e.cacheId());
                                    if (cacheCtx == null || !grpIds.contains(cacheCtx.groupId())) continue;
                                    if (e.nearXidVersion() != null) {
                                        boolean needCheckSkippedTxs;
                                        if (!this.txStates.isTrackedGroup(cacheCtx.groupId())) continue;
                                        boolean bl = needCheckSkippedTxs = recPtr.compareTo(fuzzyBorderPtr) > 0;
                                        if (recPtr.compareTo(cutPtr) >= 0 || needCheckSkippedTxs && cut.skipTxs().contains(e.nearXidVersion())) continue;
                                        this.addWalRecord(cacheCtx.groupId(), e.partitionId(), this.prepareRecord(e, cacheCtx, mvcc));
                                        continue;
                                    }
                                    int grpId = cacheCtx.groupId();
                                    int partId = e.partitionId();
                                    long cntr = e.partitionCounter();
                                    if (!this.atomicPartsStates.isTrackedGroup(grpId)) continue;
                                    if (cntr < this.atomicPartsStates.initialCounterByPartition(grpId, partId)) {
                                        if (((WALRecord)rec.get2()).type() == WALRecord.RecordType.OUT_OF_ORDER_UPDATE) continue;
                                        this.addWalRecord(grpId, partId, this.prepareRecord(e, cacheCtx, mvcc));
                                        continue;
                                    }
                                    if (cntr > this.atomicPartsStates.finalCounterByPartition(grpId, partId)) continue;
                                    this.addWalRecord(grpId, partId, this.prepareRecord(e, cacheCtx, mvcc));
                                    this.atomicPartsStates.updateRemainingUpdates(grpId, partId, cntr);
                                }
                                continue block21;
                            }
                        }
                    }
                    if (this.atomicPartsStates.hasRemaningPartitions()) {
                        throw new IgniteCheckedException("Couldn't find all required WAL records [snapRec=" + snapshotRecordPtr + ", endPtr=" + recPtr + ", partStates=" + this.atomicPartsStates + ']');
                    }
                    Comparator<WALRecord> recordsComparator = Comparator.comparingLong(r -> ((DataEntry)((DataRecord)r).writeEntries().get(0)).partitionCounter());
                    for (Integer grpId : this.atomicPartsStates.partStates.keySet()) {
                        Map<Integer, List<WALRecord>> grpRecords = this.walRecords.get(grpId);
                        if (F.isEmpty(grpRecords)) continue;
                        for (List<WALRecord> records : grpRecords.values()) {
                            records.sort(recordsComparator);
                        }
                    }
                }
                finally {
                    SnapshotCreateFuture.this.cctx.wal().release(snapshotRecordPtr);
                }
            }
            catch (IgniteCheckedException e) {
                SnapshotCreateFuture.this.cancelSnapshotCreation("Exchangeless snapshot cancelled due to inability to collect required WAL records.", e);
                this.cutReadyFut.onDone((Throwable)e);
            }
            finally {
                SnapshotCreateFuture.this.closeWalRecStore();
                this.cutId = cut.id();
                this.cutReadyFut.onDone();
            }
        }

        private void addWalRecord(int grpId, int partId, WALRecord walRecord) {
            this.walRecords.computeIfAbsent(grpId, r -> new HashMap()).computeIfAbsent(partId, r -> new ArrayList()).add(walRecord);
        }

        private WALRecord prepareRecord(DataEntry e, GridCacheContext<?, ?> cctx, boolean mvcc) throws IgniteCheckedException {
            CacheObjectContext coCtx = cctx.cacheObjectContext();
            e.key().prepareForCache(coCtx, coCtx.compressKeys());
            if (e.value() != null) {
                e.value().prepareForCache(coCtx, true);
            }
            return mvcc ? new MvccDataRecord((MvccDataEntry)e) : new DataRecord(e);
        }

        private void postProcessRemainingPartitions() {
            for (Map.Entry<Integer, Map<Integer, List<WALRecord>>> groupWALRecordsEntry : this.walRecords.entrySet()) {
                Map<Integer, List<WALRecord>> partWALRecords = groupWALRecordsEntry.getValue();
                int groupId = groupWALRecordsEntry.getKey();
                for (Map.Entry<Integer, List<WALRecord>> partWALRecordsEntry : partWALRecords.entrySet()) {
                    GroupPartitionId groupPartitionId = new GroupPartitionId(groupId, partWALRecordsEntry.getKey().intValue());
                    if (SnapshotCreateFuture.this.createdPartitions.contains(groupPartitionId)) continue;
                    SnapshotCreateFuture.this.createdPartitions.add(groupPartitionId);
                    SnapshotCreateFuture.this.completedPartitionsFutTaskQueue.submitTask((Object)groupPartitionId);
                }
            }
        }

        public void writeToSnapshot(SnapshotSession snapSes, GroupPartitionId grpPartId) throws IgniteCheckedException {
            assert (this.consistentCutReadyFuture().isDone()) : "WAL records are not available yet.";
            int grpId = grpPartId.getGroupId();
            Map<Integer, List<WALRecord>> grpEntries = this.walRecords.get(grpId);
            if (grpEntries == null) {
                return;
            }
            List<WALRecord> records = grpEntries.get(grpPartId.getPartitionId());
            if (!F.isEmpty(records)) {
                SnapshotOutputStream stream = snapSes.getOrOpenForFile(grpId, grpPartId.getPartitionId());
                this.writeMarker(stream, records.size());
                for (WALRecord record : records) {
                    this.writeWalRecordToStream(record, stream, this.recordSerializer);
                }
            }
        }

        private void writeMarker(SnapshotOutputStream stream, int walRecordsCnt) throws IgniteCheckedException {
            ByteBuffer buffer = SnapshotCreateFuture.this.getWriteBuffer();
            MarkerPageIO pageIO = (MarkerPageIO)MarkerPageIO.VERSIONS.latest();
            buffer.rewind();
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buffer);
            pageIO.initNewPage(addr, 0L, SnapshotCreateFuture.this.snapMgr.pageSize(), null);
            PageIO.setPageId((long)addr, (long)-1L);
            pageIO.setMarkerType(addr, 1);
            pageIO.setWalRecordSerializerVersion(addr, SnapshotCreateFuture.this.walRecordsSerializerVer);
            pageIO.setWalRecordsCnt(addr, walRecordsCnt);
            PageIO.setCrc((long)addr, (int)0);
            int crc = FastCrc.calcCrc((ByteBuffer)buffer, (int)SnapshotCreateFuture.this.snapMgr.pageSize());
            PageIO.setCrc((long)addr, (int)crc);
            buffer.rewind();
            stream.write(buffer);
        }

        private void writeWalRecordToStream(WALRecord record, SnapshotOutputStream stream, RecordSerializer serializer) throws IgniteCheckedException {
            int recSize = serializer.size(record);
            record.size(recSize);
            record.position((WALPointer)new FileWALPointer(0L, Long.valueOf(stream.position()).intValue(), recSize));
            ByteBuffer recBuffer = ByteBuffer.allocate(recSize);
            recBuffer.order(ByteOrder.nativeOrder());
            serializer.writeRecord(record, recBuffer);
            recBuffer.rewind();
            stream.plainWrite(recBuffer);
        }
    }

    public static interface ExchangelessSnapshotContext {
        public WALPointer snapshotRecordPointer();

        public boolean isTracked(int var1, int var2);

        public long initialUpdateCounter(int var1, int var2);
    }

    static class FullPageIdComparator
    implements Comparator<FullPageId>,
    Serializable {
        private static final long serialVersionUID = 0L;

        FullPageIdComparator() {
        }

        @Override
        public int compare(FullPageId o1, FullPageId o2) {
            int idx2;
            int partId2;
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals((Object)o2)) {
                return 0;
            }
            if (o1.groupId() < o2.groupId()) {
                return -1;
            }
            if (o1.groupId() > o2.groupId()) {
                return 1;
            }
            int partId1 = PageIdUtils.partId((long)o1.pageId());
            if (partId1 < (partId2 = PageIdUtils.partId((long)o2.pageId()))) {
                return -1;
            }
            if (partId1 > partId2) {
                return 1;
            }
            int idx1 = PageIdUtils.pageIndex((long)o1.pageId());
            if (idx1 < (idx2 = PageIdUtils.pageIndex((long)o2.pageId()))) {
                return -1;
            }
            if (idx1 > idx2) {
                return 1;
            }
            return 0;
        }
    }

    private static class TwoPhaseCalculator
    implements SnapshotProgressCalculator {
        long total;
        int secondSize = -1;
        boolean twoPhase;

        TwoPhaseCalculator(long total, boolean twoPhase) {
            this.total = total;
            this.twoPhase = twoPhase;
        }

        private void second(int size) {
            if (this.twoPhase) {
                this.secondSize = size;
            }
        }

        public long progress(long amountOfWork) {
            if (this.secondSize != -1 && !this.twoPhase) {
                throw new IllegalArgumentException("twoPhase=" + this.twoPhase + ", secondSize=" + this.secondSize);
            }
            if (this.secondSize == -1) {
                return this.twoPhase ? amountOfWork / 2L : amountOfWork;
            }
            return this.total / 2L + this.total / (long)this.secondSize * amountOfWork;
        }

        public long total() {
            return this.total;
        }
    }
}

