/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.compute.ComputeTaskCancelledCheckedException;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.messages.ChunkOfWorkAssignmentMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ChunkOfWorkInProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.NodeStartPoint;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AtomicLongSnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCopySinglePartitionCopyLocalWorkTracker;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCopySinglePartitionCopyWorkGenerator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUpdateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathOperationsHelper;
import org.gridgain.grid.persistentstore.snapshot.file.remote.VFS2SnapshotPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotCopyFuture
extends SnapshotUpdateFuture<Void> {
    private static final int DEFAULT_PARALLELISM = 1;
    private volatile SnapshotCopySinglePartitionCopyWorkGenerator generator;
    private volatile int parallelismLevel;
    private final SnapshotCopySinglePartitionCopyLocalWorkTracker localTracker = new SnapshotCopySinglePartitionCopyLocalWorkTracker();
    private final AtomicBoolean asyncStageCompleted = new AtomicBoolean();
    private final GridConcurrentHashSet<Long> needCopySnapshots = new GridConcurrentHashSet();
    private final AtomicLong inProgressMessageLastTimeSent = new AtomicLong();
    private final TransactionalDrProcessorImpl txdrProc;

    protected SnapshotCopyFuture(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<Void> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protocolVersion, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        TransactionalDrProcessor txDr = cctx.kernalContext().txDr();
        this.txdrProc = txDr instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)txDr : null;
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.COPY;
    }

    @Override
    protected boolean cancelable() {
        return this.stage() == SnapshotOperationStage.FIRST;
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        super.init(snapshotInfo);
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        this.parallelismLevel = parameters == null || parameters.parallelismLevel() == null ? 1 : parameters.parallelismLevel();
        int parallelismLevel = this.parallelismLevel;
        this.executorSrvc = Executors.newFixedThreadPool(parallelismLevel, (ThreadFactory)new IgniteThreadFactory(this.cctx.igniteInstanceName(), "db-snapshot-copy-threads"));
        if (parameters != null && parameters.singleFileCopy()) {
            SnapshotCopySinglePartitionCopyWorkGenerator generator = this.generator = new SnapshotCopySinglePartitionCopyWorkGenerator(parallelismLevel * 2, this.cctx.database().pageSize(), this.cctx.logger("SnapshotWorkGenerator-" + this.id));
            Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotInfo.snapshotId(), null, null, false, null, false);
            boolean skipWalCopying = GridSnapshotOperationAttrs.getSkipWalParameter((GridSnapshotOperationEx)snapshotInfo.snapshotOperation());
            if (!skipWalCopying) {
                this.startWalCopyingIfItIsNecessary(snapshotInfo, snapshot);
            }
            this.crdChangeFut.listen((IgniteInClosure & Serializable)future -> this.snapMgr.getMergedSnapshotDescriptorFromClusterV2Async(snapshotInfo.snapshotId(), null, null).listen((IgniteInClosure & Serializable)future1 -> {
                if (future1.error() != null) {
                    if (X.hasCause((Throwable)future1.error(), (Class[])new Class[]{ComputeTaskCancelledCheckedException.class})) {
                        U.error((IgniteLogger)this.log, (Object)"Collecting merged descriptor task was cancelled. Is node stopping?", (Throwable)future1.error());
                        return;
                    }
                    this.error0("Collecting merged descriptor has failed", future1.error());
                } else {
                    SnapshotDescriptorV2 mergedDescriptor = (SnapshotDescriptorV2)future1.result();
                    if (mergedDescriptor == null || mergedDescriptor.snapshotMetadata() == null) {
                        this.error0("Collecting merged descriptor has failed, it is null", null);
                    } else {
                        this.snapMgr.submitTaskToSnapshotExecutor(this.type(), () -> {
                            generator.init(mergedDescriptor.snapshotMetadata());
                            if (generator.workIsDone()) {
                                this.finishAsyncStage();
                            }
                        });
                    }
                }
            }));
            generator.updatesFromAllNodesReceived().listen((IgniteInClosure & Serializable)future -> {
                try {
                    Map<String, long[]> firstTime = generator.generateInitialWorkForCluster();
                    Map<String, UUID> mappingCId2NodeId = this.getMappingMaskedConsistentIdToNodeId();
                    for (Map.Entry<String, long[]> entry : firstTime.entrySet()) {
                        UUID nodeId = mappingCId2NodeId.get(entry.getKey());
                        if (nodeId == null) continue;
                        this.sendWorkAssignmentMessage(nodeId, new ChunkOfWorkAssignmentMessage(this.id, this.cctx.marshaller().marshal((Object)entry.getValue())));
                    }
                }
                catch (Exception e) {
                    this.error0(null, e);
                }
            });
        }
    }

    @NotNull
    private Map<String, UUID> getMappingMaskedConsistentIdToNodeId() {
        HashMap<String, UUID> mappingCId2NodeId = new HashMap<String, UUID>();
        for (ClusterNode node : this.cctx.discovery().allNodes()) {
            mappingCId2NodeId.put(U.maskForFileName((CharSequence)node.consistentId().toString()), node.id());
        }
        return mappingCId2NodeId;
    }

    @Override
    protected void finishAsyncStage() {
        if (!this.asyncStageCompleted.compareAndSet(false, true)) {
            return;
        }
        super.finishAsyncStage();
    }

    @Override
    protected Map<UUID, SnapshotProgress> getProgress() {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        SnapshotCopySinglePartitionCopyWorkGenerator generator = this.generator;
        if (parameters != null && parameters.singleFileCopy() && generator != null && this.stage() == SnapshotOperationStage.FIRST && this.crd != null) {
            int processed = generator.finishedCountOfPartitionsToCopy();
            int total = generator.totalCountOfPartitionsToCopy();
            return Collections.singletonMap(this.crd.id(), new SnapshotProgress((long)processed, (long)total, this.adjustProgress(SnapshotOperationStage.FIRST, total == 0 ? 0.0 : (double)processed / (double)total), 0L));
        }
        return super.getProgress();
    }

    @Override
    protected void checkAsyncStageCompleteness(boolean success, SnapshotOperationStage stage) throws IgniteCheckedException {
        if (!success) {
            this.shutdownExecutorService();
        } else if (this.localTracker.getLocalWorkInProgressCount() != 0) {
            throw new IgniteCheckedException("Received finish message before completing local work.");
        }
        if (!this.crd.isLocal()) {
            this.markStageAsFinished(stage, success);
        }
        super.checkAsyncStageCompleteness(success, stage);
    }

    @Override
    protected boolean doFirstStage() throws Exception {
        if (this.nodeShouldSkipActiveActions()) {
            return true;
        }
        if (this.isCancelled()) {
            throw new IgniteCheckedException("Snapshot operation has been cancelled");
        }
        if (this.getDestinationPath(this.snapshotInfo.snapshotOperation()) instanceof VFS2SnapshotPath && !this.isSupportSftpDestination()) {
            throw new IgniteCheckedException("Not all nodes support upload via SFTP feature!");
        }
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        if (parameters.singleFileCopy()) {
            this.startCopyOfFirstPartitionBatch();
            return false;
        }
        this.copySnapshotsEntirely(parameters);
        return true;
    }

    private void startCopyOfFirstPartitionBatch() throws IgniteCheckedException {
        Snapshot snapshot;
        SnapshotPath path;
        long id = this.snapshotInfo.snapshotId();
        if (!this.dbSnapshotSpi.isCopyRequired(id, path = this.validateAndGetDestinationPath(this.snapshotInfo.snapshotOperation()))) {
            // empty if block
        }
        if ((snapshot = this.dbSnapshotSpi.snapshot(id, null, null, false, null, false)) == null || snapshot.metadata() == null) {
            return;
        }
        this.needCopySnapshots.add((Object)id);
        this.dbSnapshotSpi.startCopy(id, path);
        SnapshotMetadataV2 metadata = snapshot.metadata();
        ClusterNode localNodeInMeta = metadata.baselineTopology().baselineNode(this.cctx.localNode().consistentId());
        long[] initialWork = this.generator.generateInitialWorkLocally(metadata, localNodeInMeta, this.cctx).array();
        this.localTracker.updateWorkAssignment(initialWork);
        ChunkOfWorkInProgressMessage message = new ChunkOfWorkInProgressMessage(this.id, this.cctx.localNode().consistentId().toString(), this.cctx.marshaller().marshal((Object)GridLongList.EMPTY_ARRAY), this.cctx.marshaller().marshal((Object)initialWork));
        this.inProgressMessageLastTimeSent.set(System.currentTimeMillis());
        this.sendWorkInProgressMessage(message);
        this.submitWork(initialWork);
        this.dbSnapshotSpi.copyDigestRegistry(id, path, this.context(null));
    }

    private void copySnapshotsEntirely(SnapshotUpdateOperationParameters parameters) throws IgniteCheckedException {
        switch (parameters.chainMode()) {
            case FROM_CURRENT_TO_LAST: {
                this.dependentSnapshots = (NavigableSet)this.snapshotInfo.snapshotOperation().dependentSnapshotIds();
                this.copy(this.dependentSnapshots, this.snapshotInfo.snapshotOperation(), this::context, this.snapMgr.pointInTimeRecoveryEnabled());
                break;
            }
            case SINGLE: 
            case DEFAULT: {
                Snapshot snapshot = this.dbSnapshotSpi.snapshot(this.snapshotInfo.snapshotId(), null, null, false, null, false);
                if (snapshot == null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("No such snapshot on current node, id=" + this.snapshotInfo.snapshotId());
                    }
                    return;
                }
                this.copy(snapshot, this.snapshotInfo.snapshotOperation(), this::context);
                break;
            }
            default: {
                throw new IgniteCheckedException("Chain mode is not supported yet. Mode=" + parameters.chainMode());
            }
        }
    }

    @Override
    protected void onChunkOfWorkInProgressReceived(UUID nodeId, ChunkOfWorkInProgressMessage msg) {
        try {
            String cId = U.maskForFileName((CharSequence)msg.consistentId());
            long[] finishedWork = (long[])this.cctx.marshaller().unmarshal(msg.finishedWork(), this.getLdr());
            long[] workInProgress = (long[])this.cctx.marshaller().unmarshal(msg.workInProgress(), this.getLdr());
            SnapshotCopySinglePartitionCopyWorkGenerator generator = this.generator;
            long[] newWork = generator.updateAndTryAssignWork(cId, workInProgress, finishedWork);
            if (newWork != null) {
                if (newWork.length == 0 && generator.workIsDone()) {
                    this.finishAsyncStage();
                } else if (newWork.length > 0 || workInProgress.length > 0) {
                    this.sendWorkAssignmentMessage(nodeId, new ChunkOfWorkAssignmentMessage(this.id, this.cctx.marshaller().marshal((Object)newWork)));
                }
            }
        }
        catch (IgniteCheckedException e) {
            this.error0(null, e);
        }
    }

    @Override
    protected void onChunkOfWorkAssignmentReceived(ChunkOfWorkAssignmentMessage msg) {
        try {
            long lastTimeSent = this.inProgressMessageLastTimeSent.get();
            this.inProgressMessageLastTimeSent.set(-lastTimeSent);
            long[] partitions = (long[])this.cctx.marshaller().unmarshal(msg.workAssignment(), this.getLdr());
            if (partitions.length == 0) {
                if (this.needToSendUpdateToCrd(this.localTracker.localWorkInProgressCount(), this.inProgressMessageLastTimeSent.get())) {
                    this.sendWorkInProgress();
                }
            } else {
                this.localTracker.updateWorkAssignment(partitions);
                this.submitWork(partitions);
            }
        }
        catch (IgniteCheckedException e) {
            this.error0(null, e);
        }
    }

    private void submitWork(long[] partitions) {
        for (final long uniquePartId : partitions) {
            ExecutorService executorSrvc = this.executorSrvc;
            if (executorSrvc == null || executorSrvc.isShutdown()) continue;
            executorSrvc.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        SnapshotCopyFuture.this.dbSnapshotSpi.copySinglePartition(SnapshotCopyFuture.this.snapshotInfo.snapshotId(), SnapshotUtils.grpId(uniquePartId), SnapshotUtils.partId(uniquePartId), SnapshotCopyFuture.this.getDestinationPath(SnapshotCopyFuture.this.snapshotInfo.snapshotOperation()), SnapshotCopyFuture.this.context(null));
                        int cntOfWorkInProgress = SnapshotCopyFuture.this.localTracker.markAsFinishedAndGetCountOfWorkInProgress(uniquePartId);
                        long lastTimeSent = SnapshotCopyFuture.this.inProgressMessageLastTimeSent.get();
                        if (SnapshotCopyFuture.this.needToSendUpdateToCrd(cntOfWorkInProgress, lastTimeSent)) {
                            SnapshotCopyFuture.this.sendWorkInProgress();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        SnapshotCopyFuture.this.error0("Unexpected error during copying partition (grpId=" + SnapshotUtils.grpId(uniquePartId) + ", partId=" + SnapshotUtils.partId(uniquePartId) + ')', e);
                    }
                    catch (Throwable th) {
                        U.error((IgniteLogger)SnapshotCopyFuture.this.log, (Object)"Unexpected error during partition copy", (Throwable)th);
                    }
                }
            });
        }
    }

    private void sendWorkInProgress() throws IgniteCheckedException {
        T2<long[], long[]> synchronizedView = this.localTracker.getSynchronizedView(true);
        byte[] workInProgress = this.cctx.marshaller().marshal(synchronizedView.get1());
        byte[] finishedWork = this.cctx.marshaller().marshal(synchronizedView.get2());
        String consistentId = U.maskForFileName((CharSequence)this.cctx.discovery().localNode().consistentId().toString());
        this.sendWorkInProgressMessage(new ChunkOfWorkInProgressMessage(this.id, consistentId, finishedWork, workInProgress));
    }

    private boolean needToSendUpdateToCrd(int countOfWorkInProgress, long lastTimeSent) {
        long ts = System.currentTimeMillis();
        return lastTimeSent < 0L && (countOfWorkInProgress <= this.parallelismLevel * 2 || ts - Math.abs(lastTimeSent) > this.snapshotThrottlingInterval) && this.inProgressMessageLastTimeSent.compareAndSet(lastTimeSent, ts);
    }

    @Override
    protected void onNodeLeft0(ClusterNode node, boolean crd) throws IgniteCheckedException {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        if (parameters.singleFileCopy()) {
            U.warn((IgniteLogger)this.log, (Object)("Node left topology during snapshot copy (nodeWasCoordinator=" + crd + ", node=" + node + ")"));
            if (crd) {
                this.inProgressMessageLastTimeSent.set(System.currentTimeMillis());
                T2<long[], long[]> view = this.localTracker.getSynchronizedView(false);
                long[] workInProgress = (long[])view.get1();
                long[] finishedWork = (long[])view.get2();
                ChunkOfWorkInProgressMessage msg = new ChunkOfWorkInProgressMessage(this.id, this.cctx.localNode().consistentId().toString(), this.cctx.marshaller().marshal((Object)finishedWork), this.cctx.marshaller().marshal((Object)workInProgress));
                this.sendWorkInProgressMessage(msg);
            }
            if (this.crd.isLocal()) {
                Map<String, GridLongList> map = this.generator.onNodeFailed(U.maskForFileName((CharSequence)node.consistentId().toString()));
                if (!F.isEmpty(map)) {
                    Map<String, UUID> mapping = this.getMappingMaskedConsistentIdToNodeId();
                    for (Map.Entry<String, GridLongList> entry : map.entrySet()) {
                        UUID nodeId = mapping.get(entry.getKey());
                        if (nodeId == null) continue;
                        this.sendWorkAssignmentMessage(nodeId, new ChunkOfWorkAssignmentMessage(this.id, this.cctx.marshaller().marshal((Object)entry.getValue().array())));
                    }
                } else if (this.generator.workIsDone()) {
                    this.finishAsyncStage();
                }
            }
        }
    }

    @Override
    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        block9: {
            SnapshotOperationContext snapCtx;
            GridSnapshotOperationEx op;
            block8: {
                if (this.nodeShouldSkipActiveActions() || !msg.success()) {
                    return true;
                }
                SnapshotUpdateOperationParameters parameters = this.operationParameters;
                op = this.snapshotInfo.snapshotOperation();
                snapCtx = this.context(null);
                if (parameters.singleFileCopy()) break block8;
                switch (parameters.chainMode()) {
                    case FROM_CURRENT_TO_LAST: {
                        for (Long snapshotId : this.dependentSnapshots) {
                            if (!this.needCopySnapshots.contains((Object)snapshotId)) continue;
                            this.finishSnapshotCopy(op, snapshotId, true, snapCtx);
                        }
                        break block9;
                    }
                    case SINGLE: 
                    case DEFAULT: {
                        if (this.needCopySnapshots.contains((Object)this.snapshotInfo.snapshotId())) {
                            this.finishSnapshotCopy(op, this.snapshotInfo.snapshotId(), true, snapCtx);
                        }
                        break block9;
                    }
                    default: {
                        assert (false);
                        break block9;
                    }
                }
            }
            this.finishSnapshotCopy(op, this.snapshotInfo.snapshotId(), false, snapCtx);
        }
        return true;
    }

    private void finishSnapshotCopy(GridSnapshotOperationEx op, Long snapshotId, boolean copyMeta, SnapshotOperationContext context) throws IgniteCheckedException {
        SnapshotPath destFolder = this.getDestinationPath(op);
        if (copyMeta) {
            this.copySnapshotMetadata(snapshotId, destFolder, context);
        }
        this.dbSnapshotSpi.finishCopy(snapshotId.longValue(), destFolder);
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (this.nodeShouldSkipActiveActions() || !msg.success()) {
            return;
        }
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        assert (parameters != null);
        if (parameters.removeSources()) {
            this.deleteSnapshots();
        }
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.SECOND;
            }
            case SECOND: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError((Object)("Unexpected stage in nextStage, passed stage=" + (Object)((Object)stage)));
    }

    @Override
    protected double adjustProgress(SnapshotOperationStage stage, double progress) {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        if (parameters != null && parameters.removeSources()) {
            switch (stage) {
                case FIRST: {
                    return progress * 0.75;
                }
                case SECOND: {
                    return progress * 0.25 + 0.75;
                }
            }
        }
        return progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelComplete(boolean force) {
        if (!this.nodeShouldSkipActiveActions()) {
            if (!force) {
                Object object = this.stageFieldsLock;
                synchronized (object) {
                    assert ((this.previousStage == SnapshotOperationStage.NONE || this.previousStage == SnapshotOperationStage.FIRST) && this.stageInProgress == SnapshotOperationStage.CANCELLED) : "previousStage=" + (Object)((Object)this.previousStage) + ", stageInProgress=" + (Object)((Object)this.stageInProgress);
                }
                this.cleanup(this.snapshotInfo);
            }
            if (this.txdrProc != null && this.txdrProc.localState().sessionId() == this.snapshotInfo.snapshotId()) {
                try {
                    this.txdrProc.localCompleteStateChange(ClusterRole.MASTER, ReplicationState.STOP_NOW, this.snapshotInfo.snapshotId(), null, this.topVer, true, null);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to stop master replication [snapshotId=" + this.snapshotInfo.snapshotId() + "]"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void onFinish(Void res, Throwable err) {
        if (this.txdrProc != null) {
            this.txdrProc.localFinishStateChange(ClusterRole.MASTER, ReplicationState.RUNNING, this.snapshotInfo.snapshotId(), err, null);
        }
    }

    @Override
    protected boolean onSecondStageDoneCrdHook() throws IgniteCheckedException {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        assert (parameters != null);
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        switch (parameters.chainMode()) {
            case FROM_CURRENT_TO_LAST: {
                for (Long id : op.dependentSnapshotIds()) {
                    if (!this.needCopySnapshots.contains((Object)id)) continue;
                    this.createSingleMetadataFileForCopiedSnapshot(id, this.getDestinationPath(op), false);
                }
                break;
            }
            case SINGLE: 
            case DEFAULT: {
                if (!this.needCopySnapshots.contains((Object)this.snapshotInfo.snapshotId())) break;
                this.createSingleMetadataFileForCopiedSnapshot(this.snapshotInfo.snapshotId(), this.getDestinationPath(op), parameters.singleFileCopy());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private SnapshotPath getDestinationPath(GridSnapshotOperationEx op) {
        return SnapshotPathFactory.create(GridSnapshotOperationAttrs.getDestinationPathParameter((GridSnapshotOperationEx)op), this.snapMgr.config().getSftpConfiguration());
    }

    @NotNull
    public SnapshotPath validateAndGetDestinationPath(GridSnapshotOperationEx op) throws IgniteCheckedException {
        SnapshotPath dstPath = this.getDestinationPath(op);
        SnapshotPathOperationsHelper.ensureDirectory(dstPath, "snapshot destination folder", null);
        return dstPath;
    }

    public long calculateSnapshotSize(NavigableSet<Long> snapshotsToCopy) {
        long totalSnapshotSize = 0L;
        for (Long snapId : snapshotsToCopy) {
            Snapshot snap = this.dbSnapshotSpi.snapshot(snapId.longValue(), null, null, false, null, false);
            if (snap == null || snap.metadata() == null) {
                this.log.warning("No snapshot with id = " + snapId + ", on node = " + this.cctx.localNode());
                continue;
            }
            long size = snap.metadata().sizeInBytes();
            if (size > 0L) {
                totalSnapshotSize += size;
            }
            int estimatedMetadataSize = 1000000;
            totalSnapshotSize += (long)estimatedMetadataSize;
        }
        return totalSnapshotSize;
    }

    public void copy(Snapshot snapshot, GridSnapshotOperationEx operationEx, Function<SnapshotProgressCalculator, SnapshotOperationContext> contextCreator) throws IgniteCheckedException {
        this.copy(new TreeSet<Long>(Collections.singleton(snapshot.id())), operationEx, contextCreator, snapshot.metadata().pointInTimeRecoveryEnabled());
    }

    public void copy(NavigableSet<Long> snapshotsToCopy, GridSnapshotOperationEx op, Function<SnapshotProgressCalculator, SnapshotOperationContext> contextCreator, boolean pointInTimeRecoveryEnabled) throws IgniteCheckedException {
        long totalSnapshotSize = this.calculateSnapshotSize(snapshotsToCopy);
        if (totalSnapshotSize == 0L) {
            return;
        }
        SnapshotPath dstPath = this.validateAndGetDestinationPath(op);
        this.copy(snapshotsToCopy, dstPath, GridSnapshotOperationAttrs.getSkipWalParameter((GridSnapshotOperationEx)op), contextCreator.apply((SnapshotProgressCalculator)new AtomicLongSnapshotProgressCalculator(totalSnapshotSize)), pointInTimeRecoveryEnabled);
    }

    private void copy(NavigableSet<Long> snapshotsToCopy, SnapshotPath dstPath, boolean skipWalParameter, SnapshotOperationContext ctx, boolean pointInTimeRecoveryEnabled) throws IgniteCheckedException {
        for (Long snapId : snapshotsToCopy) {
            if (this.dbSnapshotSpi.isCopyRequired(snapId.longValue(), dstPath)) {
                this.needCopySnapshots.add((Object)snapId);
                this.dbSnapshotSpi.startCopy(snapId.longValue(), dstPath);
                this.dbSnapshotSpi.copySnapshotEntirely(snapId.longValue(), dstPath, ctx, this.executorSrvc);
                SnapshotUtils.checkSnapshotCancellation(ctx);
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Skip copy for snapshotId = [" + snapId + "] because it exists in [" + dstPath + "]");
            }
            if (!pointInTimeRecoveryEnabled) continue;
            SnapshotUtils.checkSnapshotCancellation(ctx);
            if (skipWalParameter) {
                this.log.warning("Skipping copying WAL files because skip flag was set.");
                continue;
            }
            IgniteWriteAheadLogManager walMgr = this.cctx.cache().context().wal();
            this.copyWal(snapId, dstPath, this.recovery().nodeStartedPoints(), ctx, walMgr);
        }
    }

    private void startWalCopyingIfItIsNecessary(SnapshotOperationInfoImpl snapshotInfo, Snapshot snapshot) {
        if (snapshot != null && snapshot.metadata() != null && snapshot.metadata().pointInTimeRecoveryEnabled() && !GridSnapshotOperationAttrs.getSkipWalParameter((GridSnapshotOperationEx)snapshotInfo.snapshotOperation())) {
            assert (false) : "It's not implemented https://ggsystems.atlassian.net/browse/GG-14258";
            ExecutorService executorSrvc = this.executorSrvc;
            if (executorSrvc != null && !executorSrvc.isShutdown()) {
                executorSrvc.submit(() -> {
                    try {
                        this.copyWal(snapshot.id(), this.getDestinationPath(snapshotInfo.snapshotOperation()), null, this.context(null), this.cctx.wal());
                    }
                    catch (IgniteCheckedException igniteCheckedException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWal(Long snapId, SnapshotPath dstPath, List<NodeStartPoint> nodeStartedPoints, SnapshotOperationContext ctx, IgniteWriteAheadLogManager walMgr) throws IgniteCheckedException {
        T2<WALPointer, WALPointer> tup = this.findWalPtrs(this.cctx, snapId, null, this.dbSnapshotSpi);
        if (tup == null) {
            throw new IgniteCheckedException("There is no next snapshot");
        }
        FileWALPointer low = (FileWALPointer)tup.get1();
        FileWALPointer high = (FileWALPointer)tup.get2();
        boolean reserved = walMgr.reserve((WALPointer)low);
        try {
            Collection<File> walFiles;
            if (!reserved || (walFiles = this.getWalFilesFromArchive(low, high)).isEmpty() || SnapshotUtils.walFilesWereDeleted(snapId, (WALPointer)low, nodeStartedPoints) || SnapshotUtils.lfsWasDeleted(snapId, (WALPointer)low, walMgr, this.log)) {
                this.log.warning("WAL segment files were deleted after the snapshot was created. Copying a snapshot will be done without them.");
            } else {
                this.dbSnapshotSpi.copyWalSegments(snapId.longValue(), walFiles, dstPath, ctx);
                if (this.log.isInfoEnabled()) {
                    this.log.info(SnapshotCopyFuture.walSegmentsInfo(snapId, low.index(), high.index(), walFiles, dstPath));
                }
                SnapshotUtils.checkSnapshotCancellation(ctx);
            }
        }
        finally {
            if (reserved) {
                walMgr.release((WALPointer)low);
            }
        }
    }

    private void copySnapshotMetadata(long snapshotId, SnapshotPath destPath, SnapshotOperationContext context) throws IgniteCheckedException {
        assert (destPath != null);
        this.dbSnapshotSpi.copyMetadata(snapshotId, destPath, context);
    }

    private Collection<File> getWalFilesFromArchive(FileWALPointer low, FileWALPointer high) throws IgniteCheckedException {
        IgniteWriteAheadLogManager wal = this.cctx.wal();
        if (wal instanceof FileWriteAheadLogManager) {
            return ((FileWriteAheadLogManager)wal).getWalFilesFromArchive(low, high);
        }
        throw new IgniteCheckedException("Wal manager is not configured");
    }

    private static String walSegmentsInfo(long snapId, long low, long high, Collection<File> walSegmentFiles, SnapshotPath dstPath) {
        SB sb = new SB();
        sb.a("\n");
        sb.a("Copy segments for snapshot " + snapId + " [low=" + low + " -> high=" + high + ")\n");
        sb.a("Source dir:");
        if (F.isEmpty(walSegmentFiles)) {
            sb.a("N/A").a("\n");
            sb.a("Nothing for coping");
        } else {
            Iterator<File> it = walSegmentFiles.iterator();
            File first = it.next();
            sb.a(first.getParentFile().getAbsolutePath()).a("\n");
            sb.a("Target dir:" + dstPath.resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName(snapId, null))).a("\n");
            sb.a("Files:\n");
            sb.a(first.getName()).a("\n");
            while (it.hasNext()) {
                File nextSeg = it.next();
                sb.a(nextSeg.getName()).a("\n");
            }
        }
        return sb.toString();
    }

    private void cleanup(SnapshotOperationInfoImpl snapshotInfo) {
        SnapshotPath dstPath = this.getDestinationPath(snapshotInfo.snapshotOperation());
        assert (dstPath != null);
        SnapshotPath snapDir = this.dbSnapshotSpi.findCurNodeSnapshotDir(dstPath, snapshotInfo.snapshotId());
        if (snapDir == null && this.log.isInfoEnabled()) {
            this.log.info("Couldn't find directory of current node for cleanup, operation=" + snapshotInfo.snapshotOperation());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cleaning up of snapshot " + snapshotInfo.snapshotId());
        }
        if (snapDir.exists()) {
            snapDir.delete();
        }
        SnapshotPath parent = snapDir.getParent();
        try {
            parent.deleteIfEmpty();
        }
        catch (IOException e) {
            U.warn((IgniteLogger)this.log, (Object)("Couldn't delete snapshot dir " + parent + ", error=" + e));
        }
    }

    private void createSingleMetadataFileForCopiedSnapshot(long snapshotId, SnapshotPath destPath, boolean singleCopy) throws IgniteCheckedException {
        DatabaseSnapshotSpi spi = this.dbSnapshotSpi;
        SnapshotPath snapshotDir = spi.findSnapshotDir(destPath, snapshotId);
        if (snapshotDir == null) {
            if (!singleCopy) {
                throw new IllegalStateException("Couldn't find snapshot folder in path=" + destPath + " before creating single metadata file.");
            }
            snapshotDir = spi.generateSnapshotFolderPath(destPath, snapshotId);
            if (!snapshotDir.createDirectories() && !snapshotDir.exists()) {
                throw new IgniteCheckedException("Canot create snapshot directory " + snapshotDir);
            }
        }
        SnapshotPath file = snapshotDir.resolve("snapshot-meta.bin");
        SnapshotMetadataV2 totalMetadata = singleCopy ? this.generator.getUpdatedMetadata() : this.readAndMergeMetadataInPath(snapshotId, destPath);
        try {
            totalMetadata.prepareMarshal();
            try (OutputStream stream = file.outputStream();){
                stream.write(new JdkMarshaller().marshal((Object)totalMetadata));
            }
            file.sync();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not complete snapshot moving " + snapshotId + " on node " + this.cctx.localNodeId(), (Throwable)e);
        }
    }

    private SnapshotMetadataV2 readAndMergeMetadataInPath(long snapshotId, SnapshotPath destPath) throws IgniteCheckedException {
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotId, Collections.singleton(destPath), null, false, null, false);
        if (snapshot == null) {
            throw new IgniteCheckedException("Could not complete snapshot moving " + snapshotId + " on node " + this.cctx.localNodeId() + ", copied snapshot not found");
        }
        return snapshot.metadata();
    }

    @Override
    protected Integer snapshotEventType(SnapshotOperationFuture.SnapshotOperationLifecycleStage lifecycleStage) {
        switch (lifecycleStage) {
            case OP_STARTED: {
                return 1033;
            }
            case OP_FINISHED: {
                return 1034;
            }
        }
        return null;
    }
}

