/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.ExchangeRecord;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.RecoveryDebug;
import org.apache.ignite.internal.processors.cache.persistence.file.FileDownloader;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileUploader;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.IterationReason;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.internal.processors.cache.database.recovery.NodeStartPoint;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRLocalRecoveryFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRUtils;
import org.gridgain.grid.internal.processors.cache.database.recovery.PartitionFileTransferRequestMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.PartitionFileTransferResponseMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.PitrEntryPredicate;
import org.gridgain.grid.internal.processors.cache.database.recovery.PitrWalScanFilter;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryCoordinatorLeftException;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxConvergenceMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateCommunicationProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateRequest;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateResponse;
import org.gridgain.grid.internal.processors.cache.database.recovery.WALPointerIntervalProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;

public class PITRLocalFolderRecoveryContext
extends PITRRecoveryContext {
    private final long doubleCheckInterval = IgniteSystemProperties.getLong((String)"GG_POINT_IN_TIME_DOUBLE_CHECK_INTERVAL", (long)1000L);
    private final ExecutorService fileTransferExec = Executors.newFixedThreadPool(PITRUtils.FETCH_POOL_SIZE);
    private final SnapshotPath snapshotPath;
    protected final ExecutorService exec;
    private final ConcurrentMap<UUID, FileDownloader> downloaders = new ConcurrentHashMap<UUID, FileDownloader>();
    protected volatile PITRFuture scanFut;
    private volatile WALPointer nodeJoinPtr;
    protected volatile WALPointer recoveryPtr;
    private volatile Map<Integer, Set<Integer>> fetchParts;
    private final ConsistentCutMeta locCutMeta;

    protected PITRLocalFolderRecoveryContext(IgniteLogger log, long snpId, SnapshotPath snpPath, long time, GridKernalContext ctx, BaselineTopology snpBlt, SnapshotMetadataV2 metadata, Object id, AffinityTopologyVersion ver) {
        super(ctx, log, snpBlt, metadata, id, ver, time, snpId);
        this.snapshotPath = snpPath;
        this.exec = Executors.newSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory(ctx.igniteInstanceName(), "pitr-ctx-exec"));
        if (metadata != null) {
            Object locNodeConstId = ctx.discovery().localNode().consistentId();
            Short shortConsistentId = metadata.baselineTopology().resolveShortConsistentId(locNodeConstId);
            this.locCutMeta = shortConsistentId != null ? (ConsistentCutMeta)metadata.consistentCutMetas().get(shortConsistentId) : null;
        } else {
            this.locCutMeta = null;
        }
    }

    @Override
    public void onComplete(Throwable e) {
        super.onComplete(e);
        if (e != null) {
            this.scanFut.onDone(e);
        }
    }

    protected Set<Object> resolvePresentNodeConstIds() {
        HashSet<Object> presentNodes = new HashSet<Object>();
        Set bltNodes = this.snpBlt.consistentIds();
        for (ClusterNode node : this.ig.discovery().serverNodes(this.topVer)) {
            Object constId = node.consistentId();
            if (!bltNodes.contains(constId)) continue;
            presentNodes.add(constId);
        }
        return presentNodes;
    }

    @Override
    public void onNodeLeft(ClusterNode node, boolean initCrd) {
        PITRFuture scanFut0 = this.scanFut;
        if ((scanFut0 == null || !scanFut0.isDone()) && initCrd) {
            throw new RecoveryCoordinatorLeftException("Coordinator left during recovery before sending aggregated scan result, can't finish recovery.");
        }
        if (scanFut0 != null) {
            scanFut0.onNodeLeft(node.consistentId());
        }
    }

    @Override
    public GridMessageListener init() throws IgniteCheckedException {
        ClusterNode crd = SnapshotUtils.getSnapshotCrd(this.topVer, this.ig.cache().context());
        this.scanFut = new PITRLocalRecoveryFuture(this.time, this.snpId, this.snpBlt, crd.isLocal(), crd.consistentId(), this.locNodeConstId, this.resolvePresentNodeConstIds(), this.sender(), this.log, this.rd);
        T3<WALPointer, WALPointer, Map<Integer, Set<Integer>>> tup = this.resolveRecoveryPoint();
        this.nodeJoinPtr = (WALPointer)tup.get1();
        this.recoveryPtr = (WALPointer)tup.get2();
        this.fetchParts = (Map)tup.get3();
        if (this.rd != null) {
            this.appendDebugInfo(this.rd);
        }
        return new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof PartitionFileTransferRequestMessage) {
                    PITRLocalFolderRecoveryContext.this.handleFileTransferRequest(nodeId, (PartitionFileTransferRequestMessage)msg);
                } else if (msg instanceof PartitionFileTransferResponseMessage) {
                    PITRLocalFolderRecoveryContext.this.handleFileTransferResponse(nodeId, (PartitionFileTransferResponseMessage)msg);
                }
                if (msg instanceof TxStateRequest) {
                    PITRLocalFolderRecoveryContext.this.scanFut.processRequest(PITRLocalFolderRecoveryContext.this.mapToConstId(nodeId), (TxStateRequest)msg);
                } else if (msg instanceof TxStateResponse) {
                    PITRLocalFolderRecoveryContext.this.scanFut.processResponse(PITRLocalFolderRecoveryContext.this.mapToConstId(nodeId), (TxStateResponse)msg);
                } else if (msg instanceof TxConvergenceMessage) {
                    PITRLocalFolderRecoveryContext.this.scanFut.processConvergenceMessage(PITRLocalFolderRecoveryContext.this.mapToConstId(nodeId), (TxConvergenceMessage)msg);
                }
            }
        };
    }

    protected WALPointer resolveRecoveryPtr() {
        if (this.nodeJoinPtr != null) {
            return this.nodeJoinPtr;
        }
        if (this.recoveryPtr != null) {
            return this.recoveryPtr;
        }
        return null;
    }

    @Override
    public IgniteInternalFuture<Set<Object>> scanForLeftNodes() {
        WALPointer ptr = this.resolveRecoveryPtr();
        if (ptr == null) {
            return new GridFinishedFuture();
        }
        GridFutureAdapter finishFut = new GridFutureAdapter();
        this.exec.execute(() -> {
            try {
                IgniteWriteAheadLogManager wal = this.ig.cache().context().wal();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Scan wal log procedure initiated localNodeConstId=" + this.locNodeConstId + ", initWalPointer=" + ptr);
                }
                PitrWalScanFilter filter = this.locCutMeta == null ? PitrWalScanFilter.ALWAYS_TRUE : new PitrWalScanFilter(this.locCutMeta);
                this.withWalIterator((IgniteThrowableConsumer<WALIterator>)(IgniteThrowableConsumer & Serializable)it -> finishFut.onDone(this.scanFut.scan((WALIterator)it, filter)), ptr);
            }
            catch (Throwable e) {
                this.log.error("Fail scan wal log for recovery localNodeConstId=" + this.locNodeConstId, e);
                finishFut.onDone(e);
            }
        });
        return finishFut;
    }

    @Override
    public IgniteInternalFuture<?> continueScan(final Set<Object> allLeftNodes, final SnapshotOperationContext snapshotOperationContext) {
        final GridFutureAdapter finishFut = new GridFutureAdapter();
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                TxStateCommunicationProgressCalculator calc = new TxStateCommunicationProgressCalculator();
                calc.addTotal(PITRLocalFolderRecoveryContext.this.scanFut.generateRequestsAndGetSize(allLeftNodes));
                snapshotOperationContext.setProgressCalculator((SnapshotProgressCalculator)calc);
                try {
                    if (PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                        PITRLocalFolderRecoveryContext.this.log.info("Continue scan wal log procedure initiated localNodeConstId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId);
                    }
                    PITRLocalFolderRecoveryContext.this.scanFut.continueTxStateCommunication(snapshotOperationContext);
                    finishFut.onDone();
                }
                catch (Throwable e) {
                    PITRLocalFolderRecoveryContext.this.log.error("Fail continue scan wal log for recovery localNodeConstId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId, e);
                    finishFut.onDone(e);
                }
            }
        });
        return finishFut;
    }

    @Override
    public IgniteInternalFuture<?> recovery(final SnapshotOperationContext snapshotOperationContext) {
        final GridFutureAdapter finishFut = new GridFutureAdapter();
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    PITRFuture.Result res = (PITRFuture.Result)PITRLocalFolderRecoveryContext.this.scanFut.get();
                    WALPointer initWalPnt = F.isEmpty((Map)PITRLocalFolderRecoveryContext.this.fetchParts) ? PITRLocalFolderRecoveryContext.this.recoveryPtr : PITRLocalFolderRecoveryContext.this.nodeJoinPtr;
                    FileWALPointer lastWalPnt = (FileWALPointer)res.getEndWalPointer();
                    Set<GridCacheVersion> skipTxUpdates = res.getSkipTxs();
                    Map<Integer, Set<Integer>> cachesToRebalance = res.getPartToRebalance();
                    if ((lastWalPnt == null || initWalPnt == null) && F.isEmpty(cachesToRebalance)) {
                        if (PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                            PITRLocalFolderRecoveryContext.this.log.warning("Nothing for apply localNodeConstId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId);
                        }
                        finishFut.onDone();
                        return;
                    }
                    String recoveryPoints = "[" + PITRRecoveryContext.walPoint(initWalPnt) + " -> " + PITRRecoveryContext.walPoint((WALPointer)lastWalPnt) + "]";
                    if (PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                        PITRLocalFolderRecoveryContext.this.log.info("Start local recovery localNodeConstId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId + "\n" + recoveryPoints + "\ntransactions with id will be skipped:" + skipTxUpdates.size() + " " + Arrays.toString(skipTxUpdates.toArray()) + "\nrebalance " + cachesToRebalance.size() + "\n");
                    }
                    assert (PITRLocalFolderRecoveryContext.this.castAndCompareFileWalPoint(initWalPnt, (WALPointer)lastWalPnt) <= 0);
                    WALPointerIntervalProgressCalculator recoveryProgressCalculator = new WALPointerIntervalProgressCalculator(PITRLocalFolderRecoveryContext.this.ig.config().getDataStorageConfiguration().getWalSegmentSize(), snapshotOperationContext, PITRLocalFolderRecoveryContext.this.log);
                    Integer iteratorIndex = recoveryProgressCalculator.addWALPointers((FileWALPointer)res.getBeginWalPointer(), lastWalPnt);
                    recoveryProgressCalculator.calculateStep();
                    snapshotOperationContext.setProgressCalculator((SnapshotProgressCalculator)recoveryProgressCalculator);
                    if (initWalPnt != null) {
                        PITRLocalFolderRecoveryContext.this.withWalIterator((IgniteThrowableConsumer<WALIterator>)(IgniteThrowableConsumer & Serializable)it -> PITRLocalFolderRecoveryContext.this.applyUpdate((WALIterator)it, res, null, null, recoveryProgressCalculator, iteratorIndex), initWalPnt);
                    } else {
                        PITRLocalFolderRecoveryContext.this.applyUpdate(null, res, null, null, recoveryProgressCalculator, iteratorIndex);
                    }
                    finishFut.onDone();
                }
                catch (Throwable e) {
                    PITRLocalFolderRecoveryContext.this.log.error("Failed apply updates on recovery localNodeConstId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId, e);
                    finishFut.onDone(e);
                }
            }
        });
        return finishFut;
    }

    public IgniteInternalFuture<?> onPartitionRestored() {
        if (!F.isEmpty(this.fetchParts)) {
            GridCompoundFuture fetchFut = new GridCompoundFuture();
            HashSet<ClusterNode> presentNodes = new HashSet<ClusterNode>();
            Set bltNodes = this.snpBlt.consistentIds();
            for (ClusterNode node : this.ig.discovery().serverNodes(this.topVer)) {
                Object constId = node.consistentId();
                if (!bltNodes.contains(constId) || !this.nodeParticipateInSnapshot(node, this.metadata)) continue;
                presentNodes.add(node);
            }
            Map groupsMetadata = this.metadata.cacheGroupsMetadata();
            for (Map.Entry<Integer, Set<Integer>> entry : this.fetchParts.entrySet()) {
                final Integer grpId = entry.getKey();
                if (PITRUtils.noNeedGroupRecovery(grpId)) continue;
                final CacheSnapshotMetadata grpMetadata = (CacheSnapshotMetadata)groupsMetadata.get(grpId);
                Map partCntrs = grpMetadata.partitionSizesPerNode();
                Collection cfgs = grpMetadata.cacheConfigurations();
                assert (!cfgs.isEmpty());
                CacheConfiguration cfg = (CacheConfiguration)cfgs.iterator().next();
                final boolean grp = cfg.getGroupName() != null;
                Set<Integer> parts = entry.getValue();
                final long total = parts.size();
                final AtomicLong partsToDownload = new AtomicLong();
                for (final Integer part : parts) {
                    Set nodes = ((Map)partCntrs.get(part)).keySet();
                    if (!F.isEmpty(nodes)) {
                        CopyOnWriteArrayList<Object> constIds = new CopyOnWriteArrayList<Object>();
                        final ConcurrentLinkedQueue<ClusterNode> owners = new ConcurrentLinkedQueue<ClusterNode>();
                        for (ClusterNode node : presentNodes) {
                            Object constId;
                            if (node.consistentId().equals(this.locNodeConstId) || !nodes.contains(U.maskForFileName((CharSequence)(constId = node.consistentId()).toString()))) continue;
                            owners.add(node);
                            constIds.add(constId);
                        }
                        GridFutureAdapter downloadFut = new GridFutureAdapter();
                        if (owners.isEmpty()) {
                            String msg = "Owner not found, grpId=" + grpId + " partId=" + part + " locNodeConstId=" + this.locNodeConstId + " owners=" + nodes + " nodesAlive=" + F.nodeConsistentIds(presentNodes);
                            downloadFut.onDone((Throwable)new IgniteCheckedException(msg));
                            continue;
                        }
                        final GridFutureAdapter finishDownloadFut = new GridFutureAdapter();
                        final ClusterNode owner = (ClusterNode)owners.poll();
                        IgniteInternalFuture<?> fetchPartFut = this.requestPartition(owner, grp, grpMetadata.cacheOrGroupName(), part);
                        fetchPartFut.listen((IgniteInClosure)new CI1<IgniteInternalFuture<?>>(){

                            public void apply(IgniteInternalFuture<?> f) {
                                try {
                                    f.get();
                                    if (PITRLocalFolderRecoveryContext.this.log != null && PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                                        partsToDownload.incrementAndGet();
                                        PITRLocalFolderRecoveryContext.this.log.info("Partition downloaded [" + partsToDownload.get() + "/" + total + "] [remoteNodeConsId=" + owner.consistentId() + ", cacheOrGroupName=" + grpMetadata.cacheOrGroupName() + ", grpId=" + grpId + ", part=" + part + ", localNodeConsId=" + PITRLocalFolderRecoveryContext.this.locNodeConstId + "]");
                                    }
                                    finishDownloadFut.onDone();
                                }
                                catch (Throwable e) {
                                    U.error((IgniteLogger)PITRLocalFolderRecoveryContext.this.log, (Object)("Failed to download partition [owner=" + owner.consistentId() + ", grpId=" + grpId + " partId=" + part + "]"), (Throwable)e);
                                    ClusterNode next = (ClusterNode)owners.poll();
                                    if (next != null) {
                                        PITRLocalFolderRecoveryContext.this.requestPartition(next, grp, grpMetadata.cacheOrGroupName(), part).listen((IgniteInClosure)this);
                                    }
                                    finishDownloadFut.onDone((Throwable)new IgniteCheckedException("None node for download [grpId=" + grpId + " partId=" + part + "]"));
                                }
                            }
                        });
                        fetchFut.add((IgniteInternalFuture)finishDownloadFut);
                        continue;
                    }
                    fetchFut.onDone((Throwable)new IgniteCheckedException("None node for download [grpId=" + grpId + " partId=" + part + "]"));
                }
            }
            fetchFut.markInitialized();
            return fetchFut;
        }
        return new GridFinishedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withWalIterator(IgniteThrowableConsumer<WALIterator> c, WALPointer initWalPnt) throws IgniteCheckedException {
        IgniteWriteAheadLogManager wal = this.ig.cache().context().wal();
        if (!wal.reserve(initWalPnt)) {
            throw new IgniteException("Failed to reserve WAL segment [ptr=" + initWalPnt + ']');
        }
        try (WALIterator it = wal.replay(initWalPnt, IterationReason.PITR);){
            c.accept((Object)it);
        }
        finally {
            wal.release(initWalPnt);
        }
    }

    private boolean nodeParticipateInSnapshot(ClusterNode node, SnapshotMetadataV2 metadata) {
        Map walPoints = metadata.walPoints();
        BaselineTopology blt = metadata.baselineTopology();
        Short comNodeId = blt.resolveShortConsistentId(node.consistentId());
        return comNodeId != null && walPoints.containsKey(comNodeId);
    }

    protected void appendDebugInfo(RecoveryDebug rd) {
        rd.append((Object)"-----recovery context------\n");
        rd.append((Object)("blt " + this.snpBlt + "\n"));
        rd.append((Object)("nodeJoinPtr " + this.nodeJoinPtr + "\n"));
        rd.append((Object)("recoveryPtr " + this.recoveryPtr + "\n"));
        rd.append((Object)("topVer " + this.topVer + "\n"));
        rd.append((Object)("alive nodes " + this.resolvePresentNodeConstIds() + "\n"));
        rd.append((Object)("time " + this.time + "\n"));
        rd.append((Object)("snapshot id " + this.snpId + "\n"));
        rd.append((Object)"fetching parts\n");
        if (!F.isEmpty(this.fetchParts)) {
            for (Map.Entry<Integer, Set<Integer>> entry : this.fetchParts.entrySet()) {
                rd.append((Object)("grpId=" + entry.getKey() + " parts=" + entry.getValue() + "\n"));
            }
        } else {
            rd.append((Object)"fetching no needed\n");
        }
        rd.append((Object)"\n");
    }

    @Override
    protected WALPointer metadataWalPointer(Object nodeConstId) {
        if (this.locCutMeta != null) {
            return this.locCutMeta.fuzzyBorderStartPtr();
        }
        return super.metadataWalPointer(nodeConstId);
    }

    private T3<WALPointer, WALPointer, Map<Integer, Set<Integer>>> resolveRecoveryPoint() throws IgniteCheckedException {
        WALPointer ptr = this.metadataWalPointer(this.locNodeConstId);
        if (ptr == null) {
            return this.tryRecoveryWithFetching();
        }
        if (this.snapshotPath != null && this.snapshotPath instanceof FsSnapshotPath) {
            FsSnapshotPath path = (FsSnapshotPath)this.snapshotPath;
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)this.ig.cache().context().snapshot();
            FileDatabaseSnapshotSpi snapshotSpi = (FileDatabaseSnapshotSpi)snapshotMgr.snapshotSpi();
            FsSnapshotPath locPath = snapshotSpi.findLocalSnapshotDir(this.snpId);
            if (locPath != null && locPath.getFile().equals(path.getFile())) {
                if (SnapshotUtils.walFilesWereDeleted(this.snpId, ptr, this.recovery.nodeStartedPoints())) {
                    throw new IgniteCheckedException("WAL files have been deleted manually after snapshot " + this.snpId + " was created. Recovery to the point in time cannot be executed on this node with given parameters.");
                }
                if (SnapshotUtils.lfsWasDeleted(this.snpId, ptr, this.locCutMeta != null, this.ig.cache().context().wal(), this.log)) {
                    throw new IgniteCheckedException("Local file system has been cleaned manually after snapshot " + this.snpId + " was created. Recovery to the point in time cannot be executed on this node with given parameters.");
                }
            }
        }
        return new T3(null, (Object)ptr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private T3<WALPointer, WALPointer, Map<Integer, Set<Integer>>> tryRecoveryWithFetching() throws IgniteCheckedException {
        IgniteWriteAheadLogManager wal = this.ig.cache().context().wal();
        FileWALPointer firstStartedWalPtr = null;
        FileWALPointer lastStartedWalPtr = null;
        for (NodeStartPoint startPoint : this.recovery.nodeStartedPoints()) {
            if (startPoint.timestamp() < this.snpId) continue;
            if (firstStartedWalPtr == null) {
                firstStartedWalPtr = lastStartedWalPtr = startPoint.walPointer();
            }
            if (startPoint.timestamp() > this.time) break;
            lastStartedWalPtr = startPoint.walPointer();
        }
        if (lastStartedWalPtr == null) {
            throw new IgniteCheckedException("Failed to find started point [snapshotId=" + this.snpId + ", time=" + U.format((long)this.time) + ']');
        }
        if (!wal.reserve(lastStartedWalPtr)) {
            throw new IgniteCheckedException("Failed to reserve WAL segment: " + lastStartedWalPtr);
        }
        WALPointer recoveryPtr = null;
        HashMap toFetchGrps = new HashMap();
        try (WALIterator it = wal.replay((WALPointer)lastStartedWalPtr, IterationReason.PITR);){
            boolean locJoin = false;
            HashMap movingParts = new HashMap();
            HashMap grpState = new HashMap();
            while (it.hasNext()) {
                IgniteBiTuple tup = (IgniteBiTuple)it.next();
                WALRecord rec = (WALRecord)tup.get2();
                if (rec instanceof TimeStampRecord) {
                    boolean safetyInterval;
                    TimeStampRecord rec0 = (TimeStampRecord)rec;
                    boolean allPartsRebalanced = locJoin && movingParts.isEmpty();
                    boolean bl = safetyInterval = rec0.timestamp() + this.doubleCheckInterval <= this.time;
                    if (allPartsRebalanced && safetyInterval) {
                        recoveryPtr = (WALPointer)tup.get1();
                        break;
                    }
                }
                switch (rec.type()) {
                    case CHECKPOINT_RECORD: {
                        CheckpointRecord chpRec = (CheckpointRecord)rec;
                        if (locJoin) break;
                        for (Map.Entry entry : chpRec.cacheGroupStates().entrySet()) {
                            Integer grpId = (Integer)entry.getKey();
                            HashMap<Integer, Byte> parts = (HashMap<Integer, Byte>)grpState.get(grpId);
                            if (parts == null) {
                                parts = new HashMap<Integer, Byte>();
                                grpState.put(grpId, parts);
                            }
                            grpState.put(grpId, parts);
                            CacheState state = (CacheState)entry.getValue();
                            for (int i = 0; i < state.size(); ++i) {
                                parts.put(state.partitionByIndex(i), state.stateByIndex(i));
                            }
                        }
                        break;
                    }
                    case EXCHANGE: {
                        ExchangeRecord exchRec = (ExchangeRecord)rec;
                        Object constId = this.snpBlt.resolveConsistentId(exchRec.getConstId());
                        if (constId == null || !this.locNodeConstId.equals(constId)) break;
                        locJoin = true;
                        for (Map.Entry entry : grpState.entrySet()) {
                            Integer grpId = (Integer)entry.getKey();
                            HashSet<Integer> moving = new HashSet<Integer>();
                            HashSet<Integer> toFetch = new HashSet<Integer>();
                            for (Map.Entry partition : ((Map)entry.getValue()).entrySet()) {
                                Integer partId = (Integer)partition.getKey();
                                if (GridDhtPartitionState.fromOrdinal((int)((Byte)partition.getValue()).byteValue()) != GridDhtPartitionState.MOVING) continue;
                                moving.add(partId);
                                toFetch.add(partId);
                            }
                            movingParts.put(grpId, moving);
                            toFetchGrps.put(grpId, toFetch);
                        }
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        Object parts;
                        PartitionMetaStateRecord rec0 = (PartitionMetaStateRecord)rec;
                        int grpId = rec0.groupId();
                        int partId = rec0.partitionId();
                        byte state = rec0.state();
                        if (!locJoin) {
                            parts = (Map)grpState.get(grpId);
                            if (parts == null) {
                                parts = new HashMap();
                                grpState.put(grpId, parts);
                            }
                            parts.put(partId, state);
                            break;
                        }
                        if (GridDhtPartitionState.fromOrdinal((int)state) != GridDhtPartitionState.OWNING) break;
                        parts = (Set)movingParts.get(grpId);
                        if (parts == null) {
                            this.log.warning("Partition already in own state, grpId:" + grpId + " partId:" + partId);
                            break;
                        }
                        boolean rmv = parts.remove(partId);
                        if (!rmv) {
                            this.log.warning("Unexpected partition change state to own partId:" + partId);
                        }
                        if (!parts.isEmpty()) break;
                        movingParts.remove(grpId);
                        break;
                    }
                }
            }
        }
        finally {
            wal.release((WALPointer)lastStartedWalPtr);
        }
        if (recoveryPtr == null) {
            return new T3((Object)firstStartedWalPtr, null, null);
        }
        return new T3((Object)firstStartedWalPtr, recoveryPtr, toFetchGrps);
    }

    private Path buildPath(boolean isGroup, String cacheOrGroupName, int partId) {
        FilePageStoreManager storeMgr = (FilePageStoreManager)this.ig.cache().context().pageStore();
        return storeMgr.getPath(isGroup, cacheOrGroupName, partId);
    }

    private IgniteInternalFuture<?> requestPartition(final ClusterNode node, final boolean isGroup, final String cacheOrGroupName, final int partId) {
        final UUID id = UUID.randomUUID();
        final FileDownloader downloader = new FileDownloader(this.log, this.buildPath(isGroup, cacheOrGroupName, partId));
        this.downloaders.put(id, downloader);
        this.fileTransferExec.submit(new Runnable(){

            @Override
            public void run() {
                FileDownloader fileDownloader = (FileDownloader)PITRLocalFolderRecoveryContext.this.downloaders.get(id);
                try {
                    InetSocketAddress address = fileDownloader.start();
                    if (PITRLocalFolderRecoveryContext.this.log != null && PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                        PITRLocalFolderRecoveryContext.this.log.info("Server socket opened [node=" + node + ", addr=" + address + ", cacheOrGroupName=" + cacheOrGroupName + ", partId=" + partId + ']');
                    }
                    PartitionFileTransferRequestMessage msg = new PartitionFileTransferRequestMessage(id, cacheOrGroupName, isGroup, partId, address.getPort());
                    PITRLocalFolderRecoveryContext.this.ig.io().sendToGridTopic(node, GridTopic.TOPIC_SNAPSHOT, (Message)msg, (byte)2);
                    if (PITRLocalFolderRecoveryContext.this.log != null && PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) {
                        PITRLocalFolderRecoveryContext.this.log.info("Sent request to download partition to " + node);
                    }
                    fileDownloader.download();
                }
                catch (IgniteCheckedException e) {
                    downloader.onResult(0L, (Throwable)e);
                }
            }
        });
        return downloader.finishFuture();
    }

    private void handleFileTransferRequest(final UUID nodeId, final PartitionFileTransferRequestMessage msg) throws IgniteException {
        final GridFutureAdapter finishFut = new GridFutureAdapter();
        finishFut.listen((IgniteInClosure)new IgniteInClosure<IgniteInternalFuture<Long>>(){

            public void apply(IgniteInternalFuture<Long> f) {
                try {
                    PartitionFileTransferResponseMessage msg0;
                    Throwable th = f.error();
                    if (th != null) {
                        msg0 = new PartitionFileTransferResponseMessage(msg.id(), -1L, U.marshal((Marshaller)PITRLocalFolderRecoveryContext.this.ig.config().getMarshaller(), (Object)th));
                    } else {
                        long size = (Long)f.get();
                        msg0 = new PartitionFileTransferResponseMessage(msg.id(), size, null);
                    }
                    PITRLocalFolderRecoveryContext.this.ig.io().sendToGridTopic(nodeId, GridTopic.TOPIC_SNAPSHOT, (Message)msg0, (byte)2);
                }
                catch (Throwable th) {
                    U.error((IgniteLogger)PITRLocalFolderRecoveryContext.this.log, (Object)"Error upload partition.", (Throwable)th);
                }
            }
        });
        final ClusterNode node = this.ig.discovery().node(nodeId);
        if (this.log != null && this.log.isInfoEnabled()) {
            this.log.info("Received request to download partition [remoteNodeConsistentId=" + node.consistentId() + ", part=" + msg.partition() + ", cacheOrGroupName=" + msg.cacheOrGroupName() + ']');
        }
        final Path path = this.buildPath(msg.isGroup(), msg.cacheOrGroupName(), msg.partition());
        this.fileTransferExec.submit(new Runnable(){

            @Override
            public void run() {
                SocketChannel sc = null;
                int port = msg.port();
                for (String address : node.addresses()) {
                    InetSocketAddress addr0 = new InetSocketAddress(address, port);
                    try {
                        sc = SocketChannel.open(addr0);
                        if (PITRLocalFolderRecoveryContext.this.log == null || !PITRLocalFolderRecoveryContext.this.log.isInfoEnabled()) break;
                        PITRLocalFolderRecoveryContext.this.log.info("Successfully connected to remote node for partition transfer [addr=" + addr0 + ", cacheOrGroupName=" + msg.cacheOrGroupName() + ", partId=" + msg.cacheOrGroupName() + ']');
                        break;
                    }
                    catch (IOException e) {
                        U.warn((IgniteLogger)PITRLocalFolderRecoveryContext.this.log, (Object)("Failed connect to " + addr0), (Throwable)e);
                    }
                }
                assert (sc != null);
                FileUploader uploader = new FileUploader(path, PITRLocalFolderRecoveryContext.this.log);
                uploader.upload(sc, finishFut);
            }
        });
    }

    private void handleFileTransferResponse(UUID nodeId, PartitionFileTransferResponseMessage msg) throws IgniteException {
        FileDownloader downloader = (FileDownloader)this.downloaders.remove(msg.id());
        if (downloader == null) {
            this.log.warning("Could not find file transfer session: " + msg.id());
            return;
        }
        Throwable th = null;
        if (msg.error() != null) {
            try {
                th = (Throwable)U.unmarshal((Marshaller)this.ig.config().getMarshaller(), (byte[])msg.error(), (ClassLoader)U.gridClassLoader());
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"Fail to unmarshal exception on file transfer message response.", (Throwable)e);
                th = e;
            }
        }
        downloader.onResult(msg.size(), th);
    }

    @Override
    protected IgniteBiPredicate<WALRecord, DataEntry> getEntryPredicate(PITRFuture.Result res, PITRRecoveryContext.MultiWalApplyPredicate multiWalApplyPred, AtomicLong appliedEntries) {
        PitrEntryPredicate superPred = super.getEntryPredicate(res, multiWalApplyPred, appliedEntries);
        return this.locCutMeta == null ? superPred : new PitrEntryPredicate(superPred, this.locCutMeta);
    }
}

