/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptionUtil;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannelInputStream;

public class DecryptionReadableChannel
implements SnapshotReadableByteChannel {
    private final SnapshotReadableByteChannel delegate;
    private final GroupKey encryptionKey;
    private final int pageSize;
    private EncryptionUtil encUtil;
    private final ByteBuffer decryptedData;
    private final boolean aligned;

    public DecryptionReadableChannel(SnapshotReadableByteChannel delegate, GroupKey encryptionKey, EncryptionSpi encSpi, int pageSize, boolean aligned) {
        this.delegate = delegate;
        this.encryptionKey = encryptionKey;
        this.pageSize = pageSize;
        this.aligned = aligned;
        this.encUtil = new EncryptionUtil(encSpi, pageSize);
        if (aligned) {
            this.decryptedData = null;
        } else {
            this.decryptedData = ByteBuffer.allocate(pageSize);
            this.decryptedData.position(pageSize);
        }
    }

    @Override
    public SnapshotReadableByteChannel plain() {
        return this.aligned ? this.delegate : this;
    }

    @Override
    public InputStream asInputStream() {
        return new SnapshotReadableByteChannelInputStream(this, this.pageSize);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.aligned) {
            if (this.decryptedData.hasRemaining()) {
                return this.copyDecryptedData(dst);
            }
            this.decryptedData.rewind();
            this.decryptedData.limit(this.pageSize);
        }
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize).order(ByteOrder.LITTLE_ENDIAN);
        int res = 0;
        do {
            int read;
            if ((read = this.delegate.read(encrypted)) == -1) {
                if (res != 0) break;
                res = -1;
                break;
            }
            res += read;
        } while (encrypted.hasRemaining());
        if (res < 0) {
            if (!this.aligned) {
                this.decryptedData.position(this.decryptedData.limit());
            }
            return res;
        }
        if (res != this.pageSize) {
            throw new IllegalStateException("Expecting to read whole page[" + this.pageSize + " bytes], but read only " + res + " bytes");
        }
        encrypted.rewind();
        int position = encrypted.getInt(this.encUtil.encryptedDataSize() + 5);
        this.encUtil.decrypt(encrypted, this.aligned ? dst : this.decryptedData, this.encryptionKey);
        if (this.aligned) {
            return res;
        }
        this.decryptedData.rewind();
        if (position != 0) {
            this.decryptedData.limit(position);
        } else {
            this.decryptedData.limit(this.encUtil.plainDataSize());
        }
        return this.copyDecryptedData(dst);
    }

    private int copyDecryptedData(ByteBuffer dst) {
        int bytes = Math.min(this.decryptedData.remaining(), dst.remaining());
        dst.put(this.decryptedData.array(), this.decryptedData.position(), bytes);
        this.decryptedData.position(this.decryptedData.position() + bytes);
        return bytes;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

