/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TxDrTransferFolderFailoverTest
extends AbstractReplicationTest {
    private static final long MAX_CUT_DELIVERY_WAIT_TIME = 10000L;
    private static final long CUT_WAIT_TIMEOUT = 20000L;

    @Override
    protected TransactionalDrConfiguration getTxDrConfiguration() throws Exception {
        return super.getTxDrConfiguration().setMaxCutDeliveryWaitTime(10000L).setConsistentCutInterval(Long.MAX_VALUE);
    }

    @Test
    public void testPartialConsistentCutApplication() throws Exception {
        int i;
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        boolean crdNodeIdx = false;
        boolean slowNodeIdx = true;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        this.populateData((Ignite)masterCluster.get(0), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        IgniteEx masterCrd = masterCluster.get(0);
        TransactionalDrProcessorImpl txdrMasterSlow = this.txdr((Ignite)masterCluster.get(1));
        TxDrTransferFolderFailoverTest.assertTrue((boolean)txdrMasterSlow.walSender().walManager().reserve((WALPointer)new FileWALPointer(txdrMasterSlow.localState().lastSuccessfullySentWalIndex(), 0, 0)));
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        TransactionalDrProcessorImpl txdrReplicaCrd = this.txdr((Ignite)replicaCluster.get(0));
        AtomicLong lastReadyCutId = new AtomicLong();
        AtomicLong lastAppliedCutId = new AtomicLong();
        txdrReplicaCrd.consistentCutWatcher().addReadyCutsListener(lastReadyCutId::set);
        txdrReplicaCrd.consistentCutWatcher().addAppliedCutsListener(lastAppliedCutId::set);
        long ccId0 = this.forceConsistentCut((Ignite)masterCrd);
        this.waitForCut(replicaCluster, lastAppliedCutId, ccId0);
        txdrMasterSlow.walSender().stopSending().get();
        long lastSentSeg = txdrMasterSlow.walSender().lastReadySegmentIndex();
        IgniteInternalFuture txLoadFut = this.startTxLoad(2, ClusterRole.MASTER);
        long ccId1 = this.forceConsistentCut((Ignite)masterCrd);
        this.waitForCut(replicaCluster, lastReadyCutId, ccId1);
        Map readyCuts = txdrReplicaCrd.consistentCutWatcher().globalReadyNodesCuts();
        for (i = 0; i < this.nodesCnt; ++i) {
            TxDrTransferFolderFailoverTest.assertEquals(Collections.singleton(i == 1 ? ccId0 : ccId1), readyCuts.get(this.nodeConsistentId(i)));
        }
        this.waitForCut(replicaCluster, lastAppliedCutId, ccId1);
        for (i = 0; i < this.nodesCnt; ++i) {
            TxDrTransferFolderFailoverTest.assertEquals((long)(i == 1 ? ccId0 : ccId1), (long)this.txdr((Ignite)replicaCluster.get(i)).localState().lastSuccessfullyAppliedCutId());
        }
        txdrMasterSlow.walSender().startSending(lastSentSeg + 1L);
        this.stopTxLoad(txLoadFut);
        long ccId2 = this.forceConsistentCut((Ignite)masterCrd);
        this.waitForCut(replicaCluster, lastAppliedCutId, ccId2);
        this.txdr(ClusterRole.MASTER).stop().get();
        this.txdr(ClusterRole.REPLICA).stop().get();
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache"));
        TxDrTransferFolderFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    private void waitForCut(final List<IgniteEx> cluster, final AtomicLong cutId, final long expVal) throws IgniteInterruptedCheckedException {
        boolean res = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                TxDrTransferFolderFailoverTest.this.awakeCutsWatcher(cluster);
                return cutId.get() == expVal;
            }
        }, (long)20000L);
        if (!res) {
            TxDrTransferFolderFailoverTest.assertEquals((String)"Failed to wait for cut", (long)expVal, (long)cutId.get());
        }
    }
}

