/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.NodeLastEvents;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.junit.Test;

public class TxDrTopologyTrackerTest
extends AbstractReplicationTest {
    private static final long WAIT_CONDITION_PERIOD = 6000L;
    protected boolean useRecordingCommSpi;
    protected int rebalanceBatchSize = 524288;
    protected long rebalanceThrottle = 0L;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.useRecordingCommSpi = false;
        this.consistentCutInterval = Long.MAX_VALUE;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName, consistentId, role);
        if (ClusterRole.MASTER == role) {
            for (CacheConfiguration ccfg : cfg.getCacheConfiguration()) {
                ccfg.setRebalanceBatchSize(this.rebalanceBatchSize);
                ccfg.setRebalanceThrottle(this.rebalanceThrottle);
            }
        }
        if (this.useRecordingCommSpi) {
            TestRecordingCommunicationSpi commSpi = new TestRecordingCommunicationSpi();
            commSpi.setLocalPort(GridTestUtils.getNextCommPort(((Object)((Object)this)).getClass()));
            cfg.setCommunicationSpi((CommunicationSpi)commSpi);
        }
        return cfg;
    }

    @Test
    public void testEventLogOnBootstrappingPhase() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long snapshotId = this.bootstrapMaster();
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, snapshotId, expEvts);
    }

    @Test
    public void testNodeLeftEvent() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        ArrayList<Object> consistentIds = new ArrayList<Object>();
        for (IgniteEx ig : masterCluster) {
            consistentIds.add(ig.cluster().localNode().consistentId());
        }
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.bootstrapMaster();
        long cutIdNoEvts = this.forceConsistentCut((Ignite)master0);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutIdNoEvts, expEvts);
        Object stopNodeId = consistentIds.get(consistentIds.size() - 1);
        masterCluster.get(masterCluster.size() - 1).close();
        masterCluster.remove(masterCluster.size() - 1);
        long leftCutId = this.forceConsistentCut((Ignite)master0);
        expEvts.put(stopNodeId, new NodeLastEvents(leftCutId, -1L));
        this.checkExpectedEvents(masterCluster, leftCutId, expEvts);
    }

    @Test
    public void testNodeJoinEvent() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        ArrayList<Object> consistentIds = new ArrayList<Object>();
        for (IgniteEx ig : masterCluster) {
            consistentIds.add(ig.cluster().localNode().consistentId());
        }
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.bootstrapMaster();
        long cutIdNoEvts = this.forceConsistentCut((Ignite)master0);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutIdNoEvts, expEvts);
        int stopIdx = consistentIds.size() - 1;
        Object stopNodeId = consistentIds.get(stopIdx);
        masterCluster.get(stopIdx).close();
        masterCluster.remove(stopIdx);
        long leftCutId = this.forceConsistentCut((Ignite)master0);
        expEvts.put(stopNodeId, new NodeLastEvents(leftCutId, -1L));
        this.checkExpectedEvents(masterCluster, leftCutId, expEvts);
        IgniteEx restartedNode = this.startClusterNode(ClusterRole.MASTER, stopIdx, consistentIds.get(stopIdx).toString());
        masterCluster.add(restartedNode);
        this.awaitPartitionMapExchange(false, true, null);
        long joinCutId = this.forceConsistentCut((Ignite)master0);
        expEvts.put(stopNodeId, new NodeLastEvents(leftCutId, joinCutId));
        this.checkExpectedEvents(masterCluster, joinCutId, expEvts);
    }

    @Test
    public void testActivateDeactivateClusters() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx masterCrd = masterCluster.get(0);
        IgniteEx replicaCrd = replicaCluster.get(0);
        this.populateData((Ignite)masterCrd, "txCache");
        this.populateData((Ignite)masterCrd, "atomicCache");
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        long cutId = this.forceConsistentCut((Ignite)masterCrd);
        this.checkExpectedEvents(masterCluster, cutId, expEvts);
        this.bootstrapReplica(sesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.waitForApplyingCut(replicaCluster, cutId, 6000L);
        masterCrd.cluster().active(false);
        replicaCrd.cluster().active(false);
        masterCrd.cluster().active(true);
        replicaCrd.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        cutId = this.forceConsistentCut((Ignite)masterCrd);
        this.checkExpectedEvents(masterCluster, cutId, expEvts);
        this.waitForApplyingCut(replicaCluster, cutId, 6000L);
    }

    @Test
    public void testLeftNodeAfterDeactivation() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx crd = masterCluster.get(0);
        IgniteEx leftNode = masterCluster.get(1);
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cut1 = this.forceConsistentCut((Ignite)crd);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cut1, expEvts);
        crd.cluster().active(false);
        Object consistentId = leftNode.localNode().consistentId();
        this.stopClusterNode(ClusterRole.MASTER, leftNode);
        masterCluster = (List)this.clusterMap.get(ClusterRole.MASTER);
        crd.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cut2 = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cut2, -1L));
        this.checkExpectedEvents(masterCluster, cut2, expEvts);
    }

    @Test
    public void testRestartCoordinatorAfterDeactivation() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutId, expEvts);
        Object consistentId = masterCluster.get(masterCluster.size() - 1).localNode().consistentId();
        this.stopCluster(ClusterRole.MASTER);
        this.nodesCnt = 1;
        masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx crd = masterCluster.get(0);
        crd.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        cutId = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cutId, -1L));
        this.checkExpectedEvents(masterCluster, cutId, expEvts);
    }

    @Test
    public void testRestartCoordinatorAfterDeactivation2() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        Object consistentId = masterCluster.get(masterCluster.size() - 1).localNode().consistentId();
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cutId1 = this.forceConsistentCut((Ignite)masterCluster.get(0));
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutId1, expEvts);
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(masterCluster.size() - 1));
        long cutId2 = this.forceConsistentCut((Ignite)masterCluster.get(0));
        expEvts.put(consistentId, new NodeLastEvents(cutId2, -1L));
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(0));
        this.nodesCnt = 1;
        masterCluster = this.startCluster(ClusterRole.MASTER);
        long cutId3 = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.checkExpectedEvents(masterCluster, cutId3, expEvts);
    }

    @Test
    public void testDeactivateClusterAfterRebalancing() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx crd = masterCluster.get(0);
        int stopIdx = masterCluster.size() - 1;
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cutId1 = this.forceConsistentCut((Ignite)crd);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutId1, expEvts);
        Object consistentId = masterCluster.get(stopIdx).localNode().consistentId();
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(stopIdx));
        long cutId2 = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cutId2, -1L));
        this.checkExpectedEvents((List)this.clusterMap.get(ClusterRole.MASTER), cutId2, expEvts);
        this.startClusterNode(ClusterRole.MASTER, stopIdx);
        this.awaitPartitionMapExchange(false, true, crd.context().discovery().aliveServerNodes());
        crd.cluster().active(false);
        crd.cluster().active(true);
        long cutId3 = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cutId2, cutId3));
        this.checkExpectedEvents((List)this.clusterMap.get(ClusterRole.MASTER), cutId3, expEvts);
    }

    @Test
    public void testDeactivateClusterBeforeRebalancingCompleted() throws Exception {
        this.useRecordingCommSpi = true;
        this.rebalanceBatchSize = 256;
        this.rebalanceThrottle = 250L;
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx crd = masterCluster.get(0);
        int stopIdx = masterCluster.size() - 1;
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        long cutId1 = this.forceConsistentCut((Ignite)crd);
        Map<Object, NodeLastEvents> expEvts = this.initialNodesLastEvents(masterCluster);
        this.checkExpectedEvents(masterCluster, cutId1, expEvts);
        Object consistentId = masterCluster.get(stopIdx).localNode().consistentId();
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(stopIdx));
        long cutId2 = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cutId2, -1L));
        this.checkExpectedEvents((List)this.clusterMap.get(ClusterRole.MASTER), cutId2, expEvts);
        this.populateData((Ignite)crd, "txCache");
        this.populateData((Ignite)crd, "atomicCache");
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)crd);
        spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof GridDhtPartitionSupplyMessage) {
                GridDhtPartitionSupplyMessage supMsg = (GridDhtPartitionSupplyMessage)msg;
                return supMsg.groupId() == CU.cacheId((String)"txCache");
            }
            return false;
        });
        this.startClusterNode(ClusterRole.MASTER, stopIdx);
        masterCluster = (List)this.clusterMap.get(ClusterRole.MASTER);
        spi.waitForBlocked();
        spi.stopBlock(false);
        crd.cluster().active(false);
        crd.cluster().active(true);
        spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof GridDhtPartitionSupplyMessage) {
                GridDhtPartitionSupplyMessage supMsg = (GridDhtPartitionSupplyMessage)msg;
                return supMsg.groupId() == CU.cacheId((String)"txCache");
            }
            return false;
        });
        spi.waitForBlocked();
        long cutId3 = this.forceConsistentCut((Ignite)crd);
        this.checkExpectedEvents(masterCluster, cutId3, expEvts);
        spi.stopBlock();
        this.awaitPartitionMapExchange(false, true, crd.context().discovery().aliveServerNodes());
        long cutId4 = this.forceConsistentCut((Ignite)crd);
        expEvts.put(consistentId, new NodeLastEvents(cutId2, cutId4));
        this.checkExpectedEvents((List)this.clusterMap.get(ClusterRole.MASTER), cutId4, expEvts);
    }

    @Test
    public void testConsistentCutSchedulerAfterDeactivation() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        this.consistentCutInterval = 2000L;
        List masterCluster = this.startCluster(ClusterRole.MASTER);
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        TxDrTopologyTrackerTest.assertTrue((String)"There are no new consistent cuts.", (boolean)this.checkMasterClusterProgress(masterCluster.get(0)));
        masterCluster.get(0).cluster().active(false);
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(0));
        masterCluster = (List)this.clusterMap.get(ClusterRole.MASTER);
        TxDrTopologyTrackerTest.assertFalse((String)"New consistent cuts should not be created.", (boolean)this.checkMasterClusterProgress((IgniteEx)masterCluster.get(0)));
        ((IgniteEx)masterCluster.get(0)).cluster().active(true);
        TxDrTopologyTrackerTest.assertTrue((String)"Creating of new consistent cuts should be triggered by new coordinator node.", (boolean)this.checkMasterClusterProgress((IgniteEx)masterCluster.get(0)));
    }

    @Test
    public void testConsistentCutSchedulerAfterDeactivation2() throws Exception {
        this.clientsCnt = 0;
        this.consistentCutInterval = 2000L;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx crd = masterCluster.get(0);
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        TxDrTopologyTrackerTest.assertTrue((String)"There are no new consistent cuts.", (boolean)this.checkMasterClusterProgress(crd));
        crd.cluster().active(false);
        TxDrTopologyTrackerTest.assertFalse((String)"New consistent cuts should not be created.", (boolean)this.checkMasterClusterProgress(crd));
        crd.cluster().active(true);
        TxDrTopologyTrackerTest.assertTrue((String)"There are no new consistent cuts.", (boolean)this.checkMasterClusterProgress(crd));
        this.stopClusterNode(ClusterRole.MASTER, masterCluster.get(0));
        TxDrTopologyTrackerTest.assertTrue((String)"Creating of new consistent cuts should be triggered by new coordinator node.", (boolean)this.checkMasterClusterProgress((IgniteEx)((List)this.clusterMap.get(ClusterRole.MASTER)).get(0)));
    }

    private boolean checkMasterClusterProgress(IgniteEx crd) throws IgniteInterruptedCheckedException {
        long currCutId = this.txdr((Ignite)crd).localState().lastCreatedCutId();
        return GridTestUtils.waitForCondition(() -> this.txdr((Ignite)crd).localState().lastCreatedCutId() > currCutId, (long)6000L);
    }

    private Map<Object, NodeLastEvents> initialNodesLastEvents(List<IgniteEx> cluster) {
        HashMap<Object, NodeLastEvents> initEvts = new HashMap<Object, NodeLastEvents>();
        for (IgniteEx ig : cluster) {
            initEvts.put(ig.cluster().localNode().consistentId(), NodeLastEvents.NO_EVENTS);
        }
        return initEvts;
    }

    private void checkExpectedEvents(List<IgniteEx> masterCluster, long consistentCutId, Map<Object, NodeLastEvents> expEvts) throws IgniteCheckedException {
        for (IgniteEx ig : masterCluster) {
            ConsistentCut consistentCut;
            try {
                consistentCut = this.loadConsistentCut(consistentCutId, (Ignite)ig);
            }
            catch (IgniteCheckedException e) {
                TxDrTopologyTrackerTest.fail((String)("Consistent cut not found [cut=" + consistentCutId + ", node=" + ig.cluster().localNode().consistentId() + ']'));
                throw e;
            }
            Map evts = consistentCut.bltNodesLastEvts();
            TxDrTopologyTrackerTest.assertFalse((String)"Event log does not contain any events.", (boolean)evts.isEmpty());
            TxDrTopologyTrackerTest.assertEquals((int)expEvts.size(), (int)evts.size());
            for (Map.Entry e : evts.entrySet()) {
                NodeLastEvents exp = expEvts.get(e.getKey());
                TxDrTopologyTrackerTest.assertNotNull((String)("Topology change events not found for the node consistentId=" + e.getKey()), (Object)exp);
                TxDrTopologyTrackerTest.assertEquals((long)exp.joinCutId(), (long)((NodeLastEvents)e.getValue()).joinCutId());
                TxDrTopologyTrackerTest.assertEquals((long)exp.leftCutId(), (long)((NodeLastEvents)e.getValue()).leftCutId());
            }
        }
    }
}

