/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsDumpTask;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class TxDrBasicScenariosTest
extends AbstractReplicationTest {
    private static final String CACHE_NAME = "test-cache";

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName, consistentId, role);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME);
        ccfg.setBackups(this.backupsCnt);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ArrayList<CacheConfiguration> list = new ArrayList<CacheConfiguration>(Arrays.asList(cfg.getCacheConfiguration()));
        list.add(ccfg);
        cfg.setCacheConfiguration(list.toArray(new CacheConfiguration[list.size()]));
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 3;
        this.backupsCnt = 1;
    }

    protected long getTestTimeout() {
        return 600000L;
    }

    @Test
    public void testScenario1() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx replica0 = replicaCluster.get(0);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        IgniteCache masterTxCache = this.node(ClusterRole.MASTER).cache("txCache");
        IgniteCache masterAtomicCache = this.node(ClusterRole.MASTER).cache("atomicCache");
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        long bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        IgniteCache replicaTxCache = replica0.cache("txCache");
        IgniteCache replicaAtomicCache = replica0.cache("atomicCache");
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertEquals(dumpMasterTx, dumpReplicaTx);
        TxDrBasicScenariosTest.assertEquals(dumpMasterAtomic, dumpReplicaAtomic);
        for (int i = 0; i < 100; ++i) {
            masterTxCache.put((Object)i, (Object)((long)(-i) * 2L));
            masterAtomicCache.put((Object)i, (Object)((long)(-i) * 3L));
        }
        long dataUpdateTs = U.currentTimeMillis();
        boolean awaited = GridTestUtils.waitForCondition(() -> {
            for (int i = 0; i < 100; ++i) {
                if (!Objects.equals(replicaTxCache.get((Object)i), (long)(-i) * 2L)) {
                    return false;
                }
                if (Objects.equals(replicaAtomicCache.get((Object)i), (long)(-i) * 3L)) continue;
                return false;
            }
            return true;
        }, (long)120000L);
        TxDrBasicScenariosTest.assertTrue((boolean)awaited);
        System.out.println(">>> Data arrived to replica in " + (U.currentTimeMillis() - dataUpdateTs) + "ms");
    }

    @Test
    public void testScenario2() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx replica0 = replicaCluster.get(0);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(bootstrapSesId);
        IgniteCache masterTxCache = this.node(ClusterRole.MASTER).cache("txCache");
        IgniteCache masterAtomicCache = this.node(ClusterRole.MASTER).cache("atomicCache");
        IgniteCache replicaTxCache = replica0.cache("txCache");
        IgniteCache replicaAtomicCache = replica0.cache("atomicCache");
        Map<Integer, Long> dumpMasterTx0 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        Map<Integer, Long> dumpReplicaTx0 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertTrue((dumpMasterTx0.equals(dumpReplicaTx0) && dumpMasterAtomic0.equals(dumpReplicaAtomic0) ? 1 : 0) != 0);
        IgniteInternalFuture loadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrBasicScenariosTest.doSleep((long)10000L);
        this.stopTxLoad(loadFut);
        Map<Integer, Long> dumpMasterTx1 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic1 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        boolean awaited = GridTestUtils.waitForCondition(() -> {
            Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
            Map<Integer, Long> dumpReplicaAtomic = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
            return dumpMasterTx1.equals(dumpReplicaTx) && dumpMasterAtomic1.equals(dumpReplicaAtomic);
        }, (long)120000L);
        TxDrBasicScenariosTest.assertTrue((boolean)awaited);
        TxDrBasicScenariosTest.assertTrue((boolean)this.idleVerifyReplica(replica0));
    }

    @Test
    public void testScenario3() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)masterCluster.get(0), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        TxDrBasicScenariosTest.assertFalse((boolean)masterCluster.stream().map(ig -> this.txdr((Ignite)ig).localState().readOnly()).filter(ro -> ro).findFirst().orElse(false));
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        TxDrBasicScenariosTest.assertFalse((boolean)replicaCluster.stream().map(ig -> this.txdr((Ignite)ig).localState().readOnly()).filter(ro -> ro == false).findFirst().orElse(false));
        TxDrBasicScenariosTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrBasicScenariosTest.doSleep((long)5000L);
        bootstrapSesId = (Long)this.txdr(ClusterRole.MASTER).switchWithReplica().get();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.stopTxLoad(txLoadFut);
        this.assertClusterReadOnly(masterCluster);
        this.awakeCutsWatcher(replicaCluster);
        TxDrBasicScenariosTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)10000L));
        this.assertClusterState(replicaCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache"));
        TxDrBasicScenariosTest.assertEquals(dumpMasterTx, dumpReplicaTx);
        replicaCluster.get(0).cache("txCache").put((Object)1, (Object)1);
    }

    @Test
    public void testScenario3_1() throws Exception {
        boolean ok;
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        this.populateData((Ignite)masterCluster.get(0), "txCache");
        this.populateData((Ignite)masterCluster.get(0), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        IgniteEx client = this.startClient(ClusterRole.MASTER, 16);
        IgniteInternalFuture txLoadFut = this.startTxLoad(4, null, (Ignite)client);
        IgniteInternalFuture atomicLoadFut = this.startAtomicLoad(4, null, (Ignite)client);
        log.info(">>> Replica cluster bootstrapped successfully, sessionId=" + bootstrapSesId);
        TxDrBasicScenariosTest.doSleep((long)5000L);
        bootstrapSesId = (Long)this.txdr(ClusterRole.MASTER).switchWithReplica().get();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.stopTxLoad(txLoadFut);
        this.stopAtomicLoad(atomicLoadFut);
        this.awakeCutsWatcher(replicaCluster);
        TxDrBasicScenariosTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)60000L));
        this.assertClusterState(replicaCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
        String masterDumpPath = this.idleDump(masterCluster.get(0));
        String replicaDumpPath = this.idleDump(replicaCluster.get(0));
        List<String> masterLines = Files.readAllLines(Paths.get(masterDumpPath, new String[0]));
        List<String> replicaLines = Files.readAllLines(Paths.get(replicaDumpPath, new String[0]));
        boolean bl = ok = masterLines.size() == replicaLines.size();
        if (!ok) {
            log.warning("Master/replica dump sizes differ [master= " + masterLines.size() + ", replica=" + replicaLines.size());
        }
        if (!masterLines.equals(replicaLines)) {
            ok = false;
            for (int i = 0; i < masterLines.size(); ++i) {
                if (masterLines.get(i).equals(replicaLines.get(i))) continue;
                log.warning("Partition has differences: \n" + masterLines.get(i) + '\n' + replicaLines.get(i) + '\n');
            }
        }
        TxDrBasicScenariosTest.assertTrue((boolean)ok);
    }

    private String idleDump(IgniteEx ignite) {
        HashSet<String> caches = new HashSet<String>();
        caches.add("txCache");
        caches.add("atomicCache");
        return (String)ignite.compute().execute(VerifyBackupPartitionsDumpTask.class.getName(), (Object)new VisorIdleVerifyDumpTaskArg(caches, null, false, CacheFilterEnum.ALL, true));
    }

    @Test
    public void testScenario6() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx master0 = masterCluster.get(0);
        IgniteEx replica0 = replicaCluster.get(0);
        Map<Object, Long> archivedWalSegments = this.listenWALSegmentArchivedEvent(masterCluster);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        IgniteCache masterTxCache = this.node(ClusterRole.MASTER).cache("txCache");
        IgniteCache masterAtomicCache = this.node(ClusterRole.MASTER).cache("atomicCache");
        Map<Integer, Long> dumpMasterTx0 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        long snapshotId = this.bootstrapMaster();
        this.bootstrapReplica(snapshotId);
        this.assertClusterReadOnly(replicaCluster);
        IgniteCache replicaTxCache = replica0.cache("txCache");
        IgniteCache replicaAtomicCache = replica0.cache("atomicCache");
        Map<Integer, Long> dumpReplicaTx0 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertEquals((String)"Tx cache dump on master and replica must be same!", dumpMasterTx0, dumpReplicaTx0);
        TxDrBasicScenariosTest.assertEquals((String)"Atomic cache dump on master and replica must be same!", dumpMasterAtomic0, dumpReplicaAtomic0);
        AtomicBoolean testCacheLoadStopFlag = new AtomicBoolean(false);
        IgniteInternalFuture testCacheLoadFut = this.runLoadToTestCache(master0, testCacheLoadStopFlag);
        ConsistentCutStore masterCutStore = this.txdr((Ignite)master0).consistentCutStore();
        ArrayList<ConsistentCutStore> cutStore = new ArrayList<ConsistentCutStore>(masterCluster.size());
        masterCluster.forEach(n -> cutStore.add(this.txdr((Ignite)n).consistentCutStore()));
        this.txdr(ClusterRole.MASTER).stop().get();
        List consistentCutIds = masterCutStore.list();
        long lastConsistentCutId = (Long)consistentCutIds.get(consistentCutIds.size() - 1);
        this.waitForAllWALSegmentsArchived(masterCluster, cutStore, archivedWalSegments, lastConsistentCutId);
        testCacheLoadStopFlag.set(true);
        testCacheLoadFut.get();
        long lastWalSegmentIdx = ((FileWALPointer)masterCutStore.restore(lastConsistentCutId).cutPtr()).index();
        IgniteInternalFuture txLoadMasterFut = this.startTxLoad(4, ClusterRole.MASTER);
        IgniteInternalFuture atomicLoadMasterFut = this.startAtomicLoad(4, ClusterRole.MASTER);
        U.sleep((long)4000L);
        this.stopTxLoad(txLoadMasterFut);
        this.stopAtomicLoad(atomicLoadMasterFut);
        Map<Integer, Long> dumpReplicaTx1 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic1 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertEquals((String)"Replication is stopped. Changes on master cluster mustn't have effect on replica cluster", dumpReplicaTx1, dumpReplicaTx0);
        TxDrBasicScenariosTest.assertEquals((String)"Replication is stopped. Changes on master cluster mustn't have effect on replica cluster", dumpReplicaAtomic1, dumpReplicaAtomic0);
        this.checkWalSegsNotPresentInTransferFolder(masterCluster, snapshotId, lastWalSegmentIdx);
        this.txdr(ClusterRole.REPLICA).stop().get();
        IgniteInternalFuture txLoadReplicaFut = this.startTxLoad(4, ClusterRole.REPLICA);
        IgniteInternalFuture atomicLoadReplicaFut = this.startAtomicLoad(4, ClusterRole.REPLICA);
        U.sleep((long)4000L);
        this.stopTxLoad(txLoadReplicaFut);
        this.stopAtomicLoad(atomicLoadReplicaFut);
        Map<Integer, Long> dumpReplicaTx2 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic2 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        Assert.assertNotEquals((String)"Tx cache dumps before and after must be different", dumpReplicaTx2, dumpReplicaTx0);
        Assert.assertNotEquals((String)"Atomic cache dumps before and after must be different", dumpReplicaAtomic2, dumpReplicaAtomic0);
    }

    @Test
    public void testScenario6_PITR() throws Exception {
        this.consistentCutInterval = Long.MAX_VALUE;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx master0 = masterCluster.get(0);
        IgniteEx replica0 = replicaCluster.get(0);
        master0.cluster().active(true);
        replica0.cluster().active(true);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        this.txdr((Ignite)replica0).bootstrap(this.snapshotFolder(), bootstrapSesId).get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        IgniteCache masterTxCache = this.node(ClusterRole.MASTER).cache("txCache");
        IgniteCache masterAtomicCache = this.node(ClusterRole.MASTER).cache("atomicCache");
        Map<Integer, Long> dumpMasterTx0 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        IgniteCache replicaTxCache = replica0.cache("txCache");
        IgniteCache replicaAtomicCache = replica0.cache("atomicCache");
        Map<Integer, Long> dumpReplicaTx0 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertEquals((String)"Tx cache dump on master and replica must be same!", dumpMasterTx0, dumpReplicaTx0);
        TxDrBasicScenariosTest.assertEquals((String)"Atomic cache dump on master and replica must be same!", dumpMasterAtomic0, dumpReplicaAtomic0);
        long time0 = System.currentTimeMillis();
        IgniteInternalFuture txLoadMasterFut = this.startTxLoad(4, ClusterRole.MASTER);
        TxDrBasicScenariosTest.doSleep((long)10000L);
        this.stopTxLoad(txLoadMasterFut);
        log.info(">>> Master cluster is stopping");
        this.stopCluster(ClusterRole.MASTER);
        log.info(">>> Master cluster is stopped");
        log.info(">>> Replica cluster stop and recovery started");
        Long time = (Long)this.txdr(ClusterRole.REPLICA).stopAndRecover().get();
        log.info(">>> Replica cluster recovered successfully, recovered time = " + time);
        TxDrBasicScenariosTest.assertTrue((String)String.format("recoveryTime (%d) must be greater than startLoadTime (%d)", time, time0), (time > time0 ? 1 : 0) != 0);
        TxDrBasicScenariosTest.assertTrue((boolean)this.idleVerifyReplica(replica0));
        IgniteInternalFuture txLoadReplicaFut = this.startTxLoad(2, ClusterRole.REPLICA);
        IgniteInternalFuture atomicLoadReplicaFut = this.startAtomicLoad(2, ClusterRole.REPLICA);
        U.sleep((long)4000L);
        this.stopTxLoad(txLoadReplicaFut);
        this.stopAtomicLoad(atomicLoadReplicaFut);
        Map<Integer, Long> dumpReplicaTx2 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic2 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        Assert.assertNotEquals((String)"Tx cache dumps before and after must be different", dumpReplicaTx2, dumpReplicaTx0);
        Assert.assertNotEquals((String)"Atomic cache dumps before and after must be different", dumpReplicaAtomic2, dumpReplicaAtomic0);
    }

    @Test
    public void testScenario8() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx replica0 = replicaCluster.get(0);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(bootstrapSesId);
        IgniteCache masterTxCache = this.node(ClusterRole.MASTER).cache("txCache");
        IgniteCache masterAtomicCache = this.node(ClusterRole.MASTER).cache("atomicCache");
        IgniteCache replicaTxCache = replica0.cache("txCache");
        IgniteCache replicaAtomicCache = replica0.cache("atomicCache");
        Map<Integer, Long> dumpMasterTx0 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        this.txdr(ClusterRole.REPLICA).pause().get();
        Map<Integer, Long> dumpReplicaTx0 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic0 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertTrue((dumpMasterTx0.equals(dumpReplicaTx0) && dumpMasterAtomic0.equals(dumpReplicaAtomic0) ? 1 : 0) != 0);
        IgniteInternalFuture loadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrBasicScenariosTest.doSleep((long)10000L);
        this.stopTxLoad(loadFut);
        Map<Integer, Long> dumpMasterTx1 = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic1 = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        Map<Integer, Long> dumpReplicaTx1 = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
        Map<Integer, Long> dumpReplicaAtomic1 = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
        TxDrBasicScenariosTest.assertTrue((dumpReplicaTx1.equals(dumpReplicaTx0) && dumpReplicaAtomic1.equals(dumpReplicaAtomic0) ? 1 : 0) != 0);
        TxDrBasicScenariosTest.assertFalse((dumpMasterTx1.equals(dumpReplicaTx1) && dumpMasterAtomic1.equals(dumpReplicaAtomic1) ? 1 : 0) != 0);
        this.txdr(ClusterRole.REPLICA).resume().get();
        boolean awaited = GridTestUtils.waitForCondition(() -> {
            TransactionalDrProcessorImpl replica = this.txdr(ClusterRole.REPLICA);
            replica.pause().get();
            IdleVerifyResultV2 v2 = this.idleVerify((Ignite)replica0, new String[]{"txCache"});
            TxDrBasicScenariosTest.assertFalse((boolean)v2.hasConflicts());
            Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
            Map<Integer, Long> dumpReplicaAtomic = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
            replica.resume().get();
            return dumpMasterTx1.equals(dumpReplicaTx) && dumpMasterAtomic1.equals(dumpReplicaAtomic);
        }, (long)120000L);
        TxDrBasicScenariosTest.assertTrue((boolean)awaited);
        TxDrBasicScenariosTest.assertTrue((boolean)this.idleVerifyReplica(replica0));
    }

    @NotNull
    private Map<Object, Long> listenWALSegmentArchivedEvent(List<IgniteEx> nodes) {
        ConcurrentHashMap<Object, Long> archivedWalSegments = new ConcurrentHashMap<Object, Long>();
        nodes.forEach(ignite -> ignite.events().localListen((IgnitePredicate & Serializable)evt -> {
            if (evt.type() == 128) {
                WalSegmentArchivedEvent walSegEvt = (WalSegmentArchivedEvent)evt;
                Serializable consistentId = ignite.configuration().getConsistentId();
                long idx = walSegEvt.getAbsWalSegmentIdx();
                archivedWalSegments.put(consistentId, idx);
            }
            return true;
        }, new int[]{128}));
        return archivedWalSegments;
    }

    private void waitForAllWALSegmentsArchived(List<IgniteEx> nodes, List<ConsistentCutStore> cutStores, Map<Object, Long> archivedWalSegments, long cutId) throws IgniteCheckedException {
        HashMap<Serializable, Long> segs = new HashMap<Serializable, Long>(this.nodesCnt + this.nonBltNodesCnt);
        for (int i = 0; i < nodes.size(); ++i) {
            IgniteEx ignite = nodes.get(i);
            Serializable consistentId = ignite.configuration().getConsistentId();
            boolean bltNode = ignite.cluster().currentBaselineTopology().stream().anyMatch(n -> n.consistentId().equals(consistentId));
            if (!bltNode) continue;
            ConsistentCut cut = cutStores.get(i).restore(cutId);
            segs.put(consistentId, ((FileWALPointer)cut.cutPtr()).index());
        }
        GridTestUtils.waitForCondition(() -> archivedWalSegments.equals(segs), (long)60000L);
    }

    private void checkWalSegsNotPresentInTransferFolder(List<IgniteEx> nodes, long snapshotId, long lastWalSegmentIdx) throws Exception {
        String snapshotPath = this.transferFolder().getAbsolutePath() + "/" + snapshotId + '/';
        for (IgniteEx ignite : nodes) {
            Object consistentId = ignite.localNode().consistentId();
            boolean bltNode = ignite.cluster().currentBaselineTopology().stream().anyMatch(n -> n.consistentId().equals(consistentId));
            if (!bltNode) continue;
            Path walFolderPath = new File(snapshotPath, consistentId + "/wal/" + this.txdr((Ignite)ignite).spawnId()).toPath();
            Files.list(walFolderPath).forEach(f -> {
                String filename = f.getFileName().toString();
                long segmentIdx = Long.parseLong(filename.split("\\.")[0]);
                TxDrBasicScenariosTest.assertTrue((String)("WAL segment index in transfer folder must be less than or equal last consistent cut index. Node: " + consistentId + " segment: " + filename), (segmentIdx <= lastWalSegmentIdx ? 1 : 0) != 0);
            });
        }
    }

    private IgniteInternalFuture runLoadToTestCache(IgniteEx ignite, AtomicBoolean stop) {
        return GridTestUtils.runAsync(() -> {
            while (!stop.get()) {
                IgniteCache cache = ignite.cache(CACHE_NAME);
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                cache.put((Object)rnd.nextInt(1000), (Object)rnd.nextInt());
                cache.put((Object)rnd.nextInt(1000), (Object)rnd.nextInt());
            }
        }, (String)"test-load");
    }
}

