/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutAppliedGloballyDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutGC;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutWatcher;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.processors.cache.database.txdr.FileConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.NodeLastEvents;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ConsistentCutWatcherTest
extends GridCommonAbstractTest {
    private static final long WAIT_TIMEOUT = 5000L;
    private static final int CUT_CNT = 10;
    private static final int NODE_CNT = 3;
    private static final String TRANSFER_FOLDER_NAME = "transfer-folder";
    private File transferDir;
    private long spawnId;
    private ConsistentCut[] cuts = new ConsistentCut[10];
    private TransactionalDrProcessorImpl[] txdrProcs = new TransactionalDrProcessorImpl[3];
    private ConsistentCutWatcher[] watchers = new ConsistentCutWatcher[3];

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainTxDrConfiguration ggCfg = new GridGainTxDrConfiguration();
        TransactionalDrConfiguration txDrCfg = new TransactionalDrConfiguration();
        txDrCfg.setTransferFolderPath(this.folder(TRANSFER_FOLDER_NAME).getAbsolutePath());
        ggCfg.setTxDrConfiguration(txDrCfg);
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.transferDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)TRANSFER_FOLDER_NAME, (boolean)false);
        U.delete((File)this.transferDir);
        this.spawnId = U.currentTimeMillis();
        this.initCuts(null);
        for (int nodeIdx = 0; nodeIdx < 3; ++nodeIdx) {
            File nodeDir = new File(this.transferDir, "0/" + this.getTestIgniteInstanceName(nodeIdx));
            File walDir = new File(nodeDir, "wal/" + this.spawnId);
            U.ensureDirectory((File)walDir, (String)"WAL dir", (IgniteLogger)log);
            File cutsDir = new File(nodeDir, "cuts");
            U.ensureDirectory((File)cutsDir, (String)"Cuts dir", (IgniteLogger)log);
            FileConsistentCutStore store = new FileConsistentCutStore(cutsDir, (Marshaller)new JdkMarshaller());
            ReplicationSessionDescriptor state = new ReplicationSessionDescriptor();
            state.role(ClusterRole.REPLICA);
            state.state(ReplicationState.RUNNING);
            state.sessionId(1L);
            state.lastSuccessfullyAppliedCutId(0L);
            ReplicationSessionDescriptor readOnlyState = (ReplicationSessionDescriptor)Mockito.mock(ReplicationSessionDescriptor.class);
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.role()).when((Object)readOnlyState)).role();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.state()).when((Object)readOnlyState)).state();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.lastSuccessfullySentWalIndex()).when((Object)readOnlyState)).lastSuccessfullySentWalIndex();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.lastSuccessfullyAppliedCutId()).when((Object)readOnlyState)).lastSuccessfullyAppliedCutId();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.sessionId()).when((Object)readOnlyState)).sessionId();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.laggingBehind()).when((Object)readOnlyState)).laggingBehind();
            ((ReplicationSessionDescriptor)Mockito.doAnswer(i -> state.lastGloballyAppliedCutId()).when((Object)readOnlyState)).lastGloballyAppliedCutId();
            Mockito.when((Object)readOnlyState.role((ClusterRole)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.state((ReplicationState)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.lastSuccessfullySentWalIndex(Matchers.anyLong())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.lastSuccessfullyAppliedCutId(Matchers.anyLong())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.sessionId(Matchers.anyLong())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.laggingBehind(Matchers.anyBoolean())).thenThrow(new Throwable[]{new IllegalStateException()});
            Mockito.when((Object)readOnlyState.lastGloballyAppliedCutId(Matchers.anyLong())).thenAnswer(invocation -> {
                Long appliedCutId = (Long)invocation.getArguments()[0];
                state.lastGloballyAppliedCutId(appliedCutId.longValue());
                return null;
            });
            TransactionalDrProcessorImpl txdrProc = (TransactionalDrProcessorImpl)Mockito.mock(TransactionalDrProcessorImpl.class);
            ((TransactionalDrProcessorImpl)Mockito.doAnswer(invocation -> {
                Boolean isLaggingBehind = (Boolean)invocation.getArguments()[0];
                state.laggingBehind(isLaggingBehind.booleanValue());
                return null;
            }).when((Object)txdrProc)).nodeIsLaggingBehind(Matchers.anyBoolean());
            ((TransactionalDrProcessorImpl)Mockito.doAnswer(invocation -> {
                Long appliedCutId = (Long)invocation.getArguments()[0];
                state.lastSuccessfullyAppliedCutId(appliedCutId.longValue());
                return null;
            }).when((Object)txdrProc)).lastAppliedConsistentCut(Matchers.anyLong());
            Mockito.when((Object)txdrProc.localState()).thenReturn((Object)readOnlyState);
            Mockito.when((Object)txdrProc.walDir(this.spawnId)).thenReturn((Object)walDir);
            Mockito.when((Object)txdrProc.consistentCutStore()).thenReturn((Object)store);
            Mockito.when((Object)txdrProc.gc()).thenReturn(Mockito.mock(ConsistentCutGC.class));
            Mockito.when((Object)txdrProc.debugMode()).thenReturn((Object)DebugMode.NONE);
            Mockito.when((Object)txdrProc.essentialLogger()).thenReturn((Object)new NullLogger());
            int finalNodeIdx = nodeIdx;
            Mockito.when((Object)txdrProc.getReplicationCoordinatorNodeId()).thenAnswer(i -> Objects.requireNonNull(this.grid(finalNodeIdx).context().discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE)).id());
            Mockito.when((Object)txdrProc.stop()).thenAnswer(i -> {
                state.role(ClusterRole.DISABLED);
                state.state(ReplicationState.STOPPED);
                return new IgniteFinishedFutureImpl();
            });
            this.txdrProcs[nodeIdx] = txdrProc;
        }
        System.setProperty("TX_DR_SKIP_STRICT_BOUNDS_CHECK", Boolean.TRUE.toString());
        System.setProperty("TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD", "3");
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        for (int i = 0; i < 3; ++i) {
            if (this.watchers[i] == null) continue;
            this.watchers[i].stop();
        }
        U.delete((File)this.transferDir);
        this.cleanPersistenceDir();
        System.clearProperty("TX_DR_SKIP_STRICT_BOUNDS_CHECK");
        System.clearProperty("TX_DR_FAILED_CUTS_TO_REBALANCE_THRESHOLD");
    }

    @Test
    public void testFilesTracking() throws Exception {
        final AtomicLong lastReadyCutId = new AtomicLong();
        this.startGrids(3).cluster().active(true);
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        this.initNodesCutsAndWals(new int[][]{{2, 3, 4}, {1, 3, 5}, {2, 3, 4, 5, 6}}, new int[]{4, 6, 5}, new int[]{0, 0, 1});
        this.waitForCut(lastReadyCutId, 3L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({2, 3, 4}, {1, 3, 5}, {2, 3, 4, 5}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{{5, 6}, {6}, {6}}, new int[]{5, 7, 7}, new int[]{2, 2, 2});
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return lastReadyCutId.get() == 5L && ConsistentCutWatcherTest.this.minReadyCutId(ConsistentCutWatcherTest.this.watchers[0].globalReadyNodesCuts()) == 3L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({3, 4, 5}, {3, 5, 6}, {3, 4, 5, 6}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(null, new int[]{8, 7, 7}, new int[]{3, 3, 3});
        this.waitForCut(lastReadyCutId, 6L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({4, 5, 6}, {3, 5, 6}, {3, 4, 5, 6}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{{6, 7}, {7, 8}, {7}}, null, new int[]{5, 5, 5});
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return lastReadyCutId.get() == 7L && ConsistentCutWatcherTest.this.minReadyCutId(ConsistentCutWatcherTest.this.watchers[0].globalReadyNodesCuts()) == 6L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({6, 7}, {6, 7}, {6, 7}), (Object)this.watchers[0].globalReadyNodesCuts());
        log.info(this.watchers[0].globalReadyCutsIdsDump());
    }

    @Test
    public void testReplicaTopologyChange() throws Exception {
        int[][] nodesCuts = new int[][]{{2, 3, 4}, {1, 3, 5}, {2, 3, 4, 5, 6}};
        int[] nodesLastWal = new int[]{4, 5, 6};
        int[] nodesLastAppliedCut = new int[]{0, 0, 0};
        this.initNodesCutsAndWals(nodesCuts, nodesLastWal, nodesLastAppliedCut);
        this.startGrids(2).cluster().active(true);
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return ConsistentCutWatcherTest.this.watchers[0].globalReadyNodesCuts().size() == 2;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap(nodesCuts[0], nodesCuts[1]), (Object)this.watchers[0].globalReadyNodesCuts());
        this.startGrid(2);
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return ConsistentCutWatcherTest.this.watchers[0].globalReadyNodesCuts().size() == 3;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap(nodesCuts), (Object)this.watchers[0].globalReadyNodesCuts());
        this.stopGrid(0);
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ConsistentCutWatcherTest.this.awakeWatchers();
                return ConsistentCutWatcherTest.this.watchers[1].globalReadyNodesCuts().size() == 2;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap(null, nodesCuts[1], nodesCuts[2]), (Object)this.watchers[1].globalReadyNodesCuts());
        this.stopGrid(2);
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return ConsistentCutWatcherTest.this.watchers[1].globalReadyNodesCuts().size() == 1;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap(null, nodesCuts[1]), (Object)this.watchers[1].globalReadyNodesCuts());
    }

    @Test
    public void testMasterTopologyChangeWatch() throws Exception {
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', 'L', 'J', '-', '-', '-', '-'}, {'-', '-', '-', '-', '-', '-', 'L', '-'}, {'L', '-', '-', '-', 'J', '-', '-', '-'}};
        this.initCuts(nodesToCutsEvts);
        IgniteEx ig = this.startGrids(3);
        ig.cluster().active(true);
        final AtomicLong lastReadyCutId = new AtomicLong();
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        this.initNodesCutsAndWals(new int[][]{{1}, {1}, new int[0]}, new int[]{7, 7, 7}, new int[]{0, 0, 0});
        this.awakeWatchers();
        this.waitForCut(lastReadyCutId, 1L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({1}, {1}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{new int[0], {2}, new int[0]}, null, null);
        this.waitForCut(lastReadyCutId, 2L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({1}, {1, 2}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{new int[0], {3}, new int[0]}, null, null);
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertFalse((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return lastReadyCutId.get() == 3L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({1}, {1, 2, 3}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{{3, 4}, {4}, new int[0]}, null, new int[]{2, 2, 2});
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return lastReadyCutId.get() == 3L && ConsistentCutWatcherTest.this.minReadyCutId(ConsistentCutWatcherTest.this.watchers[0].globalReadyNodesCuts()) == 3L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({3, 4}, {3, 4}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.initNodesCutsAndWals(new int[][]{new int[0], new int[0], {4}}, null, null);
        this.waitForCut(lastReadyCutId, 4L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({3, 4}, {3, 4}, {4}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.stopGrid(2);
        this.initNodesCutsAndWals(new int[][]{{5}, {5}}, null, null);
        this.waitForCut(lastReadyCutId, 5L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({3, 4, 5}, {3, 4, 5}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.startGrid(2);
        this.initNodesCutsAndWals(new int[][]{{6}, new int[0], {6, 7}}, null, null);
        this.waitForCut(lastReadyCutId, 6L);
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap({3, 4, 5, 6}, {3, 4, 5}, {4, 6, 7}), (Object)this.watchers[0].globalReadyNodesCuts());
        this.watchers[1].addReadyCutsListener(lastReadyCutId::set);
        this.stopGrid(0);
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ConsistentCutWatcherTest.this.awakeWatchers();
                return lastReadyCutId.get() == 7L && ConsistentCutWatcherTest.this.minReadyCutId(ConsistentCutWatcherTest.this.watchers[1].globalReadyNodesCuts()) == 1L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals(this.nodesReadyCutsMap(null, {1, 2, 3, 4, 5}, {4, 6, 7}), (Object)this.watchers[1].globalReadyNodesCuts());
    }

    @Test
    public void testMasterTopologyChangeApply() throws Exception {
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', 'L', 'J', '-', '-', '-', '-', '-', '-'}, {'-', '-', '-', '-', '-', '-', 'L', 'J', '-', '-'}, {'L', '-', '-', '-', 'J', '-', '-', '-', '-', '-'}};
        this.initCuts(nodesToCutsEvts);
        IgniteEx ig = this.startGrids(3);
        ig.cluster().active(true);
        this.resumeApplying();
        final AtomicLong lastGloballyAppliedCutId = new AtomicLong();
        this.watchers[0].addAppliedCutsListener(lastGloballyAppliedCutId::set);
        AtomicLong lastReadyCutId = new AtomicLong();
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        this.initNodesCutsAndWals(new int[][]{{1}, {1}, new int[0]}, new int[]{9, 9, 9}, new int[]{0, 0, 0});
        this.waitForCut(lastGloballyAppliedCutId, 1L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{1L, 1L, 0L}), this.appliedCutsOnNodes());
        this.initNodesCutsAndWals(new int[][]{new int[0], {2}, new int[0]}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 2L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{1L, 2L, 0L}), this.appliedCutsOnNodes());
        AffinityTopologyVersion topVerOnCut2 = this.grid(0).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{{3}, {3}, new int[0]}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 3L);
        this.waitForTopologyChange(this.grid(0), topVerOnCut2);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{3L, 3L, 3L}), this.appliedCutsOnNodes());
        AffinityTopologyVersion topVerOnCut3 = this.grid(0).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{{4}, {4}, {4}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 4L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{4L, 4L, 4L}), this.appliedCutsOnNodes());
        this.waitForTopologyChange(this.grid(0), topVerOnCut3);
        this.watchers[1].waitForCutApplyAndSuspend(4L);
        this.initNodesCutsAndWals(new int[][]{{5}, {5}, {5}}, null, null);
        this.waitForCut(lastReadyCutId, 5L);
        ConsistentCutWatcherTest.assertFalse((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ConsistentCutWatcherTest.this.awakeWatchers();
                return lastGloballyAppliedCutId.get() == 5L;
            }
        }, (long)5000L));
        this.stopGrid(1);
        this.waitForCut(lastGloballyAppliedCutId, 5L);
        this.startGrid(1);
        this.watchers[1].resume();
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{5L, 4L, 5L}), this.appliedCutsOnNodes());
        this.initNodesCutsAndWals(new int[][]{{6}, new int[0], {6}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 6L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{6L, 4L, 6L}), this.appliedCutsOnNodes());
        AffinityTopologyVersion topVerOnCut6 = this.grid(0).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{{7}, {7}, {7}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 7L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{7L, 7L, 7L}), this.appliedCutsOnNodes());
        this.waitForTopologyChange(this.grid(0), topVerOnCut6);
        this.watchers[0].waitForCutApplyAndSuspend(7L);
        this.initNodesCutsAndWals(new int[][]{{8}, {8}, {8}}, null, null);
        this.waitForCut(lastReadyCutId, 8L);
        this.watchers[2].addAppliedCutsListener(lastGloballyAppliedCutId::set);
        this.stopGrid(0);
        ConsistentCutWatcherTest.assertFalse((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ConsistentCutWatcherTest.this.awakeWatchers();
                return lastGloballyAppliedCutId.get() == 8L;
            }
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{8L, 8L}), this.appliedCutsOnNodes());
        AffinityTopologyVersion topVerOnCut8 = this.grid(1).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{new int[0], {9}, {9}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 9L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{9L, 9L}), this.appliedCutsOnNodes());
        this.waitForTopologyChange(this.grid(1), topVerOnCut8);
    }

    @Test
    public void testCutTopologyValidator() throws Exception {
        AtomicLong lastReadyCutId = new AtomicLong();
        this.startGrids(2);
        this.grid(0).cluster().baselineAutoAdjustEnabled(false);
        this.grid(0).cluster().active(true);
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        this.createAndFillPartitionedCache(this.grid(0), "default", null);
        this.startGrid(2);
        this.grid(2).rebalanceEnabled(false);
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', '-', 'J', '-', 'L'}, {'-', '-', 'L', 'J', '-', '-'}, {'L', 'J', '-', '-', 'L', 'J'}};
        this.initCuts(nodesToCutsEvts);
        this.initNodesCutsAndWals(new int[][]{{1, 2}, {1, 2}, {1, 2}}, new int[]{5, 5, 5}, new int[]{0, 0, 0});
        this.waitForCut(lastReadyCutId, 1L);
        AffinityTopologyVersion topVer = this.grid(0).context().discovery().topologyVersionEx();
        this.grid(2).rebalanceEnabled(true);
        this.waitForTopologyChange(this.grid(0), topVer);
        this.initNodesCutsAndWals(new int[][]{{3}, {3}, {3}}, null, new int[]{1, 1, 1});
        this.waitForCut(lastReadyCutId, 2L);
        this.stopGrid(2);
        this.initNodesCutsAndWals(new int[][]{{4, 5}, {4, 5}, {4, 5}}, null, new int[]{3, 3, 3});
        this.waitForCut(lastReadyCutId, 4L);
    }

    @Test
    public void testCutPartitionValidator() throws Exception {
        AtomicLong lastReadyCutId = new AtomicLong();
        this.startGrids(2);
        this.grid(0).cluster().baselineAutoAdjustEnabled(false);
        this.grid(0).cluster().active(true);
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        int[][] partMap1 = new int[][]{{0, 1}, {0, 2}, {1, 2, 0}};
        int[][] partMap2 = new int[][]{{0, 1}};
        this.createAndFillPartitionedCache(this.grid(0), "cache1", new FixedAffinityFunction(partMap1, this.getTestIgniteInstanceName()));
        this.createAndFillPartitionedCache(this.grid(0), "cache2", new FixedAffinityFunction(partMap2, this.getTestIgniteInstanceName()));
        this.startGrid(2);
        this.grid(2).rebalanceEnabled(false);
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', '-', 'J', '-', '-', '-'}, {'L', 'J', '-', '-', '-', 'J', 'L'}, {'-', '-', '-', '-', 'J', '-', 'L'}};
        this.initCuts(nodesToCutsEvts);
        this.initNodesCutsAndWals(new int[][]{{1}, {1}, {1}}, new int[]{7, 7, 7}, new int[]{0, 0, 0});
        this.waitForCut(lastReadyCutId, 1L);
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        this.initNodesCutsAndWals(new int[][]{{2, 3, 4}, {2, 3, 4}, {2, 3, 4}}, null, new int[]{1, 1, 1});
        this.waitForCut(lastReadyCutId, 2L);
        AffinityTopologyVersion topVer = this.grid(0).context().discovery().topologyVersionEx();
        this.grid(2).rebalanceEnabled(true);
        this.waitForTopologyChange(this.grid(0), topVer);
        this.waitForCut(lastReadyCutId, 3L);
        this.initNodesCutsAndWals(new int[][]{{5}, {5}, {5}}, null, new int[]{3, 3, 3});
        this.stopGrid(2);
        this.waitForCut(lastReadyCutId, 4L);
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        this.waitForCut(lastReadyCutId, 5L);
        this.startGrid(2);
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        this.initNodesCutsAndWals(new int[][]{{6}, {6}, {6}}, null, new int[]{5, 5, 5});
        this.resumeApplying();
        this.awakeWatchers();
        ConsistentCutWatcherTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            this.awakeWatchers();
            return this.txdrProcs[0].localState().state() == ReplicationState.STOPPED;
        }, (long)5000L));
    }

    @Test
    public void testFailedCutApply() throws Exception {
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', '-', '-', '-', '-', '-', '-', '-', '-'}, {'-', '-', '-', '-', 'J', '-', '-', '-', '-', '-'}, {'-', '-', '-', '-', '-', '-', '-', '-', '-', '-'}};
        this.initCuts(nodesToCutsEvts);
        IgniteEx ig = this.startGrids(3);
        ig.cluster().active(true);
        AtomicLong lastReadyCutId = new AtomicLong();
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        AtomicLong lastGloballyAppliedCutId = new AtomicLong();
        this.watchers[0].addAppliedCutsListener(lastGloballyAppliedCutId::set);
        this.initNodesCutsAndWals(new int[][]{{1}, {1}, {1}}, new int[]{9, 9, 9}, new int[]{0, 0, 0});
        this.waitForCut(lastReadyCutId, 1L);
        this.txdrProcs[2].consistentCutStore().delete(1L);
        this.resumeApplying();
        this.waitForCut(lastGloballyAppliedCutId, 1L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)1L), (Object)this.watchers[0].failedNodes());
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{1L, 1L, 0L}), this.appliedCutsOnNodes());
        this.initNodesCutsAndWals(new int[][]{{2}, {2}, {2}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 2L);
        ConsistentCutWatcherTest.assertTrue((boolean)this.watchers[0].failedNodes().isEmpty());
        ConsistentCutWatcherTest.assertEquals((long)2L, (long)this.txdrProcs[2].localState().lastSuccessfullyAppliedCutId());
        this.txdrProcs[2].consistentCutStore().delete(2L);
        this.initNodesCutsAndWals(new int[][]{{3}, {3}, {3}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 3L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)3L), (Object)this.watchers[0].failedNodes());
        ConsistentCutWatcherTest.assertEquals((long)2L, (long)this.txdrProcs[2].localState().lastSuccessfullyAppliedCutId());
        AffinityTopologyVersion topVerCut4 = this.grid(0).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{{4}, {4}, {4}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 4L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)4L), (Object)this.watchers[0].failedNodes());
        this.waitForTopologyChange(this.grid(2), topVerCut4);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{4L, 4L, 4L}), this.appliedCutsOnNodes());
        this.txdrProcs[2].consistentCutStore().delete(4L);
        this.initNodesCutsAndWals(new int[][]{{5}, {5}, {5}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 5L);
        this.initNodesCutsAndWals(new int[][]{{6}, {6}, {6}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 6L);
        AffinityTopologyVersion topVerCut7 = this.grid(0).context().discovery().topologyVersionEx();
        this.initNodesCutsAndWals(new int[][]{{7}, {7}, {7}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 7L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)7L), (Object)this.watchers[0].failedNodes());
        this.waitForTopologyChange(this.grid(2), topVerCut7);
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{7L, 7L, 7L}), this.appliedCutsOnNodes());
        this.txdrProcs[2].consistentCutStore().delete(7L);
        this.initNodesCutsAndWals(new int[][]{{8}, {8}, {8}}, null, null);
        this.waitForCut(lastGloballyAppliedCutId, 8L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)8L), (Object)this.watchers[0].failedNodes());
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{8L, 8L, 7L}), this.appliedCutsOnNodes());
        this.suspendApplying();
        this.stopGrid(0);
        this.watchers[1].addReadyCutsListener(lastReadyCutId::set);
        this.initNodesCutsAndWals(new int[][]{{9}, {9}, {9}}, null, null);
        this.waitForCut(lastReadyCutId, 9L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)7L), (Object)this.watchers[1].failedNodes());
        ConsistentCutWatcherTest.assertEquals((Object)F.asList((Object[])new Long[]{8L, 7L}), this.appliedCutsOnNodes());
    }

    @Test
    public void testFailedCutWatch() throws Exception {
        char[][] nodesToCutsEvts = new char[][]{{'-', '-', '-', '-', '-', '-', '-', '-'}, {'-', '-', '-', 'J', '-', '-', '-', '-'}, {'-', '-', '-', '-', '-', '-', '-', '-'}};
        this.initCuts(nodesToCutsEvts);
        IgniteEx ig = this.startGrids(3);
        ig.cluster().active(true);
        this.createAndFillPartitionedCache(this.grid(0), "default", null);
        AtomicLong lastReadyCutId = new AtomicLong();
        this.watchers[0].addReadyCutsListener(lastReadyCutId::set);
        AtomicLong lastGloballyAppliedCutId = new AtomicLong();
        this.watchers[0].addAppliedCutsListener(lastGloballyAppliedCutId::set);
        this.initNodesCutsAndWals(new int[][]{{1}, {1}, {1}}, new int[]{7, 7, 7}, new int[]{0, 0, 0});
        this.waitForCut(lastReadyCutId, 1L);
        this.txdrProcs[2].consistentCutStore().delete(1L);
        this.resumeApplying();
        this.waitForCut(lastGloballyAppliedCutId, 1L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)1L), (Object)this.watchers[0].failedNodes());
        this.suspendApplying();
        this.initNodesCutsAndWals(new int[][]{{2, 3}, {2, 3}, {2, 3}}, null, null);
        this.waitForCut(lastReadyCutId, 2L);
        this.resumeApplying();
        this.waitForCut(lastReadyCutId, 3L);
        this.waitForCut(lastGloballyAppliedCutId, 3L);
        this.suspendApplying();
        this.initNodesCutsAndWals(new int[][]{{4}, {4}, {4}}, null, null);
        this.waitForCut(lastReadyCutId, 4L);
        this.txdrProcs[2].consistentCutStore().delete(3L);
        this.resumeApplying();
        this.waitForCut(lastGloballyAppliedCutId, 4L);
        this.stopGrid(0);
        this.watchers[1].addReadyCutsListener(lastReadyCutId::set);
        this.watchers[1].addAppliedCutsListener(lastGloballyAppliedCutId::set);
        this.initNodesCutsAndWals(new int[][]{{5}, {5}, {5}}, null, null);
        ConsistentCutWatcherTest.assertFalse((boolean)GridTestUtils.waitForCondition(() -> {
            this.awakeWatchers();
            return lastReadyCutId.get() == 5L;
        }, (long)5000L));
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)3L), (Object)this.watchers[1].failedNodes());
        this.startGrid(0);
        this.resumeApplying();
        this.waitForCut(lastReadyCutId, 5L);
        this.waitForCut(lastGloballyAppliedCutId, 5L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)5L), (Object)this.watchers[1].failedNodes());
        this.initNodesCutsAndWals(new int[][]{{6}, {6}}, null, null);
        this.waitForCut(lastReadyCutId, 6L);
        this.waitForCut(lastGloballyAppliedCutId, 6L);
        ConsistentCutWatcherTest.assertEquals((Object)F.asMap((Object)this.getTestIgniteInstanceName(2), (Object)6L), (Object)this.watchers[1].failedNodes());
    }

    private void initCuts(char[][] nodeToCutsEvts) {
        HashMap<String, NodeLastEvents> prevNodeEvts = new HashMap<String, NodeLastEvents>();
        for (int nodeIdx = 0; nodeIdx < 3; ++nodeIdx) {
            prevNodeEvts.put(this.getTestIgniteInstanceName(nodeIdx), new NodeLastEvents(-1L, -1L));
        }
        for (int cutId = 0; cutId < 10; ++cutId) {
            HashMap<String, NodeLastEvents> nodeEvtsMap = null;
            if (nodeToCutsEvts != null) {
                nodeEvtsMap = new HashMap<String, NodeLastEvents>(prevNodeEvts);
                for (int i = 0; i < nodeToCutsEvts.length; ++i) {
                    char nodeEvt;
                    if (nodeToCutsEvts[i].length <= cutId || (nodeEvt = nodeToCutsEvts[i][cutId]) != 'J' && nodeEvt != 'L') continue;
                    nodeEvtsMap.put(this.getTestIgniteInstanceName(i), new NodeLastEvents(nodeEvt == 'L' ? (long)cutId : -1L, nodeEvt == 'J' ? (long)cutId : -1L));
                }
                prevNodeEvts = nodeEvtsMap;
            }
            this.cuts[cutId] = new ConsistentCut((long)cutId, this.spawnId, (WALPointer)new FileWALPointer((long)cutId, 0, 1), (WALPointer)new FileWALPointer((long)cutId, 0, 1), Collections.emptySet(), Collections.emptySet(), false, nodeEvtsMap, null);
        }
    }

    private void initNodesCutsAndWals(int[][] nodesCuts, int[] nodesLastWal, int[] nodesLastAppliedCut) throws Exception {
        int i;
        int nodeIdx;
        if (nodesLastAppliedCut != null) {
            for (nodeIdx = 0; nodeIdx < nodesLastAppliedCut.length; ++nodeIdx) {
                int lastAppliedCut = nodesLastAppliedCut[nodeIdx];
                this.txdrProcs[nodeIdx].lastAppliedConsistentCut((long)lastAppliedCut);
            }
        }
        if (nodesCuts != null) {
            for (nodeIdx = 0; nodeIdx < nodesCuts.length; ++nodeIdx) {
                for (i = 0; i < nodesCuts[nodeIdx].length; ++i) {
                    this.txdrProcs[nodeIdx].consistentCutStore().save(this.cuts[nodesCuts[nodeIdx][i]]);
                }
            }
        }
        if (nodesLastWal != null) {
            for (nodeIdx = 0; nodeIdx < nodesLastWal.length; ++nodeIdx) {
                for (i = 0; i <= nodesLastWal[nodeIdx]; ++i) {
                    File dir = this.txdrProcs[nodeIdx].walDir(this.spawnId);
                    this.createWalSegment(dir, i);
                }
            }
        }
    }

    protected IgniteEx startGrid(int idx) throws Exception {
        ConsistentCutWatcher watcher;
        IgniteEx ignite = super.startGrid(idx);
        this.watchers[idx] = watcher = this.createWatcher(idx);
        ignite.context().discovery().setCustomEventListener(ConsistentCutAppliedGloballyDiscoveryMessage.class, (topVer, snd, msg) -> {
            this.txdrProcs[idx].localState().lastGloballyAppliedCutId(msg.cutId());
            if (msg.needExchange()) {
                this.txdrProcs[idx].lastAppliedConsistentCut(Math.max(msg.cutId(), this.txdrProcs[idx].localState().lastSuccessfullyAppliedCutId()));
            }
        });
        return ignite;
    }

    protected void stopGrid(int idx) {
        super.stopGrid(idx);
        if (this.watchers[idx] != null) {
            this.watchers[idx].stop();
            this.watchers[idx] = null;
        }
    }

    private ConsistentCutWatcher createWatcher(int nodeIdx) {
        ConsistentCutWatcher watcher;
        IgniteEx grid = this.grid(nodeIdx);
        this.watchers[nodeIdx] = watcher = new ConsistentCutWatcher(this.txdrProcs[nodeIdx], grid.context(), Long.MAX_VALUE);
        watcher.prepareStart();
        watcher.completeStart();
        watcher.waitForCutApplyAndSuspend(0L);
        return watcher;
    }

    private void awakeWatchers() {
        for (ConsistentCutWatcher watcher : this.watchers) {
            if (watcher == null) continue;
            watcher.awake();
        }
    }

    private void resumeApplying() {
        for (ConsistentCutWatcher watcher : this.watchers) {
            if (watcher == null) continue;
            watcher.resume();
        }
    }

    private void suspendApplying() {
        for (ConsistentCutWatcher watcher : this.watchers) {
            if (watcher == null) continue;
            watcher.waitForCutApplyAndSuspend(0L);
        }
    }

    private void createAndFillPartitionedCache(IgniteEx ignite, String name, AffinityFunction aff) {
        CacheConfiguration ccfg = new CacheConfiguration().setName(name).setCacheMode(CacheMode.PARTITIONED).setBackups(1);
        if (aff != null) {
            ccfg.setAffinity(aff);
        }
        IgniteCache cache = ignite.createCache(ccfg);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
    }

    private List<Long> appliedCutsOnNodes() {
        ArrayList<Long> appliedCuts = new ArrayList<Long>(3);
        for (int nodeIdx = 0; nodeIdx < 3; ++nodeIdx) {
            if (this.watchers[nodeIdx] == null) continue;
            appliedCuts.add(this.txdrProcs[nodeIdx].localState().lastSuccessfullyAppliedCutId());
        }
        return appliedCuts;
    }

    private Map<Object, Set<Long>> nodesReadyCutsMap(int[] ... nodesReadyCuts) {
        HashMap<Object, Set<Long>> res = new HashMap<Object, Set<Long>>();
        for (int nodeIdx = 0; nodeIdx < nodesReadyCuts.length; ++nodeIdx) {
            if (nodesReadyCuts[nodeIdx] == null) continue;
            HashSet<Long> cuts = new HashSet<Long>();
            for (int i = 0; i < nodesReadyCuts[nodeIdx].length; ++i) {
                cuts.add(Long.valueOf(nodesReadyCuts[nodeIdx][i]));
            }
            res.put(this.grid(nodeIdx).localNode().consistentId(), cuts);
        }
        return res;
    }

    private long minReadyCutId(Map<Object, Set<Long>> readyCuts) {
        long minReadyCutId = Long.MAX_VALUE;
        for (Set<Long> nodeCuts : readyCuts.values()) {
            for (Long cutId : nodeCuts) {
                if (cutId >= minReadyCutId) continue;
                minReadyCutId = cutId;
            }
        }
        return minReadyCutId;
    }

    private void createWalSegment(File walDir, long segmentIdx) throws IOException {
        File walFile = new File(walDir, FileDescriptor.fileName((long)segmentIdx));
        if (!walFile.exists()) {
            walFile.createNewFile();
        }
    }

    private File folder(String folder) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)folder, (boolean)false);
    }

    private void waitForCut(final AtomicLong cutId, final long expVal) throws IgniteInterruptedCheckedException {
        boolean res = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                ConsistentCutWatcherTest.this.awakeWatchers();
                return cutId.get() == expVal;
            }
        }, (long)5000L);
        if (!res) {
            ConsistentCutWatcherTest.assertEquals((String)"Failed to wait for cut", (long)expVal, (long)cutId.get());
        }
    }

    private void waitForTopologyChange(IgniteEx ignite, AffinityTopologyVersion topVer) throws IgniteInterruptedCheckedException {
        ConsistentCutWatcherTest.assertTrue((String)("Failed to wait for topology change, topVer=" + topVer), (boolean)GridTestUtils.waitForCondition(() -> ignite.context().discovery().topologyVersionEx().compareTo(topVer) > 0, (long)5000L));
    }

    private static class FixedAffinityFunction
    implements AffinityFunction {
        private final int[][] partMap;
        private final String consistentIdPrefix;

        private FixedAffinityFunction(int[][] partMap, String consistentIdPrefix) {
            this.partMap = partMap;
            this.consistentIdPrefix = consistentIdPrefix;
        }

        public void reset() {
        }

        public int partitions() {
            return this.partMap.length;
        }

        public int partition(Object key) {
            return key.hashCode() % this.partitions();
        }

        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            ArrayList<List<ClusterNode>> parts = new ArrayList<List<ClusterNode>>(this.partMap.length);
            for (int[] nodes : this.partMap) {
                ArrayList<ClusterNode> nodesList = new ArrayList<ClusterNode>();
                int backups = 0;
                for (int nodeIdx : nodes) {
                    ClusterNode affNode = (ClusterNode)F.find((Iterable)affCtx.currentTopologySnapshot(), null, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)node -> node.consistentId().equals(this.consistentIdPrefix + nodeIdx)});
                    if (affNode != null) {
                        ++backups;
                        nodesList.add(affNode);
                    }
                    if (backups >= affCtx.backups() + 1) break;
                }
                parts.add(nodesList);
            }
            return parts;
        }

        public void removeNode(UUID nodeId) {
        }
    }
}

