/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.sftp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.SftpConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.AbstractSftpSnapshotTest;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteDbUploadAndRestoreWithSftpKeyAuthTest
extends AbstractSftpSnapshotTest {
    @Override
    @NotNull
    protected SnapshotConfiguration getSnapshotConfiguration() {
        SnapshotConfiguration configuration = super.getSnapshotConfiguration();
        configuration.setSftpConfiguration(new SftpConfiguration().setKeyPath(PRIVATE_KEY_PATH.toString()).setPassphrase("123456"));
        return configuration;
    }

    @Test
    public void testMoveSnapshotAndRestoreAfterRestart() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.createCache("sftp_test_cache");
        cache.put((Object)KEY, (Object)"val171");
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp1.get();
        IgniteDbUploadAndRestoreWithSftpKeyAuthTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        SnapshotPath sftpPath = SnapshotPath.sftp().keyAlias("sftp").uri(new URI("sftp://snapshotUserWithkey@127.0.0.1:" + this.sftpRule.getPort() + "/relative")).build();
        gg.snapshot().move(new MoveSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).destinationPath(sftpPath)).get();
        IgniteDbUploadAndRestoreWithSftpKeyAuthTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        this.stopGrid(0);
        this.cleanPersistenceDir();
        ig = this.startGrid(0);
        ig.cluster().active(true);
        gg = (GridGain)ig.plugin("GridGain");
        cache = ig.cache("sftp_test_cache");
        IgniteDbUploadAndRestoreWithSftpKeyAuthTest.assertNull((Object)cache);
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).optionalSearchPaths(Arrays.asList(sftpPath))).get();
        cache = ig.cache("sftp_test_cache");
        IgniteDbUploadAndRestoreWithSftpKeyAuthTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
    }
}

