/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.sftp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.AbstractSftpSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.InmemorySftpServerRule;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.junit.Test;

public class IgniteDbUploadAndRestoreWithSeveralSftpServersTest
extends AbstractSftpSnapshotTest {
    @Test
    public void testMoveFullSnapshotAndMoveToAnotherIncrementalSnapshotRestoreAfterRestart() throws Exception {
        SnapshotPath sftpDir = this.getSftpfolder();
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.createCache("sftp_test_cache");
        cache.put((Object)KEY, (Object)"val171");
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp1.get();
        IgniteDbUploadAndRestoreWithSeveralSftpServersTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        gg.snapshot().move(new MoveSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).destinationPath(sftpDir)).get();
        cache.put((Object)(KEY + 1L), (Object)"val1711");
        SnapshotFuture snp2 = gg.snapshot().createSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp2.get();
        try (InmemorySftpServerRule server = InmemorySftpServerRule.createServer("login2", "password2");){
            SnapshotPath sftpDir2 = SnapshotPath.sftp().uri(new URI("sftp://login2:password2@127.0.0.1:" + server.getPort() + "/movedsnapshots")).build();
            gg.snapshot().move(new MoveSnapshotParams().snapshotId(snp2.snapshotOperation().snapshotId()).destinationPath(sftpDir2)).get();
            this.stopGrid(0);
            this.cleanPersistenceDir();
            ig = this.startGrid(0);
            ig.cluster().active(true);
            gg = (GridGain)ig.plugin("GridGain");
            IgniteCache cache2 = ig.cache("sftp_test_cache");
            IgniteDbUploadAndRestoreWithSeveralSftpServersTest.assertNull((Object)cache2);
            gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snp2.snapshotOperation().snapshotId()).optionalSearchPaths(Arrays.asList(sftpDir, sftpDir2))).get();
            cache2 = ig.cache("sftp_test_cache");
            IgniteDbUploadAndRestoreWithSeveralSftpServersTest.assertEquals((String)((String)cache2.get((Object)KEY)), (String)"val171");
            IgniteDbUploadAndRestoreWithSeveralSftpServersTest.assertEquals((String)((String)cache2.get((Object)(KEY + 1L))), (String)"val1711");
        }
    }
}

