/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.sftp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.AbstractSftpSnapshotTest;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.ListSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.junit.Test;

public class IgniteDbCopyMoveDeleteWithSftpServerTest
extends AbstractSftpSnapshotTest {
    @Test
    public void testCopyThenDeleteWithSftp() throws Exception {
        SnapshotPath sftpDir = this.getSftpfolder();
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.createCache("sftp_test_cache");
        cache.put((Object)KEY, (Object)"val171");
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp1.get();
        IgniteDbCopyMoveDeleteWithSftpServerTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        gg.snapshot().copy(new CopySnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).destinationPath(sftpDir).chainMode(SnapshotChainMode.SINGLE).singleFileCopy(true)).get();
        List infos = gg.snapshot().list();
        IgniteDbCopyMoveDeleteWithSftpServerTest.assertEquals((int)1, (int)infos.size());
        for (SnapshotInfo info : infos) {
            gg.snapshot().deleteSnapshot(info.snapshotId(), null).get();
        }
        infos = gg.snapshot().list(new ListSnapshotParams().optionalSearchPaths(Arrays.asList(sftpDir)));
        IgniteDbCopyMoveDeleteWithSftpServerTest.assertEquals((int)1, (int)infos.size());
        this.sftpRule.deleteAllFilesInDirectory("/movedsnapshots");
        infos = gg.snapshot().list(new ListSnapshotParams().optionalSearchPaths(Arrays.asList(sftpDir)));
        IgniteDbCopyMoveDeleteWithSftpServerTest.assertEquals((int)0, (int)infos.size());
    }
}

