/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleKey;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Test;

public class SnapshotScheduleTest
extends AbstractSnapshotTest {
    private static final int SNAPSHOT_WRITE_THROTTLING_THRESHOLD = 40000;
    private long savedFullSnapshotAdditionalDelay;
    private final ListeningTestLogger testLogger = new ListeningTestLogger(log);

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setGridLogger((IgniteLogger)this.testLogger);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        this.savedFullSnapshotAdditionalDelay = SnapshotCreateFuture.FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS;
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        SnapshotCreateFuture.FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS = this.savedFullSnapshotAdditionalDelay;
        super.afterTest();
    }

    @Test
    public void incSnapshotNearbyFullSnapshotTest() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        this.setupSnapshotListener(ignite);
        SnapshotCreateParameters createParameters = new SnapshotCreateParameters(CompressionOption.NONE, -1, 40000, false);
        SnapshotSchedule schedule = new SnapshotSchedule("", "", SnapshotOperationType.CREATE, "*/2 * * * *", "* * * * *", null, 10L, "", true, null, createParameters);
        scheduler.start(schedule);
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
        SnapshotMetricsMXBean snapMetrics = (SnapshotMetricsMXBean)U.field((Object)snapMgr, (String)"snapshotMetricsMXBean");
        AtomicBoolean positiveThrottlingObserved = new AtomicBoolean(false);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            positiveThrottlingObserved.set(snapMetrics.getWriteThrottlingTime() > 0L);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        for (int i = 0; i < 4; ++i) {
            StartSnapshotOperationDiscoveryMessage message = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(2L, TimeUnit.MINUTES);
            SnapshotScheduleTest.assertNotNull((String)"Snapshot was not created on schedule", (Object)message);
            SnapshotScheduleTest.assertEquals((i % 2 == 0 ? 1 : 0) != 0, (boolean)SnapshotScheduleTest.isFullSnapshot(message));
        }
        fut.cancel();
        SnapshotScheduleTest.assertFalse((boolean)positiveThrottlingObserved.get());
    }

    @Test
    public void testScheduledSnapshotThrottlingAndMetrics() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        this.setupSnapshotListener(ignite);
        SnapshotSchedule schedule = new SnapshotSchedule("", "", SnapshotOperationType.CREATE, "*/2 * * * *", "* * * * *", null, 10L, "", true, null, new SnapshotCreateParameters(CompressionOption.NONE, -1, 40000, false));
        scheduler.start(schedule);
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
        SnapshotScheduleTest.loadWithIntsAsync((Ignite)ignite, "cache1", 1, 1, 300);
        long fullSnapThrottleTime = this.waitAndCheckSnapshot(snapshotManager, true);
        SnapshotScheduleTest.loadWithIntsAsync((Ignite)ignite, "cache1", 1, 1, 150);
        long incSnapThrottleTime = this.waitAndCheckSnapshot(snapshotManager, false);
        SnapshotScheduleTest.assertTrue((fullSnapThrottleTime > 0L ? 1 : 0) != 0);
        SnapshotScheduleTest.assertTrue((incSnapThrottleTime > 0L ? 1 : 0) != 0);
        SnapshotScheduleTest.assertTrue((fullSnapThrottleTime > incSnapThrottleTime ? 1 : 0) != 0);
    }

    @Test
    public void testCreateIncSnapshotsAfterFullAndNodeRestart() throws Exception {
        this.checkCreateIncSnapshotsAfterFullAndNodeRestart(snapshotScheduleProcessor -> {
            int currMin = LocalDateTime.now().getMinute() % 60;
            SnapshotScheduleV2 scheduleV2 = new SnapshotScheduleV2("create_full_id", "create_full", SnapshotOperationType.CREATE, (currMin + 1) % 60 + " * * * *", "* * * * *", null, 0L, null, true, null, null, null, -1, -1, null, 0);
            snapshotScheduleProcessor.start(scheduleV2);
        });
    }

    @Test
    public void testCreateIncSnapshotsAfterFullAndNodeRestartForScheduleChain() throws Exception {
        this.checkCreateIncSnapshotsAfterFullAndNodeRestart(snapshotScheduleProcessor -> {
            int currMin = LocalDateTime.now().getMinute() % 60;
            SnapshotScheduleV2 createScheduleV2 = new SnapshotScheduleV2("create_full_id", "create_full", SnapshotOperationType.CREATE, (currMin + 1) % 60 + " * * * *", "* * * * *", null, 0L, null, true, null, null, null, -1, -1, null, 0);
            SnapshotScheduleV2 checkScheduleV2 = new SnapshotScheduleV2("check_id", "check", SnapshotOperationType.CHECK, null, null, null, 0L, null, true, null, null, null, -1, -1, createScheduleV2.getName(), 0);
            snapshotScheduleProcessor.start(createScheduleV2);
            snapshotScheduleProcessor.start(checkScheduleV2);
        });
    }

    private void checkCreateIncSnapshotsAfterFullAndNodeRestart(Consumer<SnapshotScheduleProcessor> scheduleConsumer) throws Exception {
        IgniteEx n = this.startGrid(0);
        n.cluster().state(ClusterState.ACTIVE);
        this.setupSnapshotListener(n);
        scheduleConsumer.accept(this.snapshotSchedule(n));
        this.waitAndCheckSnapshot((GridCacheSnapshotManager)this.snapshotManager(n), true);
        this.stopAllGrids();
        this.messages.clear();
        n = this.startGrid(0);
        SnapshotScheduleTest.loadWithIntsAsync((Ignite)n, "cache1", 1, 1, 300).get(this.getTestTimeout());
        this.setupSnapshotListener(n);
        this.waitAndCheckSnapshot((GridCacheSnapshotManager)this.snapshotManager(n), false);
    }

    @Test
    public void duplicateExecutionsOfLatecomerSnapshotTaskIsDiscarded() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        SnapshotCreateFuture.FULL_SNAPSHOT_ADDITIONAL_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(140L);
        LogListener discardedOperationListener = LogListener.matches((String)"Discarded scheduled snapshot operation because it is duplicated: ").build();
        this.testLogger.registerListener(discardedOperationListener);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        this.setupSnapshotListener(ignite);
        SnapshotCreateParameters createParameters = new SnapshotCreateParameters(CompressionOption.NONE, -1, 40000, false);
        SnapshotScheduleV2 schedule = new SnapshotScheduleV2("", "", SnapshotOperationType.CREATE, "{0,1}* * * * *", "* * * * *", null, 10L, "", true, null, createParameters, null, -1, -1, null, -1);
        scheduler.start(schedule);
        StartSnapshotOperationDiscoveryMessage fullSnapshotMessage = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(1L, TimeUnit.MINUTES);
        SnapshotScheduleTest.assertNotNull((Object)fullSnapshotMessage);
        SnapshotScheduleTest.assertTrue((String)"Did not observe full snapshot start", (boolean)SnapshotScheduleTest.isFullSnapshot(fullSnapshotMessage));
        StartSnapshotOperationDiscoveryMessage incSnapshotMessage = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(3L, TimeUnit.MINUTES);
        SnapshotScheduleTest.assertNotNull((Object)incSnapshotMessage);
        SnapshotScheduleTest.assertFalse((String)"Did not observe first incremental snapshot start", (boolean)SnapshotScheduleTest.isFullSnapshot(incSnapshotMessage));
        GridTestUtils.waitForCondition(() -> this.messages.peek() != null || discardedOperationListener.check(), (long)20000L);
        SnapshotScheduleTest.assertNull((String)"An unwanted incremental snapshot has been started", this.messages.poll());
        SnapshotScheduleTest.assertTrue((String)"Did not observe operation being discarded in time", (boolean)discardedOperationListener.check());
    }

    @Test
    public void testMultipleScheduleStarts() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        IgniteEx ignite1 = this.startGrid(1);
        ignite0.cluster().state(ClusterState.ACTIVE);
        GridGainImpl gg = (GridGainImpl)ignite0.plugin("GridGain");
        SnapshotScheduleProcessor scheduler0 = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        final String name0 = "schedule0";
        final String name1 = "schedule2";
        SnapshotScheduleTest.assertEquals(Arrays.asList(name1, name0), new ArrayList<String>(new HashSet<String>(){
            {
                this.add(name0);
                this.add(name1);
            }
        }));
        scheduler0.start(SnapshotScheduleTest.newSnapshotScheduleV2(name0));
        scheduler0.start(SnapshotScheduleTest.newSnapshotScheduleV2(name1));
        Affinity affinity = ignite0.utilityCache().affinity();
        SnapshotScheduleTest.assertTrue((boolean)affinity.isPrimary(ignite1.localNode(), (Object)SnapshotScheduleKey.SCHEDULES));
        SnapshotScheduleTest.assertTrue((boolean)affinity.isPrimary(ignite0.localNode(), (Object)new SnapshotScheduleKey(name0)));
        SnapshotScheduleTest.assertTrue((boolean)affinity.isPrimary(ignite1.localNode(), (Object)new SnapshotScheduleKey(name1)));
        SnapshotScheduleTest.assertEquals((int)2, (int)ignite0.cluster().nodeLocalMap().size());
        SnapshotScheduleTest.assertEquals((int)0, (int)ignite1.cluster().nodeLocalMap().size());
        this.stopGrid(0);
        Thread.sleep(5500L);
        SnapshotScheduleTest.assertEquals((int)2, (int)ignite1.cluster().nodeLocalMap().size());
    }

    private static SnapshotScheduleV2 newSnapshotScheduleV2(String name) {
        return new SnapshotScheduleV2(name, name, SnapshotOperationType.CREATE, "* * * * *", null, null, 0L, null, true, null, null, null, -1, -1, null, 0);
    }
}

