/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.events.EventType;
import org.gridgain.grid.events.SnapshotEvent;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class SnapshotEventsTest
extends GridCommonAbstractTest {
    public static final String SNAPSHOT_PATH = "snapshot";
    private final Set<Integer> FINISHED_SNAPSHOT_OPERATIONS = new HashSet<Integer>(Arrays.asList(this.finishedSnapshotEvents()));
    private volatile IgniteUuid failSnapshotOperation = null;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        String cId = "consistentId-" + igniteInstanceName;
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)cId)).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(new File(this.snapshotsDir(), cId).getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setIncludeEventTypes(EventType.EVTS_SNAPSHOT).setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanDirs();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanDirs();
        super.afterTest();
    }

    private void cleanDirs() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.getCopyDir());
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_PATH, (boolean)false));
    }

    private File snapshotsDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_PATH, (boolean)false);
    }

    private File getSnapshotFolder(Object consistentId, long snapshotId) throws IgniteCheckedException {
        File snapshotFolder = new File(new File(this.snapshotsDir(), consistentId.toString()), FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null));
        return snapshotFolder;
    }

    @NotNull
    private File getCopyDirWithCreate() throws IgniteCheckedException {
        File moveDir = this.getCopyDir();
        moveDir.mkdirs();
        return moveDir;
    }

    private File getCopyDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)true);
    }

    @Test
    public void testSnapshotEvents() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        IgniteEx ignite1 = this.startGrid(1);
        IgniteEx client = this.startClientGrid("client");
        LinkedList<EventSequenceListener> lsnrs = new LinkedList<EventSequenceListener>();
        ignite0.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite0.getOrCreateCache("default");
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.addLsnrToIgniteInstance(ignite0, lsnrs);
        this.addLsnrToIgniteInstance(ignite1, lsnrs);
        this.addLsnrToIgniteInstance(client, lsnrs);
        GridGain gg = (GridGain)client.plugin("GridGain");
        SnapshotPath copyDir = SnapshotPath.file().path(this.getCopyDirWithCreate()).build();
        AtomicReference<SnapshotFuture> futRef = new AtomicReference<SnapshotFuture>();
        lsnrs.forEach(lsnr -> lsnr.listenEvents(this.checkSnapshotEvent(this.snapshotIdSupplier(futRef), false), 1031, 1032));
        futRef.set(gg.snapshot().createFullSnapshot(null, null));
        long snapshotId = ((SnapshotFuture)futRef.get()).snapshotOperation().snapshotId();
        ((SnapshotFuture)futRef.get()).get();
        lsnrs.forEach(EventSequenceListener::check);
        lsnrs.forEach(EventSequenceListener::reset);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)(i + 1));
        }
        futRef.set(gg.snapshot().createSnapshot(null, null));
        long incSnapshotId = ((SnapshotFuture)futRef.get()).snapshotOperation().snapshotId();
        ((SnapshotFuture)futRef.get()).get();
        lsnrs.forEach(EventSequenceListener::check);
        lsnrs.forEach(lsnr -> lsnr.listenEvents(this.checkSnapshotEvent(() -> snapshotId, false), 1035, 1036));
        futRef.set(gg.snapshot().check(new CheckSnapshotParams().snapshotId(snapshotId)));
        ((SnapshotFuture)futRef.get()).get();
        lsnrs.forEach(EventSequenceListener::check);
        lsnrs.forEach(lsnr -> lsnr.listenEvents(this.checkSnapshotEvent(this.snapshotIdSupplier(futRef), false), 1037, 1038));
        futRef.set(gg.snapshot().deleteSnapshot(incSnapshotId, null));
        ((SnapshotFuture)futRef.get()).get();
        lsnrs.forEach(EventSequenceListener::check);
        lsnrs.forEach(lsnr -> lsnr.listenEvents(this.checkSnapshotEvent(this.snapshotIdSupplier(futRef), false), 1033, 1034));
        futRef.set(gg.snapshot().copy(new CopySnapshotParams().snapshotId(snapshotId).destinationPath(copyDir)));
        ((SnapshotFuture)futRef.get()).get();
        lsnrs.forEach(EventSequenceListener::check);
        lsnrs.forEach(lsnr -> lsnr.listenEvents(this.checkSnapshotEvent(this.snapshotIdSupplier(futRef), true), 1031, 1032));
        futRef.set(gg.snapshot().createFullSnapshot(null, null));
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)ignite1.context().cache().context().snapshot();
        GridTestUtils.waitForCondition(() -> snapshotManager.snapshotFuture() != null, (long)10000L, (long)20L);
        this.failSnapshotOperation = snapshotManager.snapshotFuture().id();
        try {
            ((SnapshotFuture)futRef.get()).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.failSnapshotOperation = null;
        lsnrs.forEach(EventSequenceListener::check);
    }

    private Integer[] finishedSnapshotEvents() {
        return new Integer[]{1032, 1034, 1036, 1038};
    }

    private void addLsnrToIgniteInstance(IgniteEx ignite, List<EventSequenceListener> lsnrs) {
        EventSequenceListener lsnr = new EventSequenceListener();
        ignite.events().localListen((IgnitePredicate)lsnr, EventType.EVTS_SNAPSHOT);
        lsnrs.add(lsnr);
        log.info("Added listener to ignite instance: " + ignite.name());
    }

    private void listenEvents(List<EventSequenceListener> lsnrs, Consumer<Event> callback, Integer ... eventTypes) {
        lsnrs.forEach(lsnr -> lsnr.listenEvents(callback, eventTypes));
    }

    private Supplier<Long> snapshotIdSupplier(AtomicReference<SnapshotFuture> futRef) {
        return () -> ((SnapshotFuture)futRef.get()).snapshotOperation().snapshotId();
    }

    private Consumer<Event> checkSnapshotEvent(Supplier<Long> snapshotIdSupplier, boolean withError) {
        return e -> {
            SnapshotEventsTest.assertTrue((boolean)(e instanceof SnapshotEvent));
            SnapshotEvent snapshotEvent = (SnapshotEvent)e;
            SnapshotEventsTest.assertEquals((long)((Long)snapshotIdSupplier.get()), (long)snapshotEvent.snapshotId());
            if (this.FINISHED_SNAPSHOT_OPERATIONS.contains(snapshotEvent.type()) && withError) {
                SnapshotEventsTest.assertTrue((snapshotEvent.error() != null && snapshotEvent.error() instanceof Exception ? 1 : 0) != 0);
            } else {
                SnapshotEventsTest.assertEquals(null, (Object)snapshotEvent.error());
            }
        };
    }

    private class TestCommunicationSpi
    extends TcpCommunicationSpi {
        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackClosure) throws IgniteSpiException {
            SnapshotOperationStageFinishedMessage finishedMessage;
            Message msg0;
            if (msg instanceof GridIoMessage && (msg0 = ((GridIoMessage)msg).message()) instanceof SnapshotOperationStageFinishedMessage && (finishedMessage = (SnapshotOperationStageFinishedMessage)msg0).operationId().equals((Object)SnapshotEventsTest.this.failSnapshotOperation)) {
                GridIoMessage replacedMsg = new GridIoMessage(msg.policy(), (Object)GridTopic.TOPIC_SNAPSHOT, GridTopic.TOPIC_SNAPSHOT.ordinal(), (Message)new SnapshotOperationStageFinishedMessage(finishedMessage.operationId(), finishedMessage.stage(), false, finishedMessage.getFinishTime(), "test", finishedMessage.payload()), false, 0L, false);
                super.sendMessage(node, (Message)replacedMsg, ackClosure);
            }
            super.sendMessage(node, msg, ackClosure);
        }
    }

    private static class EventSequenceListener
    implements IgnitePredicate<Event> {
        @IgniteInstanceResource
        Ignite ignite;
        volatile List<Integer> eventTypes;
        volatile CountDownLatch eventSequenceLatch;
        volatile Consumer<Event> callback;
        volatile Error assertionError;

        private EventSequenceListener() {
        }

        void listenEvents(Consumer<Event> callback, Integer ... eventTypes) {
            this.callback = callback;
            this.eventTypes = Arrays.asList(eventTypes);
            this.eventSequenceLatch = new CountDownLatch(eventTypes.length);
            this.assertionError = null;
        }

        public boolean apply(Event event) {
            log.info("Received event [ignite=" + this.ignite.name() + ", event=" + event + "]");
            int eventsReceived = this.eventTypes.size() - (int)this.eventSequenceLatch.getCount();
            this.assertEquals0("", true, eventsReceived < this.eventTypes.size());
            this.assertEquals0("received events count: " + eventsReceived + "; ", this.eventTypes.get(eventsReceived), event.type());
            this.wrapAssertion(() -> this.callback.accept(event));
            this.eventSequenceLatch.countDown();
            return true;
        }

        void check() {
            if (this.assertionError != null) {
                throw this.assertionError;
            }
            try {
                if (!this.eventSequenceLatch.await(5L, TimeUnit.SECONDS)) {
                    SnapshotEventsTest.fail((String)("received less events than expected [expected=" + this.eventTypes.size() + ", actual=" + ((long)this.eventTypes.size() - this.eventSequenceLatch.getCount()) + "]"));
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        void reset() {
            this.eventSequenceLatch = new CountDownLatch(this.eventTypes.size());
        }

        void assertEquals0(String msg, Object expected, Object actual) {
            this.wrapAssertion(() -> SnapshotEventsTest.assertEquals((String)("Ignite instance name: " + this.ignite.name() + "; " + msg), (Object)expected, (Object)actual));
        }

        void wrapAssertion(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (AssertionError err) {
                this.assertionError = err;
            }
        }
    }
}

