/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;

class FaultyStageFinishedCommunicationSpi
extends TcpCommunicationSpi {
    private final boolean failing;
    private final boolean[] allowance;
    private final AtomicInteger idx = new AtomicInteger();
    private final AtomicBoolean fail = new AtomicBoolean();
    private final CountDownLatch exhaustedLatch = new CountDownLatch(1);

    public static FaultyStageFinishedCommunicationSpi neverFailing() {
        return new FaultyStageFinishedCommunicationSpi(false, null);
    }

    public static FaultyStageFinishedCommunicationSpi failing(boolean[] allowance) {
        return new FaultyStageFinishedCommunicationSpi(true, allowance);
    }

    public FaultyStageFinishedCommunicationSpi(boolean failing, boolean[] allowance) {
        this.failing = failing;
        this.allowance = allowance == null ? null : Arrays.copyOf(allowance, allowance.length);
    }

    public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
        this.sendMessage(node, msg, null);
    }

    public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
        ClusterWideSnapshotOperationStageFinishedMessage stageMsg;
        Message message;
        if (this.fail.get()) {
            return;
        }
        if (this.failing && msg instanceof GridIoMessage && (message = ((GridIoMessage)msg).message()) instanceof ClusterWideSnapshotOperationStageFinishedMessage && (stageMsg = (ClusterWideSnapshotOperationStageFinishedMessage)message).stage() == SnapshotOperationStage.FIRST) {
            int current = this.idx.getAndIncrement();
            if (current >= this.allowance.length - 1) {
                this.exhaustedLatch.countDown();
                this.fail.set(true);
            }
            if (current >= this.allowance.length || !this.allowance[current]) {
                return;
            }
        }
        super.sendMessage(node, msg, ackC);
    }

    public void waitTillTriedToSendStageFinishedMessageToAllNodes() throws InterruptedException {
        this.exhaustedLatch.await();
    }
}

