/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import com.github.luben.zstd.ZstdInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import net.jpountz.lz4.LZ4FrameInputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.compression.CompressionTask;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.xerial.snappy.SnappyFramedInputStream;

@RunWith(value=Parameterized.class)
public class CompressionTaskTest
extends TestCase {
    private static final Random RANDOM = new Random();
    private File srcFolder;
    @Parameterized.Parameter(value=0)
    public CompressionOption codec;

    @Parameterized.Parameters(name="codec = {0}")
    public static Iterable<?> testData() {
        return Arrays.stream(CompressionOption.values()).filter(CompressionOption::isCompressed).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testRun() throws IgniteCheckedException, IOException {
        this.srcFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("tmp/" + CompressionTaskTest.class.getSimpleName() + "/src"), (boolean)true);
        byte[] fileContent = new byte[20];
        Path path = this.srcFolder.toPath().resolve("index.bin");
        RANDOM.nextBytes(fileContent);
        Files.write(path, fileContent, StandardOpenOption.CREATE);
        SnapshotOperationContext context = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBean = (SnapshotMetricsMXBeanImpl)Mockito.mock(SnapshotMetricsMXBeanImpl.class);
        CompressionTask compressionTask = new CompressionTask(new FsSnapshotPath(path.toFile()), this.codec, this.codec.defaultCompressionLevel(), context, snapshotMetricsMXBean, (IgniteLogger)Mockito.mock(IgniteLogger.class));
        compressionTask.run();
        CompressionTaskTest.assertFalse((boolean)path.toFile().exists());
        File compressedFile = new File(path.toFile().getAbsolutePath() + this.codec.fileExtension());
        ((SnapshotMetricsMXBeanImpl)Mockito.verify((Object)snapshotMetricsMXBean, (VerificationMode)Mockito.times((int)1))).incrementTotalBytesWrittenOnStorage(Mockito.eq((long)compressedFile.length()));
        CompressionTaskTest.assertTrue((this.codec != CompressionOption.ZIP || AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(compressedFile)) ? 1 : 0) != 0);
        try (InputStream inputStream = SnapshotUtils.stream((SnapshotPath)new FsSnapshotPath(path.toFile()));){
            switch (this.codec) {
                case ZIP: {
                    CompressionTaskTest.assertTrue((boolean)(inputStream instanceof ZipInputStream));
                    return;
                }
                case ZSTD: {
                    CompressionTaskTest.assertTrue((boolean)(inputStream instanceof ZstdInputStream));
                    return;
                }
                case LZ4: {
                    CompressionTaskTest.assertTrue((boolean)(inputStream instanceof LZ4FrameInputStream));
                    return;
                }
                case SNAPPY: {
                    CompressionTaskTest.assertTrue((boolean)(inputStream instanceof SnappyFramedInputStream));
                    return;
                }
                default: {
                    CompressionTaskTest.fail((String)("Please check correctness of the type of the stream for codec: " + this.codec));
                    return;
                }
            }
        }
    }

    @Test
    public void testInterrupt() throws IgniteCheckedException, IOException {
        this.srcFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("tmp/" + CompressionTaskTest.class.getSimpleName() + "/src"), (boolean)true);
        byte[] fileContent = new byte[20];
        Path path = this.srcFolder.toPath().resolve("index.bin");
        RANDOM.nextBytes(fileContent);
        Files.write(path, fileContent, StandardOpenOption.CREATE);
        Path tmpPath = this.srcFolder.toPath().resolve("index.bin" + this.codec.fileExtension() + ".tmp");
        Path zipPath = this.srcFolder.toPath().resolve("index.bin" + this.codec.fileExtension());
        SnapshotOperationContext context = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        ((SnapshotOperationContext)Mockito.doReturn((Object)true).when((Object)context)).isCancelled();
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBean = (SnapshotMetricsMXBeanImpl)Mockito.mock(SnapshotMetricsMXBeanImpl.class);
        CompressionTask zipCompressionTask = new CompressionTask(new FsSnapshotPath(path.toFile()), this.codec, this.codec.defaultCompressionLevel(), context, snapshotMetricsMXBean, (IgniteLogger)Mockito.mock(IgniteLogger.class));
        try {
            zipCompressionTask.run();
            CompressionTaskTest.fail((String)"");
        }
        catch (Exception e) {
            IgniteException checkedException = (IgniteException)((Object)e);
            CompressionTaskTest.assertEquals((String)"Snapshot operation has been cancelled", (String)checkedException.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{snapshotMetricsMXBean});
        CompressionTaskTest.assertFalse((boolean)tmpPath.toFile().exists());
        CompressionTaskTest.assertFalse((boolean)zipPath.toFile().exists());
    }

    protected void tearDown() throws Exception {
        U.delete((File)this.srcFolder);
    }
}

