/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryWithWalPageCompressionLocalTest
extends GridPointInTimeRecoveryAbstractTest {
    private IgniteConfiguration getConfiguration(String name, DiskPageCompression diskPageCompression) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalPageCompression(diskPageCompression);
        return cfg;
    }

    private Ignite startGrid(int idx, DiskPageCompression diskPageCompression) throws Exception {
        String igniteInstanceName = this.getTestIgniteInstanceName(idx);
        return this.startGrid(igniteInstanceName, this.optimize(this.getConfiguration(igniteInstanceName, diskPageCompression)), null);
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(0);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void test() throws Exception {
        this.startGrid(0, DiskPageCompression.ZSTD);
        this.startGrid(1, DiskPageCompression.LZ4);
        this.startGrid(2, DiskPageCompression.DISABLED);
        IgniteEx igClient = this.startClient(3);
        igClient.cluster().active(true);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
        snp.createFullSnapshot(null, "Incremental snapshot.").get();
        test.loadByTime(2000L);
        pnt = test.savePoint();
        test.removeByTime(1000L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }
}

