/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class GridPointInTimeRecoveryWithAbsentWalTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        U.delete((File)this.copyDir());
        U.delete((File)this.snapshotDir());
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default")}).setDataStorageConfiguration(new DataStorageConfiguration().setWalSegments(2).setWalSegmentSize(0x100000).setMaxWalArchiveSize(0x500000L).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true).setSnapshotsPath(this.snapshotDir().getAbsolutePath()))});
    }

    protected IgniteEx startGrids(int cnt) throws Exception {
        IgniteEx n = super.startGrids(cnt);
        GridPointInTimeRecoveryWithAbsentWalTest.assertTrue((n.configuration().getDataStorageConfiguration().getMaxWalArchiveSize() != -1L ? 1 : 0) != 0);
        n.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        return n;
    }

    @Test
    public void testCopyMove() throws Exception {
        long snapshotId;
        IgniteEx n = this.startGrids(1);
        SnapshotFuture full0 = this.snapshotEx(n).createFullSnapshot(null, "full0");
        full0.get(this.getTestTimeout());
        AtomicLong key = new AtomicLong();
        FileWALPointer full0WalPtr = this.snapshotWalPtr(n, full0.snapshotOperation().snapshotId());
        this.populateData(n, key, () -> GridPointInTimeRecoveryWithAbsentWalTest.walMgr((IgniteEx)n).lastTruncatedSegment() < full0WalPtr.index());
        SnapshotFuture inc0 = this.snapshotEx(n).createSnapshot(null, "inc0");
        inc0.get(this.getTestTimeout());
        FileWALPointer inc0WalPtr = this.snapshotWalPtr(n, inc0.snapshotOperation().snapshotId());
        FileWALPointer inc0WalPtrNext = new FileWALPointer(inc0WalPtr.index() + 1L, 0, 0);
        this.populateData(n, key, () -> GridPointInTimeRecoveryWithAbsentWalTest.walMgr((IgniteEx)n).currentSegment() < inc0WalPtrNext.index());
        GridPointInTimeRecoveryWithAbsentWalTest.assertTrue((boolean)GridPointInTimeRecoveryWithAbsentWalTest.walMgr((IgniteEx)n).reserve((WALPointer)inc0WalPtrNext));
        SnapshotFuture inc1 = this.snapshotEx(n).createSnapshot(null, "inc1");
        inc1.get(this.getTestTimeout());
        GridPointInTimeRecoveryWithAbsentWalTest.assertTrue((GridPointInTimeRecoveryWithAbsentWalTest.walMgr((IgniteEx)n).lastTruncatedSegment() < inc0WalPtrNext.index() ? 1 : 0) != 0);
        FileDescriptor inc0WalSegmentNext = Arrays.stream(GridPointInTimeRecoveryWithAbsentWalTest.walMgr((IgniteEx)n).walArchiveFiles()).filter(fd -> fd.idx() == inc0WalPtrNext.index()).findAny().orElseThrow(AssertionError::new);
        GridPointInTimeRecoveryWithAbsentWalTest.assertTrue((boolean)inc0WalSegmentNext.file().delete());
        org.gridgain.grid.persistentstore.SnapshotPath destPath = org.gridgain.grid.persistentstore.SnapshotPath.file().path(this.copyDir()).build();
        for (SnapshotFuture fut : F.asList((Object[])new SnapshotFuture[]{full0, inc0})) {
            snapshotId = fut.snapshotOperation().snapshotId();
            this.snapshotEx(n).copy(new CopySnapshotParams().snapshotId(snapshotId).chainMode(SnapshotChainMode.SINGLE).destinationPath(destPath)).get(this.getTestTimeout());
            GridPointInTimeRecoveryWithAbsentWalTest.assertNull((Object)this.snapshotWalSizes(n, destPath).get(snapshotId));
        }
        GridPointInTimeRecoveryWithAbsentWalTest.assertTrue((boolean)U.delete((File)this.copyDir()));
        for (SnapshotFuture fut : F.asList((Object[])new SnapshotFuture[]{full0, inc0})) {
            snapshotId = fut.snapshotOperation().snapshotId();
            this.snapshotEx(n).move(new MoveSnapshotParams().snapshotId(snapshotId).chainMode(SnapshotChainMode.SINGLE).destinationPath(destPath)).get(this.getTestTimeout());
            GridPointInTimeRecoveryWithAbsentWalTest.assertNull((Object)this.snapshotWalSizes(n, destPath).get(snapshotId));
        }
    }

    private Map<Long, Long> snapshotWalSizes(IgniteEx n, org.gridgain.grid.persistentstore.SnapshotPath path) {
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)n.context().cache().context().snapshot();
        return snapshotMgr.snapshotSpi().remoteSnapshotWalSizes((SnapshotPath)new FsSnapshotPath(path.path()));
    }

    private FileWALPointer snapshotWalPtr(IgniteEx n, long snapshotId) {
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)n.context().cache().context().snapshot();
        Snapshot snapshot = snapshotMgr.snapshotSpi().snapshot(snapshotId, null, null, false, null, false);
        GridPointInTimeRecoveryWithAbsentWalTest.assertNotNull((Object)snapshot);
        SnapshotMetadataV2 metadata = snapshot.metadata();
        GridPointInTimeRecoveryWithAbsentWalTest.assertNotNull((Object)metadata);
        BaselineTopology blt = metadata.baselineTopology();
        GridPointInTimeRecoveryWithAbsentWalTest.assertNotNull((Object)blt);
        Short shotConsistentId = blt.resolveShortConsistentId(n.cluster().localNode().consistentId());
        GridPointInTimeRecoveryWithAbsentWalTest.assertNotNull((Object)shotConsistentId);
        FileWALPointer snapshotWalPtr = (FileWALPointer)metadata.walPoints().get(shotConsistentId);
        GridPointInTimeRecoveryWithAbsentWalTest.assertNotNull((Object)snapshotWalPtr);
        return snapshotWalPtr;
    }

    private void populateData(IgniteEx n, AtomicLong key, GridAbsPredicate fillPred) throws IgniteCheckedException {
        while (fillPred.apply()) {
            if (key.getAndIncrement() % 10L == 0L) {
                this.forceCheckpoint();
            }
            n.cache("default").put((Object)key.get(), (Object)new byte[131072]);
        }
    }

    private GridSnapshotEx snapshotEx(IgniteEx n) {
        return (GridSnapshotEx)((GridGain)n.plugin("GridGain")).snapshot();
    }

    private File copyDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"copy", (boolean)false);
    }

    private File snapshotDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false);
    }
}

