/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Assert;
import org.junit.Test;

public class GridPointInTimeRecoveryWALStateTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanReferences();
    }

    @Test
    public void test() throws Exception {
        long intervalToCheck = 20000L;
        IgniteEx ig = this.startGrid();
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteWriteAheadLogManager walMgr = ig.context().cache().context().wal();
        List snapshotInfos = gg.snapshot().list();
        Assert.assertTrue((!snapshotInfos.isEmpty() ? 1 : 0) != 0);
        GridPointInTimeRecoveryAbstractTest.TestContext testContext = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig, "default");
        testContext.loadByTime(60000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint ptr1 = testContext.savePoint();
        System.out.println("ptr1 " + ptr1.cursorVal);
        testContext.loadByTime(intervalToCheck);
        PITRFuture fut = new PITRFuture(Long.MAX_VALUE, ((SnapshotInfo)snapshotInfos.get(0)).snapshotId(), ig.context().state().clusterState().baselineTopology(), true, ig.context().config().getConsistentId(), new HashSet(), "", (originalCId, req) -> {}, log){

            protected boolean isAlive(Object originalCId) {
                return true;
            }
        };
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint ptr2 = testContext.savePoint();
        System.out.println("ptr2 " + ptr2.cursorVal);
        WALIterator it = walMgr.replay(null);
        fut.scan(it);
        Map commited = (Map)U.field((Object)U.field((Object)fut, (String)"walState"), (String)"commited");
        long exp = (ptr2.cursorVal - ptr1.cursorVal) / (long)ptr1.batchSize;
        long actl = commited.size();
        GridPointInTimeRecoveryWALStateTest.assertTrue((String)("exp=" + exp + " actl=" + actl), (Math.abs(exp - actl) < 1000L ? 1 : 0) != 0);
    }
}

