/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.RecoveryParams;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class GridPointInTimeRecoveryLocalTest
extends GridPointInTimeRecoveryAbstractTest {
    private static final String IN_MEM_DATA_REGION = "inMemoryRegion";
    private boolean createInMemoryRegion;

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        if (this.createInMemoryRegion) {
            DataStorageConfiguration dsCfg = cfg.getDataStorageConfiguration();
            dsCfg.setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setPersistenceEnabled(false).setMaxSize(0x40000000L).setName(IN_MEM_DATA_REGION)});
        }
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    protected long getTestTimeout() {
        return super.getTestTimeout() * 4L;
    }

    @Test
    public void test1_1() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test1_2() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        igClient.close();
        GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test2_1() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test2_2() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        igClient.close();
        gg = (GridGain)this.grid(0).plugin("GridGain");
        snp = (GridSnapshotEx)gg.snapshot();
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test3() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test4() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        SnapshotFuture snpFut = snp.createFullSnapshot(null, "Full snapshot.");
        snpFut.get();
        this.startGrid(7);
        this.startGrid(8);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, (Ignite)this.grid(0));
        test.checkPoint(pnt, (Ignite)this.grid(1));
        test.checkPoint(pnt, (Ignite)this.grid(2));
        test.checkPoint(pnt, (Ignite)this.grid(3));
        test.checkPoint(pnt, (Ignite)this.grid(4));
        test.checkPoint(pnt, (Ignite)this.grid(5));
        test.checkPoint(pnt, (Ignite)this.grid(6));
    }

    @Test
    public void test5() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        this.stopGrid(5);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        this.stopGrid(4);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, (Ignite)this.grid(0));
        test.checkPoint(pnt, (Ignite)this.grid(1));
        test.checkPoint(pnt, (Ignite)this.grid(2));
        test.checkPoint(pnt, (Ignite)this.grid(3));
        test.checkPoint(pnt, (Ignite)this.grid(6));
    }

    @Test
    public void test6_1() throws Exception {
        this.check6(6, 5, 4);
    }

    @Test
    public void test6_2() throws Exception {
        this.check6(6, 1, 0);
    }

    private void check6(int nodes, int ... nodesToStop) throws Exception {
        assert (nodesToStop.length == 2);
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot 1.").get();
        this.stopGrid(nodesToStop[0]);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1500L);
        this.stopGrid(nodesToStop[1]);
        snp.createFullSnapshot(null, "Full snapshot 2.").get();
        snp.recoveryTo(pnt.time, pnt.msg).get();
        this.awaitPartitionMapExchange();
        this.waitForRebalancing();
        for (int i = 0; i <= 6; ++i) {
            if (i == nodesToStop[0] || i == nodesToStop[1]) continue;
            test.checkPoint(pnt, (Ignite)this.grid(i));
        }
    }

    @Test
    public void test7() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        String msg1 = "Full snapshot 1.";
        snp.createFullSnapshot(null, msg1).get();
        System.out.println("Snapshot created. " + msg1);
        this.stopGrid(5);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt2 = test.savePoint();
        String msg2 = "Full snapshot 2.";
        snp.createFullSnapshot(null, msg2).get();
        System.out.println("Snapshot created. " + msg2);
        this.startGrid(5);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt1 = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt1.time, pnt1.msg).get();
        test.checkPoint(pnt1, (Ignite)this.grid(0));
        test.checkPoint(pnt1, (Ignite)this.grid(1));
        test.checkPoint(pnt1, (Ignite)this.grid(2));
        test.checkPoint(pnt1, (Ignite)this.grid(3));
        test.checkPoint(pnt1, (Ignite)this.grid(4));
        test.checkPoint(pnt1, (Ignite)this.grid(5));
        test.checkPoint(pnt1, (Ignite)this.grid(6));
        snp.recoveryTo(pnt2.time, pnt2.msg).get();
        Thread.sleep(10000L);
        test.checkPoint(pnt2, (Ignite)this.grid(6));
        test.checkPoint(pnt2, (Ignite)this.grid(5));
        test.checkPoint(pnt2, (Ignite)this.grid(4));
        test.checkPoint(pnt2, (Ignite)this.grid(3));
        test.checkPoint(pnt2, (Ignite)this.grid(2));
        test.checkPoint(pnt2, (Ignite)this.grid(1));
        test.checkPoint(pnt2, (Ignite)this.grid(0));
    }

    @Test
    public void test8_1() throws Exception {
        this.check8(false, true);
    }

    @Test
    public void test8_2() throws Exception {
        this.check8(true, true);
    }

    @Test
    public void test8_3() throws Exception {
        this.check8(true, false);
    }

    private void check8(boolean merge, boolean recoverBoth) throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot 1.").get();
        if (merge) {
            GridTestUtils.mergeExchangeWaitVersion((Ignite)this.grid(0), (long)(nodes + 3));
            this.stopGrid(this.getTestIgniteInstanceName(4), true, false);
        }
        this.stopGrid(this.getTestIgniteInstanceName(5), true, false);
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt2 = test.savePoint();
        snp.createFullSnapshot(null, "Full snapshot 2.").get();
        if (merge) {
            this.startGrid(4);
        }
        if (recoverBoth || !merge) {
            this.startGrid(5);
        }
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt1 = test.savePoint();
        test.removeByTime(1500L);
        snp.recoveryTo(pnt2.time, pnt2.msg).get();
        this.awaitPartitionMapExchange();
        test.checkPoint(pnt2, (Ignite)this.grid(0));
        test.checkPoint(pnt2, (Ignite)this.grid(1));
        test.checkPoint(pnt2, (Ignite)this.grid(2));
        test.checkPoint(pnt2, (Ignite)this.grid(3));
        test.checkPoint(pnt2, (Ignite)this.grid(4));
        if (recoverBoth || !merge) {
            test.checkPoint(pnt2, (Ignite)this.grid(5));
        }
        test.checkPoint(pnt2, (Ignite)this.grid(6));
        snp.recoveryTo(pnt1.time, pnt1.msg).get();
        test.checkPoint(pnt1, (Ignite)this.grid(0));
        test.checkPoint(pnt1, (Ignite)this.grid(1));
        test.checkPoint(pnt1, (Ignite)this.grid(2));
        test.checkPoint(pnt1, (Ignite)this.grid(3));
        test.checkPoint(pnt1, (Ignite)this.grid(4));
        if (recoverBoth || !merge) {
            test.checkPoint(pnt1, (Ignite)this.grid(5));
        }
        test.checkPoint(pnt1, (Ignite)this.grid(6));
    }

    @Test
    public void test9() throws Exception {
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt;
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(3000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        this.stopGrid(5);
        IgniteCache c = igClient.cache("default");
        try (Transaction tx = igClient.transactions().txStart();){
            AtomicLong atomicLong = test.cursor;
            test.getClass();
            long v = atomicLong.getAndAdd(10L);
            Long res = (Long)c.get((Object)v);
            GridPointInTimeRecoveryLocalTest.assertNull((Object)res);
            c.put((Object)v, (Object)v);
            U.sleep((long)15000L);
            c.put((Object)v, (Object)(v + 1L));
            test.skipped.add(v);
            pnt = test.savePoint();
            tx.commit();
        }
        test.loadByTime(3000L);
        test.removeByTime(1500L);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
    }

    @Test
    public void test10() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startGrid(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(10000L);
        this.stopGrid(5);
        this.stopGrid(4);
        test.loadByTime(1000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt1 = test.savePoint();
        test.loadByTime(1000L);
        this.stopGrid(3);
        boolean exception = false;
        try {
            snp.recoveryTo(pnt1.time, pnt1.msg).get();
        }
        catch (Throwable h) {
            U.log((IgniteLogger)log, (Object)"Expected exception.", (Object)h);
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        IgniteEx g3 = this.startGrid(3);
        g3.resetLostPartitions(Collections.singleton("default"));
        this.awaitPartitionMapExchange();
        snp.recoveryTo(pnt1.time, pnt1.msg).get();
        test.checkPoint(pnt1, G.allGrids());
    }

    @Test
    public void test11() throws Exception {
        int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(5000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        test.loadByTime(3000L);
        this.stopGrid(5);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.loadByTime(3000L);
        IgniteEx ig = this.startGrid(5);
        ig.cache("default").rebalance().get();
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, (Ignite)this.grid(6));
        test.checkPoint(pnt, (Ignite)this.grid(5));
        test.checkPoint(pnt, (Ignite)this.grid(4));
        test.checkPoint(pnt, (Ignite)this.grid(3));
        test.checkPoint(pnt, (Ignite)this.grid(2));
        test.checkPoint(pnt, (Ignite)this.grid(1));
        test.checkPoint(pnt, (Ignite)this.grid(0));
    }

    @Test
    public void testClientTransactionsAfterBaselineTopologyChange() throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().baselineAutoAdjustEnabled(false);
        ig.cluster().state(ClusterState.ACTIVE);
        this.startGrid(1);
        ig.cluster().setBaselineTopology(2L);
        IgniteEx client = this.startClient(2);
        IgniteCache clCache = client.cache("default");
        try (Transaction tx = client.transactions().txStart();){
            clCache.put((Object)0, (Object)0);
            tx.commit();
        }
        GridPointInTimeRecoveryLocalTest.assertEquals((Object)0, (Object)clCache.get((Object)0));
    }

    @Test
    public void testNotParticipatedInSnapshotAndNothingForApply() throws Exception {
        int nodes = 6;
        String cacheName = "cache";
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().state(ClusterState.ACTIVE);
        igClient.createCache(new CacheConfiguration(cacheName).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(2));
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(5000L);
        this.stopGrid(5);
        test.loadByTime(1000L);
        snp.createFullSnapshot(null, "Full snapshot.").get();
        IgniteEx ig5 = this.startGrid(5);
        IgniteCache cache = ig5.cache(cacheName);
        Affinity aff = GridPointInTimeRecoveryLocalTest.affinity((IgniteCache)cache);
        long cnt = 0L;
        while (true) {
            if (aff.isPrimary(ig5.localNode(), (Object)cnt)) break;
            ++cnt;
        }
        cache.put((Object)cnt, (Object)(-cnt));
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint point = test.savePoint();
        test.loadByTime(100L);
        snp.recoveryTo(point.time, null).get();
        test.checkPoint(point, (Ignite)igClient);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testeRecoverySubsetCachesFromServer() throws Exception {
        this.checkRecoveryCaches(false, Collections.singleton("default"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testeRecoverySubsetCachesFromClietn() throws Exception {
        this.checkRecoveryCaches(true, Collections.singleton("default"));
    }

    @Test
    public void testeRecoveryCachesFromClietn() throws Exception {
        this.checkRecoveryCaches(true, null);
    }

    @Test
    public void testeRecoveryCachesFromServer() throws Exception {
        this.checkRecoveryCaches(false, null);
    }

    private void checkRecoveryCaches(boolean fromClient, Set<String> caches) throws Exception {
        IgniteEx ignite = this.startGrids(4);
        String cacheName1 = "cache1";
        if (fromClient) {
            ignite = this.startClient(4);
        }
        ignite.cluster().state(ClusterState.ACTIVE);
        GridPointInTimeRecoveryLocalTest.assertTrue((boolean)ClusterState.active((ClusterState)ignite.cluster().state()));
        ignite.getOrCreateCache(new CacheConfiguration(cacheName1).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)));
        GridPointInTimeRecoveryAbstractTest.TestContext testCache = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ignite, "default");
        GridPointInTimeRecoveryAbstractTest.TestContext testCache1 = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ignite, cacheName1);
        IgniteInternalFuture loadCacheFut = testCache.loadAsync(500L);
        IgniteInternalFuture loadCache1Fut = testCache1.loadAsync(500L);
        loadCacheFut.get();
        loadCache1Fut.get();
        GridPointInTimeRecoveryLocalTest.assertTrue((String)("Could not loaded even three keys for cache " + testCache.cacheName), (testCache.cursor.get() > 2L ? 1 : 0) != 0);
        GridPointInTimeRecoveryLocalTest.assertTrue((String)("Could not loaded even three keys fro cache" + testCache1.cacheName), (testCache1.cursor.get() > 2L ? 1 : 0) != 0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        snapshot.createFullSnapshot(null, "Test full snapshot.").get();
        this.info("Full snasphot created in time: " + System.currentTimeMillis());
        IgniteCache cache = ignite.cache("default");
        IgniteCache cache1 = ignite.cache(cacheName1);
        cache.put((Object)1L, (Object)11L);
        cache1.put((Object)1L, (Object)33L);
        long time = U.currentTimeMillis();
        while (time == U.currentTimeMillis()) {
            U.sleep((long)50L);
        }
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pointInTime = testCache.savePoint();
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pointInTime1 = testCache1.savePoint();
        this.info("Point in time fixed: " + pointInTime.time);
        this.info("Update some data after: " + System.currentTimeMillis());
        cache.put((Object)1L, (Object)22L);
        cache.put((Object)2L, (Object)22L);
        cache1.put((Object)1L, (Object)44L);
        cache1.put((Object)2L, (Object)44L);
        snapshot.recoveryTo(pointInTime.time, caches, "Test restore part of caches.").get();
        this.awaitPartitionMapExchange(false, true, null);
        if (F.isEmpty(caches) || caches.contains("default")) {
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache.get((Object)1L)), (long)11L);
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache.get((Object)2L)), (long)2L);
        } else {
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache.get((Object)2L)), (long)22L);
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache.get((Object)1L)), (long)22L);
        }
        if (F.isEmpty(caches) || caches.contains(cacheName1)) {
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache1.get((Object)1L)), (long)33L);
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache1.get((Object)2L)), (long)2L);
        } else {
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache1.get((Object)2L)), (long)44L);
            GridPointInTimeRecoveryLocalTest.assertEquals((long)((Long)cache1.get((Object)1L)), (long)44L);
        }
        cache.put((Object)1L, (Object)1L);
        cache.put((Object)2L, (Object)2L);
        cache1.put((Object)1L, (Object)1L);
        cache1.put((Object)2L, (Object)2L);
        testCache.checkPoint(pointInTime, (Ignite)ignite);
        testCache1.checkPoint(pointInTime1, (Ignite)ignite);
    }

    private CacheConfiguration<Long, Long> createCacheConfiguration(String name, @Nullable String dataRegName) {
        CacheConfiguration ccfg = new CacheConfiguration(name);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(0);
        if (dataRegName != null) {
            ccfg.setDataRegionName(dataRegName);
        }
        return ccfg;
    }

    @Test
    @WithSystemProperty(key="GG_POINT_IN_TIME_DOUBLE_CHECK_INTERVAL", value="30000")
    public void testCrossCacheTransactions() throws Exception {
        this.createInMemoryRegion = true;
        int nodes = 2;
        this.startGrids(nodes);
        IgniteEx client = this.startClientGrid(nodes);
        client.cluster().state(ClusterState.ACTIVE);
        String persistentCacheName = "tx-persistence-cache";
        String persistentCacheName2 = "tx-persistence-cache-2";
        String inMemoryCacheName = "tx-in-memory-cache";
        client.getOrCreateCaches(Arrays.asList(this.createCacheConfiguration(persistentCacheName, null), this.createCacheConfiguration(persistentCacheName2, null), this.createCacheConfiguration(inMemoryCacheName, IN_MEM_DATA_REGION)));
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)client.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        snp.createFullSnapshot(null, "Full snapshot.").get();
        Long primaryKey0 = this.primaryKey(this.grid(0).cache(persistentCacheName)).longValue();
        Long primaryKey1 = this.primaryKey(this.grid(1).cache(inMemoryCacheName)).longValue();
        Long expectedVal = 42L;
        IgniteCache persistentCache = client.cache(persistentCacheName);
        IgniteCache inMemoryCache = client.cache(inMemoryCacheName);
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.SERIALIZABLE);){
            persistentCache.put((Object)primaryKey0, (Object)expectedVal);
            inMemoryCache.put((Object)primaryKey1, (Object)expectedVal);
            tx.commit();
        }
        IgniteCache defaultCache = client.cache(persistentCacheName2);
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.SERIALIZABLE);){
            Long val = (Long)inMemoryCache.get((Object)primaryKey1);
            defaultCache.put((Object)primaryKey1, (Object)val);
            tx.commit();
        }
        long pointInTime = U.currentTimeMillis() + 100L;
        snp.recoveryTo(new RecoveryParams(pointInTime)).get();
        persistentCache = client.cache(persistentCacheName);
        inMemoryCache = client.cache(inMemoryCacheName);
        defaultCache = client.cache(persistentCacheName2);
        GridPointInTimeRecoveryLocalTest.assertEquals((Object)expectedVal, (Object)defaultCache.get((Object)primaryKey1));
        GridPointInTimeRecoveryLocalTest.assertEquals((Object)expectedVal, (Object)persistentCache.get((Object)primaryKey0));
        GridPointInTimeRecoveryLocalTest.assertEquals((Object)expectedVal, (Object)inMemoryCache.get((Object)primaryKey1));
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"tmp", (boolean)false));
    }
}

