/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class RegisterBinaryMetadataAfterRestoreSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache1";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setMarshaller(null);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x20000000L)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinaryMetadata() throws Exception {
        this.startGrids(3);
        this.grid(0).active(true);
        try {
            GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
            SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, "test");
            snapFut.get();
            gg.snapshot().restoreSnapshot(snapFut.snapshotOperation().snapshotId(), null, "test").get();
            IgniteCache cache = this.grid(0).cache(CACHE_NAME);
            IgniteTransactions txs = this.grid(0).transactions();
            try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.get((Object)0);
                cache.put((Object)0, (Object)new TestObject());
                tx.commit();
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    private static class TestObject {
        private int val;

        private TestObject() {
        }
    }
}

