/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteRestoreSnapshotChangeBackupFactorTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 2;
    private static final int BACKUP_FACTOR_INITIAL = 0;
    private static final int BACKUP_FACTOR_NEW = 1;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setClientMode(igniteInstanceName.contains("client")).setConsistentId((Serializable)((Object)igniteInstanceName)).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath(this.folder("snapshots").getPath()))}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(0).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setIndexedTypes(new Class[]{Long.class, String.class})});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanIgniteWorkDir();
        IgniteEx ign = this.startGrids(2);
        ign.cluster().active(true);
        ign.getOrCreateCache("default");
        try (IgniteDataStreamer str = ign.dataStreamer("default");){
            for (long i = 0L; i < 1000L; ++i) {
                str.addData((Object)i, (Object)"1");
            }
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        super.afterTest();
    }

    private void cleanIgniteWorkDir() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)this.folder("snapshots"));
        U.delete((File)this.folder("tmp"));
        U.delete((File)this.folder("move_test"));
    }

    private File folder(String folder) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)folder, (boolean)false);
    }

    @Test
    public void testRestoreFromSnapshot() throws Exception {
        long snapshotId = this.makeSnapshot();
        this.stopAllGrids(true);
        IgniteEx ign = this.startGrids(2);
        this.restore((Ignite)ign, this.folder("snapshots").getPath(), snapshotId);
        this.awaitPartitionMapExchange();
        this.checkAffinity((Ignite)ign);
    }

    @Test
    public void testRestoreFromSnapshotWithCopy() throws Exception {
        long snapshotId = this.makeSnapshot();
        File f = this.copySnapshot(snapshotId);
        this.stopAllGrids(true);
        IgniteEx ign = this.startGrids(2);
        this.restore((Ignite)ign, f.getPath(), snapshotId);
        this.awaitPartitionMapExchange();
        this.checkAffinity((Ignite)ign);
    }

    private void checkAffinity(Ignite ign) {
        for (CacheConfiguration cacheConf : ign.configuration().getCacheConfiguration()) {
            for (int i = 0; i < cacheConf.getAffinity().partitions(); ++i) {
                Collection nds = ign.affinity(cacheConf.getName()).mapPartitionToPrimaryAndBackups(i);
                IgniteRestoreSnapshotChangeBackupFactorTest.assertEquals((String)(cacheConf + " part: " + i + " nodes: " + nds), (int)2, (int)nds.size());
            }
        }
    }

    private long makeSnapshot() {
        GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("default"), null);
        fut.get();
        return fut.snapshotOperation().snapshotId();
    }

    private File copySnapshot(long snapshotId) throws Exception {
        GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
        File snapshotMovePath = this.getMoveDirWithCreate();
        SnapshotUpdateOperationParams parameters = new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, false, null);
        gg.snapshot().copySnapshot(snapshotId, snapshotMovePath, parameters, null).get();
        return snapshotMovePath;
    }

    @NotNull
    private File getMoveDirWithCreate() throws IgniteCheckedException {
        File moveDir = this.folder("move_test");
        moveDir.mkdirs();
        return moveDir;
    }

    private void restore(Ignite ign, String searchPath, long snapshotId) {
        GridGain gg = (GridGain)ign.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId, Collections.singleton(new File(searchPath)), null, true, (IgniteBiClosure & Serializable)(s, c) -> c.setBackups(1), null).get();
    }
}

