/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.junit.Test;

public class IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent
extends AbstractSnapshotTest {
    protected static IgniteEx ignite;
    protected static IgniteEx ignite2;
    protected static GridGain gg;
    private final int SNAPSHOT_MX_BEAN_HISTORY_SIZE = 5;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        ignite.destroyCache("cache1");
        ignite.createCache(this.getCacheConfig("cache1"));
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.loadWithIntsAsync((Ignite)ignite, "cache1", 0, 1);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertTrue((boolean)ignite.cluster().active());
    }

    @Override
    protected void afterTest() throws Exception {
        this.clearSnapshotNodeDir(this.snapshotFolders());
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("GG_TEST_SKIP_SNAPSHOT_SYNC");
        System.clearProperty("GG_SNAPSHOT_METRICS_HISTORY_SIZE");
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        this.setProperties();
        ignite = this.startGrid(0);
        ignite2 = this.startGrid(1);
        ignite.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((String)"beforeTest", (int)300, (int)ignite.cache("cache1").size(new CachePeekMode[0]));
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((String)"beforeTest", (int)300, (int)ignite.cache("cache2").size(new CachePeekMode[0]));
        this.startGrid("client");
    }

    protected void setProperties() {
        System.setProperty("GG_TEST_SKIP_SNAPSHOT_SYNC", "true");
        System.setProperty("GG_SNAPSHOT_METRICS_HISTORY_SIZE", Integer.toString(5));
    }

    private IgniteCache<?, ?> moveCacheToNonPersist(String cacheName) {
        ignite.cache(cacheName).destroy();
        IgniteCache c0 = ignite.createCache(new CacheConfiguration(cacheName).setDataRegionName("noPersistence"));
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.loadWithIntsAsync((Ignite)ignite, cacheName, 0, 1);
        return c0;
    }

    @Test
    public void testDeleteLastSnapshotSimple() {
        int before = gg.snapshot().list().size();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 2), (int)gg.snapshot().list().size());
        this.moveCacheToNonPersist("cache1");
        fut = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        fut.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        ignite.getOrCreateCache(this.getCacheConfig("cache1"));
    }

    @Test
    public void testMoveLastSnapshotSimple() throws Exception {
        File movedDir = this.createOrCleanMoveDir();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.moveCacheToNonPersist("cache1");
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotFuture moveFut = gg.snapshot().moveSnapshot(snapId, movedDir, false, null);
        moveFut.get();
    }

    @Test
    public void testNotFullSnapshotDataRegCacheReplacement() {
        int before = gg.snapshot().list().size();
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        CacheConfiguration ccfg = (CacheConfiguration)cache1.getConfiguration(CacheConfiguration.class);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals(null, (String)ccfg.getDataRegionName());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
        }
        this.moveCacheToNonPersist("cache1");
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null);
        fut2.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 2), (int)gg.snapshot().list().size());
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, F.asSet((Object[])new String[]{"cache1", "cache2"}), true, null, null).get();
        this.moveCacheToNonPersist("cache1");
        try {
            gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), null, F.asSet((Object[])new String[]{"cache1", "cache2"}), true, null, null).get();
        }
        catch (IgniteException e) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)e.getMessage(), (String)"Caches (cache groups) are not contained in snapshot");
        }
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), null, null, true, null, null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        ccfg = (CacheConfiguration)cache1.getConfiguration(CacheConfiguration.class);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((String)"noPersistence", (String)ccfg.getDataRegionName());
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)cache1.size(new CachePeekMode[0]), (int)300);
        for (int i = 0; i < 300; ++i) {
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, -i), (Object)val2);
        }
    }

    @Test
    public void testListSnapshotSimple() {
        int before = gg.snapshot().list().size();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        this.moveCacheToNonPersist("cache1");
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
    }

    @Test
    public void testInfoSnapshotSimple() {
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotInfoEx info = gg.snapshot().snapshot(snapId, null);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((long)info.snapshotId(), (long)snapId);
        this.moveCacheToNonPersist("cache1");
        info = gg.snapshot().snapshot(snapId, null);
        IgniteDbSnapshotTestChangeCacheDataRegionToNonPersistent.assertEquals((long)info.snapshotId(), (long)snapId);
    }
}

