/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteDbSnapshotSchemaAfterRestoreTest
extends AbstractSnapshotTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testRestoreDynamicIndexForDynamicCacheRestored() throws Exception {
        String cacheName = "DYNAMIC_CACHE";
        IgniteEx ignite = this.startGrids(3);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.getOrCreateCache(this.cacheConfiguration(cacheName));
        this.executeQuery((IgniteCache<Integer, AbstractSnapshotTest.TestValue>)cache, "CREATE INDEX testvalue_v5_idx on TestValue (v5)");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
        }
        this.assertCacheIndex((IgniteCache<Integer, AbstractSnapshotTest.TestValue>)cache);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get();
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get();
        cache = ignite.cache(cacheName);
        this.assertIndexRestored(ignite, (IgniteCache<Integer, AbstractSnapshotTest.TestValue>)cache);
        this.assertCacheIndex((IgniteCache<Integer, AbstractSnapshotTest.TestValue>)cache);
        this.stopAllGrids();
        ignite = this.startGrids(3);
        ignite.cluster().active(true);
        cache = ignite.cache(cacheName);
        this.assertCacheIndex((IgniteCache<Integer, AbstractSnapshotTest.TestValue>)cache);
    }

    private void assertIndexRestored(IgniteEx ignite, IgniteCache<Integer, AbstractSnapshotTest.TestValue> cache) {
        cache.indexReadyFuture().get();
        IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
        GridH2Table tbl = idx.schemaManager().dataTable(cache.getName(), "TESTVALUE");
        IgniteDbSnapshotSchemaAfterRestoreTest.assertNotNull((Object)tbl);
        IgniteDbSnapshotSchemaAfterRestoreTest.assertFalse((boolean)tbl.rebuildFromHashInProgress());
    }

    private void assertCacheIndex(IgniteCache<Integer, AbstractSnapshotTest.TestValue> cache) {
        IgniteDbSnapshotSchemaAfterRestoreTest.assertEquals((int)300, (int)this.executeQuery(cache, "select * from TestValue where v5 between 0 and 300").size());
        String plan = this.explain(cache, "select * from TestValue where v5 between 0 and 300");
        IgniteDbSnapshotSchemaAfterRestoreTest.assertTrue((String)plan, (boolean)plan.toLowerCase().contains("testvalue_v5_idx"));
    }

    private String explain(IgniteCache<Integer, AbstractSnapshotTest.TestValue> cache, String sql) {
        return this.executeQuery(cache, "explain " + sql).get(0).get(0).toString();
    }

    private List<List<?>> executeQuery(IgniteCache<Integer, AbstractSnapshotTest.TestValue> cache, String sql) {
        return cache.query(new SqlFieldsQuery(sql)).getAll();
    }

    @NotNull
    private CacheConfiguration<Integer, AbstractSnapshotTest.TestValue> cacheConfiguration(String cacheName) {
        CacheConfiguration ccfg2 = new CacheConfiguration();
        ccfg2.setName(cacheName);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg2.setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter());
        ccfg2.setIndexedTypes(new Class[]{Integer.class, AbstractSnapshotTest.TestValue.class});
        ccfg2.setBackups(this.getBackupCount());
        return ccfg2;
    }
}

