/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_TEST_SKIP_SNAPSHOT_SYNC", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_METRICS_HISTORY_SIZE", value="5")})
public class IgniteDbSnapshotRestoreTest
extends AbstractSnapshotTest {
    private static final int EXPECTED_CACHES_COUNT = 15;
    private static final int NODES_COUNT = 2;
    protected static IgniteEx ignite;
    protected static IgniteEx ignite2;
    protected static IgniteEx dummyNode;
    protected static GridGain gg;

    protected void beforeTest() throws Exception {
        IgniteDbSnapshotRestoreTest.assertTrue((boolean)ignite.cluster().active());
        IgniteCache cache1 = ignite.getOrCreateCache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        IgniteCache cache3 = ignite.getOrCreateCache(this.getCacheConfig("localCache"));
        cache1.clear();
        cache2.clear();
        cache3.clear();
        this.load((Ignite)ignite);
        IgniteDbSnapshotRestoreTest.loadWithIntsAsync((Ignite)ignite, "localCache", 0, 1).get();
        IgniteDbSnapshotRestoreTest.assertEquals((String)"beforeTest", (int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotRestoreTest.assertEquals((String)"beforeTest", (int)300, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotRestoreTest.assertEquals((String)"beforeTest", (int)300, (int)cache3.size(new CachePeekMode[0]));
    }

    @Override
    protected void afterTest() throws Exception {
        SnapshotStatus op = gg.snapshot().ongoingSnapshotOperation();
        if (op != null) {
            gg.snapshot().cancelSnapshotOperation(op.operationId(), "afterTest").get();
        }
        this.clearSnapshotNodeDir(this.snapshotFolders());
        IgniteDbSnapshotRestoreTest.assertEquals((String)ignite.cacheNames().toString(), (int)15, (int)ignite.cacheNames().size());
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        dummyNode = this.startGrid("dummy");
        ignite = this.startGrid(0);
        ignite2 = this.startGrid(1);
        dummyNode.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        this.startGrid("client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicIndexForCacheRestoredWithRebuildWithClosure() throws Exception {
        IgniteCache cache = ignite.createCache(this.getCacheConfig("cache2").setName("DYN_CACHE_NAME").setGroupName("DYN_GROUP_NAME").setQueryEntities(Arrays.asList(new QueryEntity(Integer.class.getName(), AbstractSnapshotTest.TestValue.class.getName()).setFields((LinkedHashMap)new LinkedHashMap<String, String>(){
            {
                this.put("v1", Integer.class.getName());
                this.put("v2", String.class.getName());
                this.put("v3", String.class.getName());
                this.put("v4", String.class.getName());
                this.put("v5", Integer.class.getName());
            }
        }).setIndexes(Arrays.asList(new QueryIndex("v2", true, "TESTVALUE_V2_IDX"), new QueryIndex("v3", true, "TESTVALUE_V3_IDX"))))));
        String cacheName = cache.getName();
        File snapshotMovePath = this.createOrCleanMoveDir();
        try {
            File[] nodeDirs;
            cache.query(new SqlFieldsQuery("CREATE INDEX \"testvalue_v5_idx\" on TESTVALUE (v5)")).getAll();
            for (int i = 0; i < 300; ++i) {
                cache.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
            }
            IgniteDbSnapshotRestoreTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v2 = ?").setArgs(new Object[]{"aa"})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V2_IDX"));
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v3 = ?").setArgs(new Object[]{"aa"})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V3_IDX"));
            cache.query(new SqlFieldsQuery("drop index TESTVALUE_V3_IDX")).getAll();
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null);
            long snapshotId = fut.snapshotOperation().snapshotId();
            fut.get();
            for (File nodeDir : nodeDirs = this.getSnapshotNodeDirs("snapshot", snapshotId)) {
                File[] cacheDirs;
                for (File cacheDir : cacheDirs = nodeDir.listFiles()) {
                    if (!cacheDir.isDirectory()) continue;
                    this.assertIndexExists(cacheDir, gg.configuration().getSnapshotConfiguration().getCompressionOption());
                }
            }
            SnapshotUpdateOperationParams parameters = new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, false, null);
            gg.snapshot().copySnapshot(snapshotId, snapshotMovePath, parameters, null).get();
            this.stopAllGrids();
            this.cleanPersistenceDir();
            dummyNode = this.startGrid("dummy");
            ignite = this.startGrid(0);
            ignite2 = this.startGrid(1);
            dummyNode.cluster().active(true);
            gg = (GridGain)ignite.plugin("GridGain");
            this.startGrid("client");
            gg.snapshot().restoreSnapshot(snapshotId, Collections.singleton(snapshotMovePath), null, true, (IgniteBiClosure & Serializable)(s, c) -> c.setBackups(0), null).get();
            ignite.getOrCreateCache("localCache");
            cache = ignite.cache(cacheName);
            cache.indexReadyFuture().get();
            for (int i = 0; i < 2; ++i) {
                IgniteEx iex = this.grid(i);
                this.info("Checking grid: " + i);
                iex.cache(cacheName).indexReadyFuture().get();
                IgniteInternalCache internalCache = iex.context().cache().cache(cacheName);
                IgniteDbSnapshotRestoreTest.assertEquals((int)0, (int)internalCache.context().cache().map().internalSize());
            }
            IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
            GridH2Table tbl = idx.schemaManager().dataTable(cacheName, "TESTVALUE");
            IgniteDbSnapshotRestoreTest.assertNotNull((Object)tbl);
            IgniteDbSnapshotRestoreTest.assertFalse((boolean)tbl.rebuildFromHashInProgress());
            IgniteDbSnapshotRestoreTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v2 = ?").setArgs(new Object[]{"aa"})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V2_IDX"));
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v3 = ?").setArgs(new Object[]{"aa"})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotRestoreTest.assertFalse((String)plan, (boolean)plan.contains("TESTVALUE_V3_IDX"));
        }
        finally {
            if (cache != null) {
                cache.query(new SqlFieldsQuery("DROP INDEX IF EXISTS testvalue_v5_idx")).getAll();
            }
            ignite.destroyCache(cacheName);
            U.delete((File)snapshotMovePath);
        }
    }
}

