/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestExternalClassLoader;
import org.apache.ignite.testframework.config.GridTestProperties;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteDbSnapshotRestoreChangeCacheConfigTest
extends GridCommonAbstractTest
implements Serializable {
    private static final int ENTRIES_COUNT = 100;
    private static final String CACHE_NAME = "cache1";
    private static final String CACHE_2_NAME = "cache2";
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static final String NODE_FILTER_CLS_NAME = "org.apache.ignite.tests.p2p.NodeFilter";
    private static final URL[] URLS;
    private static final ClassLoader ldr;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        BinaryConfiguration bCfg = new BinaryConfiguration();
        bCfg.setCompactFooter(false);
        cfg.setBinaryConfiguration(bCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath("snapshot/" + gridName));
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setClassLoader(ldr);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.cleanIgniteWorkDir();
        this.cleanMoveDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        this.cleanMoveDir();
    }

    private static CacheConfiguration<Integer, IndexedObject> defaultCacheConfig(String name) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(name);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(0);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setIndexedTypes(new Class[]{Integer.class, IndexedObject.class});
        return ccfg;
    }

    @Test
    public void testNodeFilterChangeConfig() throws Exception {
        Long snapshotId = this.prepareMovedSnapshot();
        IgniteEx ig = this.startGrids(this.getNodesCount());
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        final Class<?> p2pNodeFilterCls = ldr.loadClass(NODE_FILTER_CLS_NAME);
        gg.snapshot().restoreSnapshot(snapshotId.longValue(), Collections.singleton(this.getOrCreateMoveDir()), null, (IgniteBiClosure)new CX2<String, CacheConfiguration, CacheConfiguration>(){

            public CacheConfiguration applyx(String cacheName, CacheConfiguration conf) throws IgniteCheckedException {
                try {
                    switch (cacheName) {
                        case "cache1": {
                            return conf.setNodeFilter((IgnitePredicate)p2pNodeFilterCls.newInstance());
                        }
                        case "cache2": {
                            return conf.setNodeFilter((IgnitePredicate)new NodeFilter());
                        }
                    }
                    return conf;
                }
                catch (Exception e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
        }, null).get();
        this.checkRestoreConsistency(ig);
        IgniteDbSnapshotRestoreChangeCacheConfigTest.assertSame(ig.cachex(CACHE_NAME).configuration().getNodeFilter().getClass(), p2pNodeFilterCls);
        IgniteDbSnapshotRestoreChangeCacheConfigTest.assertTrue((boolean)(ig.cachex(CACHE_2_NAME).configuration().getNodeFilter() instanceof NodeFilter));
    }

    protected int getNodesCount() {
        return 2;
    }

    @Test
    public void testRestoreChangeConfig() throws Exception {
        Long snapshotId = this.prepareMovedSnapshot();
        IgniteEx ig = this.startGrids(this.getNodesCount());
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        gg.snapshot().restoreSnapshot(snapshotId.longValue(), Collections.singleton(this.getOrCreateMoveDir()), null, (IgniteBiClosure)new CX2<String, CacheConfiguration, CacheConfiguration>(){

            public CacheConfiguration applyx(String cacheName, CacheConfiguration conf) throws IgniteCheckedException {
                return conf.clearQueryEntities().setBackups(1).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            }
        }, null).get();
        this.awaitPartitionMapExchange();
        this.checkRestoreConsistency(ig);
        for (String cacheName : Arrays.asList(CACHE_NAME, CACHE_2_NAME)) {
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertTrue((boolean)ig.cacheNames().contains(cacheName));
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertEquals((int)0, (int)ig.context().query().types(cacheName).size());
            CacheConfiguration conf = ig.cachex(cacheName).configuration();
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertEquals((int)1, (int)conf.getBackups());
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertEquals((Object)CacheAtomicityMode.TRANSACTIONAL, (Object)conf.getAtomicityMode());
        }
    }

    private void checkRestoreConsistency(IgniteEx ig) {
        IgniteDbSnapshotRestoreChangeCacheConfigTest.assertTrue((boolean)ig.cacheNames().contains(CACHE_NAME));
        IgniteDbSnapshotRestoreChangeCacheConfigTest.assertTrue((boolean)ig.cacheNames().contains(CACHE_2_NAME));
        IgniteCache cache1 = ig.cache(CACHE_NAME);
        IgniteCache cache2 = ig.cache(CACHE_2_NAME);
        for (int k = 0; k < 100; ++k) {
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertEquals((int)k, (int)((IndexedObject)cache1.get((Object)k)).idx());
            IgniteDbSnapshotRestoreChangeCacheConfigTest.assertEquals((int)k, (int)((IndexedObject)cache2.get((Object)k)).idx());
        }
    }

    private Long prepareMovedSnapshot() throws Exception {
        IgniteEx ig = this.startGrids(this.getNodesCount());
        ig.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        ig.createCache(IgniteDbSnapshotRestoreChangeCacheConfigTest.defaultCacheConfig(CACHE_NAME));
        ig.createCache(IgniteDbSnapshotRestoreChangeCacheConfigTest.defaultCacheConfig(CACHE_2_NAME));
        try (IgniteDataStreamer streamer1 = ig.dataStreamer(CACHE_NAME);
             IgniteDataStreamer streamer2 = ig.dataStreamer(CACHE_2_NAME);){
            for (int k = 0; k < 100; ++k) {
                streamer1.addData((Object)k, (Object)new IndexedObject(k));
                streamer2.addData((Object)k, (Object)new IndexedObject(k));
            }
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        File moveDir = this.getOrCreateMoveDir();
        gg.snapshot().moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, null).get();
        this.stopAllGrids();
        this.cleanIgniteWorkDir();
        return fut.snapshotOperation().snapshotId();
    }

    private void cleanIgniteWorkDir() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @NotNull
    private File getOrCreateMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        if (!moveDir.exists()) {
            moveDir.mkdirs();
        }
        return moveDir;
    }

    private void cleanMoveDir() throws IgniteCheckedException {
        File moveDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)false);
        U.delete((File)moveDir);
    }

    static {
        try {
            URLS = new URL[]{new URL(GridTestProperties.getProperty((String)"p2p.uri.cls"))};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Define property p2p.uri.cls", e);
        }
        ldr = new GridTestExternalClassLoader(URLS, new String[0]);
    }

    public static class IndexedObject {
        @QuerySqlField(index=true)
        final Integer idx;
        final byte[] data;

        IndexedObject(Integer idx) {
            this.idx = idx;
            Random rnd = new Random();
            this.data = new byte[1024];
            rnd.nextBytes(this.data);
        }

        public Integer idx() {
            return this.idx;
        }

        public byte[] data() {
            return this.data;
        }
    }

    public static class NodeFilter
    implements IgnitePredicate<ClusterNode> {
        public boolean apply(ClusterNode node) {
            return true;
        }
    }
}

