/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Test;

public class IgniteDbIncrementalSnapshotWithIndexRemoveTest
extends AbstractSnapshotTest {
    private static Set<String> caches = Stream.of("cache1", "cache2").collect(Collectors.toSet());

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testThatIncrementalSnapshotWillSucceedAfterIndexPartitionRemove() throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        this.loadData((Ignite)ig);
        this.createSnapshot((Ignite)ig, true);
        this.loadData((Ignite)ig);
        this.createSnapshot((Ignite)ig, false);
        this.stopAllGrids();
        this.deleteIndexPartitions();
        ig = this.startGrids(2);
        ig.cluster().active(true);
        this.loadData((Ignite)ig);
        this.createSnapshot((Ignite)ig, false);
        this.checkSnapshots((Ignite)ig);
    }

    private void loadData(Ignite ig) {
        int keyCnt = 1000;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        try (IgniteDataStreamer ds1 = ig.dataStreamer("cache1");
             IgniteDataStreamer ds2 = ig.dataStreamer("cache2");){
            ds1.allowOverwrite(true);
            ds2.allowOverwrite(true);
            for (int i = 0; i < 1000; ++i) {
                ds1.addData((Object)i, (Object)((Random)rnd).nextInt());
                ds2.addData((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, ((Random)rnd).nextInt()));
            }
        }
    }

    private long createSnapshot(Ignite ig, boolean full) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot gs = gg.snapshot();
        SnapshotFuture snapFut = full ? gs.createFullSnapshot(caches, "FULL SNAP") : gs.createSnapshot(caches, "INC SNAP");
        snapFut.get();
        return snapFut.snapshotOperation().snapshotId();
    }

    private void checkSnapshots(Ignite ig) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot gs = gg.snapshot();
        List snaps = gs.list();
        IgniteDbIncrementalSnapshotWithIndexRemoveTest.assertEquals((String)"Number of snapshots", (int)3, (int)snaps.size());
        snaps.sort(Comparator.comparingLong(SnapshotInfo::snapshotId));
        IgniteDbIncrementalSnapshotWithIndexRemoveTest.assertTrue((String)"First snapshot must be full", (boolean)((SnapshotInfo)snaps.get(0)).fullSnapshot());
        snaps.forEach(snapshotInfo -> {
            SnapshotFuture checkFut = gs.checkSnapshot(snapshotInfo.snapshotId(), null, false, "");
            checkFut.get();
            IgniteDbIncrementalSnapshotWithIndexRemoveTest.assertEquals((String)"Snapshot check failed", (int)0, (int)((List)checkFut.get()).size());
        });
    }

    private void deleteIndexPartitions() throws Exception {
        Path dbDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false).toPath();
        final AtomicInteger idxCnt = new AtomicInteger();
        final Pattern pathPattern = Pattern.compile("\\S*(cache1|Group2)/index\\.bin$");
        Files.walkFileTree(dbDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                String sPath = path.toString();
                if (pathPattern.matcher(sPath).matches()) {
                    try {
                        Files.delete(path);
                        idxCnt.incrementAndGet();
                    }
                    catch (IOException e) {
                        log.error("Failed to delete " + path, (Throwable)e);
                        IgniteDbIncrementalSnapshotWithIndexRemoveTest.fail((String)("Failed to delete idx partition " + path));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        IgniteDbIncrementalSnapshotWithIndexRemoveTest.assertEquals((String)"Expected 4 deleted idx partitions", (int)4, (int)idxCnt.get());
    }
}

