/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbDifferentTopologySnapshotSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int ENTRIES_COUNT = 2000;
    public static final int SNAPSHOTS = 5;
    private static final String CACHE_NAME = "cache1";
    public static final String CACHE_2_NAME = "cache2";
    private File shared;
    private int backups;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x8000000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        ccfg1.setName(CACHE_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg1.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        ccfg1.setBackups(this.backups);
        CacheConfiguration ccfg2 = new CacheConfiguration();
        ccfg2.setName(CACHE_2_NAME);
        ccfg2.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg2.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg2.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg2.setBackups(this.backups);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        File localDir = new File(U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false), U.maskForFileName((CharSequence)gridName));
        ggDbCfg.setSnapshotsPath(localDir.getAbsolutePath());
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        }
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(IP_FINDER));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.shared = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"shared", (boolean)false);
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void testRestore_1_3_1() throws Exception {
        this.checkRestore(1, 3, 1, false);
    }

    @Test
    public void testRestore_3_1_1() throws Exception {
        this.checkRestore(3, 1, 1, false);
    }

    @Test
    public void testRestore_2_5_1() throws Exception {
        this.checkRestore(2, 5, 1, false);
    }

    @Test
    public void testRestore_5_2_1() throws Exception {
        this.checkRestore(5, 2, 1, false);
    }

    @Test
    public void testRestore_2_5_2() throws Exception {
        this.checkRestore(2, 5, 2, false);
    }

    @Test
    public void testRestore_5_2_2() throws Exception {
        this.checkRestore(5, 2, 2, false);
    }

    @Test
    public void testRestoreFromClient_5_2_1() throws Exception {
        this.checkRestore(5, 2, 1, true);
    }

    @Test
    public void testRestoreFromClient_2_5_1() throws Exception {
        this.checkRestore(2, 5, 1, true);
    }

    @Test
    public void testRestoreStepped_2_5_1() throws Exception {
        this.checkSteppedSnapshots(2, 4, 1, false);
    }

    @Test
    public void testRestoreStepped_5_2_1() throws Exception {
        this.checkSteppedSnapshots(5, 2, 1, false);
    }

    @Test
    public void testRestoreSteppedFromClient_2_5_1() throws Exception {
        this.checkSteppedSnapshots(2, 5, 1, true);
    }

    @Test
    public void testRestoreSteppedFromClient_5_2_1() throws Exception {
        this.checkSteppedSnapshots(5, 2, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSteppedSnapshots(int startSize, int endSize, int backups, boolean useClient) throws Exception {
        this.backups = backups;
        try {
            this.startGrids(startSize).cluster().active(true);
            IgniteEx agent = useClient ? this.startGrid("client") : this.ignite(0);
            int delta = startSize > endSize ? -1 : 1;
            ArrayList<Long> snapshotIds = new ArrayList<Long>();
            for (int i = startSize; i != endSize; i += delta) {
                this.populateCaches((Ignite)agent, i);
                GridGain gg = (GridGain)agent.plugin("GridGain");
                GridSnapshot db = gg.snapshot();
                SnapshotFuture fut = db.createFullSnapshot(null, null);
                fut.get();
                snapshotIds.add(fut.snapshotOperation().snapshotId());
                db.moveSnapshot(fut.snapshotOperation().snapshotId(), this.shared, "move to shared folder").get();
                this.info("++++++++++++++++++++++++++++");
                this.info("++++++++++++++++++++++++++++");
                this.info("++++++++++++++++++++++++++++");
                this.info("++++++++++++++++++++++++++++");
                if (delta > 0) {
                    this.startGrid(i);
                } else {
                    this.stopGrid(i);
                }
                this.info("=============================");
                this.info("=============================");
                this.info("=============================");
                this.info("=============================");
            }
            this.stopAllGrids();
            this.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            IgniteEx ignite = this.startGrids(endSize);
            ignite.cluster().baselineAutoAdjustEnabled(false);
            ignite.cluster().active(true);
            ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
            agent = useClient ? this.startGrid("client") : this.ignite(0);
            int val = startSize;
            for (Long snapshotId : snapshotIds) {
                GridGain gg = (GridGain)agent.plugin("GridGain");
                GridSnapshot db = gg.snapshot();
                db.restoreSnapshot(snapshotId.longValue(), Collections.singletonList(this.shared), null, null).get();
                this.checkCaches((Ignite)agent, val);
                val += delta;
            }
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testMoveAfterNodesStart() throws Exception {
        this.checkMoveAfterNodesStart(false);
    }

    @Test
    public void testMoveAfterNodesStartClient() throws Exception {
        this.checkMoveAfterNodesStart(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMoveAfterNodesStart(boolean useClient) throws Exception {
        this.backups = 1;
        try {
            this.startGrids(3).active(true);
            IgniteEx ig = useClient ? this.startGrid("client") : this.ignite(0);
            ig.cluster().baselineAutoAdjustEnabled(false);
            GridGain gg = (GridGain)ig.plugin("GridGain");
            GridSnapshot db = gg.snapshot();
            IgniteCache cache1 = ig.cache(CACHE_NAME);
            IgniteCache cache2 = ig.cache(CACHE_2_NAME);
            for (int k = 0; k < 2000; ++k) {
                cache1.put((Object)k, (Object)new TestValue(0));
                cache2.put((Object)k, (Object)new TestValue(0));
            }
            SnapshotFuture fut = db.createFullSnapshot(null, null);
            fut.get();
            IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)1, (int)db.list().size());
            this.startGrid(3);
            this.startGrid(4);
            ig.cluster().setBaselineTopology(ig.cluster().topologyVersion());
            db.forceMoveSnapshot(fut.snapshotOperation().snapshotId(), this.shared, "move to shared folder").get();
            IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)1, (int)db.listSnapshots(Collections.singleton(this.shared)).size());
            this.stopAllGrids();
            this.cleanPersistenceDir();
            this.startGrids(5).active(true);
            ig = useClient ? this.startGrid("client") : this.ignite(0);
            this.restoreAndVerify((Ignite)ig, 1, F.asList((Object)fut.snapshotOperation().snapshotId()));
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRestore(int sizeBefore, int sizeAfter, int backups, boolean useClient) throws Exception {
        this.backups = backups;
        try {
            this.startGrids(sizeBefore).active(true);
            IgniteEx agent = useClient ? this.startGrid("client") : this.ignite(0);
            List<Long> snapshotIds = this.snapshotAndMove((Ignite)agent);
            this.stopAllGrids();
            this.cleanPersistenceDir();
            IgniteEx ignite = this.startGrids(sizeAfter);
            ignite.cluster().baselineAutoAdjustEnabled(false);
            ignite.active(true);
            ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
            agent = useClient ? this.startGrid("client") : this.ignite(0);
            this.restoreAndVerify((Ignite)agent, 5, snapshotIds);
        }
        finally {
            this.stopAllGrids();
        }
    }

    private List<Long> snapshotAndMove(Ignite ig) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        for (int i = 0; i < 5; ++i) {
            this.populateCaches(ig, i);
            SnapshotFuture fut = i == 0 ? db.createFullSnapshot(null, null) : db.createSnapshot(null, null);
            fut.get();
            snapshotIds.add(fut.snapshotOperation().snapshotId());
        }
        IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)5, (int)db.list().size());
        db.forceMoveSnapshot(((Long)snapshotIds.get(0)).longValue(), this.shared, "move to shared folder").get();
        IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)5, (int)db.listSnapshots(Collections.singleton(this.shared)).size());
        return snapshotIds;
    }

    private void populateCaches(Ignite ig, int val) {
        IgniteCache cache1 = ig.cache(CACHE_NAME);
        IgniteCache cache2 = ig.cache(CACHE_2_NAME);
        for (int k = 0; k < 2000; ++k) {
            cache1.put((Object)k, (Object)new TestValue(val));
            cache2.put((Object)k, (Object)new TestValue(val));
        }
    }

    private void checkCaches(Ignite ig, int val) {
        IgniteCache cache1 = ig.cache(CACHE_NAME);
        IgniteCache cache2 = ig.cache(CACHE_2_NAME);
        for (int k = 0; k < 2000; ++k) {
            IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((Object)new TestValue(val), (Object)cache1.get((Object)k));
            IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((Object)new TestValue(val), (Object)cache2.get((Object)k));
        }
    }

    private void restoreAndVerify(Ignite ig, int expCnt, List<Long> snapshotIds) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        List infos = db.listSnapshots(Collections.singleton(this.shared));
        IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)expCnt, (int)infos.size());
        for (int i = 0; i < snapshotIds.size(); ++i) {
            Long snapshotId = snapshotIds.get(i);
            List issues = (List)db.checkSnapshot(snapshotId.longValue(), Collections.singleton(this.shared), false, null).get();
            IgniteDbDifferentTopologySnapshotSelfTest.assertEquals((int)0, (int)issues.size());
            db.restoreSnapshot(snapshotId.longValue(), Collections.singleton(this.shared), null, null).get();
            this.checkCaches(ig, i);
        }
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        if (this.shared != null) {
            U.delete((File)this.shared);
        }
        for (int i = 0; i < 5; ++i) {
            U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("snapshots-" + this.getTestIgniteInstanceName(i)), (boolean)false));
        }
    }

    private static class TestValue {
        private int val;

        private TestValue(int val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestValue)) {
                return false;
            }
            TestValue testValue = (TestValue)o;
            return this.val == testValue.val;
        }

        public int hashCode() {
            return this.val;
        }
    }
}

