/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.dr;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.service.DummyService;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.dr.ist.messages.DrStateRecord;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.internal.processors.dr.DrAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class DrSnapshotLwmCountersTest
extends DrAbstractTest {
    public static final int HALF_OF_KEYS = 10;
    protected Ignite sndIgnite;
    protected GridCacheAdapter<String, Integer> sndCache;
    protected Ignite rcvIgnite;
    protected GridCacheAdapter<String, Integer> rcvCache;

    protected void beforeTest() throws Exception {
        this.clearFolders();
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.clearFolders();
        this.sndIgnite = null;
        this.rcvIgnite = null;
        this.sndCache = null;
        this.rcvCache = null;
        DummyService.reset();
    }

    private void clearFolders() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    protected IgniteConfiguration config(GridGainConfiguration ggCfg, String igniteInstanceName, byte dataCenterId, TcpDiscoveryIpFinder ipFinder, @Nullable DrSenderConfiguration sndHubCfg, @Nullable DrReceiverConfiguration rcvHubCfg, boolean clientMode, CacheConfiguration ... cacheCfgs) throws IgniteCheckedException {
        IgniteConfiguration cfg = super.config(ggCfg, igniteInstanceName, dataCenterId, ipFinder, sndHubCfg, rcvHubCfg, clientMode, cacheCfgs);
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return cfg;
    }

    @Test
    public void testSendingPrimitives() throws Exception {
        int k;
        this.startUp();
        for (k = 0; k < 20; ++k) {
            this.sndCache.put((Object)("Key" + k), (Object)k);
        }
        for (k = 10; k < 20; ++k) {
            this.sndCache.remove((Object)("Key" + k));
            this.sndCache.put((Object)("Key" + (k + 10)), (Object)k);
        }
        DrSnapshotLwmCountersTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (int k = 0; k < 10; ++k) {
                try {
                    if (this.rcvCache.get((Object)("Key" + k)) == null) {
                        return false;
                    }
                    if (this.rcvCache.get((Object)("Key" + (k + 10))) != null) {
                        return false;
                    }
                    if (this.rcvCache.get((Object)("Key" + (k + 20))) != null) continue;
                    return false;
                }
                catch (IgniteCheckedException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }, (long)10000L));
        this.checkSnapshotRestoration();
    }

    @Test
    public void testEmptyCache() throws Exception {
        int k;
        this.startUp();
        for (k = 0; k < 10; ++k) {
            this.sndCache.put((Object)("Key" + k), (Object)k);
        }
        DrSnapshotLwmCountersTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (int k = 0; k < 10; ++k) {
                try {
                    if (this.rcvCache.get((Object)("Key" + k)) != null) continue;
                    return false;
                }
                catch (IgniteCheckedException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }, (long)10000L));
        for (k = 0; k < 10; ++k) {
            this.sndCache.remove((Object)("Key" + k));
        }
        DrSnapshotLwmCountersTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (int k = 0; k < 10; ++k) {
                try {
                    if (this.rcvCache.get((Object)("Key" + k)) == null) continue;
                    return false;
                }
                catch (IgniteCheckedException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }, (long)10000L));
        this.checkSnapshotRestoration();
    }

    private void checkSnapshotRestoration() throws IgniteCheckedException {
        this.forceCheckpoint(this.sndIgnite);
        this.validateCounters();
        Ignition.stop((String)"top1_node_snd", (boolean)true);
        Ignition.stop((String)"top2_node_rcv", (boolean)true);
        Ignition.stop((String)"top2_node", (boolean)true);
        GridSnapshot gridSnapshot = DrSnapshotLwmCountersTest.snapshot((Ignite)this.sndIgnite);
        SnapshotFuture createFullSnapFut = gridSnapshot.createFullSnapshot(Collections.singleton("cache"), null, new SnapshotCreateParams(CompressionOption.ZIP, 1, 0, true, "snap"), "test snapshot");
        createFullSnapFut.get(this.getTestTimeout());
        long snapId = createFullSnapFut.snapshotOperation().snapshotId();
        SnapshotFuture restoreFut = gridSnapshot.restore(new RestoreSnapshotParams().snapshotId(snapId));
        restoreFut.get(this.getTestTimeout());
        this.sndCache = ((IgniteKernal)this.sndIgnite).internalCache("cache");
        this.validateCounters();
    }

    private void validateCounters() throws IgniteCheckedException {
        CacheGroupContext group = this.sndCache.context().group();
        Collection records = DrUtils.readDrState((IgniteCacheDatabaseSharedManager)group.shared().database(), (String)DrUtils.drStateMetastorageKey((String)"cache"));
        StringBuilder errMsg = new StringBuilder("Broken partitions found:" + IgniteKernal.NL);
        int brokenParts = 0;
        for (DrStateRecord r : records) {
            GridDhtLocalPartition localPartition = group.topology().localPartition(r.part());
            long lwm = r.lwm();
            if (localPartition != null) {
                long counter = localPartition.updateCounter();
                if (lwm == counter) continue;
                errMsg.append("  part=").append(r.part()).append(", lwm=").append(lwm).append(", updCntr=").append(counter).append(IgniteKernal.NL);
                ++brokenParts;
                continue;
            }
            errMsg.append("  part=").append(r.part()).append(", lwm=").append(lwm).append(IgniteKernal.NL);
            ++brokenParts;
        }
        DrSnapshotLwmCountersTest.assertEquals((String)errMsg.toString(), (int)0, (int)brokenParts);
    }

    protected void startUp() throws Exception {
        TcpDiscoveryIpFinder rcvTop = this.createTopology((IgniteClosureX)new IgniteClosureX<TcpDiscoveryIpFinder, IgniteConfiguration[]>(){

            public IgniteConfiguration[] applyx(TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
                IgniteConfiguration dataNodeCfg = DrSnapshotLwmCountersTest.this.receiverDataNodeConfiguration(new GridGainConfiguration(), ipFinder);
                IgniteConfiguration rcvHubCfg = DrSnapshotLwmCountersTest.this.receiverHubConfiguration(ipFinder);
                return DrSnapshotLwmCountersTest.this.wrap(new IgniteConfiguration[]{dataNodeCfg, rcvHubCfg});
            }
        });
        TcpDiscoveryIpFinder sndTop = this.createTopology((IgniteClosureX)new IgniteClosureX<TcpDiscoveryIpFinder, IgniteConfiguration[]>(){

            public IgniteConfiguration[] applyx(TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
                IgniteConfiguration sndHubCfg = DrSnapshotLwmCountersTest.this.senderHubConfiguration(ipFinder);
                IgniteConfiguration dataNodeCfg = DrSnapshotLwmCountersTest.this.sendDataNodeConfiguration(ipFinder);
                return DrSnapshotLwmCountersTest.this.wrap(new IgniteConfiguration[]{dataNodeCfg, sndHubCfg});
            }
        });
        List rcvTopNodes1 = this.startTopology(rcvTop);
        this.rcvIgnite = (Ignite)rcvTopNodes1.get(0);
        this.rcvCache = ((IgniteKernal)this.rcvIgnite).internalCache("cache");
        List sndTopNodes = this.startTopology(sndTop);
        this.sndIgnite = (Ignite)sndTopNodes.get(0);
        this.sndCache = ((IgniteKernal)this.sndIgnite).internalCache("cache");
    }

    protected IgniteConfiguration senderHubConfiguration(TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
        DrSenderConfiguration sndHubCfg = this.senderHubConfig(new DrSenderConnectionConfiguration[]{this.senderHubReplicaConfig((byte)2, new String[]{"127.0.0.1:12311"})});
        sndHubCfg.setCacheNames(new String[]{"cache"});
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        IgniteConfiguration cfg = this.config(ggCfg, "top1_node_snd", (byte)1, ipFinder, sndHubCfg, null, new CacheConfiguration[0]);
        cfg.setPeerClassLoadingEnabled(true);
        return cfg;
    }

    protected IgniteConfiguration receiverHubConfiguration(TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        DrReceiverConfiguration rcvHubCfg = new DrReceiverConfiguration();
        rcvHubCfg.setLocalInboundPort(12311);
        IgniteConfiguration cfg = this.config(ggCfg, "top2_node_rcv", (byte)2, ipFinder, null, rcvHubCfg, new CacheConfiguration[0]);
        cfg.setPeerClassLoadingEnabled(true);
        return cfg;
    }

    protected IgniteConfiguration sendDataNodeConfiguration(TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        CacheConfiguration<?, ?> ccfg = this.senderCacheConfiguration();
        IgniteConfiguration cfg = this.config(ggCfg, "top1_node", (byte)1, ipFinder, null, null, new CacheConfiguration[]{ccfg});
        cfg.setPeerClassLoadingEnabled(true);
        return cfg;
    }

    protected CacheConfiguration<?, ?> senderCacheConfiguration() {
        CacheDrSenderConfiguration drSndCfg = new CacheDrSenderConfiguration();
        drSndCfg.setBatchSendFrequency(100L);
        return this.createCacheConfiguration(drSndCfg);
    }

    protected IgniteConfiguration receiverDataNodeConfiguration(GridGainConfiguration ggCfg, TcpDiscoveryIpFinder ipFinder) throws IgniteCheckedException {
        CacheConfiguration<?, ?> ccfg = this.recieverCacheConfiguration();
        IgniteConfiguration cfg = this.config(ggCfg, "top2_node", (byte)2, ipFinder, null, null, new CacheConfiguration[]{ccfg});
        cfg.setPeerClassLoadingEnabled(true);
        return cfg;
    }

    protected CacheConfiguration<?, ?> recieverCacheConfiguration() {
        return this.createCacheConfiguration(null);
    }

    protected CacheConfiguration<?, ?> createCacheConfiguration(@Nullable CacheDrSenderConfiguration sndCfg) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName("cache");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        this.ggCacheConfig(ccfg).setDrSenderConfiguration(sndCfg);
        return ccfg;
    }
}

