/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.db;

import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)ipFinder));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testJoinActiveNodeToInActiveCluster() throws Exception {
        this.checkJoin(false, this.cfg(this.name(0)).setActiveOnStart(false), this.cfg(this.name(1)).setActiveOnStart(false), this.cfg(this.name(2)).setActiveOnStart(false), this.cfg(this.name(3)).setActiveOnStart(true));
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        ig0.active(true);
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig0.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig1.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig2.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig3.active());
    }

    @Test
    public void testJoinInActiveNodeToActiveCluster() throws Exception {
        this.checkJoin(true, this.cfg(this.name(0)).setActiveOnStart(true), this.cfg(this.name(1)).setActiveOnStart(true), this.cfg(this.name(2)).setActiveOnStart(true), this.cfg(this.name(3)).setActiveOnStart(false));
    }

    @Test
    public void testJoinActiveClientNodeToInActiveCluster() throws Exception {
        this.checkJoin(false, this.cfg(this.name(0)).setActiveOnStart(false), this.cfg(this.name(1)).setActiveOnStart(false), this.cfg(this.name(2)).setActiveOnStart(false), this.cfg(this.name(3)).setActiveOnStart(true).setClientMode(true));
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        ig0.active(true);
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig0.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig1.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig2.active());
        IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertTrue((boolean)ig3.active());
    }

    @Test
    public void testJoinInActiveClientNodeToActiveCluster() throws Exception {
        this.checkJoin(true, this.cfg(this.name(0)).setActiveOnStart(true), this.cfg(this.name(1)).setActiveOnStart(true), this.cfg(this.name(2)).setActiveOnStart(true), this.cfg(this.name(3)).setActiveOnStart(false).setClientMode(true));
    }

    protected void checkJoin(boolean assertFlag, IgniteConfiguration ... cfgs) throws Exception {
        for (int i = 0; i < cfgs.length - 1; ++i) {
            this.startGrid(cfgs[i]);
        }
        IgniteConfiguration lastNode = cfgs[cfgs.length - 1];
        this.startGrid(lastNode);
        for (int i = 0; i < cfgs.length - 1; ++i) {
            IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest.assertEquals((boolean)assertFlag, (boolean)this.grid(i).active());
        }
    }

    protected String name(int idx) {
        return this.getTestIgniteInstanceName(idx);
    }

    protected IgniteConfiguration cfg(String name) throws Exception {
        return this.getConfiguration(name);
    }
}

