/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.function.Predicate;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.compression.SnapshotCompressionUtils;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStreamListener;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.snapshot.file.ByteChannelSnapshotOutputStream;
import org.gridgain.grid.persistentstore.snapshot.file.DigestSnapshotOutputStreamWrapper;
import org.gridgain.grid.persistentstore.snapshot.file.EncryptedOutputStream;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotEncryptionOutputStream;
import org.jetbrains.annotations.Nullable;

public class SnapshotOutputStreamFactory {
    private final Predicate<Integer> postponedCompression;
    private final CompressionOption compressionOption;
    private final int compressionLevel;
    private final SnapshotMetricsMXBeanImpl snapshotMetricsMXBean;
    private final MessageDigestFactory msgDigestFactory;
    private final SnapshotEncryptionOptions encryptionOptions;
    private final EncryptionSpi encryptionSpi;
    private final int pageSize;

    public SnapshotOutputStreamFactory(Predicate<Integer> postponedCompression, CompressionOption compressionOption, int compressionLevel, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotMetricsMXBeanImpl snapshotMetricsMXBean, @Nullable SnapshotEncryptionOptions encryptionOptions, EncryptionSpi encryptionSpi, int pageSize) {
        this.postponedCompression = postponedCompression;
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.msgDigestFactory = msgDigestFactory;
        this.snapshotMetricsMXBean = snapshotMetricsMXBean;
        this.encryptionOptions = encryptionOptions;
        this.encryptionSpi = encryptionSpi;
        this.pageSize = pageSize;
    }

    public SnapshotOutputStream makeOutputStream(FsSnapshotPath path) throws IOException {
        return this.makeOutputStream(path, null);
    }

    public SnapshotOutputStream makeOutputStream(FsSnapshotPath path, Integer grpId) throws IOException {
        ByteChannelSnapshotOutputStream snapStream;
        MessageDigest msgDigest = this.msgDigestFactory == null ? null : this.msgDigestFactory.createDigest();
        DigestOutputStream digestOutputStream = null;
        GroupKey encryptionKey = this.encryptionOptions != null && grpId != null ? this.encryptionOptions.getGroupKey(grpId) : null;
        boolean optimizedCompressedEncryption = encryptionKey != null && this.encryptionOptions.optimizedCompressedEncryption();
        boolean postponedCompression = this.postponedCompression.test(grpId);
        CompressionOption compressionOption = postponedCompression ? CompressionOption.NONE : this.compressionOption;
        FsSnapshotPath file = compressionOption == CompressionOption.NONE ? path : path.resolveSibling(path + compressionOption.fileExtension());
        SnapshotOutputStreamListener lsnr = this.makeListener((SnapshotPath)file, postponedCompression);
        OutputStream outStream = file.outputStream();
        if (optimizedCompressedEncryption) {
            if (msgDigest != null) {
                digestOutputStream = new DigestOutputStream(outStream, msgDigest);
                outStream = digestOutputStream;
            }
            outStream = new EncryptedOutputStream(outStream, encryptionKey, this.encryptionSpi, this.pageSize);
            assert (compressionOption.isCompressed()) : "Unexpected uncompressed snapshot with 'optimizedCompressedEncryption' option: " + path;
            outStream = SnapshotCompressionUtils.wrapWithCompression(outStream, compressionOption, this.compressionLevel, path.getName());
            snapStream = new ByteChannelSnapshotOutputStream(outStream, lsnr);
        } else {
            if (compressionOption.isCompressed()) {
                outStream = SnapshotCompressionUtils.wrapWithCompression(outStream, compressionOption, this.compressionLevel, path.getName());
            }
            if (msgDigest != null) {
                digestOutputStream = new DigestOutputStream(outStream, msgDigest);
                outStream = digestOutputStream;
            }
            snapStream = encryptionKey != null ? new SnapshotEncryptionOutputStream(outStream, lsnr, encryptionKey, this.encryptionSpi, this.pageSize) : new ByteChannelSnapshotOutputStream(outStream, lsnr);
        }
        if (digestOutputStream != null) {
            return new DigestSnapshotOutputStreamWrapper(snapStream, digestOutputStream);
        }
        return snapStream;
    }

    private SnapshotOutputStreamListener makeListener(SnapshotPath file, boolean postponedCompression) {
        return () -> {
            if (this.snapshotMetricsMXBean != null && !postponedCompression) {
                this.snapshotMetricsMXBean.incrementTotalBytesWrittenOnStorage(file.length());
            }
        };
    }
}

