/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptionUtil;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStreamListener;
import org.gridgain.grid.persistentstore.snapshot.file.ByteChannelSnapshotOutputStream;

public class SnapshotEncryptionOutputStream
extends ByteChannelSnapshotOutputStream {
    private final GroupKey encryptionKey;
    private final int pageSize;
    EncryptionUtil encUtil;

    public SnapshotEncryptionOutputStream(OutputStream target, SnapshotOutputStreamListener listener, GroupKey encryptionKey, EncryptionSpi encSpi, int pageSize) {
        super(target, listener);
        this.encryptionKey = encryptionKey;
        this.pageSize = pageSize;
        this.encUtil = new EncryptionUtil(encSpi, pageSize);
    }

    public void write(ByteBuffer data) throws IgniteCheckedException {
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        this.encUtil.encrypt(data, encrypted, this.encryptionKey);
        encrypted.rewind();
        this.writeInternal(encrypted);
    }

    @Override
    public void plainWrite(ByteBuffer data) throws IgniteCheckedException {
        assert (data.get(data.position()) - 1 == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V2.index() || data.get(data.position()) - 1 == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V3.index()) : "Not encrypted record was included to encrypted group [idx=" + (data.get(data.position()) - 1) + ']';
        this.writeInternal(data);
    }

    private void writeInternal(ByteBuffer data) throws IgniteCheckedException {
        super.plainWrite(data);
    }
}

