/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2DigestWriter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;

public class SnapshotDigestRegistryCache {
    public static final String REGISTRY_IS_MISSING_ERROR = "Snapshot digest registry is missing.";
    public static final String INVALID_SNAPSHOT_ID_ERROR = "Unexpected snapshot id found in digest registry.";
    public static final String INVALID_ALGO_ERROR = "Incompatible digest algorithm found in digest registry.";
    public static final String INVALID_CONSISTENT_ID_ERROR = "Unexpected consistent node id found in digest registry.";
    public static final String CORRUPTED_META_HASH_ERROR = "Metadata partial hash verification failure.";
    private final IgniteLogger log;
    private final IgniteConfiguration igCfg;
    private final long snapshotId;
    private final SnapshotPath snapshotDir;
    private final MessageDigestFactory msgDigestFactory;
    private final SnapshotRegistryTransformer transformer;
    private final SnapshotSecurityLevel securityLevel;
    private final Map<String, SnapshotDigestRegistry> registryMap = new ConcurrentHashMap<String, SnapshotDigestRegistry>();

    public SnapshotDigestRegistryCache(IgniteConfiguration igCfg, long snapshotId, SnapshotPath snapshotDir, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer transformer, SnapshotSecurityLevel securityLevel) {
        this.log = igCfg.getGridLogger().getLogger(this.getClass());
        this.igCfg = igCfg;
        this.snapshotDir = snapshotDir;
        this.snapshotId = snapshotId;
        this.msgDigestFactory = msgDigestFactory;
        this.transformer = transformer;
        this.securityLevel = securityLevel;
    }

    public SnapshotDigestRegistry cachedRegistry(String consistentId) {
        return this.registryMap.computeIfAbsent(consistentId, id -> {
            SnapshotDigestRegistry registry = this.readRegistry((String)id);
            this.validateRegistry((String)id, registry);
            return registry;
        });
    }

    public SnapshotDigestRegistry readRegistry(String consistentId) {
        SnapshotPath resolvedFile = this.snapshotDir.resolve(consistentId);
        return SnapshotUtils.readSnapshotDigestRegistry(resolvedFile, this.transformer, this.igCfg, this.log);
    }

    public void verifyMetadata(SnapshotMetadataV2 meta) {
        byte[] actual;
        if (meta == null || this.securityLevel == SnapshotSecurityLevel.DISABLED || this.securityLevel == SnapshotSecurityLevel.IGNORE_EXISTING) {
            return;
        }
        SnapshotDigestRegistry registry = null;
        if (!this.registryMap.isEmpty()) {
            registry = this.registryMap.values().iterator().next();
        } else {
            Object cid;
            String constId;
            Set cids = meta.baselineTopology().consistentIds();
            Iterator iterator = cids.iterator();
            while (iterator.hasNext() && (registry = this.cachedRegistry(constId = U.maskForFileName((CharSequence)(cid = iterator.next()).toString()))) == null) {
            }
        }
        if (registry == null) {
            if (this.securityLevel == SnapshotSecurityLevel.REQUIRE) {
                throw new SnapshotDigestException("Snapshot digest registry is missing.[securityLevel=" + this.securityLevel.name() + "]");
            }
            return;
        }
        byte[] exp = registry.metadataDigest();
        try {
            actual = SnapshotUtils.computeMetadataDigest(SnapshotMetadataV2DigestWriter.INSTANCE, this.msgDigestFactory, meta);
        }
        catch (IOException e) {
            throw new SnapshotDigestException("Failed to compute partial metadata hash.", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Metadata partial hash verification. [consistentId='" + registry.consistentId() + "', expected='" + (exp == null ? "null" : U.byteArray2HexString((byte[])exp)) + "', actual='" + U.byteArray2HexString((byte[])actual) + "']");
        }
        if (!Arrays.equals(exp, actual)) {
            throw new SnapshotDigestException("Metadata partial hash verification failure. [consistentId='" + registry.consistentId() + "', expected='" + (exp == null ? "null" : U.byteArray2HexString((byte[])exp)) + "', actual invalid='" + U.byteArray2HexString((byte[])actual) + "']");
        }
    }

    private void validateRegistry(String consistentId, SnapshotDigestRegistry registry) {
        if (registry == null) {
            return;
        }
        if (!F.eq((Object)registry.consistentId(), (Object)consistentId)) {
            throw new SnapshotDigestException("Unexpected consistent node id found in digest registry.[consistentId='" + consistentId + "', registryConsistentId='" + registry.consistentId() + "']");
        }
        if (registry.snapshotId() != this.snapshotId) {
            throw new SnapshotDigestException("Unexpected snapshot id found in digest registry.[consistentId='" + registry.consistentId() + "', snapshotId=" + this.snapshotId + ", registrySnapshotId=" + registry.snapshotId() + "]");
        }
        if (!F.eq((Object)registry.digestAlgo(), (Object)this.msgDigestFactory.getAlgorithmCode())) {
            throw new SnapshotDigestException("Incompatible digest algorithm found in digest registry.[consistentId='" + registry.consistentId() + "', configuredDigestAlgo='" + this.msgDigestFactory.getAlgorithmCode() + "', registryDigestAlgo='" + registry.digestAlgo() + "']");
        }
    }
}

