/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;

public class DeleteFileVisitor
extends SimpleFileVisitor<Path> {
    private final SnapshotOperationContext ctx;

    public DeleteFileVisitor(SnapshotOperationContext ctx, IgniteLogger log) {
        this.ctx = ctx;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.delete(file);
        this.ctx.reportWork(1L);
        if (this.ctx.isCancelled()) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        Files.delete(dir);
        if (this.ctx.isCancelled()) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }
}

