/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;

@GridInternal
public class VisorReplicationStopTask
extends VisorOneNodeTask<VisorReplicationInfo, VisorReplicationInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorReplicationInfo, VisorReplicationInfo> job(VisorReplicationInfo arg) {
        return new VisorReplicationStopJob(arg, this.debug);
    }

    private static class VisorReplicationStopJob
    extends VisorJob<VisorReplicationInfo, VisorReplicationInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture opFut;
        private long sesId;

        VisorReplicationStopJob(VisorReplicationInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected VisorReplicationInfo run(VisorReplicationInfo arg) throws IgniteException {
            if (this.opFut == null) {
                ReplicationSessionDescriptor state;
                if (!(this.ignite.context().txDr() instanceof TransactionalDr)) {
                    throw new IgniteException("Transactional data center replication is not configured.");
                }
                TransactionalDr txDr = (TransactionalDr)this.ignite.context().txDr();
                if (txDr instanceof TransactionalDrProcessorImpl && (state = ((TransactionalDrProcessorImpl)txDr).localState()) != null) {
                    this.sesId = state.sessionId();
                }
                try {
                    IgniteFuture igniteFuture = arg.forcibleStop() ? txDr.stopNow() : (this.opFut = arg.recovery() ? txDr.stopAndRecover() : txDr.stop());
                    if (!this.opFut.isDone()) {
                        this.jobCtx.holdcc();
                        this.opFut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                            public void apply(IgniteFuture f) {
                                jobCtx.callcc();
                            }
                        });
                        return null;
                    }
                    this.opFut.get();
                }
                catch (Exception cause) {
                    throw new IgniteException("Failed to stop the replication session.", (Throwable)cause);
                }
            }
            Object res = this.opFut.get();
            VisorReplicationInfo.Builder builder = new VisorReplicationInfo.Builder().withSessionId(this.sesId).withForcibleStop(arg.forcibleStop()).withRecovery(arg.recovery());
            if (arg.recovery()) {
                builder.withResultRecoveryTime((Long)res);
            }
            return builder.build();
        }

        public String toString() {
            return S.toString(VisorReplicationStopJob.class, (Object)((Object)this));
        }
    }
}

