/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCutTestingSnapshotCreateTask
extends VisorOneNodeTask<Void, VisorSnapshotInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorCutTestingSnapshotCreateJob job(Void arg) {
        return new VisorCutTestingSnapshotCreateJob(arg, this.debug);
    }

    private static class VisorCutTestingSnapshotCreateJob
    extends VisorJob<Void, VisorSnapshotInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private SnapshotFuture fut;

        VisorCutTestingSnapshotCreateJob(Void arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorSnapshotInfo run(@Nullable Void arg) throws IgniteException {
            if (this.fut == null) {
                IgniteCacheSnapshotManager snapMgr = this.ignite.context().cache().context().snapshot();
                if (!(snapMgr instanceof GridCacheSnapshotManager)) {
                    throw new IgniteException("Error: snapshots are not configured.");
                }
                GridCacheSnapshotManager gridSnapMgr = (GridCacheSnapshotManager)snapMgr;
                Collection descs = this.ignite.context().cache().cacheDescriptors().values();
                Collection publicPersistentCaches = F.viewReadOnly(descs, (IgniteClosure)new IgniteClosure<DynamicCacheDescriptor, String>(){

                    public String apply(DynamicCacheDescriptor desc) {
                        return desc.cacheConfiguration().getName();
                    }
                }, (IgnitePredicate[])new IgnitePredicate[]{new IgnitePredicate<DynamicCacheDescriptor>(){

                    public boolean apply(DynamicCacheDescriptor desc) {
                        return (desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES && CU.cacheId((String)"default-volatile-ds-group") != desc.groupId()) && desc.groupDescriptor().persistenceEnabled() && desc.cacheConfiguration().getCacheMode() != CacheMode.LOCAL;
                    }
                }});
                this.fut = gridSnapMgr.startGlobalSnapshotCreation(new HashSet<String>(publicPersistentCaches), null, true, Collections.singletonMap("CONISTENT_CUT_TESTING_SNAPSHOT_CREATE", true), null, null, new SnapshotCreateParameters(CompressionOption.ZIP, 1, 0));
                if (this.fut.isDone()) {
                    this.fut.get();
                } else {
                    this.jobCtx.holdcc();
                    this.fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                        public void apply(IgniteFuture f) {
                            jobCtx.callcc();
                        }
                    });
                    return null;
                }
            }
            this.fut.get();
            return VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)this.fut.snapshotOperation()).withClusterName(this.ignite.cluster().tag()).build();
        }

        public String toString() {
            return S.toString(VisorCutTestingSnapshotCreateJob.class, (Object)((Object)this));
        }
    }
}

