/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class VisorSnapshotNode
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID id;
    private Object consistentId;
    private boolean client;
    private Collection<String> addrs;
    private Collection<String> hostNames;
    @Nullable
    private IgniteProductVersion ver;

    public VisorSnapshotNode() {
    }

    public VisorSnapshotNode(UUID id, Object consistentId, boolean client, Collection<String> addrs, Collection<String> hostNames, @Nullable IgniteProductVersion ver) {
        this.id = id;
        this.consistentId = consistentId;
        this.client = client;
        this.addrs = addrs;
        this.hostNames = hostNames;
        this.ver = ver;
    }

    public VisorSnapshotNode(ClusterNode node) {
        this(node.id(), node.consistentId(), node.isClient(), node.addresses(), node.hostNames(), node.version());
    }

    public UUID getId() {
        return this.id;
    }

    public Object getConsistentId() {
        return this.consistentId;
    }

    public boolean isClient() {
        return this.client;
    }

    public Collection<String> getAddresses() {
        return this.addrs;
    }

    public Collection<String> getHostNames() {
        return this.hostNames;
    }

    @Nullable
    public IgniteProductVersion getVersion() {
        return this.ver;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid((DataOutput)out, (UUID)this.id);
        out.writeObject(this.consistentId);
        out.writeBoolean(this.client);
        U.writeCollection((ObjectOutput)out, this.addrs);
        U.writeCollection((ObjectOutput)out, this.hostNames);
        out.writeObject(this.ver);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readUuid((DataInput)in);
        this.consistentId = in.readObject();
        this.client = in.readBoolean();
        this.addrs = U.readList((ObjectInput)in);
        this.hostNames = U.readList((ObjectInput)in);
        this.ver = protoVer > 1 ? (IgniteProductVersion)in.readObject() : null;
    }

    public String toString() {
        return S.toString(VisorSnapshotNode.class, (Object)((Object)this));
    }
}

