/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.InvalidUserCommandException;
import org.apache.ignite.internal.UserCommandExceptions;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridPluginProcessorAdapter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.DeduplicatingSingleThreadExecutor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotConfigurationCorrectnessChecker;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleKey;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;

public class SnapshotScheduleProcessor
extends GridPluginProcessorAdapter {
    private static final String CLUSTER_NOT_ACTIVE = "Can not perform the operation because the cluster is inactive.";
    private static final String SCHEDULE_NOT_FOUND = "Snapshot schedule not found: ";
    private static final String LOCAL_SCHEDULE_NOT_FOUND = "Local snapshot schedule not found: ";
    public static final String CLUSTER_DOESNT_SUPPORT_TASK_CHAINING = "Failed to add chained schedule task: there are nodes in cluster that don't support scheduled task chaining";
    private static final String FAILED_TO_START_SCHEDULE_TEMPLATE = "Failed to start schedule. %s [schedule=%s]";
    public static final String CANT_ADD_TASK_IN_THE_MIDDLE_OF_THE_CHAIN_ERROR_MSG = "Failed to add schedule task: it's possible to add one only to the end of the task chain";
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 10;
    private GridLocalEventListener topLsnr;
    private GridLocalEventListener clusterStateLsnr;
    private volatile GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ExecutorService restartsExec;
    private final ExecutorService workerExec;

    public SnapshotScheduleProcessor(PluginContext ctx, GridGainConfiguration cfg) {
        super(ctx, cfg);
        String instanceName = this.igniteCtx.igniteInstanceName();
        this.restartsExec = Executors.newSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory(instanceName, "snapshot-scheduler-restart"));
        this.workerExec = Executors.unconfigurableExecutorService(new DeduplicatingSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory(instanceName, "snapshot-scheduler-worker"), this.log));
    }

    public void onIgniteStart() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Snapshot scheduler processor started.");
        }
        if (!this.igniteCtx.clientNode()) {
            this.topLsnr = new GridLocalEventListener(){

                public void onEvent(Event evt) {
                    assert (evt.type() == 12 || evt.type() == 11) : "Unexpected event: " + evt;
                    SnapshotScheduleProcessor.this.restart();
                }
            };
            this.igniteCtx.event().addLocalEventListener(this.topLsnr, 11, new int[]{12});
            this.clusterStateLsnr = new SnapshotConfigurationCorrectnessChecker(this.igniteCtx, this.log);
            this.igniteCtx.event().addLocalEventListener(this.clusterStateLsnr, 144, new int[0]);
            ClusterNode crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, this.igniteCtx.cache().context());
            if (crd != null && crd.isLocal()) {
                this.restart();
            }
        }
    }

    public void onIgniteStop(boolean cancel) {
        GridSpinBusyLock busyLock = this.busyLock;
        if (busyLock != null) {
            busyLock.block();
            this.busyLock = null;
        }
        this.tryShutdownExecutorsGracefully();
        if (this.topLsnr != null) {
            this.igniteCtx.event().removeLocalEventListener(this.topLsnr, new int[]{11, 12});
        }
        if (this.clusterStateLsnr != null) {
            this.igniteCtx.event().removeLocalEventListener(this.clusterStateLsnr, new int[]{144});
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Snapshots catalog processor stopped.");
        }
    }

    private void restart() {
        if (this.busyLock == null || !this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.restartsExec.execute(new Runnable(){

                @Override
                public void run() {
                    block29: {
                        IgniteEx ignite = SnapshotScheduleProcessor.this.igniteCtx.grid();
                        boolean active = ignite.context().state().publicApiActiveState(false);
                        IgniteInternalCache utilityCache = null;
                        if (active) {
                            try {
                                utilityCache = ignite.utilityCache();
                            }
                            catch (IgniteException e) {
                                U.error((IgniteLogger)SnapshotScheduleProcessor.this.log, (Object)"Failed to get utility cache on active cluster", (Throwable)e);
                            }
                        }
                        if (!active || utilityCache == null) {
                            LT.warn((IgniteLogger)SnapshotScheduleProcessor.this.log, (String)"Snapshot schedule processor awaits for cluster activation.");
                            SnapshotScheduleProcessor.this.scheduleRestartAfterDelay();
                            return;
                        }
                        ClusterNode crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, ignite.context().cache().context());
                        if (crd != null && crd.isLocal()) {
                            ArrayList<Object> newlyStarted = new ArrayList<Object>();
                            try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                                Map map = (Map)utilityCache.get((Object)SnapshotScheduleKey.SCHEDULES);
                                if (!GridFunc.isEmpty((Map)map)) {
                                    U.warn((IgniteLogger)SnapshotScheduleProcessor.this.log, (Object)("Restart snapshot schedules: " + map.size()));
                                    Iterator it = map.entrySet().iterator();
                                    while (it.hasNext()) {
                                        Map.Entry entry = it.next();
                                        String name = (String)entry.getKey();
                                        SnapshotScheduleKey key = new SnapshotScheduleKey(name);
                                        Object schedule = utilityCache.get((Object)key);
                                        if (schedule != null) {
                                            SnapshotScheduleV2 scheduleV2;
                                            boolean started;
                                            if (schedule instanceof SnapshotSchedule) {
                                                SnapshotSchedule scheduleV1 = ((SnapshotSchedule)schedule).copy();
                                                schedule = scheduleV1;
                                                started = scheduleV1.startLocal((Ignite)ignite);
                                                if (started) {
                                                    newlyStarted.add(scheduleV1);
                                                }
                                            } else if (schedule instanceof SnapshotScheduleV2 && ((scheduleV2 = ((SnapshotScheduleV2)((Object)schedule)).copy()).getFullSnapshotFrequency() != null || scheduleV2.getIncrementalSnapshotFrequency() != null)) {
                                                schedule = scheduleV2;
                                                started = scheduleV2.startLocal((Ignite)ignite);
                                                if (started) {
                                                    newlyStarted.add((Object)scheduleV2);
                                                }
                                            }
                                            utilityCache.put((Object)key, schedule);
                                            continue;
                                        }
                                        U.error((IgniteLogger)SnapshotScheduleProcessor.this.log, (Object)(SnapshotScheduleProcessor.SCHEDULE_NOT_FOUND + name));
                                        it.remove();
                                    }
                                    utilityCache.put((Object)SnapshotScheduleKey.SCHEDULES, (Object)map);
                                    tx.commit();
                                }
                            }
                            catch (Throwable e) {
                                U.error((IgniteLogger)SnapshotScheduleProcessor.this.log, (Object)"Failed to restart schedules", (Throwable)e);
                                for (Serializable serializable : newlyStarted) {
                                    if (serializable instanceof SnapshotSchedule) {
                                        ((SnapshotSchedule)serializable).cancel((Ignite)ignite);
                                        continue;
                                    }
                                    ((SnapshotScheduleV2)((Object)serializable)).cancel((Ignite)ignite);
                                }
                                if (e.getMessage() == null || !e.getMessage().contains("retry transaction if possible")) break block29;
                                SnapshotScheduleProcessor.this.scheduleRestartAfterDelay();
                            }
                        }
                    }
                }
            });
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void scheduleRestartAfterDelay() {
        this.igniteCtx.timeout().addTimeoutObject((GridTimeoutObject)new GridTimeoutObjectAdapter(5000L){

            public void onTimeout() {
                SnapshotScheduleProcessor.this.restart();
            }
        });
    }

    private String getNameById(Map<String, String> map, String id) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void cancelPrevSchedule(Object prevSchedule) {
        if (prevSchedule != null) {
            U.warn((IgniteLogger)this.log, (Object)("Cancel previous snapshot schedule: " + prevSchedule));
            if (prevSchedule instanceof SnapshotSchedule) {
                ((SnapshotSchedule)prevSchedule).cancel((Ignite)this.igniteCtx.grid());
            }
            if (prevSchedule instanceof SnapshotScheduleV2) {
                ((SnapshotScheduleV2)((Object)prevSchedule)).cancel((Ignite)this.igniteCtx.grid());
            }
        }
    }

    private void completeScheduleParameters(SnapshotScheduleV2 sched) {
        if (sched.getSnapshotCommonParameters() == null) {
            sched.setSnapshotCommonParameters(new SnapshotCommonParameters(2));
        }
        if (sched.getSnapshotCreateParameters() == null) {
            sched.setSnapshotCreateParameters(new SnapshotCreateParameters(SnapshotConfiguration.DEFAULT_COMPRESSION, -1, 0));
        }
    }

    private boolean v2FormatSupport() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.igniteCtx.grid().context(), (Iterable)this.igniteCtx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_SFTP_UPLOAD_V2);
    }

    private void checkWriteThrottlingThreshold(SnapshotScheduleV2 schedule) {
        int writeThrottlingThreshold = schedule.getSnapshotCreateParameters().getWriteThrottlingThreshold();
        if (writeThrottlingThreshold < 0) {
            throw this.invalidUserCommandException("Write throttling threshold should be non-negative number: " + writeThrottlingThreshold);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findAndCancelPreviousSchedules(IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 schedule, Map<String, String> schedules, SnapshotScheduleKey key) throws IgniteCheckedException {
        String name = schedule.getName();
        String id = schedule.getId();
        String prevId = schedules.get(name);
        if (prevId != null) {
            if (!schedule.getId().equals(prevId)) throw this.invalidUserCommandException("Schedule with such name already exists [name=" + name + ", prevId=" + prevId + ", actualId=" + schedule.getId() + "]");
            this.cancelPrevSchedule((Object)schedule);
            return;
        } else {
            String prevName = this.getNameById(schedules, id);
            if (prevName == null) return;
            SnapshotScheduleKey prevKey = new SnapshotScheduleKey(prevName);
            this.cancelPrevSchedule(utilityCache.get((Object)prevKey));
            schedules.remove(prevName);
            utilityCache.remove((Object)prevKey);
        }
    }

    @Deprecated
    public void start(SnapshotSchedule schedule) {
        this.start(new SnapshotScheduleV2(schedule));
    }

    public void start(SnapshotScheduleV2 schedule) {
        IgniteEx ignite = this.igniteCtx.grid();
        if (ignite.cluster().state() == ClusterState.ACTIVE) {
            this.completeScheduleParameters(schedule);
            U.warn((IgniteLogger)this.log, (Object)("Start snapshot schedule: " + (Object)((Object)schedule)));
            IgniteInternalCache utilityCache = ignite.utilityCache();
            boolean v2FormatSupport = this.v2FormatSupport();
            this.checkWriteThrottlingThreshold(schedule);
            if (schedule.execAfter() == null) {
                this.addOrUpdateSchedule(ignite, (IgniteInternalCache<SnapshotScheduleKey, Object>)utilityCache, schedule, v2FormatSupport);
            } else {
                this.addScheduleToChain(ignite, (IgniteInternalCache<SnapshotScheduleKey, Object>)utilityCache, schedule, v2FormatSupport);
            }
        } else {
            throw this.invalidUserCommandException(CLUSTER_NOT_ACTIVE);
        }
    }

    private void addOrUpdateSchedule(IgniteEx ignite, IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 schedule, boolean v2FormatSupport) {
        boolean started = false;
        try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            HashMap<String, String> schedules = (HashMap<String, String>)utilityCache.get((Object)SnapshotScheduleKey.SCHEDULES);
            if (schedules == null) {
                schedules = new HashMap<String, String>();
            }
            SnapshotScheduleKey key = new SnapshotScheduleKey(schedule.getName());
            this.findAndCancelPreviousSchedules(utilityCache, schedule, schedules, key);
            started = schedule.startLocal((Ignite)ignite);
            schedules.put(schedule.getName(), schedule.getId());
            utilityCache.put((Object)key, v2FormatSupport ? schedule : schedule.toV1Format());
            utilityCache.put((Object)SnapshotScheduleKey.SCHEDULES, schedules);
            tx.commit();
        }
        catch (Throwable e) {
            if (started) {
                schedule.cancel((Ignite)ignite);
            }
            throw this.wrapFailedToStartScheduleErr(e, schedule);
        }
    }

    private IgniteException wrapFailedToStartScheduleErr(Throwable e, SnapshotScheduleV2 schedule) {
        String msg = this.failedToStartScheduleErr(e, schedule);
        if (UserCommandExceptions.causedByUserCommandException((Throwable)e)) {
            return new InvalidUserCommandException(msg);
        }
        return new IgniteException(msg);
    }

    private void addScheduleToChain(IgniteEx ignite, IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 schedule, boolean v2FormatSupport) {
        SnapshotScheduleKey taskChainKey;
        boolean chainingSupport = IgniteFeatures.allNodesSupports((GridKernalContext)this.igniteCtx.grid().context(), (Iterable)this.igniteCtx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_OPERATIONS_CHAINING);
        if (!v2FormatSupport || !chainingSupport) {
            throw this.invalidUserCommandException("Failed to add chained schedule task: there are nodes in cluster that don't support scheduled task chaining [v2FormatSupport=" + v2FormatSupport + ", chainingSupport=" + chainingSupport + "]");
        }
        if (schedule.getFullSnapshotFrequency() != null || schedule.getIncrementalSnapshotFrequency() != null) {
            throw this.invalidUserCommandException("Failed to add snapshot schedule : 'frequency' parameter clashes with 'execAfter' parameter [schedule=" + (Object)((Object)schedule) + "]");
        }
        try {
            taskChainKey = this.getKeyOfTaskChain(utilityCache, schedule);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to start schedule: " + (Object)((Object)schedule), (Throwable)e);
        }
        SnapshotScheduleV2 taskChainSchedule = null;
        boolean started = false;
        try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            Map schedules = (Map)utilityCache.get((Object)SnapshotScheduleKey.SCHEDULES);
            if (schedules == null) {
                throw new IgniteException("Failed to add scheduled task, '" + SnapshotScheduleKey.SCHEDULES + "' key is missing in utility cache.");
            }
            Object taskChainObject = utilityCache.get((Object)taskChainKey);
            if (taskChainObject == null) {
                throw this.invalidUserCommandException("Schedule not found: " + schedule.execAfter());
            }
            SnapshotScheduleV2 snapshotScheduleV2 = taskChainSchedule = taskChainObject instanceof SnapshotSchedule ? new SnapshotScheduleV2((SnapshotSchedule)taskChainObject) : ((SnapshotScheduleV2)((Object)taskChainObject)).copy();
            if (GridFunc.isEmpty(taskChainSchedule.followingSchedules())) {
                if (!schedule.execAfter().equals(taskChainSchedule.getName())) {
                    throw new IgniteException("Broken task chain, list of following tasks is empty in " + taskChainKey + " and new schedule 'execAfter' parameter points to " + schedule.execAfter());
                }
                ArrayList<SnapshotScheduleV2> followingSchedules = new ArrayList<SnapshotScheduleV2>();
                followingSchedules.add(schedule);
                taskChainSchedule.followingSchedules(followingSchedules);
            } else {
                String lastTaskInChainName = taskChainSchedule.followingSchedules().get(taskChainSchedule.followingSchedules().size() - 1).getName();
                if (!schedule.execAfter().equals(lastTaskInChainName)) {
                    throw this.invalidUserCommandException("Failed to add schedule task: it's possible to add one only to the end of the task chain (last task in chain: " + lastTaskInChainName + ")");
                }
                taskChainSchedule.followingSchedules().add(schedule);
            }
            schedule.taskChain(taskChainKey);
            this.findAndCancelPreviousSchedules(utilityCache, taskChainSchedule, schedules, taskChainKey);
            started = taskChainSchedule.startLocal((Ignite)ignite);
            schedules.put(schedule.getName(), schedule.getId());
            utilityCache.put((Object)taskChainKey, (Object)taskChainSchedule);
            utilityCache.put((Object)new SnapshotScheduleKey(schedule.getName()), (Object)schedule);
            utilityCache.put((Object)SnapshotScheduleKey.SCHEDULES, (Object)schedules);
            tx.commit();
        }
        catch (Throwable e) {
            if (started) {
                taskChainSchedule.cancel((Ignite)ignite);
            }
            throw this.wrapFailedToStartScheduleErr(e, schedule);
        }
    }

    private SnapshotScheduleKey getKeyOfTaskChain(IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 schedule) throws IgniteCheckedException {
        SnapshotScheduleKey prevScheduleKey = new SnapshotScheduleKey(schedule.execAfter());
        Object prev = utilityCache.get((Object)prevScheduleKey);
        if (prev == null) {
            throw this.invalidUserCommandException("Schedule not found: " + schedule.execAfter());
        }
        if (prev instanceof SnapshotScheduleV2) {
            SnapshotScheduleV2 prevSchedule = (SnapshotScheduleV2)((Object)prev);
            if (prevSchedule.taskChain() != null) {
                SnapshotScheduleV2 taskChainSchedule = (SnapshotScheduleV2)((Object)utilityCache.get((Object)prevSchedule.taskChain()));
                if (taskChainSchedule == null) {
                    throw new IgniteException("Broken chain of scheduled tasks, can't find task: " + prevSchedule.taskChain());
                }
                return prevSchedule.taskChain();
            }
            return prevScheduleKey;
        }
        return prevScheduleKey;
    }

    public void disable(String name) {
        block19: {
            IgniteEx ignite = this.igniteCtx.grid();
            if (ignite.cluster().active()) {
                U.warn((IgniteLogger)this.log, (Object)("Disable snapshot schedule: " + name));
                IgniteInternalCache utilityCache = ignite.utilityCache();
                try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    SnapshotScheduleKey key = new SnapshotScheduleKey(name);
                    Object schedule = utilityCache.get((Object)key);
                    if (schedule != null) {
                        if (schedule instanceof SnapshotSchedule) {
                            ((SnapshotSchedule)schedule).disable((Ignite)ignite);
                        }
                        if (schedule instanceof SnapshotScheduleV2) {
                            ((SnapshotScheduleV2)((Object)schedule)).disable((Ignite)ignite);
                        }
                    } else {
                        throw this.invalidUserCommandException(SCHEDULE_NOT_FOUND + name);
                    }
                    utilityCache.put((Object)key, schedule);
                    tx.commit();
                    break block19;
                }
                catch (Throwable e) {
                    throw new IgniteException("Failed to disable snapshot schedule: " + name, e);
                }
            }
            throw this.invalidUserCommandException(CLUSTER_NOT_ACTIVE);
        }
    }

    public void enable(String name) {
        block27: {
            IgniteEx ignite = this.igniteCtx.grid();
            if (ignite.cluster().active()) {
                U.warn((IgniteLogger)this.log, (Object)("Enable snapshot schedule: " + name));
                IgniteInternalCache utilityCache = ignite.utilityCache();
                boolean enabled = false;
                Object schedule = null;
                try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    SnapshotScheduleKey key = new SnapshotScheduleKey(name);
                    schedule = utilityCache.get((Object)key);
                    if (schedule != null) {
                        if (schedule instanceof SnapshotSchedule) {
                            SnapshotSchedule scheduleV1 = ((SnapshotSchedule)schedule).copy();
                            if (!scheduleV1.isEnabled()) {
                                schedule = scheduleV1;
                                enabled = scheduleV1.enable((Ignite)ignite);
                            } else {
                                U.warn((IgniteLogger)this.log, (Object)("Snapshot schedule already enabled: " + name));
                            }
                        }
                        if (schedule instanceof SnapshotScheduleV2) {
                            SnapshotScheduleV2 scheduleV2 = (SnapshotScheduleV2)((Object)schedule);
                            if (scheduleV2.execAfter() != null) {
                                throw this.invalidUserCommandException("Can't enable single task in scheduled task chain [task=" + (Object)((Object)scheduleV2) + "]");
                            }
                            if (!scheduleV2.isEnabled()) {
                                schedule = scheduleV2;
                                enabled = scheduleV2.enable((Ignite)ignite);
                            } else {
                                U.warn((IgniteLogger)this.log, (Object)("Snapshot schedule already enabled: " + name));
                            }
                        }
                    } else {
                        throw this.invalidUserCommandException(SCHEDULE_NOT_FOUND + name);
                    }
                    utilityCache.put((Object)key, schedule);
                    tx.commit();
                    break block27;
                }
                catch (Throwable e) {
                    if (enabled) {
                        if (schedule instanceof SnapshotSchedule) {
                            ((SnapshotSchedule)schedule).disable((Ignite)ignite);
                        } else {
                            ((SnapshotScheduleV2)((Object)schedule)).disable((Ignite)ignite);
                        }
                    }
                    throw new IgniteException("Failed to enable snapshot schedule: " + name, e);
                }
            }
            throw this.invalidUserCommandException(CLUSTER_NOT_ACTIVE);
        }
    }

    public void delete(String name) {
        block27: {
            IgniteEx ignite = this.igniteCtx.grid();
            if (ignite.cluster().active()) {
                U.warn((IgniteLogger)this.log, (Object)("Delete snapshot schedule: " + name));
                IgniteInternalCache utilityCache = ignite.utilityCache();
                try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    SnapshotScheduleKey key;
                    HashMap<String, String> schedules = (HashMap<String, String>)utilityCache.get((Object)SnapshotScheduleKey.SCHEDULES);
                    if (schedules == null) {
                        schedules = new HashMap<String, String>();
                    }
                    if (schedules.containsKey(name)) {
                        key = new SnapshotScheduleKey(name);
                        Object schedule = utilityCache.get((Object)key);
                        if (schedule != null) {
                            if (schedule instanceof SnapshotSchedule) {
                                ((SnapshotSchedule)schedule).disable((Ignite)ignite);
                            } else if (schedule instanceof SnapshotScheduleV2) {
                                SnapshotScheduleV2 scheduleV2 = (SnapshotScheduleV2)((Object)schedule);
                                if (!GridFunc.isEmpty(scheduleV2.followingSchedules())) {
                                    this.deleteScheduledTaskChain(ignite, (IgniteInternalCache<SnapshotScheduleKey, Object>)utilityCache, scheduleV2, schedules);
                                } else if (scheduleV2.execAfter() != null) {
                                    this.deleteSingleScheduledTaskFromChain(ignite, (IgniteInternalCache<SnapshotScheduleKey, Object>)utilityCache, scheduleV2, schedules);
                                }
                                scheduleV2.disable((Ignite)ignite);
                            } else {
                                U.warn((IgniteLogger)this.log, (Object)("Unknown type of schedule: " + schedule));
                            }
                        } else {
                            U.warn((IgniteLogger)this.log, (Object)(LOCAL_SCHEDULE_NOT_FOUND + name));
                        }
                    } else {
                        throw this.invalidUserCommandException(SCHEDULE_NOT_FOUND + name);
                    }
                    utilityCache.remove((Object)key);
                    schedules.remove(name);
                    utilityCache.put((Object)SnapshotScheduleKey.SCHEDULES, schedules);
                    tx.commit();
                    break block27;
                }
                catch (Throwable e) {
                    throw new IgniteException("Failed to delete snapshot schedule: " + name, e);
                }
            }
            throw this.invalidUserCommandException(CLUSTER_NOT_ACTIVE);
        }
    }

    private void deleteSingleScheduledTaskFromChain(IgniteEx ignite, IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 scheduleV2, Map<String, String> schedules) throws IgniteCheckedException {
        SnapshotScheduleV2 taskChain = (SnapshotScheduleV2)((Object)utilityCache.get((Object)scheduleV2.taskChain()));
        int idxInChain = -1;
        for (int i = 0; i < taskChain.followingSchedules().size(); ++i) {
            if (!taskChain.followingSchedules().get(i).getId().equals(scheduleV2.getId())) continue;
            idxInChain = i;
            break;
        }
        if (idxInChain == -1) {
            throw new IgniteException("Broken chain of snapshot scheduled tasks, task chain doesn't have link to task [taskChain=" + (Object)((Object)taskChain) + ", task=" + (Object)((Object)scheduleV2) + "]");
        }
        taskChain.followingSchedules().remove(idxInChain);
        this.findAndCancelPreviousSchedules(utilityCache, taskChain, schedules, scheduleV2.taskChain());
        taskChain.startLocal((Ignite)ignite);
        utilityCache.put((Object)scheduleV2.taskChain(), (Object)taskChain);
        this.log.warning("Scheduled task chain is modified [chain=" + (Object)((Object)taskChain) + "]");
    }

    private void deleteScheduledTaskChain(IgniteEx ignite, IgniteInternalCache<SnapshotScheduleKey, Object> utilityCache, SnapshotScheduleV2 scheduleV2, Map<String, String> schedules) throws IgniteCheckedException {
        this.log.warning("Deleting scheduled task chain, cascade deletion of all dependant tasks [chain=" + (Object)((Object)scheduleV2) + "]");
        for (SnapshotScheduleV2 s : scheduleV2.followingSchedules()) {
            SnapshotScheduleKey k = new SnapshotScheduleKey(s.getName());
            utilityCache.remove((Object)k);
            schedules.remove(s.getName());
            scheduleV2.disable((Ignite)ignite);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SnapshotScheduleV2> list() {
        IgniteEx ignite = this.igniteCtx.grid();
        if (!ignite.cluster().active()) throw this.invalidUserCommandException(CLUSTER_NOT_ACTIVE);
        U.warn((IgniteLogger)this.log, (Object)"Collect list of snapshot schedules");
        IgniteInternalCache utilityCache = ignite.utilityCache();
        try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            ArrayList<SnapshotScheduleV2> res = new ArrayList<SnapshotScheduleV2>();
            Map schedules = (Map)utilityCache.get((Object)SnapshotScheduleKey.SCHEDULES);
            if (!GridFunc.isEmpty((Map)schedules)) {
                for (String name : schedules.keySet()) {
                    SnapshotScheduleKey key = new SnapshotScheduleKey(name);
                    Object schedule = utilityCache.get((Object)key);
                    if (schedule != null) {
                        if (schedule instanceof SnapshotSchedule) {
                            res.add(new SnapshotScheduleV2((SnapshotSchedule)schedule));
                            continue;
                        }
                        if (schedule instanceof SnapshotScheduleV2) {
                            res.add((SnapshotScheduleV2)((Object)schedule));
                            continue;
                        }
                        U.warn((IgniteLogger)this.log, (Object)("Unknown type of schedule: " + schedule));
                        continue;
                    }
                    U.warn((IgniteLogger)this.log, (Object)(LOCAL_SCHEDULE_NOT_FOUND + name));
                }
            }
            tx.commit();
            ArrayList<SnapshotScheduleV2> arrayList = res;
            return arrayList;
        }
        catch (Throwable e) {
            throw new IgniteException("Failed to collect list of snapshot schedules", e);
        }
    }

    private IgniteException invalidUserCommandException(String errorMessage) {
        return UserCommandExceptions.invalidUserCommandException((String)errorMessage, (DiscoverySpi)this.ctx.igniteConfiguration().getDiscoverySpi());
    }

    public Future<?> execute(ScheduledSnapshotOperation job) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Submitting a scheduled snapshot operation " + job + " from schedule " + (Object)((Object)job.schedule));
        }
        return this.workerExec.submit(job);
    }

    private void tryShutdownExecutorsGracefully() {
        this.restartsExec.shutdown();
        this.workerExec.shutdown();
        try {
            this.restartsExec.awaitTermination(10L, TimeUnit.SECONDS);
            this.workerExec.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            U.warn((IgniteLogger)this.log, (Object)"Got interrupted while waiting for executor service to stop.");
            this.restartsExec.shutdownNow();
            this.workerExec.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String failedToStartScheduleErr(Throwable e, SnapshotScheduleV2 schedule) {
        return String.format(FAILED_TO_START_SCHEDULE_TEMPLATE, e.getMessage(), schedule.toString());
    }

    public void lastFullSnapshotId(String scheduleName, long snapshotId) {
        IgniteEx igniteEx = this.igniteCtx.grid();
        if (igniteEx.cluster().state() != ClusterState.ACTIVE) {
            throw new IgniteException(CLUSTER_NOT_ACTIVE);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Update the full snapshot ID for the schedule [name=" + scheduleName + ", snapshotId=" + snapshotId + ']');
        }
        IgniteInternalCache utilityCache = igniteEx.utilityCache();
        try (GridNearTxLocal tx = utilityCache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            SnapshotScheduleKey key = new SnapshotScheduleKey(scheduleName);
            Object schedule = utilityCache.get((Object)key);
            if (schedule == null) {
                throw new IgniteException(SCHEDULE_NOT_FOUND + scheduleName);
            }
            if (schedule instanceof SnapshotSchedule) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Full snapshot ID update is not possible for a previous version of the schedule: " + scheduleName);
                }
            } else if (schedule instanceof SnapshotScheduleV2) {
                SnapshotScheduleV2 scheduleV2 = (SnapshotScheduleV2)((Object)schedule);
                assert (scheduleV2.execAfter() == null) : scheduleName;
                scheduleV2.lastFullSnapshotId(snapshotId);
                utilityCache.put((Object)key, schedule);
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Unknown type of schedule: " + schedule);
            }
            tx.commit();
        }
        catch (Throwable t) {
            throw new IgniteException("Failed to update full snapshot ID for schedule: " + scheduleName, t);
        }
    }
}

