/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

public abstract class ScheduledSnapshotOperation
implements Runnable,
Serializable {
    @IgniteInstanceResource
    protected transient Ignite ignite;
    @LoggerResource
    protected transient IgniteLogger log;
    protected SnapshotScheduleV2 schedule;

    @Deprecated
    protected ScheduledSnapshotOperation(Ignite ignite, SnapshotSchedule schedule) {
        this.ignite = ignite;
        this.log = ignite.log().getLogger(ScheduledSnapshotOperation.class);
        this.schedule = new SnapshotScheduleV2(schedule);
    }

    protected ScheduledSnapshotOperation(Ignite ignite, SnapshotScheduleV2 schedule) {
        this.ignite = ignite;
        this.log = ignite.log().getLogger(ScheduledSnapshotOperation.class);
        this.schedule = schedule;
    }

    protected abstract void run0(GridSnapshot var1) throws Exception;

    @Override
    public void run() {
        U.warn((IgniteLogger)this.log, (Object)("Scheduled snapshot operation started: " + (Object)((Object)this.schedule)));
        GridGain gg = (GridGain)this.ignite.plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        try {
            if (snapshot == null) {
                throw new IllegalStateException("Snapshot facade not found");
            }
            this.run0(snapshot);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to run scheduled snapshot operation: " + (Object)((Object)this.schedule)), (Throwable)e);
        }
    }

    protected String message() {
        return "[src=schedule, schedule=" + this.schedule.getName() + ", user=" + System.getProperty("user.name") + "]";
    }

    protected List<Long> filteredSnapshots(GridSnapshot snapshot) {
        int i;
        ArrayList<Long> res = new ArrayList<Long>();
        long currTime = System.currentTimeMillis();
        long ttl = this.schedule.getTtl();
        int forOldest = this.schedule.forOldest();
        int forLatest = this.schedule.forLatest();
        assert (ttl > -1L && forOldest == -1 && forLatest == -1 || ttl == -1L && forOldest > -1 && forLatest == -1 || ttl == -1L && forOldest == -1 && forLatest > -1) : "incorrect filter, only one option should be specified [ttl=" + ttl + ", forOldest=" + forOldest + ", forLatest=" + forLatest + "]";
        List<SnapshotInfo> snapshotInfos = snapshot.list(null);
        if (this.schedule.getOperationType() == SnapshotOperationType.DELETE) {
            snapshotInfos = this.filterSnapshotsToKeep(new ArrayList<SnapshotInfo>(snapshotInfos), this.schedule.keepCount());
        }
        if (ttl > -1L) {
            for (SnapshotInfo snapInfo : snapshotInfos) {
                if (currTime - snapInfo.snapshotId() <= ttl) continue;
                res.add(snapInfo.snapshotId());
            }
            res.sort(Collections.reverseOrder());
            return res;
        }
        snapshotInfos.sort(Comparator.comparingLong(SnapshotInfo::snapshotId));
        if (forOldest > -1) {
            for (i = 0; i < Math.min(forOldest, snapshotInfos.size() - 1); ++i) {
                res.add(snapshotInfos.get(i).snapshotId());
            }
        }
        if (forLatest > -1) {
            for (i = snapshotInfos.size() - 1; i >= Math.max(snapshotInfos.size() - forLatest, 0); --i) {
                res.add(snapshotInfos.get(i).snapshotId());
            }
        }
        return res;
    }

    private List<SnapshotInfo> filterSnapshotsToKeep(List<SnapshotInfo> snapshotInfos, int keep) {
        NavigableSet<Long> snapshotsToKeep;
        snapshotInfos.sort(Comparator.comparingLong(SnapshotInfo::snapshotId));
        ArrayList<SnapshotInfo> fullSnapshotsToKeep = new ArrayList<SnapshotInfo>();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)((IgniteEx)this.ignite).context().cache().context().snapshot();
        for (int i = snapshotInfos.size() - 1; i >= 0 && keep > 0; --i) {
            SnapshotInfo info2 = snapshotInfos.get(i);
            if (!info2.fullSnapshot()) continue;
            fullSnapshotsToKeep.add(info2);
            --keep;
        }
        try {
            snapshotsToKeep = snapMgr.collectDependentSnapshotIds(fullSnapshotsToKeep.stream().map(SnapshotInfo::snapshotId).collect(Collectors.toSet()), null);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed: " + e.getMessage(), (Throwable)e);
        }
        return snapshotInfos.stream().filter(info -> !snapshotsToKeep.contains(info.snapshotId())).collect(Collectors.toList());
    }

    protected SnapshotScheduleProcessor snapshotScheduler() {
        GridGainImpl gg = (GridGainImpl)this.ignite.plugin("GridGain");
        return (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
    }
}

