/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.catalog;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginProcessorAdapter;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogMessageEx;

public class SnapshotsCatalogProcessor
extends GridPluginProcessorAdapter {
    private volatile ExecutorService executor;
    private final Collection<Consumer<Collection<SnapshotsCatalogMessageEx>>> lsnrs = new GridConcurrentHashSet(4);

    public SnapshotsCatalogProcessor(PluginContext ctx, GridGainConfiguration cfg) {
        super(ctx, cfg);
    }

    public void onIgniteStart() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory(this.igniteCtx.igniteInstanceName(), "db-snapshot-messages"));
    }

    public void onIgniteStop(boolean cancel) {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    public void addListener(Consumer<Collection<SnapshotsCatalogMessageEx>> lsnr) {
        A.notNull(lsnr, (String)"lsnr");
        this.lsnrs.add(lsnr);
    }

    public boolean removeListener(Consumer<Collection<SnapshotsCatalogMessageEx>> lsnr) {
        A.notNull(lsnr, (String)"lsnr");
        return this.lsnrs.remove(lsnr);
    }

    public void addMessages(Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        if (this.executor == null) {
            this.log.info("Failed to add snapshot messages to catalog processor. Node is stopping.");
            return;
        }
        this.lsnrs.forEach(lsnr -> this.executor.submit(() -> lsnr.accept(snapMsgs)));
    }
}

