/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutContextSupplier;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutContext;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;

class TransactionalCutContextSupplier
implements ConsistentCutContextSupplier {
    private final GridKernalContext ctx;
    private final TransactionalDrProcessorImpl txdrProc;
    private final ConsistentCutStore store = new ConsistentCutStore(){

        @Override
        public void save(ConsistentCut consistentCut) throws IgniteCheckedException {
            TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().save(consistentCut);
            TransactionalCutContextSupplier.this.txdrProc.lastCreatedConsistentCut(consistentCut.id());
        }

        @Override
        public ConsistentCut restore(long id) throws IgniteCheckedException {
            return TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().restore(id);
        }

        @Override
        public boolean delete(long id) throws IgniteCheckedException {
            return TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().delete(id);
        }

        @Override
        public void cleanup() throws IgniteCheckedException {
            TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().cleanup();
        }

        @Override
        public List<Long> list() throws IgniteCheckedException {
            return TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().list();
        }

        @Override
        public List<Long> list(long startId) throws IgniteCheckedException {
            return TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().list(startId);
        }

        @Override
        public List<Long> list(long startId, long endId) throws IgniteCheckedException {
            return TransactionalCutContextSupplier.this.txdrProc.consistentCutStore().list(startId, endId);
        }
    };

    public TransactionalCutContextSupplier(GridKernalContext ctx) {
        this.ctx = ctx;
        TransactionalDrProcessor txDr = ctx.txDr();
        this.txdrProc = txDr instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)txDr : null;
    }

    @Override
    public ConsistentCutContext createConsistentCutContext(long cutId) {
        return new ConsistentCutContext(cutId, this.txdrProc.spawnId(), this.ctx.cache().context());
    }

    @Override
    public ConsistentCutStore consistentCutStore() {
        return this.store;
    }

    @Override
    public boolean shouldSkipConsistentCut(ConsistentCutContext cutCtx, AffinityTopologyVersion topVer) {
        return !topVer.equals((Object)this.ctx.discovery().topologyVersionEx()) || this.txdrProc.skipSavingCut(topVer, cutCtx.cutId());
    }

    @Override
    public boolean shouldCancelOnSkippedCut() {
        return false;
    }

    @Override
    public Collection<BinaryMetadata> binaryMetadata() throws IgniteCheckedException {
        return this.txdrProc.getAndClearBinaryMetadata();
    }

    @Override
    public TopologyEventsSnapshot localTopologySnapshot(ConsistentCutContext cutCtx) throws IgniteCheckedException {
        return this.txdrProc.topologyTracker().snapshot(cutCtx.cutId(), this.ctx.discovery().topologyVersionEx());
    }

    @Override
    public void updateLocalTopologySnapshot(TopologyEventsSnapshot snapshot) throws IgniteCheckedException {
        this.txdrProc.topologyTracker().merge(snapshot);
    }
}

