/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Arrays;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AtomicLongSnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogMessageEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogMessageState;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotUpdateFuture<T>
extends SnapshotOperationFuture<T> {
    protected volatile SnapshotUpdateOperationParameters operationParameters;
    protected volatile NavigableSet<Long> dependentSnapshots;

    protected SnapshotUpdateFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<T> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        super.init(snapshotInfo);
        this.operationParameters = this.updateAttributes(GridSnapshotOperationAttrs.getUpdateOperationsParameters((GridSnapshotOperationEx)snapshotInfo.snapshotOperation()));
    }

    protected SnapshotUpdateOperationParameters updateAttributes(SnapshotUpdateOperationParameters params) {
        return params;
    }

    @Override
    protected void crdStartHook(Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        assert (parameters != null);
        GridSnapshotOperationEx snapOp = this.snapshotInfo.snapshotOperation();
        long snapshotId = snapOp.snapshotId();
        switch (parameters.chainMode()) {
            case FROM_CURRENT_TO_LAST: {
                for (Long dependentSnapshotId : snapOp.dependentSnapshotIds()) {
                    Set dependantSnapshotIds = snapshotId == dependentSnapshotId ? snapOp.dependentSnapshotIds() : null;
                    snapMsgs.add(new SnapshotsCatalogMessageEx(SnapshotUpdateFuture.createSnapshotOperation(snapOp, dependentSnapshotId, dependantSnapshotIds), this.snapshotStatus(), SnapshotsCatalogMessageState.STARTED, this.snapshotInfo.initiatorNodeId(), null));
                }
                break;
            }
            case SINGLE: 
            case DEFAULT: {
                snapMsgs.add(new SnapshotsCatalogMessageEx(SnapshotUpdateFuture.createSnapshotOperation(snapOp, snapshotId, null), this.snapshotStatus(), SnapshotsCatalogMessageState.STARTED, this.snapshotInfo.initiatorNodeId(), null));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    protected void crdFinishHook(Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        assert (parameters != null);
        GridSnapshotOperationEx snapOp = this.snapshotInfo.snapshotOperation();
        SnapshotsCatalogMessageState state = this.success() ? SnapshotsCatalogMessageState.FINISHED : SnapshotsCatalogMessageState.FAILED;
        long snapshotId = snapOp.snapshotId();
        switch (parameters.chainMode()) {
            case FROM_CURRENT_TO_LAST: {
                assert (!snapOp.dependentSnapshotIds().isEmpty() && snapOp.dependentSnapshotIds().contains(snapOp.snapshotId())) : snapOp;
                for (Long dependentSnapshotId : snapOp.dependentSnapshotIds()) {
                    Set dependantSnapshotIds = snapshotId == dependentSnapshotId ? snapOp.dependentSnapshotIds() : null;
                    GridSnapshotOperationEx depSnapOp = SnapshotUpdateFuture.createSnapshotOperation(snapOp, dependentSnapshotId, dependantSnapshotIds);
                    IgniteException depSnapErr = state == SnapshotsCatalogMessageState.FAILED ? new IgniteException("Failed to complete " + this.type() + " on snapshot with id: " + dependentSnapshotId) : null;
                    snapMsgs.add(new SnapshotsCatalogMessageEx(depSnapOp, this.snapshotStatus(), state, this.snapshotInfo.initiatorNodeId(), (Throwable)depSnapErr));
                }
                break;
            }
            case SINGLE: 
            case DEFAULT: {
                snapMsgs.add(new SnapshotsCatalogMessageEx(SnapshotUpdateFuture.createSnapshotOperation(snapOp, snapOp.snapshotId(), null), this.snapshotStatus(), state, this.snapshotInfo.initiatorNodeId(), null));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @NotNull
    protected static GridSnapshotOperationEx createSnapshotOperation(GridSnapshotOperationEx snapOp, Long snapshotId, Set<Long> dependantSnapshotIds) {
        return new GridSnapshotOperationImpl(snapOp.type(), snapshotId.longValue(), snapOp.cacheGroupIds(), snapOp.cacheNames(), snapOp.message(), snapOp.extraParameter(), dependantSnapshotIds, null, snapOp.cacheConfigClo());
    }

    protected void deleteSnapshots() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting DELETE after " + this.type() + ", snapshotOperation = " + this.snapshotInfo().snapshotOperation());
        }
        SnapshotUpdateOperationParameters parameters = this.operationParameters;
        assert (parameters != null);
        switch (parameters.chainMode()) {
            case FROM_CURRENT_TO_LAST: {
                assert (this.dependentSnapshots != null);
                long totalFilesToDelCnt = this.calculateCountOfFilesToDelete(this.dependentSnapshots, this.dbSnapshotSpi);
                if (totalFilesToDelCnt == 0L) {
                    return;
                }
                SnapshotOperationContext context = this.context((SnapshotProgressCalculator)new AtomicLongSnapshotProgressCalculator(totalFilesToDelCnt));
                for (Long snapId : this.dependentSnapshots) {
                    this.deleteSnapshot(snapId, context, this.dbSnapshotSpi, this.cctx, this.log);
                }
                break;
            }
            case SINGLE: 
            case DEFAULT: {
                long snapshotId = this.snapshotInfo.snapshotId();
                long totalFilesToDelCnt = this.countFilesOfSnapshot(this.dbSnapshotSpi, snapshotId);
                if (totalFilesToDelCnt == 0L) {
                    return;
                }
                SnapshotOperationContext context = this.context((SnapshotProgressCalculator)new AtomicLongSnapshotProgressCalculator(totalFilesToDelCnt));
                this.deleteSnapshot(snapshotId, context, this.dbSnapshotSpi, this.cctx, this.log);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void deleteSnapshot(long snapId, SnapshotOperationContext context, DatabaseSnapshotSpi dbSnapshotSpi, GridCacheSharedContext cctx, IgniteLogger log) throws IgniteCheckedException {
        SnapshotUtils.checkSnapshotCancellation(context);
        if (this.snapMgr.pointInTimeRecoveryEnabled()) {
            this.deleteWalInPitrMode(snapId, dbSnapshotSpi, cctx, log);
        }
        SnapshotUtils.checkSnapshotCancellation(context);
        dbSnapshotSpi.deleteSnapshot(snapId, context);
    }

    private void deleteWalInPitrMode(long id, DatabaseSnapshotSpi snapshotSpi, GridCacheSharedContext<?, ?> cctx, IgniteLogger log) throws IgniteCheckedException {
        T2<WALPointer, WALPointer> tup;
        long maxWalArchiveSize = cctx.kernalContext().config().getDataStorageConfiguration().getMaxWalArchiveSize();
        if (-1L != maxWalArchiveSize) {
            return;
        }
        long[] snapshotIds = StreamSupport.stream(snapshotSpi.localSnapshots(true).spliterator(), false).mapToLong(SnapshotMetadataV2::id).toArray();
        if (snapshotIds.length == 0) {
            return;
        }
        if (snapshotIds[0] != id) {
            log.warning("Skipped WAL segments removal, it requires sequential removal of snapshots: " + Arrays.toString(snapshotIds));
            return;
        }
        Snapshot snapshot = snapshotSpi.snapshot(id, null, null, true, null, false);
        if (snapshot != null && snapshot.metadata() != null && snapshot.metadata().pointInTimeRecoveryEnabled() && (tup = this.findWalPtrs(cctx, id, snapshot, snapshotSpi)) != null) {
            FileWALPointer low = (FileWALPointer)tup.get1();
            FileWALPointer high = (FileWALPointer)tup.get2();
            if (low != null && high != null) {
                if (SnapshotUtils.walFilesWereDeleted(id, (WALPointer)low, this.recovery().nodeStartedPoints())) {
                    log.warning("Skipped WAL segments removal, they have been deleted manually after snapshot was created.");
                    return;
                }
                if (SnapshotUtils.lfsWasDeleted(id, (WALPointer)low, cctx.wal(), log)) {
                    log.warning("Skipped WAL segments removal, local file system has been cleaned manually after snapshot was created.");
                    return;
                }
                GridCacheDatabaseSharedManager ps = (GridCacheDatabaseSharedManager)cctx.database();
                ps.onWalTruncated((WALPointer)high);
                int truncated = cctx.wal().truncate((WALPointer)high);
                if (log.isInfoEnabled()) {
                    log.info("Remove wal segments on snapshot " + this.type() + " snpId=" + id + " [highIdx=" + high.index() + ", removeCnt=" + truncated + ']');
                }
            }
        }
    }

    protected final GridRecovery recovery() {
        GridGainImpl gg = (GridGainImpl)this.cctx.kernalContext().grid().plugin("GridGain");
        return gg.provider().recovery();
    }

    private long calculateCountOfFilesToDelete(NavigableSet<Long> snapshotToDel, DatabaseSnapshotSpi dbSnapshotSpi) {
        long totalFilesToDelCnt;
        if (dbSnapshotSpi instanceof FileDatabaseSnapshotSpi) {
            FileDatabaseSnapshotSpi spi = (FileDatabaseSnapshotSpi)dbSnapshotSpi;
            long c = 0L;
            for (long snapId : snapshotToDel) {
                c += this.countFilesOfSnapshot(spi, snapId);
            }
            totalFilesToDelCnt = c;
        } else {
            totalFilesToDelCnt = Integer.MAX_VALUE;
        }
        return totalFilesToDelCnt;
    }

    private long countFilesOfSnapshot(DatabaseSnapshotSpi spi, long snapId) {
        try {
            FsSnapshotPath dir = spi.findLocalCurNodeSnapshotDir(snapId);
            if (dir != null) {
                return dir.fileCount();
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Exception while finding local snapshot dir for id=" + snapId), (Throwable)e);
        }
        return 0L;
    }

    @Nullable
    protected T2<WALPointer, WALPointer> findWalPtrs(GridCacheSharedContext<?, ?> cctx, Long lastSnapshotId, Snapshot snapshot, DatabaseSnapshotSpi dbSnapshotSpi) throws IgniteCheckedException {
        if (snapshot == null) {
            snapshot = dbSnapshotSpi.snapshot(lastSnapshotId.longValue(), null, null, false, null, false);
        }
        if (snapshot == null || snapshot.metadata() == null || !snapshot.metadata().pointInTimeRecoveryEnabled()) {
            return null;
        }
        SnapshotMetadataV2 m = snapshot.metadata();
        BaselineTopology blt = m.baselineTopology();
        Object locNodeId = cctx.localNode().consistentId();
        WALPointer fromPtr = (WALPointer)m.walPoints().get(blt.resolveShortConsistentId(locNodeId));
        TreeSet<Long> snapshotIds = new TreeSet<Long>();
        for (SnapshotMetadataV2 item : dbSnapshotSpi.localSnapshots(false)) {
            snapshotIds.add(item.id());
        }
        Long nextSnapshot = snapshotIds.higher(lastSnapshotId);
        if (nextSnapshot == null) {
            return null;
        }
        SnapshotMetadataV2 m2 = dbSnapshotSpi.snapshot(nextSnapshot.longValue(), null, null, false, null, false).metadata();
        assert (m2 != null) : "No any appropriate snapshot found, snapshots count: " + snapshotIds.size();
        BaselineTopology blt2 = m2.baselineTopology();
        WALPointer to = (WALPointer)m2.walPoints().get(blt2.resolveShortConsistentId(locNodeId));
        return new T2((Object)fromPtr, (Object)to);
    }
}

