/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestException;

public class SnapshotDigestRegistry
extends IgniteDataTransferObject {
    public static final String REGISTRY_VERSION_ERROR = "Incompatible version of snapshot digest registry.";
    private static final long serialVersionUID = 0L;
    private long snapshotId;
    private String digestAlgo;
    private int digestLen;
    private String consistentId;
    private byte[] metadataDigest;
    private Map<GroupPartitionId, byte[]> digestMap = new ConcurrentHashMap<GroupPartitionId, byte[]>();

    public SnapshotDigestRegistry(long snapshotId, int digestLen, String digestAlgo, String consistentId) {
        this.snapshotId = snapshotId;
        this.digestLen = digestLen;
        this.digestAlgo = digestAlgo;
        this.consistentId = consistentId;
    }

    public SnapshotDigestRegistry() {
    }

    public void snapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public void digestLength(int digestLen) {
        this.digestLen = digestLen;
    }

    public int digestLength() {
        return this.digestLen;
    }

    public void digestAlgo(String digestAlgo) {
        this.digestAlgo = digestAlgo;
    }

    public String digestAlgo() {
        return this.digestAlgo;
    }

    public void consistentId(String consistentId) {
        this.consistentId = consistentId;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public void metadataDigest(byte[] metaDigest) {
        this.metadataDigest = metaDigest;
    }

    public byte[] metadataDigest() {
        return this.metadataDigest;
    }

    public byte[] partitionDataDigest(GroupPartitionId groupPartitionId) {
        return this.digestMap.get(groupPartitionId);
    }

    public void partitionDataDigest(GroupPartitionId groupPartitionId, byte[] digest) {
        this.digestMap.put(groupPartitionId, digest);
    }

    public Map<GroupPartitionId, byte[]> digestMap() {
        return this.digestMap;
    }

    public int hashCode() {
        int res = 31 * Long.hashCode(this.snapshotId) + this.digestLen;
        res = 31 * res + (this.digestAlgo == null ? 0 : this.digestAlgo.hashCode());
        res = 31 * res + (this.consistentId == null ? 0 : this.consistentId.hashCode());
        res = 31 * res + (this.metadataDigest == null ? 0 : Arrays.hashCode(this.metadataDigest));
        res = 31 * res + (this.digestMap == null ? 0 : this.digestMap.hashCode());
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SnapshotDigestRegistry oth = (SnapshotDigestRegistry)((Object)o);
        if (!(this.snapshotId == oth.snapshotId && this.digestLen == oth.digestLen && Objects.equals(this.digestAlgo, oth.digestAlgo) && Objects.equals(this.consistentId, oth.consistentId) && Arrays.equals(this.metadataDigest, oth.metadataDigest))) {
            return false;
        }
        return this.digestMap == oth.digestMap || this.digestMap != null && this.mapsEqual(this.digestMap, oth.digestMap);
    }

    private <T> boolean mapsEqual(Map<T, byte[]> m1, Map<T, byte[]> m2) {
        if (m1.size() == m2.size()) {
            for (Map.Entry<T, byte[]> e : m1.entrySet()) {
                byte[] data = m2.get(e.getKey());
                if (Arrays.equals(e.getValue(), data)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.snapshotId);
        out.writeInt(this.digestLen);
        out.writeUTF(this.digestAlgo);
        out.writeUTF(this.consistentId);
        out.writeInt(this.digestMap.size());
        for (Map.Entry<GroupPartitionId, byte[]> entry : this.digestMap.entrySet()) {
            assert (entry.getValue().length == this.digestLen);
            out.writeInt(entry.getKey().getGroupId());
            out.writeShort(entry.getKey().getPartitionId());
            out.write(entry.getValue());
        }
        assert (this.metadataDigest != null && this.metadataDigest.length == this.digestLen);
        out.write(this.metadataDigest);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException {
        if (protoVer != 1) {
            throw new SnapshotDigestException("Incompatible version of snapshot digest registry. [version=" + protoVer + ", expected=" + 1 + ", class='" + ((Object)((Object)this)).getClass().getName() + "']");
        }
        this.snapshotId = in.readLong();
        this.digestLen = in.readInt();
        this.digestAlgo = in.readUTF();
        this.consistentId = in.readUTF();
        int size = in.readInt();
        this.digestMap = new ConcurrentHashMap<GroupPartitionId, byte[]>();
        for (int i = 0; i < size; ++i) {
            int grpId = in.readInt();
            int partId = in.readShort() & 0xFFFF;
            byte[] hash = new byte[this.digestLen];
            in.readFully(hash);
            this.digestMap.put(new GroupPartitionId(grpId, partId), hash);
        }
        this.metadataDigest = new byte[this.digestLen];
        in.readFully(this.metadataDigest);
    }
}

