/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.CheckSnapshotFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.CheckSnapshotMetadataMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotIssueMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ResultOfOperationWithSnapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreAndCheckFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class SnapshotCheckFuture
extends SnapshotRestoreAndCheckFuture<List<SnapshotIssue>> {
    private SnapshotMetadataV2 snapshotMetadata;

    @Override
    protected List<SnapshotIssueMessage> getSnapshotIssues() {
        return this.getListOfIssuesInLegacyForm();
    }

    SnapshotCheckFuture(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter<List<SnapshotIssue>> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protocolVersion, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.CHECK;
    }

    @Override
    protected boolean doFirstStage() throws IgniteCheckedException {
        this.doOperation(GridSnapshotOperationAttrs.getRestoreStrategyOrDefault((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation(), (SnapshotRestoreStrategy)SnapshotRestoreStrategy.defaultStrategy((SnapshotOperationType)SnapshotOperationType.RESTORE)));
        SnapshotMetadataV2 metadata = this.snapshotMetadata;
        if (metadata != null) {
            Set cacheNames = this.snapshotInfo.snapshotOperation().cacheNames();
            if (!GridSnapshotOperationAttrs.getRestoreForceOption((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation())) {
                this.collectUnknownLogicalCachesToDestroy(this.log, this.cctx, this.resolveGroupIds(metadata.cacheGroupIds()), cacheNames == null ? metadata.cacheNames() : cacheNames);
            }
        }
        return true;
    }

    @Override
    protected SnapshotOperationStage stageForResultOfOperation() {
        return SnapshotOperationStage.FIRST;
    }

    @Override
    protected void completeStagesLocally(ClusterWideSnapshotOperationStageFinishedMessage msg, SnapshotOperationStage localStageToComplete) {
        if (this.isRestoreOwnConsistentIdStrategyAvailable() || localStageToComplete == SnapshotOperationStage.FINISH || localStageToComplete == SnapshotOperationStage.CANCELLED) {
            super.completeStagesLocally(msg, localStageToComplete);
            return;
        }
        try {
            ResultOfOperationWithSnapshot resultOfOperation = (ResultOfOperationWithSnapshot)((Object)this.resultOfOperation.get());
            assert (this.nodeShouldSkipActiveActions() || resultOfOperation != null) : "nodeShouldSkipActiveActions=" + this.nodeShouldSkipActiveActions() + ", issues=" + this.snapshotOperationIssues + ", resultOfSnapshotOperation=" + (Object)((Object)resultOfOperation);
            CheckSnapshotFinishedMessage checkFinishMsg = new CheckSnapshotFinishedMessage(this.id, true, null, resultOfOperation == null ? null : new CheckSnapshotMetadataMessage(resultOfOperation.partitionCountForCacheGroup(), resultOfOperation.partitionIdsForCacheGroup()), this.getListOfIssuesInLegacyForm());
            this.markStageAsFinished(localStageToComplete, this.success());
            this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, (Message)checkFinishMsg, (byte)2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent CheckSnapshotFinishedMessage, msg = " + checkFinishMsg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send CheckSnapshotFinishedMessage.", (Throwable)e);
        }
    }

    private List<SnapshotIssueMessage> getListOfIssuesInLegacyForm() {
        ConcurrentLinkedQueue messages = this.snapshotOperationIssues;
        return F.isEmpty((Collection)messages) ? Collections.emptyList() : messages.stream().map((? super T m) -> new SnapshotIssueMessage(m.cacheGroupName(), m.partitionId(), m.issueMessage())).collect(Collectors.toList());
    }

    @Override
    protected boolean onFirstStageDoneCrdHook() throws IgniteCheckedException {
        boolean restoreOwnStrategyAvailable = this.isRestoreOwnConsistentIdStrategyAvailable();
        ResultOfOperationWithSnapshot resultOfOperation = (ResultOfOperationWithSnapshot)((Object)this.resultOfOperation.get());
        if (restoreOwnStrategyAvailable && resultOfOperation == null) {
            throw new IgniteCheckedException("Snapshot does not exist [id=" + this.snapshotInfo().snapshotOperation().snapshotId() + ']');
        }
        Map<Integer, BitSet> partIdsForCache = resultOfOperation.partitionIdsForCacheGroup();
        Map<Integer, Integer> partCountForCache = resultOfOperation.partitionCountForCacheGroup();
        this.checkOperationResultOnCrd(partIdsForCache, partCountForCache);
        return true;
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) {
        if (this.stage() == SnapshotOperationStage.CANCELLED) {
            return;
        }
        this.res = SnapshotCheckFuture.getPartitionNumberForCacheGroups(msg.issues());
    }

    @Override
    protected SnapshotRestoreAndCheckFuture.OperationOnGroup startOperationOnGroup(SnapshotRestoreStrategy stgy, Snapshot snapshot, Integer grpId, final String cacheOrGrpName, CacheConfiguration cacheCfg, BitSet partitions, String cId, final int pageSize, GroupKeyEncrypted encryptionKey, EncryptionSpi encSpi) {
        final boolean skipCrc = GridSnapshotOperationAttrs.getSkipCrcParameter((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
        return new SnapshotRestoreAndCheckFuture.OperationOnGroup(pageSize, encryptionKey, encSpi){

            @Override
            ByteBuffer createBuffer() {
                ByteBuffer buf = ByteBuffer.allocate(pageSize);
                buf.order(ByteOrder.nativeOrder());
                return buf;
            }

            @Override
            public int doJobOnPartition(SnapshotInputStream stream, int part) throws IOException {
                int readPageCntPerPart = 0;
                ByteBuffer buf = this.readBuf();
                while (stream.readNextPage(buf)) {
                    buf.rewind();
                    if (!skipCrc) {
                        SnapshotCheckFuture.this.checkCrc(pageSize, buf, cacheOrGrpName, part);
                    }
                    ++readPageCntPerPart;
                }
                boolean markerPageFound = false;
                while (stream.readNextRecord() != null) {
                    markerPageFound = true;
                }
                if (markerPageFound) {
                    ++readPageCntPerPart;
                }
                return readPageCntPerPart;
            }
        };
    }

    @Override
    protected boolean beforeOperationStarted(GridKernalContext ctx, Snapshot snapshot) throws IgniteCheckedException {
        this.snapshotMetadata = snapshot.metadata();
        return true;
    }

    @Override
    protected void checkSecurityLevel(UUID initiatorId, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
        try {
            SnapshotUtils.checkSecurityLevel(this.cctx, initiatorId, snapshotOperation, this.snapMgr.resolveSecurityLevel());
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private static List<SnapshotIssue> getPartitionNumberForCacheGroups(Collection<SnapshotIssueMessage> issueMessages) {
        if (issueMessages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SnapshotIssue> res = new ArrayList<SnapshotIssue>();
        for (SnapshotIssueMessage message : issueMessages) {
            res.add(new SnapshotIssue(message.cacheName(), message.partId(), message.errorMessage()));
        }
        return res;
    }

    private synchronized void onCheckResultReceived(ClusterNode node, CheckSnapshotMetadataMessage metadata, Collection<SnapshotIssueMessage> issues) throws IgniteCheckedException {
        ResultOfOperationWithSnapshot old;
        if (this.isDone()) {
            return;
        }
        while (!this.resultOfOperation.compareAndSet(old = (ResultOfOperationWithSnapshot)((Object)this.resultOfOperation.get()), SnapshotCheckFuture.merge(old, metadata, node, issues, this.snapshotOperationIssues))) {
        }
        this.onAckReceived(node, SnapshotOperationStage.FIRST);
    }

    public static ResultOfOperationWithSnapshot merge(ResultOfOperationWithSnapshot result, CheckSnapshotMetadataMessage metadataMessage, ClusterNode node, Collection<SnapshotIssueMessage> issues, Collection<SnapshotOperationIssue> issueAccumulator) throws IgniteCheckedException {
        for (SnapshotIssueMessage issue : issues) {
            issueAccumulator.add(new SnapshotOperationIssue(node.id(), issue.cacheName(), issue.partId(), issue.errorMessage()));
        }
        if (result == null) {
            return metadataMessage == null ? null : new ResultOfOperationWithSnapshot(metadataMessage.partCountForCache(), metadataMessage.partIdsForCache(), new ArrayList<SnapshotOperationIssue>(issueAccumulator));
        }
        if (metadataMessage == null) {
            return result;
        }
        HashMap<Integer, Integer> partCntForCache = new HashMap<Integer, Integer>(result.partitionCountForCacheGroup());
        HashMap<Integer, BitSet> partForCache = new HashMap<Integer, BitSet>(result.partitionIdsForCacheGroup());
        for (Map.Entry<Integer, Integer> entry : metadataMessage.partCountForCache().entrySet()) {
            Integer partCnt = entry.getValue();
            Integer prev = partCntForCache.put(entry.getKey(), partCnt);
            if (prev == null || partCnt.intValue() == prev.intValue()) continue;
            throw new IgniteCheckedException("Error during merge results from different nodes: partition count differs on different nodes, grpId=" + entry.getKey() + " from message=" + partCnt + ", current=" + prev + ", message node=" + node);
        }
        for (Map.Entry<Integer, Serializable> entry : metadataMessage.partIdsForCache().entrySet()) {
            BitSet bitSet = (BitSet)partForCache.get(entry.getKey());
            if (bitSet != null) {
                bitSet.or((BitSet)entry.getValue());
                continue;
            }
            partForCache.put(entry.getKey(), (BitSet)entry.getValue());
        }
        return new ResultOfOperationWithSnapshot(partCntForCache, partForCache, new ArrayList<SnapshotOperationIssue>(issueAccumulator));
    }

    @Override
    protected synchronized void onMessage(ClusterNode node, Object msg0) {
        CheckSnapshotFinishedMessage msg = null;
        if (!(msg0 instanceof CheckSnapshotFinishedMessage)) {
            super.onMessage(node, msg0);
            return;
        }
        msg = (CheckSnapshotFinishedMessage)msg0;
        if (this.id.equals((Object)msg.operationId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received CheckSnapshotFinishedMessage from node = " + node + ", msg= " + msg);
            }
            if (!msg.success() && this.tryStartCancellation()) {
                if (!this.initialized()) {
                    return;
                }
                String errorMsg = msg.errorMessage();
                this.cancelSnapshotOperationOnCrd(node, false, errorMsg, null);
                return;
            }
            try {
                this.onCheckResultReceived(node, msg.snapshotMetadata(), msg.issues());
            }
            catch (IgniteCheckedException e) {
                if (this.tryStartCancellation()) {
                    this.cancelSnapshotOperationOnCrd(node, false, "Merge metadata from different node failed", (Exception)((Object)e));
                }
            }
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received CheckSnapshotFinishedMessage message with wrong id, msg = " + msg));
        }
    }

    private void checkCrc(int pageSize, ByteBuffer buf, String cacheOrGrpName, int p) {
        int crcSaved = PageIO.getCrc((ByteBuffer)buf);
        PageIO.setCrc((ByteBuffer)buf, (int)0);
        int currCrc = FastCrc.calcCrc((ByteBuffer)buf, (int)pageSize);
        if (currCrc != crcSaved) {
            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, p, "Page is corrupted: cache group - " + cacheOrGrpName + ", partition - " + p + ", pageId - " + U.hexLong((long)PageIO.getPageId((ByteBuffer)buf)) + ", checksum calculated = " + currCrc + ", checksum saved = " + crcSaved));
        }
        buf.rewind();
    }

    @Override
    protected Integer snapshotEventType(SnapshotOperationFuture.SnapshotOperationLifecycleStage lifecycleStage) {
        switch (lifecycleStage) {
            case OP_STARTED: {
                return 1035;
            }
            case OP_FINISHED: {
                return 1036;
            }
        }
        return null;
    }
}

