/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import java.util.Set;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;

class PitrWalScanFilter
implements IgniteBiPredicate<WALPointer, GridCacheVersion> {
    private static final long serialVersionUID = 0L;
    public static final IgniteBiPredicate<WALPointer, GridCacheVersion> ALWAYS_TRUE = (IgniteBiPredicate & Serializable)(ptr, ver) -> true;
    private final FileWALPointer fuzzyBorderStartPtr;
    private final FileWALPointer cutPtr;
    private Set<GridCacheVersion> skipTxs;

    PitrWalScanFilter(ConsistentCutMeta meta) {
        this.fuzzyBorderStartPtr = (FileWALPointer)meta.fuzzyBorderStartPtr();
        this.cutPtr = (FileWALPointer)meta.cutPtr();
        this.skipTxs = meta.skipTxs();
    }

    public boolean apply(WALPointer recPtr, GridCacheVersion ver) {
        FileWALPointer ptr = (FileWALPointer)recPtr;
        return ptr.compareTo(this.fuzzyBorderStartPtr) >= 0 && (ptr.compareTo(this.cutPtr) >= 0 || this.skipTxs.contains(ver));
    }
}

