/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetricsMXBeanImpl
implements SnapshotMetricsMXBean {
    private final int snapshotHistorySize = IgniteSystemProperties.getInteger((String)"GG_SNAPSHOT_METRICS_HISTORY_SIZE", (int)10);
    private final SnapshotMetrics[] snapshotHistory = new SnapshotMetrics[this.snapshotHistorySize];
    private int head;
    private int size;
    private volatile boolean snapshotInProgress;
    private final File snapshotDir;
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder writeThrottlingTime = new LongAdder();
    private final LongAdder totalBytesWrittenOnStorage = new LongAdder();
    private final Set<T2<Integer, Integer>> grpIdPartId = new GridConcurrentHashSet();
    private static final String CREATE_SNAPSHOT = SnapshotOperationType.CREATE.name();

    public SnapshotMetricsMXBeanImpl(File dir) {
        this.snapshotDir = dir;
    }

    public boolean isSnapshotInProgress() {
        return this.snapshotInProgress;
    }

    public long getFreeSpace() {
        return this.snapshotDir.getFreeSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPartitionsWritten() {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            if (this.isSnapshotInProgress() && CREATE_SNAPSHOT.equals(this.getLastSnapshotOperation())) {
                return this.grpIdPartId.size();
            }
        }
        return this.getPartitionsWritten(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            if (this.isSnapshotInProgress() && CREATE_SNAPSHOT.equals(this.getLastSnapshotOperation())) {
                return this.bytesWritten.sum();
            }
        }
        return this.getBytesWritten(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteThrottlingTime() {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            if (this.isSnapshotInProgress() && CREATE_SNAPSHOT.equals(this.getLastSnapshotOperation())) {
                return this.writeThrottlingTime.sum();
            }
        }
        return this.getWriteThrottlingTime(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBytesWrittenOnStorage() {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            if (this.isSnapshotInProgress() && CREATE_SNAPSHOT.equals(this.getLastSnapshotOperation())) {
                return this.totalBytesWrittenOnStorage.sum();
            }
        }
        return this.getTotalBytesWrittenOnStorage(0);
    }

    public long getLastSnapshotId() {
        return this.snapshotId(0);
    }

    public long getLastSnapshotStartTime() {
        return this.snapshotStartTime(0);
    }

    public long getLastSnapshotFinishTime() {
        return this.snapshotFinishTime(0);
    }

    public String getLastSnapshotOperation() {
        return this.snapshotOperation(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SnapshotMetrics getMetricsHistory(int index) {
        if (index >= this.snapshotHistorySize) {
            return null;
        }
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            return this.getMetrics(index);
        }
    }

    public long snapshotId(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.snapshotId;
    }

    public long snapshotStartTime(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.startTime;
    }

    public long snapshotFinishTime(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.finishTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String snapshotOperation(int index) {
        SnapshotMetrics m;
        if (index >= this.snapshotHistorySize) {
            return "N/A";
        }
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            m = this.getMetrics(index);
            if (m == null) {
                return "N/A";
            }
        }
        return m.operationType;
    }

    public long getBytesWritten(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.bytesWritten;
    }

    public long getWriteThrottlingTime(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.writeThrottlingTime;
    }

    public long getPartitionsWritten(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.partProcessed;
    }

    public long getTotalBytesWrittenOnStorage(int index) {
        SnapshotMetrics m = this.getMetricsHistory(index);
        return m == null ? -1L : m.totalBytesWrittenOnStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableSnapshotMetrics() {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            return this.size;
        }
    }

    public void updateProcessedPartitions(int grpId, int partId) {
        this.grpIdPartId.add((T2<Integer, Integer>)new T2((Object)grpId, (Object)partId));
    }

    public void incrementBytesWritten(long bytes) {
        this.bytesWritten.add(bytes);
    }

    public void incrementWriteThrottlingTime(long millis) {
        this.writeThrottlingTime.add(millis);
    }

    public void incrementTotalBytesWrittenOnStorage(long bytes) {
        this.totalBytesWrittenOnStorage.add(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotStarted(long snapshotId, SnapshotOperationType opType) {
        SnapshotMetrics snapshotMetrics = new SnapshotMetrics();
        snapshotMetrics.snapshotId = snapshotId;
        snapshotMetrics.startTime = U.currentTimeMillis();
        snapshotMetrics.operationType = opType.name();
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            this.snapshotInProgress = true;
            for (SnapshotMetrics m : this.snapshotHistory) {
                if (m == null || m.snapshotId != snapshotId || !m.operationType.equals(opType.name())) continue;
                return;
            }
            this.snapshotHistory[this.head] = snapshotMetrics;
            ++this.head;
            if (this.size < this.snapshotHistorySize) {
                ++this.size;
            }
            if (this.head == this.snapshotHistorySize) {
                this.head = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotMetrics get(int idx) {
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            return this.getMetrics(idx);
        }
    }

    private SnapshotMetrics getMetrics(int idx) {
        int target = this.head - idx - 1 < 0 ? this.snapshotHistorySize + (this.head - idx - 1) : this.head - idx - 1;
        return this.snapshotHistory[target];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotFinished(long snapshotId) {
        boolean resetInProgress = true;
        SnapshotMetricsMXBeanImpl snapshotMetricsMXBeanImpl = this;
        synchronized (snapshotMetricsMXBeanImpl) {
            SnapshotMetrics m = this.head == 0 ? this.snapshotHistory[this.snapshotHistorySize - 1] : this.snapshotHistory[this.head - 1];
            if (m == null) {
                return;
            }
            if (m.snapshotId != snapshotId) {
                resetInProgress = false;
                m = null;
                for (SnapshotMetrics m0 : this.snapshotHistory) {
                    if (m0 == null || snapshotId != m0.snapshotId) continue;
                    m = m0;
                    break;
                }
                if (m == null) {
                    return;
                }
            }
            assert (m != null);
            m.finishTime = U.currentTimeMillis();
            m.bytesWritten = this.bytesWritten.sum();
            m.partProcessed = this.grpIdPartId.size();
            m.totalBytesWrittenOnStorage = this.totalBytesWrittenOnStorage.sum();
            m.writeThrottlingTime = this.writeThrottlingTime.sum();
        }
        this.bytesWritten.reset();
        this.totalBytesWrittenOnStorage.reset();
        this.grpIdPartId.clear();
        this.writeThrottlingTime.reset();
        if (resetInProgress) {
            this.snapshotInProgress = false;
        }
    }

    public static class SnapshotMetrics {
        public long snapshotId = -1L;
        public long startTime = -1L;
        long finishTime = -1L;
        public String operationType = "N/A";
        long bytesWritten;
        long totalBytesWrittenOnStorage;
        long partProcessed;
        long writeThrottlingTime;

        public String toString() {
            return "SnapshotMetrics{snapshotId=" + this.snapshotId + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", operationType='" + this.operationType + ", bytesWritten='" + this.bytesWritten + '\'' + ", totalBytesWrittenOnStorage='" + this.totalBytesWrittenOnStorage + '\'' + ", partitionsProcessed='" + this.partProcessed + '\'' + ", writeThrottlingTime='" + this.writeThrottlingTime + "'" + '}';
        }
    }
}

