/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResult;
import org.gridgain.grid.internal.processors.cache.database.SnapshotCompatibilityJob;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public class CollectSnapshotDescriptorV2Task
extends SnapshotTaskBase<T3<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>>, SnapshotDescriptorV2> {
    private static final long serialVersionUID = 0L;
    private volatile SnapshotDescriptorV2 taskRes;

    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, T3<Long, Collection<File>, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>> param) throws IgniteException {
        HashMap<CollectSnapshotInfoV2Job, ClusterNode> jobs = new HashMap<CollectSnapshotInfoV2Job, ClusterNode>();
        if (param.get1() == null) {
            throw new IgniteException("Snapshot ID is null: " + param);
        }
        for (ClusterNode node : subgrid) {
            if (node.isClient() || node.isDaemon()) continue;
            jobs.put(new CollectSnapshotInfoV2Job((Long)param.get1(), (Collection)param.get2(), (IgniteBiClosure)param.get3()), node);
        }
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Send CollectSnapshotInfoJob on " + jobs.size() + " nodes");
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        CollectSnapshotInfoTaskResult data;
        if (res.getException() != null) {
            return super.result(res, rcvd);
        }
        JdkMarshaller jdkMarshaller = new JdkMarshaller();
        IgniteLogger log = this.getLog();
        Object data0 = res.getData();
        if (data0 instanceof byte[]) {
            try {
                data = (CollectSnapshotInfoTaskResult)jdkMarshaller.unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)log, (Object)("Failed to deserialize job execution result (will skip the node): " + U.toShortString((ClusterNode)res.getNode())), (Throwable)e);
                return ComputeJobResultPolicy.WAIT;
            }
        } else {
            data = (CollectSnapshotInfoTaskResult)data0;
        }
        if (data == null || data.descriptorForNodeV2().isEmpty()) {
            return ComputeJobResultPolicy.WAIT;
        }
        try {
            CollectSnapshotDescriptorV2Task e = this;
            synchronized (e) {
                for (SnapshotDescriptorV2 detail : data.descriptorForNodeV2().values()) {
                    if (this.taskRes == null) {
                        if (log != null && log.isInfoEnabled()) {
                            log.info("Starting reducing CollectSnapshotInfoTaskResult");
                        }
                        this.taskRes = detail;
                        continue;
                    }
                    this.taskRes.merge(detail);
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)log, (Object)("Snapshot metadata can't be merged for snapshot with id: " + data.snapshotId()), (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
        return ComputeJobResultPolicy.WAIT;
    }

    @Nullable
    public SnapshotDescriptorV2 reduce(List<ComputeJobResult> results) throws IgniteException {
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Finished reducing CollectSnapshotDescriptorTask");
        }
        return this.taskRes;
    }

    @GridInternal
    private static class CollectSnapshotInfoV2Job
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        private Collection<File> optSearchPaths;
        private IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
        private final long snapshotId;

        private CollectSnapshotInfoV2Job(long snapshotId, Collection<File> optSearchPaths, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotInfoTask.collectFullSnapshotInfo(this.ignite, SnapshotRemotePath.convertToSnapshotPathCollection(this.optSearchPaths), this.c, this.snapshotId, true, true);
        }
    }
}

