/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class TxDrStopReplicaTest
extends AbstractReplicationTest {
    @Override
    protected TransactionalDrConfiguration getTxDrConfiguration() throws Exception {
        return super.getTxDrConfiguration().setConsistentCutInterval(5000L);
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 3;
    }

    @Test
    public void testStopNowSimple() throws Exception {
        this.doTestStopNow(false);
    }

    @Test
    public void testStopNowWithHangingStateChangeFuture() throws Exception {
        this.doTestStopNow(true);
    }

    private void doTestStopNow(boolean blockStateChangeFut) throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        if (blockStateChangeFut) {
            IgniteCacheSnapshotManager mgr = this.node(ClusterRole.REPLICA).context().cache().context().snapshot();
            SnapshotFuture fut = ((GridCacheSnapshotManager)mgr).startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"HANG_ON_FIRST_STAGE", (Object)true), null);
            this.txdr(ClusterRole.REPLICA).stopNow().get();
            ((GridGain)this.node(ClusterRole.REPLICA).plugin("GridGain")).snapshot().cancelSnapshotOperation(fut.operationId(), null).get();
        } else {
            this.txdr(ClusterRole.REPLICA).stopNow().get();
        }
        TxDrStopReplicaTest.assertFalse((String)"Consistent cut watcher thread has not been stopped.", (boolean)Thread.getAllStackTraces().keySet().stream().anyMatch(t -> t.getName().startsWith("cc-watcher-worker")));
        this.stopCluster(ClusterRole.MASTER);
        this.stopCluster(ClusterRole.REPLICA);
        replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.assertClusterState(replicaCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
    }
}

