/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.junit.Test;

public class TxDrReplicaReadOnlyModeSystemCachesTest
extends AbstractReplicationTest {
    @Test
    public void testSysCacheIsReadWrite() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long bootstrapSesId = this.bootstrapMaster();
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        IgniteEx master = masterCluster.get(0);
        IgniteEx replica = replicaCluster.get(0);
        AtomicBoolean masterStop = new AtomicBoolean();
        AtomicBoolean replicaStop = new AtomicBoolean();
        IgniteInternalFuture masterFut = this.startSysLoad(ClusterRole.MASTER, masterStop);
        IgniteInternalFuture replicaFut = this.startSysLoad(ClusterRole.REPLICA, replicaStop);
        U.sleep((long)5000L);
        this.stopLoad(masterFut, masterStop);
        this.stopLoad(replicaFut, replicaStop);
        U.sleep((long)5000L);
        this.txdr((Ignite)master).stop().get();
        long lastCreatedCutId = this.txdr((Ignite)master).localState().lastCreatedCutId();
        GridTestUtils.waitForCondition(() -> {
            for (IgniteEx node : replicaCluster) {
                if (this.txdr((Ignite)node).localState().lastSuccessfullyAppliedCutId() != lastCreatedCutId) continue;
                return true;
            }
            return false;
        }, (long)(this.consistentCutInterval * 5L));
        this.txdr((Ignite)replica).stop().get();
        IgniteInternalCache sysCache = replica.context().cache().utilityCache();
        Iterator it = sysCache.scanIterator(false, (IgniteBiPredicate & Serializable)(k, v) -> k instanceof String && v instanceof Long);
        TxDrReplicaReadOnlyModeSystemCachesTest.assertTrue((String)"Sys cache must contain at least one key-value pair. ", (boolean)it.hasNext());
        while (it.hasNext()) {
            Cache.Entry e = (Cache.Entry)it.next();
            TxDrReplicaReadOnlyModeSystemCachesTest.assertTrue((boolean)((String)e.getKey()).startsWith(ClusterRole.REPLICA.toString()));
            TxDrReplicaReadOnlyModeSystemCachesTest.assertFalse((boolean)((String)e.getKey()).startsWith(ClusterRole.MASTER.toString()));
        }
    }

    @Test
    public void testDataStructuresCacheIsReadWrite() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long bootstrapSesId = this.bootstrapMaster();
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        IgniteEx master = masterCluster.get(0);
        IgniteEx replica = replicaCluster.get(0);
        AtomicBoolean masterStop = new AtomicBoolean();
        AtomicBoolean replicaStop = new AtomicBoolean();
        IgniteInternalFuture masterFut = this.startDsLoad(ClusterRole.MASTER, masterStop);
        IgniteInternalFuture replicaFut = this.startDsLoad(ClusterRole.REPLICA, replicaStop);
        U.sleep((long)5000L);
        this.stopLoad(masterFut, masterStop);
        this.stopLoad(replicaFut, replicaStop);
        for (int i = 0; i < 50; ++i) {
            IgniteSemaphore sem1 = replica.semaphore(ClusterRole.REPLICA.toString() + i, 0, false, false);
            IgniteSemaphore sem2 = replica.semaphore(ClusterRole.MASTER.toString() + i, 0, false, false);
            IgniteSemaphore sem3 = master.semaphore(ClusterRole.MASTER.toString() + i, 0, false, false);
            TxDrReplicaReadOnlyModeSystemCachesTest.assertNull((Object)sem1);
            TxDrReplicaReadOnlyModeSystemCachesTest.assertNull((Object)sem2);
            TxDrReplicaReadOnlyModeSystemCachesTest.assertNotNull((Object)sem3);
        }
        this.txdr((Ignite)master).stop().get();
        long lastCreatedCutId = this.txdr((Ignite)master).localState().lastCreatedCutId();
        GridTestUtils.waitForCondition(() -> {
            for (IgniteEx node : replicaCluster) {
                if (this.txdr((Ignite)node).localState().lastSuccessfullyAppliedCutId() != lastCreatedCutId) continue;
                return true;
            }
            return false;
        }, (long)(this.consistentCutInterval * 5L));
        this.txdr((Ignite)replica).stop().get();
        boolean ok = false;
        for (int i = 0; i < 50; ++i) {
            IgniteSemaphore sem = replica.semaphore(ClusterRole.REPLICA.toString() + i, 0, false, true);
            if (sem != null) continue;
            TxDrReplicaReadOnlyModeSystemCachesTest.fail((String)"Can`t create semaphore after replication is finished.");
        }
    }

    private IgniteInternalFuture startSysLoad(ClusterRole role, AtomicBoolean stop) {
        stop.set(false);
        return GridTestUtils.runAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!stop.get()) {
                Ignite ig = this.tryGetRandomInstance(role, rnd);
                if (ig == null) continue;
                IgniteInternalCache sysCache = ((IgniteEx)ig).context().cache().utilityCache();
                try {
                    String key = role.toString() + rnd.nextInt(50);
                    long val = rnd.nextLong();
                    TxDrReplicaReadOnlyModeSystemCachesTest.assertTrue((boolean)sysCache.put((Object)key, (Object)val));
                }
                catch (IgniteCheckedException e) {
                    log.error("Unexpected exception", (Throwable)e);
                }
            }
        }, (String)(role.toString().toLowerCase() + "-sys-load"));
    }

    private IgniteInternalFuture startDsLoad(ClusterRole role, AtomicBoolean stop) {
        stop.set(false);
        return GridTestUtils.runAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!stop.get()) {
                Ignite ig = this.tryGetRandomInstance(role, rnd);
                if (ig == null) continue;
                try {
                    String name = role.toString() + rnd.nextInt(50);
                    int val = rnd.nextInt();
                    ig.semaphore(name, val, false, true);
                }
                catch (IgniteException e) {
                    log.error("Unexpected exception", (Throwable)e);
                }
            }
        }, (String)(role.toString().toLowerCase() + "-ds-load"));
    }

    private void stopLoad(IgniteInternalFuture fut, AtomicBoolean stop) throws IgniteCheckedException {
        stop.set(true);
        fut.get();
    }
}

