/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Collections;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotInfoParams;
import org.junit.Ignore;
import org.junit.Test;

public class SnapshotMisconfiguredClientTest
extends AbstractSnapshotTest {
    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-46346")
    public void testSnapshotNoConfigurationOnClient() throws Exception {
        this.startServer();
        Ignite client = this.startClient();
        client.cluster().state(ClusterState.ACTIVE);
        client.getOrCreateCache("foobar");
        GridGain gg = (GridGain)client.plugin("GridGain");
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(null, null);
        snapshotFut.get();
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        SnapshotInfoParams snapshotInfoParams = new SnapshotInfoParams().snapshotId(snapshotId);
        SnapshotInfoEx snapshotInfo = gg.snapshot().snapshot(snapshotInfoParams);
        SnapshotMisconfiguredClientTest.assertEquals((long)snapshotId, (long)snapshotInfo.snapshotId());
        SnapshotMisconfiguredClientTest.assertEquals(Collections.singleton("foobar"), (Object)snapshotInfo.cacheNames());
    }

    private Ignite startServer() throws Exception {
        IgniteConfiguration cfg = new IgniteConfiguration().setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(LOCAL_IP_FINDER));
        return this.startGrid("server", cfg);
    }

    private Ignite startClient() throws Exception {
        IgniteConfiguration cfg = new IgniteConfiguration().setClientMode(true).setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(LOCAL_IP_FINDER));
        return this.startGrid("client", cfg);
    }
}

